#pragma once

using namespace BWAPI;
using namespace std;

class Ximp;

class MyBase {

  private: 

    Ximp *ximp;

    bool isFreeSpace(UnitType unitType, TilePosition pos, int freeSpace, int sides);

    TilePosition getSuitableBuildLocation(UnitType unitType, TilePosition pos, int freeSpace, int sides = 15, int maxDist = -1);

    bool build(UnitType unitType, TilePosition tilePos, Unit* worker);
    bool buildNewPylon(Position pos = Position(-1, -1));
    bool buildAssimilator();
    bool buildNearPylon(UnitType unitType);
    bool buildNearPosition(UnitType unitType, Position pos);

    Unit* getNearestUnassignedMineralField(Position pos);
    Unit* getAssignedMineralField(Unit* worker);
    void assignToMineralField(Unit* mineral, Unit* worker);
    void unassignFromMineralField(Unit* worker);

  public:

    set<Unit*> hqs;
    map<UnitType, set<Unit*>> buildings;
    map<UnitType, set<Unit*>> buildingsCompleted;
    set<Unit*> mineralWorkers;
    set<Unit*> gasWorkers;

    map<Unit*, set<Unit*>> mineralFields;
    map<UnitType, TilePosition> buildingPositions;
    map<UnitType, Unit*> buildingWorkers;

    BWTA::BaseLocation* baseLocation;
    set<BWTA::Region*> regions;
    set<BWTA::Chokepoint*> chokepoints;

    Unit* waitPylon;

    Position defenseCentroid;
    Position pylonsCentroid;

    CarrierGroup* defendingGroup;

    bool isCapital;
    bool isNatural;
    bool isMinedOut;
    bool isUnderAttack;
    bool isGasSteal;
    bool hasUnpoweredBuildings;

    int lastAttackedFrame;
    int lastSeenMineralCount;

    int checkMineralsDist;
    int maxBasePointDist;
    int pylonFreeSpace;
    int buildingsFreeSpace;
    int pylonEnergySpace;

    int buildingSides;
    int chokepointSpaceDist;
    bool isFull;


    MyBase(Ximp *x, BWTA::BaseLocation* baseLoc);

    bool isMyBase(bool mustHaveNexus = true);

    void addBuilding(Unit* building, bool completed = false);
    void deleteBuilding(Unit* building);
    bool addWorker(Unit* worker);
    bool deleteWorker(Unit* worker);

    set<Unit*> getBaseWorkers();
    Unit* getWorkerNotAssignedToMinerals();
    Unit* getNearestFreeWorker(Position pos, bool onlyThisBase = false);

    void taskIdleWorkers();
    void mineAssignedMinerals();
    void checkFull();
    void checkMinerals();
    void checkUnderAttack();
    void checkGasSteal();
    void checkUnpoweredBuildings();

    int getMaxMineralWorkers();
    int getMaxGasWorkers();

    bool isInBuildingWorkers(Unit* worker);

    void resolveGasSteal();
    void resolveUnpoweredBuildings();

    double getWorkersRatio();

    Unit* getFirstBuildingUnderAttack();
    bool isAnyWorkerUnderAttack();

    bool hasCompletedNexus();

    int getNeededAssimilators();

    bool isInBaseRegions(Position pos);  

    void moveOneMineralWorkerToGasWorkers();

    vector<UnitType> getBuildingsBeignBuilt();
    set<TilePosition> getPositionsBeignBuilt();
    vector<UnitType> getAllBuildingTypes();
    set<Unit*> getAllBuildings();

    bool isPositionBeignBuilt(TilePosition pos, UnitType buildingType);

    bool isBeignBuild(UnitType unitType);
    bool isAnyWorkerPlacingBuilding();
    bool isTrainingQueueEmpty(UnitType unitType);
    bool isBaseSafe();
    set<Unit*> getEnemyUnitsInBaseRegions(bool detected = true);

    bool buildBuilding(UnitType unitType, Position pos = Position(-1, -1));   
    bool trainUnit(UnitType unitType);
    bool cancelCarriers();

    void buildBuildings();

};