#include "Dll.h"

EnemyBase::EnemyBase(Ximp *x, BWTA::BaseLocation* baseLoc): ximp(x), 
                                                 probablyEnemyBase(false), 
                                                 baseLocation(baseLoc), 
                                                 isCapital(false) { 
  regions.insert(baseLocation->getRegion()); 

  // Update regions
  set<BWTA::Region*> allRegions = BWTA::getRegions();
  for (set<BWTA::Region*>::iterator it = allRegions.begin(); it != allRegions.end(); it++) {
    // Electric Circuit
    if (Broodwar->mapHash() == "9505d618c63a0959f0c0bfe21c253a2ea6e58d26") {
      if (baseLocation->getPosition() == Position(288, 272) && (*it)->getCenter() == Position(722, 802)) {
        regions.insert(*it);
      }
    }
    // Judgement Day
    else if (Broodwar->mapHash() == "2f69eaa1a73bb743934d55e7ea12186fe340e656") {
      if (baseLocation->getPosition() == Position(3744, 2992) && (*it)->getCenter() == Position(3130, 3252)) {
        regions.insert(*it);
      }
      else if (baseLocation->getPosition() == Position(3744, 1136) && (*it)->getCenter() == Position(3139, 874)) {
        regions.insert(*it);
      }
      else if (baseLocation->getPosition() == Position(352, 1136) && (*it)->getCenter() == Position(945, 873)) {
        regions.insert(*it);
      }
      else if (baseLocation->getPosition() == Position(352, 2992) && (*it)->getCenter() == Position(953, 3253)) {
        regions.insert(*it);
      }
    }
  }
}

bool EnemyBase::isEnemyBase() {
  for (map<UnitType, set<Unit*>>::iterator unitTypeIterator = buildings.begin(); unitTypeIterator != buildings.end(); unitTypeIterator++) {
    if (!unitTypeIterator->first.isAddon() && unitTypeIterator->second.size() > 0) {
      return true;
    }
  }

  return hqs.size() > 0;
}

void EnemyBase::addBuilding(Unit* building) {
  if (!building->getType().isResourceDepot()) {
    if (building->getType().getRace() == Races::Zerg) {
      deleteBuilding(building);
    }

    map<UnitType, set<Unit*>>::iterator buildingsIterator = buildings.find(building->getType());

    if (buildingsIterator != buildings.end()) {
      buildingsIterator->second.insert(building);
    }
    else {
      set<Unit*> newBuildingType;
      newBuildingType.insert(building);
      buildings.insert(pair<UnitType, set<Unit*>>(building->getType(), newBuildingType));
    }
  }
  else if (building->getType().isResourceDepot()) {
    hqs.insert(building);
  }
}

void EnemyBase::deleteBuilding(Unit* building) {
  if (!building->getType().isResourceDepot()) {
    if (building->getType().getRace() != Races::Zerg) {
      map<UnitType, set<Unit*>>::iterator buildingsIterator = buildings.find(building->getType());

      if (buildingsIterator != buildings.end()) {
        for (set<Unit*>::iterator it = buildingsIterator->second.begin(); it != buildingsIterator->second.end(); it++) {
          if (*it == building) {
            buildingsIterator->second.erase(it);
            break;
          }
        }
      }
    }
    else {
      for (map<UnitType, set<Unit*>>::iterator it = buildings.begin(); it != buildings.end(); it++) {
        for (set<Unit*>::iterator jt = it->second.begin(); jt != it->second.end(); jt++) {
          if (*jt == building) {
            it->second.erase(jt);
            break;
          }
        }
      }
    }
  } 
  else if (building->getType().isResourceDepot()) {
    for (set<Unit*>::iterator it = hqs.begin(); it != hqs.end(); it++) {
      if (*it == building) {
        hqs.erase(it);
        break;
      }
    }
  }

  if (isCapital && !isEnemyBase()) {
    isCapital = false;
  }
}

bool EnemyBase::isInBaseRegions(Position pos) {
  for (set<BWTA::Region*>::iterator it = regions.begin(); it != regions.end(); it++) {
    if ((*it)->getPolygon().isInside(pos)) {
      return true;
    }
  }

  return false;
}
