#pragma once

using namespace BWAPI;
using namespace std;

enum CorsairInstruction { DEFEND_BASES, ATTACK_WITH_CARRIER_GROUP, DEFEND_CARRIER_GROUP, DEFEND_WORKERS, HUNT_OVERLORDS };

class Ximp;
class MyBase;

class CorsairGroup {
  
  public:
    
    Ximp* ximp;

    set<Unit*> units;

    Unit* observer;

    Position centroid;

    MyBase* defendedMyBase;
    CarrierGroup* defendedCarrierGroup;

    CorsairInstruction instruction;
    

    CorsairGroup(Ximp *x, set<Unit*> un = set<Unit*>()): 
      ximp(x),
      units(un),
      observer(NULL),
      defendedMyBase(NULL), 
      defendedCarrierGroup(NULL), 
      instruction(DEFEND_CARRIER_GROUP) {};

    void computeCentroid();
    void doInstruction();
    void doRetreat();

    void groupAttack(Unit* unit);
    void groupAttackNearestEnemyAttackingFlyier();

    bool moveToCapitalBase(bool force = false);

};