#include "Dll.h"


void CorsairGroup::computeCentroid() {
  centroid = ximp->computeCentroid(units);
}

void CorsairGroup::doInstruction() {
  if (observer != NULL) {
    if (observer->getPosition().getDistance(centroid) > 2 * TILE_SIZE) {
      observer->move(centroid);
    }
  }

  defendedMyBase = NULL;

  map<BWTA::BaseLocation*, MyBase*> occupiedMyBases = ximp->colony.getOccupiedMyBases(false);

  set<pair<MyBase*, set<Unit*>>> myBasesWithEnemyUnits;

  for (map<BWTA::BaseLocation*, MyBase*>::iterator it = occupiedMyBases.begin(); it != occupiedMyBases.end(); it++) {
    set<Unit*> enemyUnits = it->second->getEnemyUnitsInBaseRegions();
    set<Unit*> enemyUnitsWithWeapon = ximp->getUnitsWithWeapon(enemyUnits);
    set<Unit*> enemyFlyiers = ximp->getFlyers(enemyUnitsWithWeapon);
    
    if (!enemyFlyiers.empty()) {
      myBasesWithEnemyUnits.insert(pair<MyBase*, set<Unit*>>(it->second, enemyFlyiers));
    }
  }

  set<pair<MyBase*, set<Unit*>>>::iterator baseToDefend = myBasesWithEnemyUnits.end();

  for (set<pair<MyBase*, set<Unit*>>>::iterator it = myBasesWithEnemyUnits.begin(); it != myBasesWithEnemyUnits.end(); it++) {
    if (it->first->isCapital) {
      baseToDefend = it;
      instruction = DEFEND_BASES;
      break;
    }
  }

  if (baseToDefend == myBasesWithEnemyUnits.end()) {
    BWTA::BaseLocation* baseLocation = NULL;

    for (set<pair<MyBase*, set<Unit*>>>::iterator it = myBasesWithEnemyUnits.begin(); it != myBasesWithEnemyUnits.end(); it++) {
      if (baseLocation == NULL || it->first->baseLocation->getPosition().getDistance(centroid) < baseLocation->getPosition().getDistance(centroid)) {
        baseToDefend = it;
        instruction = DEFEND_BASES;
        break;
      }
    }
  }

  if (instruction == DEFEND_BASES) {
    if (ximp->isInRegionWithEnemyBase(centroid)) {
      moveToCapitalBase(true);
    }
    else {
      if (baseToDefend != myBasesWithEnemyUnits.end() && units.size() >= 2) {
        defendedMyBase = baseToDefend->first;

        Unit* nearestEnemyFlyier = ximp->getNearestUnit(centroid, baseToDefend->second, true);
        groupAttack(nearestEnemyFlyier);
      }
      else if (baseToDefend == myBasesWithEnemyUnits.end()) {
        groupAttackNearestEnemyAttackingFlyier();
      }

      if (defendedMyBase == NULL && moveToCapitalBase()) {
        instruction = DEFEND_CARRIER_GROUP;
      }
    }
  }
  else if (instruction == ATTACK_WITH_CARRIER_GROUP) {
    // ToDo
  }
  else if (instruction == DEFEND_CARRIER_GROUP) {
    set<Unit*> enemyFlyiersCloseToCarrierGroup;

    for (vector<CarrierGroup>::iterator groupIt = ximp->army.carrierGroups.begin(); groupIt != ximp->army.carrierGroups.end(); groupIt++) {
      set<Unit*> unitsInRadius = Broodwar->getUnitsInRadius(groupIt->centroid, UnitTypes::Protoss_Carrier.sightRange() + 2*TILE_SIZE);
      set<Unit*> enemyUnits = ximp->getEnemyUnits(unitsInRadius);
      set<Unit*> enemyUnitsWithWeapon = ximp->getUnitsWithWeapon(enemyUnits);

      enemyFlyiersCloseToCarrierGroup = ximp->getFlyers(enemyUnitsWithWeapon);

      if (!enemyFlyiersCloseToCarrierGroup.empty()) {
        defendedCarrierGroup = &(*groupIt);
        break;
      }
    }

    if (!enemyFlyiersCloseToCarrierGroup.empty()) {
      Unit* nearestEnemyFlyier = ximp->getNearestUnit(defendedCarrierGroup->centroid, enemyFlyiersCloseToCarrierGroup);
      groupAttack(nearestEnemyFlyier);
    }
    else {
      if (moveToCapitalBase()) {
        instruction = DEFEND_WORKERS;
      }
    }
  }
  else if (instruction == DEFEND_WORKERS) {
    set<Unit*> myWorkers = ximp->getMyUnits(UnitTypes::Protoss_Probe, true);

    set<pair<Unit*, set<Unit*>>> myWorkersWithEnemyFlyiers;

    for (set<Unit*>::iterator it = myWorkers.begin(); it != myWorkers.end(); it++) {
      set<Unit*> unitsInRadius = Broodwar->getUnitsInRadius((*it)->getPosition(), UnitTypes::Protoss_Probe.sightRange() + 4*TILE_SIZE);
      set<Unit*> enemyUnits = ximp->getEnemyUnits(unitsInRadius);
      set<Unit*> enemyUnitsWithWeapon = ximp->getUnitsWithWeapon(enemyUnits);
      set<Unit*> enemyFlyiers = ximp->getFlyers(enemyUnitsWithWeapon);

      if (!enemyFlyiers.empty()) {
        myWorkersWithEnemyFlyiers.insert(pair<Unit*, set<Unit*>>(*it, enemyFlyiers));
      }
    }

    Unit* worker = NULL;

    for (set<pair<Unit*, set<Unit*>>>::iterator it = myWorkersWithEnemyFlyiers.begin(); it != myWorkersWithEnemyFlyiers.end(); it++) {
      if ((worker == NULL || it->first->getPosition().getDistance(centroid) < worker->getPosition().getDistance(centroid)) && !ximp->isInRegionWithEnemyBase(it->first->getPosition()) && !myWorkersWithEnemyFlyiers.empty()) {
        worker = it->first;
      }
    }

    if (worker != NULL) {
      for (set<pair<Unit*, set<Unit*>>>::iterator it = myWorkersWithEnemyFlyiers.begin(); it != myWorkersWithEnemyFlyiers.end(); it++) {
        if (it->first == worker) {
          Unit* nearestEnemyFlyier = ximp->getNearestUnit(centroid, it->second);
          groupAttack(nearestEnemyFlyier);
          break;
        }
      }
    }

    if (moveToCapitalBase()) {
      instruction = HUNT_OVERLORDS;
    }
  }
  else if (instruction == HUNT_OVERLORDS) {
    if (ximp->isInRegionWithEnemyBase(centroid)) {
      moveToCapitalBase(true);
    }
    else {
      set<Unit*> enemyUnits = Broodwar->enemy()->getUnits();
      set<Unit*> enemyOverlords = ximp->getUnitsOfType(UnitTypes::Zerg_Overlord, enemyUnits);

      Unit* nearestEnemyOverlord = NULL;

      for (set<Unit*>::iterator it = enemyOverlords.begin(); it != enemyOverlords.end(); it++) {
        if (!ximp->isInRegionWithEnemyBase((*it)->getPosition())) {
          if (nearestEnemyOverlord == NULL || (*it)->getPosition().getDistance(centroid) < nearestEnemyOverlord->getPosition().getDistance(centroid)) {
            nearestEnemyOverlord = *it;
          }
        }
      }  

      if (nearestEnemyOverlord != NULL) {
        groupAttack(nearestEnemyOverlord);
      }
    }

    instruction = DEFEND_BASES;
  }
}

void CorsairGroup::doRetreat() {
  set<Unit*> unitsInRadius = Broodwar->getUnitsInRadius(centroid, UnitTypes::Protoss_Corsair.sightRange() + 2*TILE_SIZE);
  set<Unit*> enemyUnits = ximp->getEnemyUnits(unitsInRadius);

  set<Unit*> withAirWeapons = ximp->getUnitsWithAirWeapons(enemyUnits);

  //set<Unit*> highTemplars = ximp->getUnitsOfType(UnitTypes::Protoss_High_Templar, enemyUnits);
  //withAirWeapons.insert(highTemplars.begin(), highTemplars.end());

  for (set<Unit*>::iterator it = withAirWeapons.begin(); it != withAirWeapons.end(); it++) {
    int range = (*it)->getType().airWeapon().maxRange()/*+4*TILE_SIZE*/;

    /*if ((*it)->getType() == UnitTypes::Protoss_High_Templar) { 
      range = WeaponTypes::Psionic_Storm.maxRange();
    }
    else if ((*it)->getType() == UnitTypes::Protoss_Dragoon) {
      range = UnitTypes::Protoss_Dragoon.airWeapon().maxRange() + 3*TILE_SIZE;
    }
    else */if ((*it)->getType() == UnitTypes::Terran_Bunker) {
      range = 6 * TILE_SIZE;
    }
    else if ((*it)->getType() == UnitTypes::Protoss_Carrier || (*it)->getType() == UnitTypes::Protoss_Interceptor) { 
      continue;
    }

    for (set<Unit*>::iterator jt = units.begin(); jt != units.end(); jt++) {
      if (!(*it)->getType().isFlyer()) {
        if ((*it)->isInWeaponRange(*jt) || ((/*(*it)->getType() == UnitTypes::Protoss_High_Templar || (*it)->getType() == UnitTypes::Protoss_Dragoon ||*/ (*it)->getType() == UnitTypes::Terran_Bunker) && (*jt)->getPosition().getDistance((*it)->getPosition()) <= range)) {
          Position vec((*jt)->getPosition().x() - (*it)->getPosition().x(), (*jt)->getPosition().y() - (*it)->getPosition().y());

          double vecLength = sqrt((double)(vec.x()*vec.x() + vec.y()*vec.y()));
          if (vecLength == 0) { 
            vecLength = 1; 
          }
          
          int range = (*it)->getType().airWeapon().maxRange();
          double moveQuot = (range + TILE_SIZE) / vecLength;
          Position vecMove(vec.x()*moveQuot, vec.y()*moveQuot);

          Position nextPos((*jt)->getPosition().x() + vecMove.x(), (*jt)->getPosition().y() + vecMove.y());
          TilePosition nextTilePos(nextPos);

          if (nextTilePos.isValid()) {
            if (nextPos.getDistance((*jt)->getPosition()) > TILE_SIZE) {
              (*jt)->attack(nextPos);
            }
          }
          else {
            if (nextPos.makeValid().getDistance((*jt)->getPosition()) > 2*TILE_SIZE) {
              (*jt)->attack(nextPos.makeValid());
            }
          }
        }
      }
    }
  }
}

void CorsairGroup::groupAttack(Unit* unit) {
  for (set<Unit*>::iterator it = units.begin(); it != units.end(); it++) {
    (*it)->attack(unit);
  }
}

void CorsairGroup::groupAttackNearestEnemyAttackingFlyier() {
  set<Unit*> unitsInRadius = Broodwar->getUnitsInRadius(centroid, UnitTypes::Protoss_Corsair.sightRange() + 4*TILE_SIZE);
  set<Unit*> enemyUnits = ximp->getEnemyUnits(unitsInRadius);
  set<Unit*> enemyFlyiers = ximp->getFlyers(enemyUnits);
  set<Unit*> enemyUnitsWithWeapon = ximp->getUnitsWithWeapon(enemyFlyiers);

  Unit* nearestEnemyFlyier = NULL;

  for (set<Unit*>::iterator it = enemyUnitsWithWeapon.begin(); it != enemyUnitsWithWeapon.end(); it++) {
    //if ((*it)->isAttacking()/* && units.find((*it)->getOrderTarget()) != units.end()*/) {
      if (nearestEnemyFlyier == NULL || (*it)->getPosition().getDistance(centroid) < nearestEnemyFlyier->getPosition().getDistance(centroid)) {
        nearestEnemyFlyier = *it;
      }
    //}
  }

  if (nearestEnemyFlyier != NULL) {
    groupAttack(nearestEnemyFlyier);
  }
}

bool CorsairGroup::moveToCapitalBase(bool force) {
  MyBase* capitalMyBase = ximp->colony.getCapitalMyBase();

  if (capitalMyBase != NULL) {
    bool oneAttack = false;

    if (!force) {
      for (set<Unit*>::iterator it = units.begin(); it != units.end(); it++) {
        if ((*it)->getOrder() == Orders::AttackUnit) {
          for (set<Unit*>::iterator jt = units.begin(); jt != units.end(); jt++) {
            (*jt)->attack((*it)->getOrderTarget());
          }

          oneAttack = true;
          return false;
        }
      }
    }

    Position movePosition = capitalMyBase->baseLocation->getPosition();

    if (capitalMyBase != NULL) {
      set<Unit*> minerals = capitalMyBase->baseLocation->getStaticMinerals();
      Position pos = ximp->computeCentroid(minerals, true);
      
      if (pos != Position(0,0)) {
        movePosition = pos;
      }
    }

    if (capitalMyBase != NULL && ((!oneAttack && movePosition.getDistance(centroid) > 5*TILE_SIZE) || force)) {
      for (set<Unit*>::iterator it = units.begin(); it != units.end(); it++) {
        if ((*it)->getOrder() != Orders::Move) {
          Position pos(movePosition.x() + (rand() % 10*TILE_SIZE) - 5*TILE_SIZE, movePosition.y() + (rand() % 10*TILE_SIZE) - 5*TILE_SIZE);
          (*it)->move(pos.makeValid());
        }
      }

      return true;
    }
    else if (capitalMyBase != NULL && movePosition.getDistance(centroid) <= 5*TILE_SIZE) {
      return true;
    }
  }

  return false;
}