#pragma once

using namespace BWAPI;
using namespace std;

class Ximp;

// Skupin - 4
// Carriers - 16 na skupinu 4   (celkovo supply: 96)
// Observers - 4 na skupinu 1   (celkovo supply: 4)

// Skupin - 1
// Corsairs - 14 na skupinu 14  (celkovo supply: 28)
// Observers - 1 na skupinu 1   (celkovo supply: 1)

// Observers (scouting) - 3     (celkovo supply: 3)
// Workers - 56                 (celkovo supply: 56)

// Dragoons (max) - 3
// Zealots (max) - 3
// bud 3x Dragoon a 3x Zealot alebo 5x Dragoon a 1x Zealot (celkovo supply: 12)

class Colony {

  private: 

    Ximp *ximp;

    set<Unit*> incompleteAssimilators;

    void addBuildingToBases(Unit* building, bool completed = false);
    void deleteBuildingFromBases(Unit* building);
    bool addWorkerToBase(Unit* worker, BWTA::BaseLocation* baseLocation = NULL);
    void deleteWorkerFromBase(Unit* worker);
    MyBase* getMyBaseOfBuilding(Unit* building);
    set<MyBase*> getMyBasesOfBuilding(Unit* building);

    BuildInstruction getNextBuildInstruction(vector<BuildInstruction> buildOrder, vector<UnitType> builtBuilding);

  public:

    double countWorkersPerMineralField;
    int countWorkersPerGas;
    int countWorkersPerGasDepleted;
    int maxCountWorkers;
    int maxCountScouts;
    int maxCountCarriers;
    int maxCountCorsairs;
    int minFreeSupply;

    map<BWTA::BaseLocation*, MyBase> myBases;
    set<Unit*> unassignedWorkers;
    map<BWTA::BaseLocation*, Unit*> newNexusWorkers;
    map<BWTA::BaseLocation*, int> buildingAttempts;
    map<pair<TilePosition, TilePosition>, double> cachedGroundDistances;

    bool stopBuildingWorkers;

    map<int, BuildInstruction> startBuildOrder;
    vector<BuildInstruction> normalBuildOrder;
    vector<BuildInstruction> advancedBuildOrder;
    vector<BuildInstruction> advancedBuildOrder2;


    Colony(Ximp *x): ximp(x), 
                     countWorkersPerMineralField(2.0), 
                     countWorkersPerGas(3), 
                     countWorkersPerGasDepleted(0), 
                     maxCountWorkers(56), 
                     maxCountScouts(3),
                     maxCountCarriers(16),
                     maxCountCorsairs(14),
                     minFreeSupply(6) {};

    void onStart();
    void onUnitDiscover(Unit* unit);
    void onFrame();
    void onNukeDetect(Position target);
    void onUnitCreate(Unit* unit);
    void onUnitComplete(Unit *unit);
    void onUnitDestroy(Unit* unit);
    void onUnitMorph(Unit* unit);
    void onUnitRenegade(Unit* unit);
    void onUnitEvade(Unit* unit);
    void onUnitShow(Unit* unit);
    void onUnitHide(Unit* unit);

    void processAnalysis();

    void handleWorkers();
    void buildingWorkers();
    void reassignWorkers();

    void handleNewNexusWorkers();

    void handleMyBases();
    void handleOccupiedMyBases();
    void handleCapitalBase(MyBase* myBase);
    void handleMyBase(MyBase* myBase);

    map<BWTA::BaseLocation*, MyBase*> getOccupiedMyBases(bool mustHaveNexus = true);
    MyBase* getCapitalMyBase();
    MyBase* getNaturalMyBase();
    MyBase* getMyBase(BWTA::BaseLocation* baseLocation);
    
    BWTA::BaseLocation* getNearestBaseLocation(Position pos, BWTA::BaseLocation* without = NULL, bool startLocation = false, bool mustHaveGeyser = false);
    BWTA::BaseLocation* getNearestBaseLocationAir(Position pos, BWTA::BaseLocation* without = NULL, bool startLocation = false, bool mustHaveGeyser = false);
    MyBase* getNearestOccupiedMyBase(Position pos, bool mustHaveNexus = true, bool mustHaveFreeWorker = false);
    BWTA::BaseLocation* getNearestUnoccupiedBaseLocation(Position pos, bool startLocation = false, bool mustHaveGeyser = false);
    set<BWTA::BaseLocation*> getUnoccupiedBaseLocations();

    bool checkMyOccupied(BWTA::BaseLocation* baseLocation);
    bool checkEnemyOccupied(BWTA::BaseLocation* baseLocation);
    bool checkOccupied(BWTA::BaseLocation* baseLocation);

    MyBase* getMyBaseWithSmallestWorkerRatio(bool canBeUnderAttack = true, BWTA::BaseLocation* baseLocation = NULL, bool withEmptyTrainingQueue = true);
    MyBase* getMyBaseWithLargestWorkerRatio(bool canBeUnderAttack = true, BWTA::BaseLocation* baseLocation = NULL);

    bool isAnyBaseUnderAttack();
    bool isAnyWorkerUnderAttack();
    bool isAnyWorkerPlacingBuilding();

    int buildingsBeignBuiltMinerals(UnitType except = UnitTypes::None);
    int buildingsBeignBuiltGas(UnitType except = UnitTypes::None);

    vector<UnitType> getAllBuildingTypes();
    vector<UnitType> getBuildingsBeignBuilt();

    bool isBeignBuilt(UnitType unitType);
    bool isPositionBeignBuilt(TilePosition pos, UnitType buildingType);

    int getCountAllWorkers();
    int getMaxCountOfWorkers();

    int buildNewNexus(bool startLocation = false, bool mustHaveGeyser = false);
    bool isInNewNexusWorkers(Unit* worker);
    bool isInBuildingWorkers(Unit* worker);

    bool researchUpgrade(UpgradeType upgradeType);
    bool researchTech(TechType techType);

    int getNextSupply();

    void changeStartBuildOrderZerglingRush();
    void changeStartBuildOrderZealotRush();
    void changeStartBuildOrderMarineRush();
    void changeNormalBuildOrderEarlyMutalisks();

};