#include "Dll.h"


void Colony::addBuildingToBases(Unit* building, bool completed) {
  set<MyBase*> myBases = getMyBasesOfBuilding(building);

  for (set<MyBase*>::iterator it = myBases.begin(); it != myBases.end(); it++) {
    (*it)->addBuilding(building, completed);
  }
}

void Colony::deleteBuildingFromBases(Unit* building) {
  set<MyBase*> myBases = getMyBasesOfBuilding(building);

  for (set<MyBase*>::iterator it = myBases.begin(); it != myBases.end(); it++) {
    (*it)->deleteBuilding(building);
  }
}

bool Colony::addWorkerToBase(Unit* worker, BWTA::BaseLocation* baseLocation) {
  if (baseLocation == NULL) {
    BWTA::BaseLocation* workerBaseLocation = BWTA::getNearestBaseLocation(worker->getPosition());

    MyBase *myBase = getMyBaseWithSmallestWorkerRatio(false, workerBaseLocation);
    if (myBase != NULL) {
      baseLocation = myBase->baseLocation;
    }

    if (myBase == NULL) {
      MyBase *myBaseNearest = getNearestOccupiedMyBase(worker->getPosition());

      if (myBaseNearest != NULL) {
        if (myBaseNearest->getWorkersRatio() >= 1) {
          unassignedWorkers.insert(worker);
          return false;
        }

        baseLocation = myBaseNearest->baseLocation;
      }
    }
  }

  if (baseLocation != NULL) {
    map<BWTA::BaseLocation*, MyBase>::iterator myBasesIterator = myBases.find(baseLocation);

    if (myBasesIterator != myBases.end()) {
      if (!myBasesIterator->second.addWorker(worker)) {
        unassignedWorkers.insert(worker);
        return false;
      }
    }

    return true;
  }
  else {
    unassignedWorkers.insert(worker);
    return false;
  }
}

void Colony::deleteWorkerFromBase(Unit* worker) {
  for (map<BWTA::BaseLocation*, MyBase>::iterator myBasesIterator = myBases.begin(); myBasesIterator != myBases.end(); myBasesIterator++) {
    /*if (myBasesIterator->second.deleteWorker(worker)) {
      break;
    }*/
    myBasesIterator->second.deleteWorker(worker);
  }
}

MyBase* Colony::getMyBaseOfBuilding(Unit* building) {
  BWTA::Region* region = BWTA::getRegion(building->getPosition());
    
  for (map<BWTA::BaseLocation*, MyBase>::iterator myBasesIterator = myBases.begin(); myBasesIterator != myBases.end(); myBasesIterator++) {
    for (set<BWTA::Region*>::iterator rt = myBasesIterator->second.regions.begin(); rt != myBasesIterator->second.regions.end(); rt++) {
      if (*rt == region) {
        return &myBasesIterator->second;
      }
    }
  }

  return NULL;
}

set<MyBase*> Colony::getMyBasesOfBuilding(Unit* building) {
  set<MyBase*> result;

  BWTA::Region* region = BWTA::getRegion(building->getPosition());

  for (map<BWTA::BaseLocation*, MyBase>::iterator myBasesIterator = myBases.begin(); myBasesIterator != myBases.end(); myBasesIterator++) {
    for (set<BWTA::Region*>::iterator rt = myBasesIterator->second.regions.begin(); rt != myBasesIterator->second.regions.end(); rt++) {
      if (*rt == region) {
        result.insert(&myBasesIterator->second);
      }
    }
  }

  return result;
}

BuildInstruction Colony::getNextBuildInstruction(vector<BuildInstruction> buildOrder, vector<UnitType> builtBuildings) {
  for (vector<BuildInstruction>::iterator it = buildOrder.begin(); it != buildOrder.end(); it++) {
    bool isBuilt = false;
    for (vector<UnitType>::iterator jt = builtBuildings.begin(); jt != builtBuildings.end(); jt++) {
      if (it->unitType == *jt) {
        builtBuildings.erase(jt);
        isBuilt = true;
        break;
      }
    }
    
    if (!isBuilt) {
      return *it;
    }
  }

  return BuildInstruction(UnitTypes::None, NULL);
}

void Colony::onStart() {
  incompleteAssimilators.clear();
  myBases.clear();
  unassignedWorkers.clear();
  newNexusWorkers.clear();

  buildingAttempts.clear();
  cachedGroundDistances.clear();

  stopBuildingWorkers = false;

  startBuildOrder.clear();
  normalBuildOrder.clear();
  advancedBuildOrder.clear();
  advancedBuildOrder2.clear();

  normalBuildOrder.push_back(BuildInstruction(UnitTypes::Protoss_Nexus, NULL));
  normalBuildOrder.push_back(BuildInstruction(UnitTypes::Protoss_Forge, NULL));
  normalBuildOrder.push_back(BuildInstruction(UnitTypes::Protoss_Nexus, NULL));
  normalBuildOrder.push_back(BuildInstruction(UnitTypes::Protoss_Gateway, NULL));
  normalBuildOrder.push_back(BuildInstruction(UnitTypes::Protoss_Cybernetics_Core, NULL));
  normalBuildOrder.push_back(BuildInstruction(UnitTypes::Protoss_Stargate, NULL));
  normalBuildOrder.push_back(BuildInstruction(UnitTypes::Protoss_Stargate, NULL));
  normalBuildOrder.push_back(BuildInstruction(UnitTypes::Protoss_Fleet_Beacon, NULL));
  normalBuildOrder.push_back(BuildInstruction(UnitTypes::Protoss_Stargate, NULL));
  normalBuildOrder.push_back(BuildInstruction(UnitTypes::Protoss_Stargate, NULL));
  normalBuildOrder.push_back(BuildInstruction(UnitTypes::Protoss_Gateway, NULL));
  normalBuildOrder.push_back(BuildInstruction(UnitTypes::Protoss_Nexus, NULL));

  advancedBuildOrder.push_back(BuildInstruction(UnitTypes::Protoss_Robotics_Facility, NULL));
  advancedBuildOrder.push_back(BuildInstruction(UnitTypes::Protoss_Observatory, NULL));

  advancedBuildOrder2.push_back(BuildInstruction(UnitTypes::Protoss_Citadel_of_Adun, NULL));
  advancedBuildOrder2.push_back(BuildInstruction(UnitTypes::Protoss_Templar_Archives, NULL));
  advancedBuildOrder2.push_back(BuildInstruction(UnitTypes::Protoss_Arbiter_Tribunal, NULL));
}

void Colony::onUnitDiscover(Unit* unit) {

}

void Colony::onFrame() {
  #if WRITE_LOG 
    ostringstream ss;
    ss << "Colony::onFrame - start";
    ximp->log.writeToLog(ss.str());
  #endif

  if (!incompleteAssimilators.empty()) {
    for (set<Unit*>::iterator it = incompleteAssimilators.begin(); it != incompleteAssimilators.end(); it++) {
      if (!(*it)->isBeingConstructed()) {
        addBuildingToBases(*it, true);
        incompleteAssimilators.erase(it);
        break;
      }
    }
  }

  handleMyBases();

  if ((Broodwar->getFrameCount() % 10 == 0) && (Broodwar->getFrameCount() > 0)) {
    handleOccupiedMyBases();

    if (!stopBuildingWorkers) {
      buildingWorkers();
    }

    handleWorkers();
    reassignWorkers();

    handleNewNexusWorkers();
  }

  #if WRITE_LOG 
    ss.str("");
    ss << "Colony::onFrame - end";
    ximp->log.writeToLog(ss.str());
  #endif
}

void Colony::onNukeDetect(Position target) {

}

void Colony::onUnitCreate(Unit* unit) {
  if (!Broodwar->self()->isEnemy(unit->getPlayer()) && !unit->getPlayer()->isNeutral()) {
    if (unit->getType().isBuilding()) {
      addBuildingToBases(unit);
    }
    else if (unit->getType().isWorker()) {
      addWorkerToBase(unit);
    }
  }
}

void Colony::onUnitComplete(Unit *unit) {
  if (!Broodwar->self()->isEnemy(unit->getPlayer()) && !unit->getPlayer()->isNeutral()) {
    if (unit->getType().isBuilding()) {
      addBuildingToBases(unit, true);
      
      MyBase* capitalMyBase = getCapitalMyBase();
      if (capitalMyBase != NULL) {
        if (unit->getType().canProduce() && unit->getType() != UnitTypes::Protoss_Nexus) {
          unit->setRallyPoint(capitalMyBase->baseLocation->getPosition());
        }
      }
    }

    /////////////////////////////
    /*if (unit->getType() == UnitTypes::Protoss_Observer) {
      EnemyBase* capitalEnemyBase = ximp->getCapitalEnemyBase();

      if (capitalEnemyBase != NULL) {
        BWTA::BaseLocation* baseLocation = capitalEnemyBase->baseLocation;
        unit->move(baseLocation->getPosition());
      }
    }*/
    /////////////////////////////
  }
}

void Colony::onUnitDestroy(Unit* unit) {
  if (!Broodwar->self()->isEnemy(unit->getPlayer()) && !unit->getPlayer()->isNeutral()) {
    if (unit->getType() == UnitTypes::Protoss_Assimilator) {
      if (!incompleteAssimilators.empty()) {
        for (set<Unit*>::iterator it = incompleteAssimilators.begin(); it != incompleteAssimilators.end(); it++) {
          if ((*it) == unit) {
            incompleteAssimilators.erase(it);
            break;
          }
        }
      }
    }

    if (unit->getType() == UnitTypes::Protoss_Nexus) {
      MyBase* myBase = getMyBaseOfBuilding(unit);

      if (myBase != NULL && myBase->isCapital) {
        myBase->isCapital = false;

        bool capitalSet = false;
        map<BWTA::BaseLocation*, MyBase*> myBases = getOccupiedMyBases();

        for (map<BWTA::BaseLocation*, MyBase*>::iterator it = myBases.begin(); it != myBases.end(); it++) {
          if (it->second != myBase && it->first->isStartLocation() && it->second->hasCompletedNexus()) {
            it->second->isCapital = true;
            capitalSet = true;
            break;
          }
        }
        
        if (!capitalSet) {
          for (map<BWTA::BaseLocation*, MyBase*>::iterator it = myBases.begin(); it != myBases.end(); it++) {
            if (it->second != myBase && it->second->hasCompletedNexus()) {
              it->second->isCapital = true;
              break;
            }
          }
        }
      }
    }

    if (unit->getType() == UnitTypes::Protoss_Probe) {
      for (map<BWTA::BaseLocation*, Unit*>::iterator it = newNexusWorkers.begin(); it != newNexusWorkers.end(); it++) {
        if (it->second == unit) {
          newNexusWorkers.erase(it);
          break;
        }
      }

      if (ximp->getMyUnits(UnitTypes::Protoss_Probe, false).size() <= 2) {
        for (map<BWTA::BaseLocation*, MyBase>::iterator it = myBases.begin(); it != myBases.end(); it++) {
          it->second.buildingPositions.clear();
          it->second.buildingWorkers.clear();
        }
      }

      //deleteWorkerFromBase(unit);
    }    
    
    if (unit->getType().isBuilding()) {
      deleteBuildingFromBases(unit);
    }
    else if (unit->getType().isWorker()) {
      deleteWorkerFromBase(unit);
    }
  }

  if (unit->getType() == UnitTypes::Resource_Mineral_Field) {  
    map<BWTA::BaseLocation*, MyBase*> myOccupiedBases = getOccupiedMyBases();

    for (map<BWTA::BaseLocation*, MyBase*>::iterator myOccupiedBasesIterator = myOccupiedBases.begin(); myOccupiedBasesIterator != myOccupiedBases.end(); myOccupiedBasesIterator++) {
      BWTA::BaseLocation* nearest = BWTA::getNearestBaseLocation(TilePosition(unit->getPosition()));

      map<BWTA::BaseLocation*, MyBase>::iterator myBasesIterator = myBases.find(nearest);

      if (myBasesIterator != myBases.end()) {
        myBasesIterator->second.checkFull();
      }
    }
  }
}

void Colony::onUnitMorph(Unit* unit) {
  if (!Broodwar->self()->isEnemy(unit->getPlayer()) && !unit->getPlayer()->isNeutral()) {
    if (unit->getType() == UnitTypes::Protoss_Assimilator) {
      addBuildingToBases(unit);
      incompleteAssimilators.insert(unit);
    }
  }

  if (unit->getType() == UnitTypes::Resource_Vespene_Geyser) {
    deleteBuildingFromBases(unit);
  }
}

void Colony::onUnitRenegade(Unit* unit) {

}

void Colony::onUnitEvade(Unit* unit) {

}

void Colony::onUnitShow(Unit* unit) {

}

void Colony::onUnitHide(Unit* unit) {

}

void Colony::processAnalysis() {
  BWTA::BaseLocation* myStartLocation = BWTA::getStartLocation(Broodwar->self());
  
  set<BWTA::BaseLocation*> baseLocations = BWTA::getBaseLocations();

  for (set<BWTA::BaseLocation*>::iterator it = baseLocations.begin(); it != baseLocations.end(); it++) {
    bool nearOtherBaseLocation = false;

    for (set<BWTA::BaseLocation*>::iterator jt = baseLocations.begin(); jt != baseLocations.end(); jt++) {
      if (*it != *jt && (*it)->getAirDistance(*jt) < 4*TILE_SIZE && myBases.find(*jt) != myBases.end()) {
        nearOtherBaseLocation = true;
      }
    }

    if (!nearOtherBaseLocation && !(*it)->isIsland()) {
      MyBase myBase = MyBase(ximp, *it);
      if (myStartLocation != NULL && myStartLocation == *it) {
        myBase.isCapital = true;
      }

      myBases.insert(pair<BWTA::BaseLocation*, MyBase>(*it, myBase));
    }

    buildingAttempts.insert(pair<BWTA::BaseLocation*, int>(*it, 0));
  }

  map<UnitType, set<Unit*>>::iterator unitsIterator = ximp->myUnits.find(UnitTypes::Protoss_Nexus);

  if (unitsIterator != ximp->myUnits.end() && unitsIterator->second.size() > 0) {
    for (set<Unit*>::iterator nexusesIterator = unitsIterator->second.begin(); nexusesIterator != unitsIterator->second.end(); nexusesIterator++) {
      addBuildingToBases(*nexusesIterator);
    }

    unitsIterator = ximp->myUnits.find(UnitTypes::Protoss_Probe);

    if (unitsIterator != ximp->myUnits.end()) {
      Unit *firstNexus = *unitsIterator->second.begin();

      for (set<Unit*>::iterator workersIterator = unitsIterator->second.begin(); workersIterator != unitsIterator->second.end(); workersIterator++) {
        (*workersIterator)->stop();
        addWorkerToBase(*workersIterator, BWTA::getNearestBaseLocation(firstNexus->getPosition()));

        for (set<Unit*>::iterator it = unassignedWorkers.begin(); it != unassignedWorkers.end(); it++) {
          if (*it == *workersIterator) {
            unassignedWorkers.erase(it);
            break;
          }
        }
      }
    }
  }

  MyBase* capitalMyBase = getCapitalMyBase();
  MyBase* naturalMyBase = NULL;
  if (capitalMyBase != NULL) {
    BWTA::BaseLocation* nearestBaseLocation = getNearestUnoccupiedBaseLocation(capitalMyBase->baseLocation->getPosition(), false, true);

    map<BWTA::BaseLocation*, MyBase>::iterator myBasesIt = myBases.find(nearestBaseLocation);
    if (myBasesIt != myBases.end()) {
      naturalMyBase = &myBasesIt->second;
    }
  }

  if (naturalMyBase != NULL) {
    naturalMyBase->isNatural = true;
  }

  startBuildOrder.insert(pair<int, BuildInstruction>(0, BuildInstruction(UnitTypes::Protoss_Nexus, capitalMyBase)));
  if (naturalMyBase != NULL) {
    startBuildOrder.insert(pair<int, BuildInstruction>(8, BuildInstruction(UnitTypes::Protoss_Pylon, naturalMyBase, naturalMyBase->pylonsCentroid)));
  }
  else {
    startBuildOrder.insert(pair<int, BuildInstruction>(8, BuildInstruction(UnitTypes::Protoss_Pylon, naturalMyBase)));
  }
  startBuildOrder.insert(pair<int, BuildInstruction>(9, BuildInstruction(UnitTypes::Protoss_Forge, naturalMyBase)));
  startBuildOrder.insert(pair<int, BuildInstruction>(11, BuildInstruction(UnitTypes::Protoss_Photon_Cannon, naturalMyBase)));
  startBuildOrder.insert(pair<int, BuildInstruction>(12, BuildInstruction(UnitTypes::Protoss_Photon_Cannon, naturalMyBase)));
  startBuildOrder.insert(pair<int, BuildInstruction>(14, BuildInstruction(UnitTypes::Protoss_Pylon, capitalMyBase)));
  startBuildOrder.insert(pair<int, BuildInstruction>(15, BuildInstruction(UnitTypes::Protoss_Gateway, capitalMyBase)));
  startBuildOrder.insert(pair<int, BuildInstruction>(16, BuildInstruction(UnitTypes::Protoss_Nexus, NULL)));
  startBuildOrder.insert(pair<int, BuildInstruction>(17, BuildInstruction(UnitTypes::Protoss_Assimilator, capitalMyBase)));
  startBuildOrder.insert(pair<int, BuildInstruction>(18, BuildInstruction(UnitTypes::Protoss_Cybernetics_Core, capitalMyBase)));
  startBuildOrder.insert(pair<int, BuildInstruction>(19, BuildInstruction(UnitTypes::Protoss_Photon_Cannon, naturalMyBase)));
  startBuildOrder.insert(pair<int, BuildInstruction>(20, BuildInstruction(UnitTypes::Protoss_Photon_Cannon, naturalMyBase)));

  // startBuildOrder.insert(pair<int, BuildInstruction>(19, BuildInstruction(UnitTypes::Protoss_Photon_Cannon, nearestMyBase)));
  // startBuildOrder.insert(pair<int, BuildInstruction>(18, BuildInstruction(UnitTypes::Protoss_Assimilator, capitalMyBase)));
  /*startBuildOrder.insert(pair<int, BuildInstruction>(21, BuildInstruction(UnitTypes::Protoss_Photon_Cannon, nearestMyBase)));*/
  /*if (nearestMyBase != NULL) {
    startBuildOrder.insert(pair<int, BuildInstruction>(20, BuildInstruction(UnitTypes::Protoss_Pylon, nearestMyBase, nearestMyBase->pylonsCentroid)));
  }
  else {
    startBuildOrder.insert(pair<int, BuildInstruction>(20, BuildInstruction(UnitTypes::Protoss_Pylon, nearestMyBase)));
  }*/
}

void Colony::handleWorkers() {
  map<BWTA::BaseLocation*, MyBase*> myOccupiedBases = getOccupiedMyBases();

  for (map<BWTA::BaseLocation*, MyBase*>::iterator myOccupiedBasesIterator = myOccupiedBases.begin(); myOccupiedBasesIterator != myOccupiedBases.end(); myOccupiedBasesIterator++) {
    myOccupiedBasesIterator->second->taskIdleWorkers();
    myOccupiedBasesIterator->second->mineAssignedMinerals();
  }

  // Clean dummy resource fields
  for (map<BWTA::BaseLocation*, MyBase*>::iterator myOccupiedBasesIterator = myOccupiedBases.begin(); myOccupiedBasesIterator != myOccupiedBases.end(); myOccupiedBasesIterator++) {
    set<Unit*> baseWorkers = myOccupiedBasesIterator->second->getBaseWorkers();

    for (set<Unit*>::iterator it = baseWorkers.begin(); it != baseWorkers.end(); it++) {
      if ((*it)->getOrder() != Orders::PlaceBuilding && (*it)->getOrder() != Orders::AttackUnit && !myOccupiedBasesIterator->second->isInBuildingWorkers(*it) && !isInNewNexusWorkers(*it) && *it != ximp->observation.earlyScoutWorker) {
        set<Unit*> unitsInRadius = (*it)->getUnitsInRadius((*it)->getType().sightRange());

        for (set<Unit*>::iterator jt = unitsInRadius.begin(); jt != unitsInRadius.end(); jt++) {
          if ((*jt)->getType().isMineralField() && (*jt)->getResources() == 0 && (*it)->getDistance(*jt) > TILE_SIZE*2 && !(*it)->isCarryingMinerals() && (*it)->getOrder() != Orders::AttackUnit) {
            (*it)->rightClick(*jt);
          }
        }
      }
    }
  }

  // Workers self-defense against near units
  for (map<BWTA::BaseLocation*, MyBase*>::iterator myOccupiedBasesIterator = myOccupiedBases.begin(); myOccupiedBasesIterator != myOccupiedBases.end(); myOccupiedBasesIterator++) {
    set<Unit*> baseWorkers = myOccupiedBasesIterator->second->getBaseWorkers();

    for (set<Unit*>::iterator it = baseWorkers.begin(); it != baseWorkers.end(); it++) {
      bool stopAttack = true;

      set<Unit*> unitsInRadius = (*it)->getUnitsInRadius(48);
        
      for (set<Unit*>::const_iterator jt = unitsInRadius.begin(); jt != unitsInRadius.end(); jt++) {
        if (Broodwar->self()->isEnemy((*jt)->getPlayer()) && (*jt)->getType().canAttack() && !(*jt)->getType().isFlyer()) {
          if ((*it)->getOrder() != Orders::PlaceBuilding && !myOccupiedBasesIterator->second->isInBuildingWorkers(*it)) {
            (*it)->attack(*jt);
          }
          stopAttack = false;
          break;
        }
      }
      
      stopAttack = true;

      if ((*it)->getOrder() == Orders::AttackUnit && stopAttack) {
        (*it)->stop();
      }
    }
  }
}

void Colony::buildingWorkers() {
  map<UnitType, set<Unit*>>::iterator workers = ximp->myUnits.find(UnitTypes::Protoss_Probe);

  if (workers != ximp->myUnits.end() && workers->second.size() < maxCountWorkers && workers->second.size() < getMaxCountOfWorkers()) {
    map<BWTA::BaseLocation*, MyBase*> occupiedMyBases = getOccupiedMyBases();
    
    for (map<BWTA::BaseLocation*, MyBase*>::iterator it = occupiedMyBases.begin(); it != occupiedMyBases.end(); it++) {  
      if (it->second->hasCompletedNexus() && workers->second.size()+1 <= maxCountWorkers && workers->second.size()+1 <= getMaxCountOfWorkers() && ximp->isEnoughResources(UnitTypes::Protoss_Probe, false)) {
        MyBase *myBase = getMyBaseWithSmallestWorkerRatio(false);

        if (myBase != NULL && myBase->hasCompletedNexus() && (*myBase->hqs.begin())->getTrainingQueue().size() == 0) {
          (*myBase->hqs.begin())->train(UnitTypes::Protoss_Probe);
          return;
        }

        bool canBeBuild = false;

        if (myBase != NULL && ((!myBase->isUnderAttack && !it->second->isUnderAttack) || it->second->getWorkersRatio() < 1)) {
          canBeBuild = true;
        }
        else if (myBase == NULL && it->second->getWorkersRatio() <  1) {
          canBeBuild = true;
        }

        Unit *nexus = *it->second->hqs.begin();

        if (canBeBuild && nexus->getTrainingQueue().size() == 0) {
          nexus->train(UnitTypes::Protoss_Probe);
          return;
        }
      }
    }
  }
}

void Colony::reassignWorkers() {
  map<BWTA::BaseLocation*, MyBase*> occupiedMyBases = getOccupiedMyBases();

  // add mineral workers from bases with largest worker ratio to bases with smallest worker ratio
  MyBase *myBaseSmallest = getMyBaseWithSmallestWorkerRatio(false, NULL, false);
  MyBase *myBaseLargest = getMyBaseWithLargestWorkerRatio(false);

  if (myBaseSmallest != NULL && myBaseLargest != NULL && !myBaseSmallest->isUnderAttack && !myBaseLargest->isUnderAttack && myBaseLargest->getEnemyUnitsInBaseRegions().empty() && myBaseSmallest->getEnemyUnitsInBaseRegions().empty() && myBaseLargest->getWorkersRatio() - myBaseSmallest->getWorkersRatio() >= 0.1 && myBaseLargest->mineralWorkers.size() > 0) {
    for (set<Unit*>::iterator it = myBaseLargest->mineralWorkers.begin(); it != myBaseLargest->mineralWorkers.end(); it++) {
      Unit* worker = *it;

      if (!worker->isCarryingMinerals()) {
        unassignedWorkers.insert(worker);
        myBaseLargest->deleteWorker(worker);
        worker->stop();
        break;
      }
    }
  }

  // add gas workers from bases with depleted gas to unassigned
  for (map<BWTA::BaseLocation*, MyBase>::iterator myBasesIterator = myBases.begin(); myBasesIterator != myBases.end(); myBasesIterator++) {
    MyBase* myBase = &myBasesIterator->second;

    if (myBase->gasWorkers.size() > 0 && myBase->getMaxGasWorkers() == 0) {
      for (set<Unit*>::iterator it = myBase->gasWorkers.begin(); it != myBase->gasWorkers.end(); it++) {
        Unit* worker = *it;

        if (worker->getOrder() != Orders::HarvestGas && !worker->isCarryingGas()) {
          unassignedWorkers.insert(worker);
          myBase->deleteWorker(worker);
          worker->stop();
          break;
        }
      }
    }
  }

  // add workers from destroyed bases to unassigned workers
  for (map<BWTA::BaseLocation*, MyBase>::iterator myBasesIterator = myBases.begin(); myBasesIterator != myBases.end(); myBasesIterator++) {
    MyBase* myBase = &myBasesIterator->second;

    if (!myBase->isMyBase()) {
      MyBase* capitalMyBase = getCapitalMyBase();

      if (myBase->mineralWorkers.size() > 0) {
        unassignedWorkers.insert(myBase->mineralWorkers.begin(), myBase->mineralWorkers.end());
        
        set<Unit*> mineralWorkersCopy = myBase->mineralWorkers;

        for (set<Unit*>::iterator it = mineralWorkersCopy.begin(); it != mineralWorkersCopy.end(); it++) {
          if (capitalMyBase != NULL) {
            (*it)->move(capitalMyBase->baseLocation->getPosition());
          }
          else {
            (*it)->stop();
          }
          myBase->deleteWorker(*it);
        }
      }
      if (myBase->gasWorkers.size() > 0) {
        unassignedWorkers.insert(myBase->gasWorkers.begin(), myBase->gasWorkers.end());

        set<Unit*> gasWorkersCopy = myBase->gasWorkers;

        for (set<Unit*>::iterator it = gasWorkersCopy.begin(); it != gasWorkersCopy.end(); it++) {
          if (capitalMyBase != NULL) {
            (*it)->move(capitalMyBase->baseLocation->getPosition());
          }
          else {
            (*it)->stop();
          }
          myBase->deleteWorker(*it);
        }
      }
    }
  }

  // add workers to unassigned in bases which have workersRatio > 1
  for (map<BWTA::BaseLocation*, MyBase*>::iterator it = occupiedMyBases.begin(); it != occupiedMyBases.end(); it++) {
    MyBase* myBase = it->second;

    if (myBase->getWorkersRatio() > 1 && !myBase->isUnderAttack) {
      if (myBase->mineralWorkers.size() > myBase->getMaxMineralWorkers()) {
        Unit* worker = myBase->getWorkerNotAssignedToMinerals();

        if (worker != NULL) {
          unassignedWorkers.insert(worker);
          myBase->deleteWorker(worker);
        }
      }
      else if (myBase->gasWorkers.size() > myBase->getMaxGasWorkers()) {
        unassignedWorkers.insert(*myBase->gasWorkers.begin());
        myBase->deleteWorker(*myBase->gasWorkers.begin());
      }
    }
  }

  // assign unassigned workers
  for (set<Unit*>::iterator it = unassignedWorkers.begin(); it != unassignedWorkers.end(); ) {
    MyBase *myBase = getMyBaseWithSmallestWorkerRatio(false, NULL, false);

    if (myBase != NULL && !myBase->isUnderAttack && myBase->getWorkersRatio() < 1 && myBase->getMaxMineralWorkers() + myBase->getMaxGasWorkers() > 0) {
      if ((*it)->getOrder() != Orders::HarvestGas && addWorkerToBase(*it, myBase->baseLocation)) {
        (*it)->move(myBase->baseLocation->getPosition());
        set<Unit*>::iterator temp = it;
        it++;
        unassignedWorkers.erase(temp);
      }
      else {
        it++;
      }
    }
    else {
      it++;
    }
  } 

  // prioritize gas workers
  for (map<BWTA::BaseLocation*, MyBase*>::iterator it = occupiedMyBases.begin(); it != occupiedMyBases.end(); it++) {
    MyBase* myBase = it->second;

    if (myBase->gasWorkers.size() < it->second->getMaxGasWorkers() && myBase->mineralWorkers.size() > 0) {
      myBase->moveOneMineralWorkerToGasWorkers();
    }
  }

  // if unassigned workers num is larger or equal to 5, build new Nexus
  if (unassignedWorkers.size() >= 5 && getUnoccupiedBaseLocations().size() > 0 && newNexusWorkers.size() < 1 && ximp->getMyUnits(UnitTypes::Protoss_Nexus, false).size() - ximp->getMyUnits(UnitTypes::Protoss_Nexus, true).size() < 1) {
    buildNewNexus();
  }
}

void Colony::handleNewNexusWorkers() {
  for (map<BWTA::BaseLocation*, Unit*>::iterator it = newNexusWorkers.begin(); it != newNexusWorkers.end(); ) {
    bool isCleaning = false;
    
    MyBase* capitalMyBase = getCapitalMyBase();
    set<Unit*> unitsInRadius = it->second->getUnitsInRadius(it->second->getType().sightRange());
    
    for (set<Unit*>::iterator jt = unitsInRadius.begin(); jt != unitsInRadius.end(); jt++) {
      if ((*jt)->getType().isMineralField() && (*jt)->getResources() == 0 && it->second->getDistance(*jt) > TILE_SIZE*2) {
        it->second->rightClick(*jt);
        isCleaning = true;
        break;
      }
      else if ((*jt)->getType().isMineralField() && (*jt)->getResources() == 0 && it->second->getOrderTarget() == *jt) {
        isCleaning = true;
        break;
      }
    }

    if (!isCleaning) {
      if (/*checkOccupied(it->first) || */ximp->isInRegionWithEnemyBase(it->first->getPosition()) || ximp->isInRegionWithEnemyUnits(it->first->getPosition()) || (getMyBase(it->first) != NULL && getMyBase(it->first)->isMinedOut)) {
        it->second->stop();

        //addWorkerToBase(it->second);

        it = newNexusWorkers.erase(it);
        continue;
      }
    
      if (it->second->getPosition().getDistance(it->first->getPosition()) <= TILE_SIZE) {
        TilePosition center(it->first->getPosition());
        TilePosition tilePos(center.x() - UnitTypes::Protoss_Nexus.tileWidth()/2, center.y() - UnitTypes::Protoss_Nexus.tileHeight()/2);

        it->second->build(tilePos, UnitTypes::Protoss_Nexus);

        map<BWTA::BaseLocation*, int>::iterator buildingAttemptsIt = buildingAttempts.find(it->first);
        if (buildingAttemptsIt != buildingAttempts.end()) {
          buildingAttemptsIt->second = buildingAttemptsIt->second + 1;
        }
        else {
          buildingAttempts.insert(pair<BWTA::BaseLocation*, int>(it->first, 0));
        }

        buildingAttemptsIt = buildingAttempts.find(it->first);

        if (buildingAttemptsIt->second > 1) {
          set<Unit*> zealots = ximp->getMyUnits(UnitTypes::Protoss_Zealot);
        
          if (!zealots.empty()) {
            if ((*zealots.begin())->getOrder() == Orders::PlayerGuard) {
              (*zealots.begin())->move(it->first->getPosition());
            }
          }

          set<Unit*> unitsInRadius = Broodwar->getUnitsInRadius(it->first->getPosition(), 3 * TILE_SIZE);
          
          for (set<Unit*>::iterator unit = unitsInRadius.begin(); unit != unitsInRadius.end(); unit++) {
            if ((*unit)->getPlayer() == Broodwar->self() && *unit != it->second) {
              Position vector((*unit)->getPosition().x() - it->first->getPosition().x(), (*unit)->getPosition().y() - it->first->getPosition().y());
              double length = sqrt((double)(vector.x()*vector.x() + vector.y()*vector.y()));
              
              Position moveVector((vector.x() / length) * 4 * TILE_SIZE, (vector.y() / length) * 4 * TILE_SIZE);
              Position movePosition((*unit)->getPosition().x() + moveVector.x(), (*unit)->getPosition().y() + moveVector.y());

              (*unit)->move(movePosition);
            }
          }
        }

        //addWorkerToBase(it->second);

        it = newNexusWorkers.erase(it);
      }
      else {
        MyBase* myBase = getMyBase(it->first);

        if (myBase != NULL && it->second->getOrderTargetPosition() != it->first->getPosition() && it->second->getPosition().getDistance(it->first->getPosition()) > 10*TILE_SIZE) {
          Unit* nearestWorker = myBase->getNearestFreeWorker(it->first->getPosition());

          if (nearestWorker != NULL && nearestWorker != it->second && !nearestWorker->isCarryingMinerals() && !nearestWorker->isCarryingGas()) {
            if (it->second->getOrderTargetPosition() == it->first->getPosition()) {
              it->second->stop();
            }

            it->second = nearestWorker;
          }
        }

        if (ximp->willHaveEnoughResources(UnitTypes::Protoss_Nexus, it->second->getPosition().getDistance(it->first->getPosition()), UnitTypes::Protoss_Probe.topSpeed(), UnitTypes::Protoss_Nexus)) {
          if (it->second->getOrderTargetPosition() != it->first->getPosition()) {
            it->second->move(it->first->getPosition());
          }
        }

        it++;
      }
    }
    else {
      it++;
    }
  }
}

void Colony::handleMyBases() {
  for (map<BWTA::BaseLocation*, MyBase>::iterator it = myBases.begin(); it != myBases.end(); it++) {
    it->second.checkMinerals();
    it->second.checkUnderAttack();
    it->second.checkGasSteal();
    it->second.checkUnpoweredBuildings();
    it->second.buildBuildings();
  }
}

void Colony::handleOccupiedMyBases() {
  #if WRITE_LOG 
    ostringstream ss;
    ss << "Colony::handleOccupiedMyBases - start";
    ximp->log.writeToLog(ss.str());
  #endif

  map<BWTA::BaseLocation*, MyBase*> myOccupiedBases = getOccupiedMyBases();

  for (map<BWTA::BaseLocation*, MyBase*>::iterator myOccupiedBasesIterator = myOccupiedBases.begin(); myOccupiedBasesIterator != myOccupiedBases.end(); myOccupiedBasesIterator++) {
    if (myOccupiedBasesIterator->second->isCapital) {
      handleCapitalBase(myOccupiedBasesIterator->second);
    }
    else {
      handleMyBase(myOccupiedBasesIterator->second);
    }
  }

  #if WRITE_LOG 
    ss.str("");
    ss << "Colony::handleOccupiedMyBases - end";
    ximp->log.writeToLog(ss.str());
  #endif
}

void Colony::handleCapitalBase(MyBase* myBase) {
  #if WRITE_LOG 
    ostringstream ss;
    ss << "Colony::handleCapitalBase - start";
    ximp->log.writeToLog(ss.str());
  #endif

  if (!ximp->analyzed) {
    return;
  }

  if (myBase->isGasSteal) {
    myBase->resolveGasSteal();
  }

  if (myBase->hasUnpoweredBuildings) {
    myBase->resolveUnpoweredBuildings();
  }

  if (ximp->state != 0) {
    if (ximp->getFreeSupply() + getNextSupply() < minFreeSupply && Broodwar->self()->supplyTotal()/2 < 200/* && ximp->isEnoughResources(UnitTypes::Protoss_Pylon)*/) {
      myBase->buildBuilding(UnitTypes::Protoss_Pylon);
    }

    if (myBase->getNeededAssimilators() > 0 && myBase->hasCompletedNexus()/* && ximp->isEnoughResources(UnitTypes::Protoss_Assimilator)*/) {
      myBase->buildBuilding(UnitTypes::Protoss_Assimilator);
    }
  }


  if (ximp->state == 0) {
    vector<BuildInstruction> buildOrder;

    if (!startBuildOrder.empty()) {
      if (ximp->getMyUnits(UnitTypes::Protoss_Probe).size() >= 9 && Broodwar->getFrameCount() < 5000 && ximp->getMyUnits(UnitTypes::Protoss_Forge, false).empty() && !ximp->isMarineRush) {
        MyBase* naturalBase = getNaturalMyBase();

        if (naturalBase != NULL) {
          set<Unit*> probes = ximp->getMyUnits(UnitTypes::Protoss_Probe);
          Unit* nearestWorker = NULL;

          for (set<Unit*>::iterator it = probes.begin(); it != probes.end(); it++) {
            if (*it != ximp->observation.earlyScoutWorker) {
              if (nearestWorker == NULL || (*it)->getPosition().getDistance(naturalBase->defenseCentroid) < nearestWorker->getPosition().getDistance(naturalBase->pylonsCentroid)) {
                nearestWorker = *it;
              }
            }
          }

          bool moving = false;
                  
          for (set<Unit*>::iterator it = probes.begin(); it != probes.end(); it++) {
            if (naturalBase->defenseCentroid.getDistance((*it)->getOrderTargetPosition()) <= 4*TILE_SIZE) {
              moving = true;
              break;
            }
          }

          if (nearestWorker != NULL && !moving && nearestWorker->getOrder() != Orders::PlaceBuilding && !naturalBase->isInBuildingWorkers(nearestWorker)) {
            nearestWorker->move(naturalBase->defenseCentroid);
          }
        }
      }

      bool reachedEnd = true;
      for (map<int, BuildInstruction>::iterator it = startBuildOrder.begin(); it != startBuildOrder.end(); it++) {
        if (it->first <= ximp->maxSupply) {
          buildOrder.push_back(it->second);
        }
        else if (getCountAllWorkers() + unassignedWorkers.size() + newNexusWorkers.size() >= getMaxCountOfWorkers() && it->first > getMaxCountOfWorkers()) {
          buildOrder.push_back(it->second);
          break;
        }
        else {
          reachedEnd = false;
          break;
        }
      }

      vector<UnitType> myBasesBuildings = getAllBuildingTypes();

      BuildInstruction currentInstruction = getNextBuildInstruction(buildOrder, myBasesBuildings);

      if (currentInstruction.unitType != UnitTypes::None) {
        if (currentInstruction.unitType.isBuilding()) {
          stopBuildingWorkers = true;

          if (currentInstruction.unitType != UnitTypes::Protoss_Nexus) {
            Position pos = currentInstruction.position;

            if (currentInstruction.myBase != NULL && currentInstruction.myBase != myBase) {
              if (pos != Position(-1, -1) && !Broodwar->isExplored(TilePosition(pos))) {
                Unit* worker = currentInstruction.myBase->getNearestFreeWorker(pos);

                if (worker != NULL) {
                  worker->move(pos);
                }
              }
              else {
                currentInstruction.myBase->buildBuilding(currentInstruction.unitType, pos);
              }
            }
            else {
              myBase->buildBuilding(currentInstruction.unitType, pos);
            }
          }
          else {
            if ((ximp->isZerglingRush && (ximp->getMyUnits(UnitTypes::Protoss_Zealot).size() >= 3 || ximp->getMyUnits(UnitTypes::Protoss_Photon_Cannon).size() >= 2)) || !ximp->isZerglingRush) {
              buildNewNexus(false, true);
            }
          }
        }
      }
      else {
        stopBuildingWorkers = false;
        if (reachedEnd) {
          ximp->state = 1;
        }
      }
    }

    if (!ximp->isMarineRush) {
      if (ximp->getMyUnits(UnitTypes::Protoss_Zealot, false).size() < 3 && !ximp->isZealotRush && !ximp->isEarlyMutalisks/* && ximp->getMyUnits(UnitTypes::Protoss_Carrier, false).size() >= 1*/) {
        myBase->trainUnit(UnitTypes::Protoss_Zealot);
      }
    }

    if (ximp->maxSupply > Broodwar->self()->supplyUsed()/2) {
      stopBuildingWorkers = false;
    }
  }
  else if (ximp->state == 1) {
    if (minFreeSupply < 18 && ximp->getMyUnits(UnitTypes::Protoss_Stargate, false).size() >= 4) {
      minFreeSupply = 18;
    }

    if (ximp->isMarineRush) {
      if (ximp->getMyUnits(UnitTypes::Protoss_Dragoon, false).size() < 3) {
        myBase->trainUnit(UnitTypes::Protoss_Dragoon);
      }
    }
    else { 
      if (ximp->getMyUnits(UnitTypes::Protoss_Zealot, false).size() < 1/* && ximp->getMyUnits(UnitTypes::Protoss_Carrier, false).size() >= 1*/) {
        myBase->trainUnit(UnitTypes::Protoss_Zealot);
      }

      if (ximp->getMyUnits(UnitTypes::Protoss_Zealot, false).size() < 3 && !ximp->isZealotRush && !ximp->isEarlyMutalisks/* && ximp->getMyUnits(UnitTypes::Protoss_Carrier, false).size() >= 1*/) {
        myBase->trainUnit(UnitTypes::Protoss_Zealot);
      }

      if (ximp->getMyUnits(UnitTypes::Protoss_Dragoon, false).size() < 5 && ximp->getMyUnits(UnitTypes::Protoss_Zealot, false).size() >= 1/* && ximp->getMyUnits(UnitTypes::Protoss_Carrier, false).size() >= 1*/) {
        if (ximp->getMyUnits(UnitTypes::Protoss_Zealot, false).size() + ximp->getMyUnits(UnitTypes::Protoss_Dragoon, false).size() < 6) {
          if (ximp->getMyUnits(UnitTypes::Protoss_Dragoon, false).size() == 0 || ximp->getMyUnits(UnitTypes::Protoss_Carrier, false).size() >= 4) {
            myBase->trainUnit(UnitTypes::Protoss_Dragoon);
          }
        }
      }
    }

    bool trainCarrier = true;

    if (ximp->getMyUnits(UnitTypes::Protoss_Carrier, false).size() >= 4) {
      if (ximp->buildRequirementsMet(UnitTypes::Protoss_Observer) && ximp->getMyUnits(UnitTypes::Protoss_Observer, false).size() < maxCountScouts + ximp->army.carrierGroups.size() + ximp->army.corsairGroups.size()) {
        myBase->trainUnit(UnitTypes::Protoss_Observer);
      }

      if (ximp->buildRequirementsMet(UnitTypes::Protoss_Arbiter) && ximp->getMyUnits(UnitTypes::Protoss_Arbiter, false).size() < ximp->army.carrierGroups.size()) {
        myBase->trainUnit(UnitTypes::Protoss_Arbiter);
        trainCarrier = false;
      }
    }

    if (ximp->enemyHasFlyers/* || ximp->isMassMarines || ximp->isMassGoliaths || ximp->isMassHydras || ximp->isMassDragoons*/) {
      if (ximp->buildRequirementsMet(UnitTypes::Protoss_Corsair) && ximp->getMyUnits(UnitTypes::Protoss_Corsair, false).size() < maxCountCorsairs) {
        myBase->cancelCarriers();
        if (myBase->trainUnit(UnitTypes::Protoss_Corsair)) {
          trainCarrier = false;
        }
      }
    }

    if (trainCarrier && ximp->buildRequirementsMet(UnitTypes::Protoss_Carrier) && ximp->getMyUnits(UnitTypes::Protoss_Carrier, false).size() < maxCountCarriers) {
      myBase->trainUnit(UnitTypes::Protoss_Carrier);
    }
    
	  if ((ximp->isEarlyMutalisks && ximp->getMyUnits(UnitTypes::Protoss_Corsair, true).size() >= 6) || (!ximp->isEarlyMutalisks && Broodwar->getFrameCount() >= 11000)) {
      if (!ximp->getMyUnits(UnitTypes::Protoss_Forge).empty()) {
        map<UnitType, set<Unit*>>::iterator buildingsIt = myBase->buildings.find(UnitTypes::Protoss_Photon_Cannon);

        if (buildingsIt == myBase->buildings.end() || buildingsIt->second.size() < 2) {
          set<Unit*> minerals = myBase->baseLocation->getStaticMinerals();

          Position pos(-1, -1);

          if (!minerals.empty()) {
            pair<Position, Position> corners = ximp->getDistantPositions(minerals);

            bool first = true;
            if (buildingsIt != myBase->buildings.end() && buildingsIt->second.size() > 0) {
              Position canonPosition = (*buildingsIt->second.begin())->getPosition();

              if (canonPosition.getDistance(corners.first) < canonPosition.getDistance(corners.second)) {
                first = false;
              }
            }

            if (first) {
              pos = corners.first;
            }
            else {
              pos = corners.second;
            }
          }

          myBase->buildBuilding(UnitTypes::Protoss_Photon_Cannon, pos);
        }
      }
    }

    if ((ximp->isEarlyMutalisks && (ximp->getMyUnits(UnitTypes::Protoss_Corsair, false).size() > 6 || ximp->getMyUnits(UnitTypes::Protoss_Stargate, false).size() < 3)) || (!ximp->isEarlyMutalisks)) {
      if (myBase->isTrainingQueueEmpty(UnitTypes::Protoss_Carrier) || ximp->getMyUnits(UnitTypes::Protoss_Carrier, false).size() >= 2) {
        if (Broodwar->self()->getUpgradeLevel(UpgradeTypes::Carrier_Capacity) == 0 && ximp->getMyUnits(UnitTypes::Protoss_Carrier, false).size() >= 4) {
          researchUpgrade(UpgradeTypes::Carrier_Capacity);
        }

        if (Broodwar->self()->getUpgradeLevel(UpgradeTypes::Protoss_Air_Weapons) < 3 && ximp->getMyUnits(UnitTypes::Protoss_Carrier, false).size() >= 4) {
          researchUpgrade(UpgradeTypes::Protoss_Air_Weapons);
        }

        if (Broodwar->self()->getUpgradeLevel(UpgradeTypes::Protoss_Plasma_Shields) < 3 && ximp->getMyUnits(UnitTypes::Protoss_Carrier, false).size() >= 8) {
          researchUpgrade(UpgradeTypes::Protoss_Plasma_Shields);
        }
      }

      if (ximp->getMyUnits(UnitTypes::Protoss_Carrier, false).size() >= 4) {
        if (Broodwar->self()->getUpgradeLevel(UpgradeTypes::Gravitic_Boosters) == 0 && ximp->getMyUnits(UnitTypes::Protoss_Observer, true).size() > 0) {
          researchUpgrade(UpgradeTypes::Gravitic_Boosters);
        }

        if (!Broodwar->self()->hasResearched(TechTypes::Disruption_Web) && ximp->getMyUnits(UnitTypes::Protoss_Corsair, false).size() > 0) {
          researchTech(TechTypes::Disruption_Web);
        }
      }

      vector<UnitType> myBasesBuildings = getAllBuildingTypes();
      BuildInstruction currentInstruction = getNextBuildInstruction(normalBuildOrder, myBasesBuildings);

      if (currentInstruction.unitType != UnitTypes::None) {
        if (currentInstruction.unitType != UnitTypes::Protoss_Nexus) {
          myBase->buildBuilding(currentInstruction.unitType);
        }
        else {
          MyBase* naturalMyBase = getNaturalMyBase();
          
          if (naturalMyBase != NULL && !naturalMyBase->isUnderAttack && getUnoccupiedBaseLocations().size() > 0) {
            if (ximp->getMyUnits(UnitTypes::Protoss_Nexus, false).size() + newNexusWorkers.size() < 2) {
              buildNewNexus(false, true);
            }
            else if (ximp->getMyUnits(UnitTypes::Protoss_Nexus, false).size() + newNexusWorkers.size() < 3 && Broodwar->getFrameCount() >= 10000 && (ximp->getMyUnits(UnitTypes::Protoss_Carrier, true).size() >= 4 || ximp->isEarlyMutalisks || Broodwar->self()->minerals() >= 800) && Broodwar->self()->minerals() >= 500) {
              buildNewNexus(false, true);
            }
          }
        }
      }
      if (currentInstruction.unitType == UnitTypes::None || (currentInstruction.unitType == UnitTypes::Protoss_Nexus && Broodwar->getFrameCount() > 15000 && ximp->getMyUnits(UnitTypes::Protoss_Nexus, false).size() >= 2)) {
        if (ximp->getMyUnits(UnitTypes::Protoss_Carrier, true).size() >= 4) {
          BuildInstruction currentAdvancedInstruction = getNextBuildInstruction(advancedBuildOrder, myBasesBuildings);
        
          if (currentAdvancedInstruction.unitType != UnitTypes::None) {
            myBase->buildBuilding(currentAdvancedInstruction.unitType);
          }
          else if (ximp->getMyUnits(UnitTypes::Protoss_Carrier, false).size() >= 12 && ximp->getMyUnits(UnitTypes::Protoss_Nexus, true).size() >= 3) {
            currentAdvancedInstruction = getNextBuildInstruction(advancedBuildOrder2, myBasesBuildings);

            if (currentAdvancedInstruction.unitType != UnitTypes::None) {
              myBase->buildBuilding(currentAdvancedInstruction.unitType);
            }
          }
        }
      }
    }

    /*if (getUnoccupiedBaseLocations().size() > 0 && (ximp->getMyUnits(UnitTypes::Protoss_Nexus, false).size() + newNexusWorkers.size() < 2)) {
      buildNewNexus();
    }*/

    /*if (ximp->getMyUnits(UnitTypes::Protoss_Forge, false).size() < 1 && !myBase->isBeignBuild(UnitTypes::Protoss_Forge)) {
      myBase->buildBuilding(UnitTypes::Protoss_Forge);
    }
    else if (ximp->getMyUnits(UnitTypes::Protoss_Gateway, false).size() < 5 && !myBase->isBeignBuild(UnitTypes::Protoss_Gateway)) {
      myBase->buildBuilding(UnitTypes::Protoss_Gateway);
    }*/

    /*vector<UnitType> buildOrder = ximp->getBuildOrder(UnitTypes::Protoss_Arbiter);
    vector<UnitType> myBasesBuildings = getAllBuildingTypes();

    UnitType buildNext = getBuildNext(buildOrder, myBasesBuildings);

    if (buildNext != UnitTypes::None) {
      myBase->buildBuilding(buildNext);
    }
    else {
      if (ximp->getMyUnits(UnitTypes::Protoss_Arbiter, false).size() < 1) {
        myBase->trainUnit(UnitTypes::Protoss_Arbiter);
      }

      vector<UnitType> buildOrder = ximp->getBuildOrder(UnitTypes::Protoss_Reaver);
      vector<UnitType> myBasesBuildings = getAllBuildingTypes();
 
      UnitType buildNext = getBuildNext(buildOrder, myBasesBuildings);

      if (buildNext != UnitTypes::None) {
        myBase->buildBuilding(buildNext);
      }
      else {
        if (ximp->getMyUnits(UnitTypes::Protoss_Reaver, false).size() < 3) {
          myBase->trainUnit(UnitTypes::Protoss_Reaver);
        }
      }
    }

    if (ximp->getMyUnits(UnitTypes::Protoss_Zealot, false).size() < 20) {
      myBase->trainUnit(UnitTypes::Protoss_Zealot);
    }
    else if (ximp->getMyUnits(UnitTypes::Protoss_Dragoon, false).size() < 50) {
      myBase->trainUnit(UnitTypes::Protoss_Dragoon);
    } */
  }



  #if WRITE_LOG 
    ss.str("");
    ss << "Colony::handleCapitalBase - end";
    ximp->log.writeToLog(ss.str());
  #endif
}

void Colony::handleMyBase(MyBase* myBase) {
  #if WRITE_LOG 
    ostringstream ss;
    ss << "Colony::handleMyBase - start";
    ximp->log.writeToLog(ss.str());
  #endif

  if (myBase->isGasSteal) {
    myBase->resolveGasSteal();
  }

  if (myBase->hasUnpoweredBuildings) {
    myBase->resolveUnpoweredBuildings();
  }

  if (myBase->getNeededAssimilators() > 0 && myBase->hasCompletedNexus()/* && ximp->isEnoughResources(UnitTypes::Protoss_Assimilator)*/) {
    myBase->buildBuilding(UnitTypes::Protoss_Assimilator);
  }
  
  int photonCanonsNum = 2;
  if (!myBase->baseLocation->isMineralOnly() && myBase->isNatural) {
    if (Broodwar->getFrameCount() >= 13000) {
      photonCanonsNum = 18;
    }
    else if (Broodwar->getFrameCount() >= 12000) {
      photonCanonsNum = 16;
    }
    else if (Broodwar->getFrameCount() >= 11000) {
      photonCanonsNum = 14;
    }
    else if (Broodwar->getFrameCount() >= 10000) {
      photonCanonsNum = 12;
    }
    else if (Broodwar->getFrameCount() >= 8000) {
      photonCanonsNum = 10;
    }
    else if (Broodwar->getFrameCount() >= 7000) {
      photonCanonsNum = 8;
    }
    else if (Broodwar->getFrameCount() >= 6000) {
      photonCanonsNum = 6;
    }
  }
  else if (!myBase->isNatural) {
    if (!myBase->baseLocation->isMineralOnly()) {
      photonCanonsNum = 10;
    }
    else {
      photonCanonsNum = 4;
    }
  }

  if (ximp->isEarlyMutalisks) {
    photonCanonsNum = 3;
  }

  /*vector<UnitType> myBasesBuildings = getAllBuildingTypes();
  BuildInstruction currentInstruction = getNextBuildInstruction(normalBuildOrder, myBasesBuildings);

  bool wait = (currentInstruction.unitType == UnitTypes::Protoss_Stargate || currentInstruction.unitType == UnitTypes::Protoss_Cybernetics_Core) && Broodwar->getFrameCount() < 13000;*/

  if (!ximp->getMyUnits(UnitTypes::Protoss_Forge).empty() && myBase->hasCompletedNexus() && !myBase->isUnderAttack /*&& !wait && !myBase->isBeignBuild(UnitTypes::Protoss_Photon_Cannon)*/) {
    map<UnitType, set<Unit*>>::iterator buildingsIt = myBase->buildings.find(UnitTypes::Protoss_Photon_Cannon);

    if (buildingsIt == myBase->buildings.end() || buildingsIt->second.size() < photonCanonsNum) {
      myBase->buildBuilding(UnitTypes::Protoss_Photon_Cannon/*, myBase->pylonsCentroid*/);
    }
  }

  #if WRITE_LOG 
    ss.str("");
    ss << "Colony::handleMyBase - end";
    ximp->log.writeToLog(ss.str());
  #endif
}

map<BWTA::BaseLocation*, MyBase*> Colony::getOccupiedMyBases(bool mustHaveNexus) {
  map<BWTA::BaseLocation*, MyBase*> myOccupiedBases;

  for (map<BWTA::BaseLocation*, MyBase>::iterator myBasesIterator = myBases.begin(); myBasesIterator != myBases.end(); myBasesIterator++) {
    if (myBasesIterator->second.isMyBase(mustHaveNexus)) {
      myOccupiedBases.insert(pair<BWTA::BaseLocation*, MyBase*>(myBasesIterator->first, &myBasesIterator->second));
    }
  }

  return myOccupiedBases;
}

MyBase* Colony::getCapitalMyBase() {
  for (map<BWTA::BaseLocation*, MyBase>::iterator myBasesIterator = myBases.begin(); myBasesIterator != myBases.end(); myBasesIterator++) {
    if (myBasesIterator->second.isCapital) {
      return &myBasesIterator->second;
    }
  }

  return NULL;
}

MyBase* Colony::getNaturalMyBase() {
  for (map<BWTA::BaseLocation*, MyBase>::iterator myBasesIterator = myBases.begin(); myBasesIterator != myBases.end(); myBasesIterator++) {
    if (myBasesIterator->second.isNatural) {
      return &myBasesIterator->second;
    }
  }

  return NULL;
}

MyBase* Colony::getMyBase(BWTA::BaseLocation* baseLocation) {
  map<BWTA::BaseLocation*, MyBase>::iterator myBasesIterator = myBases.find(baseLocation);

  if (myBasesIterator != myBases.end()) {
    return &myBasesIterator->second;
  }

  return NULL;
}

BWTA::BaseLocation* Colony::getNearestBaseLocation(Position pos, BWTA::BaseLocation* without, bool startLocation, bool mustHaveGeyser) {
  BWTA::BaseLocation* nearest = NULL;
  double nearestDist = 1000000.0;

  set<BWTA::BaseLocation*> baseLocations = BWTA::getBaseLocations();

  for (set<BWTA::BaseLocation*>::iterator it = baseLocations.begin(); it != baseLocations.end(); it++) {
    if (!mustHaveGeyser || !(*it)->isMineralOnly()) {
      double groundDistance;

      pair<TilePosition, TilePosition> fromTo(TilePosition(pos), TilePosition((*it)->getPosition()));
      map<pair<TilePosition, TilePosition>, double>::iterator cachedGroundDistancesIt = cachedGroundDistances.find(fromTo);
      if (cachedGroundDistancesIt == cachedGroundDistances.end()) {
        groundDistance = BWTA::getGroundDistance(TilePosition(pos), TilePosition((*it)->getPosition()));
        cachedGroundDistances.insert(pair<pair<TilePosition, TilePosition>, double>(fromTo, groundDistance));
      }
      else {
        groundDistance = cachedGroundDistancesIt->second;
      }

      if (*it != without && !(*it)->isIsland() && groundDistance < nearestDist && groundDistance >= 0.0) {
        nearest = *it;
        nearestDist = groundDistance;
      }
    }
  }

  return nearest;
}

BWTA::BaseLocation* Colony::getNearestBaseLocationAir(Position pos, BWTA::BaseLocation* without, bool startLocation, bool mustHaveGeyser) {
  BWTA::BaseLocation* nearest = NULL;
  double nearestDist = 1000000.0;

  set<BWTA::BaseLocation*> baseLocations = BWTA::getBaseLocations();

  for (set<BWTA::BaseLocation*>::iterator it = baseLocations.begin(); it != baseLocations.end(); it++) {
    if (!mustHaveGeyser || !(*it)->isMineralOnly()) {
      double currentDist;
      if (*it != without && !(*it)->isIsland() && (currentDist = pos.getDistance((*it)->getPosition())) < nearestDist && currentDist >= 0.0) {
        nearest = *it;
        nearestDist = currentDist;
      }
    }
  }

  return nearest;
}

MyBase* Colony::getNearestOccupiedMyBase(Position pos, bool mustHaveNexus, bool mustHaveFreeWorker) {
  MyBase* nearest = NULL;

  map<BWTA::BaseLocation*, MyBase*> occupiedMyBases = getOccupiedMyBases(mustHaveNexus);

  for (map<BWTA::BaseLocation*, MyBase*>::iterator it = occupiedMyBases.begin(); it != occupiedMyBases.end(); it++) {
    if (nearest == NULL || (it->first->getPosition().getDistance(pos) < nearest->baseLocation->getPosition().getDistance(pos))) {
      if (!mustHaveNexus || !it->second->hqs.empty()) {
        if (!mustHaveFreeWorker || it->second->getNearestFreeWorker(it->first->getPosition(), true) != NULL) {
          nearest = it->second;
        }
      }
    }
  }

  return nearest;
}

BWTA::BaseLocation* Colony::getNearestUnoccupiedBaseLocation(Position pos, bool startLocation, bool mustHaveGeyser) {
  map<BWTA::BaseLocation*, MyBase*> occupiedMyBases = getOccupiedMyBases();
  map<BWTA::BaseLocation*, EnemyBase*> occupiedEnemyBases = ximp->getOccupiedEnemyBases();

  set<BWTA::BaseLocation*> baseLocations = BWTA::getBaseLocations();
  BWTA::BaseLocation* nearest = NULL;
  double nearestDist = 1000000.0;

  for (set<BWTA::BaseLocation*>::iterator it = baseLocations.begin(); it != baseLocations.end(); it++) {
    if ((getMyBase(*it) != NULL && !getMyBase(*it)->isMinedOut) && !ximp->isInRegionWithEnemyUnits((*it)->getPosition()) && occupiedMyBases.find(*it) == occupiedMyBases.end() && occupiedEnemyBases.find(*it) == occupiedEnemyBases.end()) {

      bool inNewNexusWorkers = false;
      for (map<BWTA::BaseLocation*, Unit*> ::iterator jt = newNexusWorkers.begin(); jt != newNexusWorkers.end(); jt++) {
        if (jt->first == *it) {
          inNewNexusWorkers = true;
          break;
        }
      }

      if (!inNewNexusWorkers) {
        if ((startLocation && (*it)->isStartLocation()) || !startLocation) {
          if ((!(*it)->isMineralOnly()) || !mustHaveGeyser) {
            double groundDistance;
            
            pair<TilePosition, TilePosition> fromTo(TilePosition(pos), TilePosition((*it)->getPosition()));
            map<pair<TilePosition, TilePosition>, double>::iterator cachedGroundDistancesIt = cachedGroundDistances.find(fromTo);
            if (cachedGroundDistancesIt == cachedGroundDistances.end()) {
              groundDistance = BWTA::getGroundDistance(TilePosition(pos), TilePosition((*it)->getPosition()));
              cachedGroundDistances.insert(pair<pair<TilePosition, TilePosition>, double>(fromTo, groundDistance));
            }
            else {
              groundDistance = cachedGroundDistancesIt->second;
            }

            if (groundDistance < nearestDist && groundDistance >= 0.0) {
              nearest = *it;
              nearestDist = groundDistance;
            }
          }
        }
      }
    }
  }

  return nearest;
}

set<BWTA::BaseLocation*> Colony::getUnoccupiedBaseLocations() {
  #if WRITE_LOG 
    ostringstream ss;
    ss << "Colony::getUnoccupiedBaseLocations - start";
    ximp->log.writeToLog(ss.str());
  #endif
  set<BWTA::BaseLocation*> result;
  set<BWTA::BaseLocation*> baseLocations = BWTA::getBaseLocations();

  for (set<BWTA::BaseLocation*>::iterator it = baseLocations.begin(); it != baseLocations.end(); it++) {
    if (!checkOccupied(*it) && (getMyBase(*it) != NULL && !getMyBase(*it)->isMinedOut)) {
      result.insert(*it);
    }
  }

  return result;
}

bool Colony::checkMyOccupied(BWTA::BaseLocation* baseLocation) {
  map<BWTA::BaseLocation*, MyBase*> occupiedMyBases = getOccupiedMyBases();

  if (occupiedMyBases.find(baseLocation) == occupiedMyBases.end()) {
    return false;
  }

  return true;
}
 
bool Colony::checkEnemyOccupied(BWTA::BaseLocation* baseLocation) {
  map<BWTA::BaseLocation*, EnemyBase*> occupiedEnemyBases = ximp->getOccupiedEnemyBases();

  if (occupiedEnemyBases.find(baseLocation) == occupiedEnemyBases.end()) {
    return false;
  }

  return true;
}

bool Colony::checkOccupied(BWTA::BaseLocation* baseLocation) {
  map<BWTA::BaseLocation*, MyBase*> occupiedMyBases = getOccupiedMyBases();
  map<BWTA::BaseLocation*, EnemyBase*> occupiedEnemyBases = ximp->getOccupiedEnemyBases();

  if (occupiedMyBases.find(baseLocation) == occupiedMyBases.end() && occupiedEnemyBases.find(baseLocation) == occupiedEnemyBases.end()) {
    return false;
  }

  return true;
}

MyBase* Colony::getMyBaseWithSmallestWorkerRatio(bool canBeUnderAttack, BWTA::BaseLocation* baseLocation, bool withEmptyTrainingQueue) {
  MyBase* myBase = NULL;

  map<BWTA::BaseLocation*, MyBase*> occupiedMyBases = getOccupiedMyBases(false);

  for (map<BWTA::BaseLocation*, MyBase*>::iterator it = occupiedMyBases.begin(); it != occupiedMyBases.end(); it++) {
    if (it->second->hasCompletedNexus() && it->second->getMaxMineralWorkers() + it->second->getMaxGasWorkers() > 0) {
      if (!withEmptyTrainingQueue || (*it->second->hqs.begin())->getTrainingQueue().empty()) {
        if ((!canBeUnderAttack && !it->second->isUnderAttack) || canBeUnderAttack) {
          if (myBase == NULL || (it->second->getWorkersRatio() < myBase->getWorkersRatio() || (baseLocation != NULL && it->first == baseLocation && it->second->getWorkersRatio() == myBase->getWorkersRatio()))) {
            myBase = it->second;
          }
        }
      }
    }
  }

  return myBase;
}

MyBase* Colony::getMyBaseWithLargestWorkerRatio(bool canBeUnderAttack, BWTA::BaseLocation* baseLocation) {
  MyBase* myBase = NULL;

  map<BWTA::BaseLocation*, MyBase*> occupiedMyBases = getOccupiedMyBases(false);

  for (map<BWTA::BaseLocation*, MyBase*>::iterator it = occupiedMyBases.begin(); it != occupiedMyBases.end(); it++) {
    if (it->second->hasCompletedNexus() && it->second->getMaxMineralWorkers() + it->second->getMaxGasWorkers() > 0) {
      if ((!canBeUnderAttack && !it->second->isUnderAttack) || canBeUnderAttack) {
        if (myBase == NULL || (it->second->getWorkersRatio() > myBase->getWorkersRatio() || (baseLocation != NULL && it->first == baseLocation && it->second->getWorkersRatio() == myBase->getWorkersRatio()))) {
          myBase = it->second;
        }
      }
    }
  }

  return myBase;
}

bool Colony::isAnyBaseUnderAttack() {
  map<BWTA::BaseLocation*, MyBase*> occupiedMyBases = getOccupiedMyBases();

  for (map<BWTA::BaseLocation*, MyBase*>::iterator it = occupiedMyBases.begin(); it != occupiedMyBases.end(); it++) {
    if (it->second->isUnderAttack) {
      return true;
    }
  }

  return false;
}

bool Colony::isAnyWorkerUnderAttack() {
  map<BWTA::BaseLocation*, MyBase*> occupiedMyBases = getOccupiedMyBases();

  for (map<BWTA::BaseLocation*, MyBase*>::iterator it = occupiedMyBases.begin(); it != occupiedMyBases.end(); it++) {
    if (it->second->isAnyWorkerUnderAttack()) {
      return true;
    }
  }

  return false;
}

bool Colony::isAnyWorkerPlacingBuilding() {
  map<BWTA::BaseLocation*, MyBase*> occupiedMyBases = getOccupiedMyBases();

  for (map<BWTA::BaseLocation*, MyBase*>::iterator it = occupiedMyBases.begin(); it != occupiedMyBases.end(); it++) {
    if (it->second->isAnyWorkerPlacingBuilding()) {
      return true;
    }
  }

  return false;
}

int Colony::buildingsBeignBuiltMinerals(UnitType except) {
  //int nexuses = newNexusWorkers.size() * UnitTypes::Protoss_Nexus.mineralPrice();
  int otherBuildings = 0;

  vector<UnitType> buildingsBeignBuilt = getBuildingsBeignBuilt();

  for (vector<UnitType>::iterator it = buildingsBeignBuilt.begin(); it != buildingsBeignBuilt.end(); it++) {
    if (*it != except) {
      otherBuildings += it->mineralPrice();
    }
  }

  return otherBuildings/* + nexuses*/;
}

int Colony::buildingsBeignBuiltGas(UnitType except) {
  int result = 0;

  vector<UnitType> buildingsBeignBuilt = getBuildingsBeignBuilt();

  for (vector<UnitType>::iterator it = buildingsBeignBuilt.begin(); it != buildingsBeignBuilt.end(); it++) {
    if (*it != except) {
      result += it->gasPrice();
    }
  }

  return result;
}

vector<UnitType> Colony::getAllBuildingTypes() {
  vector<UnitType> result;

  set<Unit*> allBuildings;

  for (map<BWTA::BaseLocation*, MyBase>::iterator it = myBases.begin(); it != myBases.end(); it++) {
    set<Unit*> buildings = it->second.getAllBuildings();
    allBuildings.insert(buildings.begin(), buildings.end());
  }

  for (set<Unit*>::iterator it = allBuildings.begin(); it != allBuildings.end(); it++) {
    vector<UnitType>::iterator first = std::find(result.begin(), result.end(), (*it)->getType());
    result.insert(first, (*it)->getType());
  }

  vector<UnitType> beignBuilt = getBuildingsBeignBuilt();
  for (vector<UnitType>::iterator it = beignBuilt.begin(); it != beignBuilt.end(); it++) {
    vector<UnitType>::iterator first = std::find(result.begin(), result.end(), *it);
    result.insert(first, *it);
  }
  
  return result;
}

vector<UnitType> Colony::getBuildingsBeignBuilt() {
  vector<UnitType> result;

  for (map<BWTA::BaseLocation*, MyBase>::iterator it = myBases.begin(); it != myBases.end(); it++) {
    vector<UnitType> buildingTypes = it->second.getBuildingsBeignBuilt();

    for (vector<UnitType>::iterator jt = buildingTypes.begin(); jt != buildingTypes.end(); jt++) {
      vector<UnitType>::iterator first = std::find(result.begin(), result.end(), *jt);
      result.insert(first, *jt);
    }
  }

  int nexuses = newNexusWorkers.size();
  for (int i = 0; i < nexuses; i++) {
    result.push_back(UnitTypes::Protoss_Nexus);
  }
  
  return result;
}

bool Colony::isBeignBuilt(UnitType unitType) {
  vector<UnitType> buildingsBeignBuilt = getBuildingsBeignBuilt();

  if (std::find(buildingsBeignBuilt.begin(), buildingsBeignBuilt.end(), unitType) != buildingsBeignBuilt.end()) {
    return true;
  }

  map<UnitType, set<Unit*>>::iterator myUnitsIterator = ximp->myUnits.find(unitType);

  if (myUnitsIterator != ximp->myUnits.end()) {
    for (set<Unit*>::iterator it = myUnitsIterator->second.begin(); it != myUnitsIterator->second.end(); it++) {
      if (!(*it)->isCompleted()) {
        return true;
      }
    }
  }

  return false;
}

bool Colony::isPositionBeignBuilt(TilePosition pos, UnitType buildingType) {
  for (map<BWTA::BaseLocation*, MyBase>::iterator it = myBases.begin(); it != myBases.end(); it++) {
    if (it->second.isPositionBeignBuilt(pos, buildingType)) {
      return true;
    }
  }

  return false;
}

int Colony::getCountAllWorkers() {
  int count = 0;

  map<BWTA::BaseLocation*, MyBase*> occupiedMyBases = getOccupiedMyBases();

  for (map<BWTA::BaseLocation*, MyBase*>::iterator it = occupiedMyBases.begin(); it != occupiedMyBases.end(); it++) {
    count += it->second->mineralWorkers.size() + it->second->gasWorkers.size();
  }

  return count;
}

int Colony::getMaxCountOfWorkers() {
  int max = 0;

  map<BWTA::BaseLocation*, MyBase*> occupiedMyBases = getOccupiedMyBases();

  for (map<BWTA::BaseLocation*, MyBase*>::iterator it = occupiedMyBases.begin(); it != occupiedMyBases.end(); it++) {
    max += it->second->getMaxMineralWorkers() + it->second->getMaxGasWorkers();
  }

  return max;
}

// return: 0 - OK, 1 - no worker exist, 2 - no base location is unoccupied, 3 - no free worker exist, 4 - base location is under construction
int Colony::buildNewNexus(bool startLocation, bool mustHaveGeyser) {
  //Broodwar->printf("build new nexus...");
  if (!ximp->haveUnit(UnitTypes::Protoss_Probe)) {
    //Broodwar->printf("build new nexus - no worker exist");
    return 1;
  }  

  MyBase* capitalMyBase = getCapitalMyBase();
  BWTA::BaseLocation* baseLocation;

  if (capitalMyBase != NULL) {
    baseLocation = getNearestUnoccupiedBaseLocation(capitalMyBase->baseLocation->getPosition(), startLocation, mustHaveGeyser);
  }
  else {
    baseLocation = getNearestUnoccupiedBaseLocation(Position(1,1), startLocation, mustHaveGeyser); 
  }

  if (baseLocation != NULL) {
    /*for (map<BWTA::BaseLocation*, Unit*>::iterator it = newNexusWorkers.begin(); it != newNexusWorkers.end(); it++) {
      if (it->first == baseLocation) {
        return 4;
      }
    }*/

    MyBase* nearestMyBase = getNearestOccupiedMyBase(baseLocation->getPosition(), false, true);
    Unit* worker = NULL;
    if (nearestMyBase != NULL) {
      worker = nearestMyBase->getNearestFreeWorker(baseLocation->getPosition(), true);
    }
    else { 
      worker = ximp->getNearestUnitType(baseLocation->getPosition(), UnitTypes::Protoss_Probe, MY);
    }

    if (worker != NULL && !worker->isCarryingMinerals() && !worker->isCarryingGas()) {
      //deleteWorkerFromBase(worker);
      newNexusWorkers.insert(pair<BWTA::BaseLocation*, Unit*>(baseLocation, worker));
    }
    else {
      //Broodwar->printf("build new nexus - no free worker exist");
      return 3;
    }
  }
  else {
    //Broodwar->printf("build new nexus - no base location is unoccupied");
    return 2;
  }

  //Broodwar->printf("build new nexus - ok");
  return 0;
}

bool Colony::isInNewNexusWorkers(Unit* worker) {
  for (map<BWTA::BaseLocation*, Unit*>::iterator it = newNexusWorkers.begin(); it != newNexusWorkers.end(); it++) {
    if (it->second == worker && worker->getOrderTargetPosition() == it->first->getPosition()) {
      return true;
    }
  }

  return false;
}

bool Colony::isInBuildingWorkers(Unit* worker) {
  for (map<BWTA::BaseLocation*, MyBase>::iterator it = myBases.begin(); it != myBases.end(); it++) {
    if (it->second.isInBuildingWorkers(worker)) {
      return true;
    }
  }

  return false;
}

bool Colony::researchUpgrade(UpgradeType upgradeType) {
  if (!ximp->isEnoughResources(upgradeType) || !ximp->upgradeRequirementsMet(upgradeType)) {
    return false;
  }

  UnitType whatUpgrades = upgradeType.whatUpgrades();

  if (whatUpgrades == UnitTypes::None) {
    return false;
  }
  else {
    map<UnitType, set<Unit*>>::iterator myUnitsIt = ximp->myUnitsCompleted.find(whatUpgrades);

    if (myUnitsIt != ximp->myUnitsCompleted.end() && !myUnitsIt->second.empty()) {
      for (set<Unit*>::iterator it = myUnitsIt->second.begin(); it != myUnitsIt->second.end(); it++) {
        if (!(*it)->isUpgrading()) {
          (*it)->upgrade(upgradeType);
          return true;
        }
      }
    }
  }

  return false;
}

bool Colony::researchTech(TechType techType) {
  if (!ximp->isEnoughResources(techType) || !ximp->techRequirementsMet(techType)) {
    return false;
  }

  UnitType whatResearches = techType.whatResearches();

  if (whatResearches == UnitTypes::None) {
    return false;
  }
  else {
    map<UnitType, set<Unit*>>::iterator myUnitsIt = ximp->myUnitsCompleted.find(whatResearches);

    if (myUnitsIt != ximp->myUnitsCompleted.end() && !myUnitsIt->second.empty()) {
      for (set<Unit*>::iterator it = myUnitsIt->second.begin(); it != myUnitsIt->second.end(); it++) {
        if (!(*it)->isResearching()) {
          (*it)->research(techType);
          return true;
        }
      }
    }
  }

  return false;
}

int Colony::getNextSupply() {
  vector<UnitType> buildingsBeignBuilt = getBuildingsBeignBuilt();
  int nextSupply = 0;

  for (vector<UnitType>::iterator it = buildingsBeignBuilt.begin(); it != buildingsBeignBuilt.end(); it++) {
    if (*it == UnitTypes::Protoss_Pylon || *it == UnitTypes::Protoss_Nexus) {
      nextSupply += it->supplyProvided()/2;
    }
  }

  set<Unit*> notCompletedNexuses = ximp->getMyUnits(UnitTypes::Protoss_Nexus, false);

  for (set<Unit*>::iterator it = notCompletedNexuses.begin(); it != notCompletedNexuses.end(); it++) {
    if (!(*it)->isCompleted()) {
      nextSupply += UnitTypes::Protoss_Nexus.supplyProvided()/2;
    }
  }

  set<Unit*> notCompletedPylons = ximp->getMyUnits(UnitTypes::Protoss_Pylon, false);

  for (set<Unit*>::iterator it = notCompletedPylons.begin(); it != notCompletedPylons.end(); it++) {
    if (!(*it)->isCompleted()) {
      nextSupply += UnitTypes::Protoss_Pylon.supplyProvided()/2;
    }
  }

  return nextSupply;
}

void Colony::changeStartBuildOrderZerglingRush() {
  map<int, BuildInstruction>::iterator startBuildOrderIt = startBuildOrder.find(9);

  if (startBuildOrderIt != startBuildOrder.end() && startBuildOrderIt->second.unitType != UnitTypes::Protoss_Gateway) {
    startBuildOrderIt->second = BuildInstruction(UnitTypes::Protoss_Gateway, NULL);

    startBuildOrderIt = startBuildOrder.find(11);
    if (startBuildOrderIt != startBuildOrder.end()) {
      startBuildOrder.erase(startBuildOrderIt);
    }

    startBuildOrderIt = startBuildOrder.find(12);
    if (startBuildOrderIt != startBuildOrder.end()) {
      startBuildOrder.erase(startBuildOrderIt);
    }

    startBuildOrderIt = startBuildOrder.find(15);
    if (startBuildOrderIt != startBuildOrder.end()) {
      startBuildOrder.erase(startBuildOrderIt);
    }

    Broodwar->printf("Changed build order against Zergling rush...");
  }
}

void Colony::changeStartBuildOrderZealotRush() {
  MyBase* capitalMyBase = getCapitalMyBase();
  MyBase* naturalMyBase = getNaturalMyBase();

  startBuildOrder.clear();

  startBuildOrder.insert(pair<int, BuildInstruction>(0, BuildInstruction(UnitTypes::Protoss_Nexus, capitalMyBase)));
  if (naturalMyBase != NULL) {
    startBuildOrder.insert(pair<int, BuildInstruction>(8, BuildInstruction(UnitTypes::Protoss_Pylon, naturalMyBase, naturalMyBase->pylonsCentroid)));
  }
  else {
    startBuildOrder.insert(pair<int, BuildInstruction>(8, BuildInstruction(UnitTypes::Protoss_Pylon, naturalMyBase)));
  }
  startBuildOrder.insert(pair<int, BuildInstruction>(9, BuildInstruction(UnitTypes::Protoss_Forge, naturalMyBase)));
  startBuildOrder.insert(pair<int, BuildInstruction>(11, BuildInstruction(UnitTypes::Protoss_Photon_Cannon, naturalMyBase)));
  startBuildOrder.insert(pair<int, BuildInstruction>(12, BuildInstruction(UnitTypes::Protoss_Photon_Cannon, naturalMyBase)));
  startBuildOrder.insert(pair<int, BuildInstruction>(13, BuildInstruction(UnitTypes::Protoss_Pylon, capitalMyBase)));
  startBuildOrder.insert(pair<int, BuildInstruction>(14, BuildInstruction(UnitTypes::Protoss_Photon_Cannon, naturalMyBase)));
  startBuildOrder.insert(pair<int, BuildInstruction>(15, BuildInstruction(UnitTypes::Protoss_Photon_Cannon, naturalMyBase)));
  startBuildOrder.insert(pair<int, BuildInstruction>(16, BuildInstruction(UnitTypes::Protoss_Nexus, NULL)));
  startBuildOrder.insert(pair<int, BuildInstruction>(17, BuildInstruction(UnitTypes::Protoss_Photon_Cannon, naturalMyBase)));
  startBuildOrder.insert(pair<int, BuildInstruction>(18, BuildInstruction(UnitTypes::Protoss_Photon_Cannon, naturalMyBase)));
  startBuildOrder.insert(pair<int, BuildInstruction>(19, BuildInstruction(UnitTypes::Protoss_Gateway, capitalMyBase)));
  startBuildOrder.insert(pair<int, BuildInstruction>(20, BuildInstruction(UnitTypes::Protoss_Assimilator, capitalMyBase)));
  startBuildOrder.insert(pair<int, BuildInstruction>(21, BuildInstruction(UnitTypes::Protoss_Cybernetics_Core, capitalMyBase)));
  startBuildOrder.insert(pair<int, BuildInstruction>(22, BuildInstruction(UnitTypes::Protoss_Photon_Cannon, naturalMyBase)));
  startBuildOrder.insert(pair<int, BuildInstruction>(23, BuildInstruction(UnitTypes::Protoss_Photon_Cannon, naturalMyBase)));

  Broodwar->printf("Changed build order against Zealot rush...");
}

void Colony::changeStartBuildOrderMarineRush() {
  MyBase* capitalMyBase = getCapitalMyBase();

  startBuildOrder.clear();

  startBuildOrder.insert(pair<int, BuildInstruction>(0, BuildInstruction(UnitTypes::Protoss_Nexus, capitalMyBase)));
  startBuildOrder.insert(pair<int, BuildInstruction>(8, BuildInstruction(UnitTypes::Protoss_Pylon, capitalMyBase, capitalMyBase != NULL ? capitalMyBase->pylonsCentroid : Position(-1,-1))));
  startBuildOrder.insert(pair<int, BuildInstruction>(9, BuildInstruction(UnitTypes::Protoss_Forge, capitalMyBase, capitalMyBase != NULL ? capitalMyBase->pylonsCentroid : Position(-1, -1))));
  startBuildOrder.insert(pair<int, BuildInstruction>(11, BuildInstruction(UnitTypes::Protoss_Photon_Cannon, capitalMyBase, capitalMyBase != NULL ? capitalMyBase->pylonsCentroid : Position(-1, -1))));
  startBuildOrder.insert(pair<int, BuildInstruction>(12, BuildInstruction(UnitTypes::Protoss_Photon_Cannon, capitalMyBase, capitalMyBase != NULL ? capitalMyBase->pylonsCentroid : Position(-1, -1))));
  startBuildOrder.insert(pair<int, BuildInstruction>(13, BuildInstruction(UnitTypes::Protoss_Photon_Cannon, capitalMyBase, capitalMyBase != NULL ? capitalMyBase->pylonsCentroid : Position(-1, -1))));
  startBuildOrder.insert(pair<int, BuildInstruction>(14, BuildInstruction(UnitTypes::Protoss_Pylon, capitalMyBase)));
  startBuildOrder.insert(pair<int, BuildInstruction>(15, BuildInstruction(UnitTypes::Protoss_Gateway, capitalMyBase)));
  startBuildOrder.insert(pair<int, BuildInstruction>(16, BuildInstruction(UnitTypes::Protoss_Assimilator, capitalMyBase)));
  startBuildOrder.insert(pair<int, BuildInstruction>(17, BuildInstruction(UnitTypes::Protoss_Cybernetics_Core, capitalMyBase)));
  startBuildOrder.insert(pair<int, BuildInstruction>(18, BuildInstruction(UnitTypes::Protoss_Nexus, NULL)));

  Broodwar->printf("Changed build order against Marine rush...");
}

void Colony::changeNormalBuildOrderEarlyMutalisks() {
  normalBuildOrder.clear();

  normalBuildOrder.push_back(BuildInstruction(UnitTypes::Protoss_Nexus, NULL));
  normalBuildOrder.push_back(BuildInstruction(UnitTypes::Protoss_Forge, NULL));
  normalBuildOrder.push_back(BuildInstruction(UnitTypes::Protoss_Nexus, NULL));
  normalBuildOrder.push_back(BuildInstruction(UnitTypes::Protoss_Gateway, NULL));
  normalBuildOrder.push_back(BuildInstruction(UnitTypes::Protoss_Cybernetics_Core, NULL));
  normalBuildOrder.push_back(BuildInstruction(UnitTypes::Protoss_Stargate, NULL));
  normalBuildOrder.push_back(BuildInstruction(UnitTypes::Protoss_Stargate, NULL));
  normalBuildOrder.push_back(BuildInstruction(UnitTypes::Protoss_Stargate, NULL));
  normalBuildOrder.push_back(BuildInstruction(UnitTypes::Protoss_Nexus, NULL));
  normalBuildOrder.push_back(BuildInstruction(UnitTypes::Protoss_Stargate, NULL));
  normalBuildOrder.push_back(BuildInstruction(UnitTypes::Protoss_Fleet_Beacon, NULL));
  normalBuildOrder.push_back(BuildInstruction(UnitTypes::Protoss_Gateway, NULL));

  Broodwar->printf("Changed build order against early Mutalisks...");
}