#pragma once

using namespace BWAPI;
using namespace std;

enum CarrierInstruction { WAIT, ATTACK_UNITS, ATTACK_MOVE, ATTACK_POSITIONS, DEFEND_BASE, MOVE, DONE, ATTACK_ALL };

class Ximp;
class MyBase;

class CarrierGroup {
  
  public:
    
    Ximp* ximp;

    set<Unit*> units;

    Unit* observer;
    Unit* arbiter;

    Position movePosition;
    Position attackPosition;
    Position centroid;

    MyBase* defendedMyBase;

    Unit* attackedUnit;
    int attackedUnitPriority;

    vector<Position> attackPositions;
    int attackPositionsCurrent;
    bool hasAtLeastDone;
	  bool waitForResupply;
    bool retreating;
    bool attackRepairing;
    int minCountInterceptors;

    CarrierInstruction instruction;
    vector<CarrierInstruction> previousInstructions;

    CarrierGroup(Ximp *x, set<Unit*> un = set<Unit*>()): 
      ximp(x),
      units(un),
      defendedMyBase(NULL),
      movePosition(Position(-1,-1)),
      attackPosition(Position(-1,-1)),
      observer(NULL),
      arbiter(NULL),
      attackedUnit(NULL),
      attackedUnitPriority(0),
      hasAtLeastDone(false),
	    waitForResupply(false),
      retreating(false),
      attackRepairing(false),
      minCountInterceptors(8),
      instruction(WAIT) {};

    void computeCentroid();
    void doStopIfNeeded();
    void doInstruction();
    void doRetreat();

    int countInterceptors();
	  int maxCountInterceptors();
	  int desiredCountInterceptors();

    Unit* findBestTarget(set<Unit*> &units);

    bool attackPriorityEnemyUnits(set<Unit*> unitsInRadius);
    void groupMove(Position pos);
    void groupStop();
    void groupHoldPosition();
    void groupAttackUnit(Unit *unit);
    void groupAttackPosition(Position pos);
    void groupDefendBase(MyBase* myBase, Position pos);
    void groupStopDefendBase();

    void onUnitHide(Unit* unit);
    void onUnitDestroy(Unit* unit);

};