#include "Dll.h"


void CarrierGroup::computeCentroid() {
  centroid = ximp->computeCentroid(units);
}

void CarrierGroup::doStopIfNeeded() {
  if (waitForResupply && countInterceptors() >= desiredCountInterceptors()) {
    waitForResupply = false;
  }

  if (countInterceptors() < (int)((double)desiredCountInterceptors() * 0.6) || waitForResupply) {
	  waitForResupply = true;

	  for (set<Unit*>::iterator it = units.begin(); it != units.end(); it++) {
      if (!retreating) {
        (*it)->move((*it)->getPosition());
        attackedUnit = NULL;
        attackedUnitPriority = 0;
	    }
    }
  }
}

void CarrierGroup::doInstruction() {
  if (observer != NULL) {
    if (observer->getPosition().getDistance(centroid) > TILE_SIZE) {
      observer->move(centroid);
    }
  }

  if (arbiter != NULL) {
    if (arbiter->getPosition().getDistance(centroid) > TILE_SIZE) {
      arbiter->move(centroid);
    }
  }

  set<Unit*> unitsInRadius = Broodwar->getUnitsInRadius(centroid, UnitTypes::Protoss_Carrier.sightRange() + 2*TILE_SIZE);
  set<Unit*> enemyUnits = ximp->getEnemyUnits(unitsInRadius);  

  if (instruction == WAIT) {

  }
  else if (instruction == ATTACK_UNITS) {
	  if (!enemyUnits.empty()) {
      if (waitForResupply) {
        return;
      }

      if (attackedUnit != NULL) {
        if (!attackRepairing) {
          for (set<Unit*>::iterator it = enemyUnits.begin(); it != enemyUnits.end(); it++) {
            if ((*it)->getOrderTarget() != NULL && (*it)->getOrderTarget() == attackedUnit && 
                (((*it)->isRepairing() && (*it)->isInWeaponRange(attackedUnit)) || 
                (((*it)->getOrder() == Orders::MedicHeal1 || (*it)->getOrder() == Orders::MedicHeal2) && (*it)->getPosition().getDistance(attackedUnit->getPosition()) <= TILE_SIZE*3))) {
              groupAttackUnit(*it);
              attackRepairing = true;
              break;
            }
          }
        }

        if (attackRepairing && attackedUnit != NULL && centroid.getDistance(attackedUnit->getPosition()) < UnitTypes::Protoss_Carrier.seekRange()+4*TILE_SIZE) {
          return;
        }

        for (set<Unit*>::iterator it = units.begin(); it != units.end(); it++) {
          if ((*it)->getOrderTarget() != attackedUnit && !attackedUnit->getType().isAddon()) {
            (*it)->attack(attackedUnit);
          }
        }

        /*if (attackedUnit->exists()) {
          return;
        }*/
      }

      ////////////
      /*if (previousInstructions.back() == DEFEND_BASE && defendedMyBase != NULL) {
        set<Unit*> unitsInBaseRadius = Broodwar->getUnitsInRadius(defendedMyBase->baseLocation->getPosition(), 30*TILE_SIZE);
        enemyUnits = ximp->getEnemyUnits(unitsInBaseRadius);
      }*/
      ////////////

      if (!attackPriorityEnemyUnits(enemyUnits)) {
        attackedUnit = NULL;
        instruction = previousInstructions.back();
        previousInstructions.pop_back();
        attackedUnitPriority = 0;
      }
    }
    else {
      attackedUnit = NULL;
      instruction = previousInstructions.back();
      previousInstructions.pop_back();
      attackedUnitPriority = 0;
    }
  }
  else if (instruction == ATTACK_MOVE) {
	  bool move = false;

    for (set<Unit*>::iterator it = units.begin(); it != units.end(); it++) {
      if ((!(*it)->isMoving() && !(*it)->isAttacking()) || (*it)->getPosition().getDistance(attackPosition) > 4*TILE_SIZE) {
        move = true;
        break;
      }
    }

    if (move) {
      groupAttackPosition(attackPosition);
    }

    ////////////
    /*if (previousInstructions.back() == DEFEND_BASE && defendedMyBase != NULL) {
      set<Unit*> unitsInBaseRadius = Broodwar->getUnitsInRadius(defendedMyBase->baseLocation->getPosition(), 30*TILE_SIZE);
      enemyUnits = ximp->getEnemyUnits(unitsInBaseRadius);
    }*/
    ////////////
      
    /*bool isAttacking = */attackPriorityEnemyUnits(enemyUnits);

    if (centroid.getDistance(attackPosition) <= 4*TILE_SIZE) {
      instruction = previousInstructions.back();
      previousInstructions.pop_back();
    }
    /*else if (move && !isAttacking) {
      groupAttackPosition(attackPosition);
    }*/
  }
  else if (instruction == ATTACK_POSITIONS) {
    if (attackPositionsCurrent >= 0 && attackPositionsCurrent < attackPositions.size()) {
      Position attackPos = attackPositions.at(attackPositionsCurrent);

      bool move = false;

      for (set<Unit*>::iterator it = units.begin(); it != units.end(); it++) {
        if ((!(*it)->isMoving() && !(*it)->isAttacking()) || (*it)->getPosition().getDistance(attackPos) > 4*TILE_SIZE) {
          move = true;
          break;
        }
      }

      if (move) {
        if (attackPositionsCurrent < attackPositions.size()) {
          groupAttackPosition(attackPos);
        }
      }

      attackPriorityEnemyUnits(enemyUnits);

      if (centroid.getDistance(attackPos) <= 4*TILE_SIZE) {
        attackPositionsCurrent++;

        if (attackPositionsCurrent < attackPositions.size()) {
          attackPos = attackPositions.at(attackPositionsCurrent);
          groupAttackPosition(attackPos);
        }
        else {
          instruction = DONE;
        }
      }
    }
  }
  else if (instruction == DEFEND_BASE) {
    if (defendedMyBase != NULL) {
      vector<Position> enemyBaseUnitPositions = ximp->getEnemyUnitPositionsInRadius(defendedMyBase->baseLocation->getPosition(), 30*TILE_SIZE);

      Position nearest(-1,-1);
      for (vector<Position>::iterator it = enemyBaseUnitPositions.begin(); it != enemyBaseUnitPositions.end(); it++) {
        if ((nearest == Position(-1,-1) || centroid.getDistance(*it) <= centroid.getDistance(nearest)) && it->isValid()) {
          nearest = *it;
        }
      }
      
      if (nearest != Position(-1,-1) && centroid.getDistance(nearest) > TILE_SIZE*4) {
        groupAttackPosition(nearest);
      }

      set<Unit*> unitsInBaseRadius = Broodwar->getUnitsInRadius(defendedMyBase->baseLocation->getPosition(), 30*TILE_SIZE);
      set<Unit*> enemyBaseUnits = ximp->getEnemyUnits(unitsInBaseRadius);

      if (nearest == Position(-1,-1) && !attackPriorityEnemyUnits(enemyBaseUnits)) {
        instruction = previousInstructions.back();
        previousInstructions.pop_back();
        defendedMyBase->defendingGroup = NULL;

        defendedMyBase = NULL;

        MyBase* capitalMyBase = ximp->colony.getCapitalMyBase();

        if (capitalMyBase != NULL && instruction == WAIT) {
          groupMove(capitalMyBase->baseLocation->getPosition());
        }
      }
    }
    else {
      instruction = previousInstructions.back();
      previousInstructions.pop_back();
     
      MyBase* capitalMyBase = ximp->colony.getCapitalMyBase();

      if (capitalMyBase != NULL && instruction == WAIT) {
        groupMove(capitalMyBase->baseLocation->getPosition());
      }
    }
  }
  else if (instruction == MOVE) {
    bool move = false;

    for (set<Unit*>::iterator it = units.begin(); it != units.end(); it++) {
      if (!(*it)->isMoving() || (*it)->getPosition().getDistance(movePosition) > 4*TILE_SIZE) {
        move = true;
        break;
      }
    }

    if (move) {
      groupMove(movePosition);
    }

    if (centroid.getDistance(movePosition) <= 4*TILE_SIZE) {
      instruction = previousInstructions.back();
      previousInstructions.pop_back();
    }
  }
  else if (instruction == DONE) {

  }
  else if (instruction == ATTACK_ALL) {
    attackPriorityEnemyUnits(enemyUnits);
  }
}

void CarrierGroup::doRetreat() {
  retreating = false;

  set<Unit*> unitsInRadius = Broodwar->getUnitsInRadius(centroid, UnitTypes::Protoss_Carrier.sightRange() + 2*TILE_SIZE);
  set<Unit*> enemyUnits = ximp->getEnemyUnits(unitsInRadius);

  set<Unit*> withAirWeapons = ximp->getUnitsWithAirWeapons(enemyUnits);

  set<Unit*> highTemplars = ximp->getUnitsOfType(UnitTypes::Protoss_High_Templar, enemyUnits);
  set<Unit*> darkArchons = ximp->getUnitsOfType(UnitTypes::Protoss_Dark_Archon, enemyUnits);
  withAirWeapons.insert(highTemplars.begin(), highTemplars.end());
  withAirWeapons.insert(darkArchons.begin(), darkArchons.end());

	int desCountInterceptors = desiredCountInterceptors();
  int currentCountInterceptors = countInterceptors();

  for (set<Unit*>::iterator it = withAirWeapons.begin(); it != withAirWeapons.end(); it++) {
    int range = (*it)->getType().airWeapon().maxRange()/*+4*TILE_SIZE*/;

    if ((*it)->getType() == UnitTypes::Protoss_High_Templar) { 
      range = WeaponTypes::Psionic_Storm.maxRange();
    }
    else if ((*it)->getType() == UnitTypes::Protoss_Dark_Archon) { 
      range = WeaponTypes::Mind_Control.maxRange();
    }
    else if ((*it)->getType() == UnitTypes::Protoss_Dragoon) {
      range = UnitTypes::Protoss_Dragoon.airWeapon().maxRange() + 3*TILE_SIZE;
    }
    else if ((*it)->getType() == UnitTypes::Terran_Bunker) {
      range = 6 * TILE_SIZE;
    }
    else if ((*it)->getType() == UnitTypes::Protoss_Carrier || (*it)->getType() == UnitTypes::Protoss_Interceptor) { 
      continue;
    }

    for (set<Unit*>::iterator jt = units.begin(); jt != units.end(); jt++) {
      if (!(*it)->getType().isFlyer() || currentCountInterceptors < desCountInterceptors) {
        if ((*it)->isInWeaponRange(*jt) || (((*it)->getType() == UnitTypes::Protoss_High_Templar || (*it)->getType() == UnitTypes::Protoss_Dark_Archon || (*it)->getType() == UnitTypes::Protoss_Dragoon || (*it)->getType() == UnitTypes::Terran_Bunker) && (*jt)->getPosition().getDistance((*it)->getPosition()) <= range)) {
          Position vec((*jt)->getPosition().x() - (*it)->getPosition().x(), (*jt)->getPosition().y() - (*it)->getPosition().y());

          double vecLength = sqrt((double)(vec.x()*vec.x() + vec.y()*vec.y()));
          if (vecLength == 0) { 
            vecLength = 1; 
          }
          
          double moveQuot = (range + TILE_SIZE*2) / vecLength;
          Position vecMove(vec.x()*moveQuot, vec.y()*moveQuot);

          Position nextPos((*jt)->getPosition().x() + vecMove.x(), (*jt)->getPosition().y() + vecMove.y());
          TilePosition nextTilePos(nextPos);

          if (nextTilePos.isValid()) {
            if (nextPos.getDistance((*jt)->getPosition()) > TILE_SIZE) {
              if (!waitForResupply) {
                (*jt)->attack(nextPos);
              }
              else {
                (*jt)->move(nextPos);
              }
            }
          }
          else {
            if (nextPos.makeValid().getDistance((*jt)->getPosition()) > 2*TILE_SIZE) {
              if (!waitForResupply) {
                (*jt)->attack(nextPos.makeValid());
              }
              else {
                (*jt)->move(nextPos.makeValid());
              }
            }
          }

          retreating = true;
        }
      }
    }
  }
}

int CarrierGroup::countInterceptors() {
  int result = 0;

  for (set<Unit*>::iterator it = units.begin(); it != units.end(); it++) {
    result += (*it)->getInterceptorCount();
  }

  return result;
}

int CarrierGroup::maxCountInterceptors() {
  return units.size() * (Broodwar->self()->getUpgradeLevel(UpgradeTypes::Carrier_Capacity) == 0 ? 4 : 8);
}

int CarrierGroup::desiredCountInterceptors() {
  double ratio = UnitTypes::Protoss_Interceptor.airWeapon().damageAmount() + Broodwar->self()->getUpgradeLevel(UpgradeTypes::Protoss_Air_Weapons);
    
  set<Unit*> unitsInRadius = Broodwar->getUnitsInRadius(centroid, UnitTypes::Protoss_Carrier.sightRange() + 4*TILE_SIZE);
  set<Unit*> enemyUnits = ximp->getEnemyUnits(unitsInRadius);
  set<Unit*> withAirWeapons = ximp->getUnitsWithAirWeapons(enemyUnits);

  double enemyAirWeaponsPower = ximp->getAirAttackPower(withAirWeapons);

  int desiredCountInterceptors = enemyAirWeaponsPower / ratio;

  if (desiredCountInterceptors > maxCountInterceptors()) {
    desiredCountInterceptors = maxCountInterceptors();
  }

  return desiredCountInterceptors;
}

Unit* CarrierGroup::findBestTarget(set<Unit*> &enemyUnits) {
  Unit* unit = NULL;

  if (unit == NULL) {
    for (set<Unit*>::iterator it = enemyUnits.begin(); it != enemyUnits.end(); it++) {
      if ((*it)->getType().canAttack() && (unit == NULL || (double)(*it)->getType().groundWeapon().damageAmount()/(double)(*it)->getType().groundWeapon().damageCooldown() > (double)unit->getType().groundWeapon().damageAmount()/(double)unit->getType().groundWeapon().damageCooldown())) {
        if (unit == NULL || (*it)->getPosition().getDistance(centroid) < unit->getPosition().getDistance(centroid)) {
          unit = *it;
        }
      }
    }
  }

  if (unit == NULL) {
    for (set<Unit*>::iterator it = enemyUnits.begin(); it != enemyUnits.end(); it++) {
      if (unit == NULL || (*it)->getType().mineralPrice() + (*it)->getType().gasPrice() > unit->getType().mineralPrice() + unit->getType().gasPrice()) {
        if (unit == NULL || (*it)->getPosition().getDistance(centroid) < unit->getPosition().getDistance(centroid)) {
          unit = *it;
        }
      }
    }
  }

  return unit;
}

bool CarrierGroup::attackPriorityEnemyUnits(set<Unit*> units) {
  if (waitForResupply) {
    return true;
  }

  set<Unit*> highTemplars = ximp->getUnitsOfType(UnitTypes::Protoss_High_Templar, units);
  set<Unit*> darkArchons = ximp->getUnitsOfType(UnitTypes::Protoss_Dark_Archon, units);
  set<Unit*> specials;
  specials.insert(highTemplars.begin(), highTemplars.end());
  specials.insert(darkArchons.begin(), darkArchons.end());

  Unit* nearestSpecial = ximp->getNearestUnit(centroid, specials);

  set<Unit*> withAirWeapons = ximp->getUnitsWithAirWeapons(units);
  Unit* nearestWithAirWeapons = ximp->getNearestUnit(centroid, withAirWeapons);

  set<Unit*> importantBuildings = ximp->getImportantBuildings(units);
  Unit* nearestImportantBuilding = ximp->getNearestUnit(centroid, importantBuildings);

  set<Unit*> resourceDepots = ximp->getResourceDepots(units);
  Unit* nearestResourceDepot = ximp->getNearestUnit(centroid, resourceDepots);

  set<Unit*> productionBuildings = ximp->getProductionBuildings(units);
  Unit* nearestProductionBuilding = ximp->getNearestUnit(centroid, productionBuildings);

  set<Unit*> workers = ximp->getWorkers(units);
  Unit* nearestWorker = ximp->getNearestUnit(centroid, workers);

  Unit* bestTarget = findBestTarget(units);

  if (nearestSpecial != NULL && attackedUnitPriority <= 7) {
    if (attackedUnitPriority < 7) {
      groupAttackUnit(nearestSpecial);
      attackedUnitPriority = 7;
    }
    return true;
  }
  else if (attackedUnitPriority <= 6) {
    if (nearestWithAirWeapons != NULL) {
      if (attackedUnitPriority < 6 || centroid.getDistance(nearestWithAirWeapons->getPosition()) > UnitTypes::Protoss_Carrier.seekRange()) {
        groupAttackUnit(nearestWithAirWeapons);
        attackedUnitPriority = 6;
      }
      return true;
    }
    else if (attackedUnitPriority <= 5) {
      if (nearestImportantBuilding != NULL) {
        if (attackedUnitPriority < 5) {
          groupAttackUnit(nearestImportantBuilding);
          attackedUnitPriority = 5;
        }
        return true;
      }
      else if (attackedUnitPriority <= 4) {
        if (nearestResourceDepot != NULL) {
          if (attackedUnitPriority < 4) {
            groupAttackUnit(nearestResourceDepot);
            attackedUnitPriority = 4;
          }
          return true;
        }

        else if (attackedUnitPriority <= 3) {
          if (nearestProductionBuilding != NULL) {
            if (attackedUnitPriority < 3) {
              groupAttackUnit(nearestProductionBuilding);
              attackedUnitPriority = 3;
            }
            return true;
          }
          else if (attackedUnitPriority <= 2) {
            if (nearestWorker != NULL) {
              if (attackedUnitPriority < 2) {
                groupAttackUnit(nearestWorker);
                attackedUnitPriority = 2;
              }
              return true;
            }
            else if (bestTarget != NULL && attackedUnitPriority <= 1) {
              if (attackedUnitPriority < 1) {
                groupAttackUnit(bestTarget);
                attackedUnitPriority = 1;
              }
              return true;
            }
          }
        }
      }
    }
  }
  
  if (bestTarget == NULL && hasAtLeastDone) {
    Position nearestEnemyUnitPosition = ximp->getNearestEnemyUnitPosition(centroid, true);

    if (nearestEnemyUnitPosition != Position(-1,-1) && centroid.getDistance(nearestEnemyUnitPosition) > 6*TILE_SIZE) {
      groupAttackPosition(nearestEnemyUnitPosition);
      attackedUnitPriority = 0;
      return true;
    }
    else if (centroid.getDistance(nearestEnemyUnitPosition) <= 6*TILE_SIZE) {
      return true;
    }
  }

  return false;
}

void CarrierGroup::groupMove(Position pos) {
  if (pos.isValid()) {
    movePosition = pos;

    for (set<Unit*>::iterator it = units.begin(); it != units.end(); it++) {
      (*it)->move(pos);
    }

    if (instruction != MOVE) {
      previousInstructions.push_back(instruction);
      instruction = MOVE;
    }
  }
}

void CarrierGroup::groupStop() {
  for (set<Unit*>::iterator it = units.begin(); it != units.end(); it++) {
    (*it)->stop();
  }
}

void CarrierGroup::groupAttackUnit(Unit *unit) {
  if (attackedUnit != unit) {
	  int desCountInterceptors = desiredCountInterceptors();
    int currentCountInterceptors = countInterceptors();

    if (currentCountInterceptors >= desCountInterceptors || instruction == ATTACK_UNITS) {
	    if (currentCountInterceptors < desCountInterceptors / 2 && instruction == ATTACK_UNITS) {
        attackedUnit = NULL;
        instruction = previousInstructions.back();
        previousInstructions.pop_back();
        attackedUnitPriority = 0;
		    return;
	    }

      for (set<Unit*>::iterator it = units.begin(); it != units.end(); it++) {
        (*it)->attack(unit);
      }

      attackedUnit = unit;

      if (instruction != ATTACK_UNITS) {
        previousInstructions.push_back(instruction);
        instruction = ATTACK_UNITS;
      }
    }
  }
}

void CarrierGroup::groupAttackPosition(Position pos) {
  if (pos.isValid()) {
    attackPosition = pos;

    for (set<Unit*>::iterator it = units.begin(); it != units.end(); it++) {
      (*it)->attack(pos);
    }

    if (instruction != ATTACK_MOVE) {
      previousInstructions.push_back(instruction);
      instruction = ATTACK_MOVE;
    }
  }
}

void CarrierGroup::groupDefendBase(MyBase* myBase, Position pos) {
  if (defendedMyBase != myBase) {
    if (myBase != NULL) {
      myBase->defendingGroup = this;
    }
    defendedMyBase = myBase;
    
    for (set<Unit*>::iterator it = units.begin(); it != units.end(); it++) {
      (*it)->attack(pos);
    }

    if (instruction != DEFEND_BASE) {
      previousInstructions.push_back(instruction);
      instruction = DEFEND_BASE;
    }
  }
}

void CarrierGroup::groupStopDefendBase() {
  if (defendedMyBase->defendingGroup != NULL) {
    if (instruction == DEFEND_BASE) {
      instruction = previousInstructions.back();
      previousInstructions.pop_back();
    }
    else {
      for (vector<CarrierInstruction>::iterator it = previousInstructions.begin(); it != previousInstructions.end(); ) {
        if (*it == DEFEND_BASE) {
          vector<CarrierInstruction>::iterator temp = it;
          it++;
          previousInstructions.erase(temp);
        }
        else {
          it++;
        }
      }
    }

    defendedMyBase->defendingGroup = NULL;

    defendedMyBase = NULL;
  }
}

void CarrierGroup::onUnitHide(Unit* unit) {
  if (Broodwar->self()->isEnemy(unit->getPlayer()) || unit->getType().isAddon()) {
    if (unit == attackedUnit) {
      attackedUnit = NULL;
      previousInstructions.push_back(instruction);
      attackedUnitPriority = 0;
      attackRepairing = false;
    }
  }
}

void CarrierGroup::onUnitDestroy(Unit* unit) {
  if (Broodwar->self()->isEnemy(unit->getPlayer()) || unit->getType().isAddon()) {
    if (unit == attackedUnit) {
      attackedUnit = NULL;
      previousInstructions.push_back(instruction);
      attackedUnitPriority = 0;
      attackRepairing = false;
    }
  }
}