#pragma once

using namespace BWAPI;
using namespace std;

class Base;
class Ximp;

class Army {
  
  private: 

    Ximp *ximp;

    void onDestroy(Unit* unit, bool onlyChangedOwnership = false);

  public:    

    int carrierGroupSize;
    int corsairGroupSize;
    int maxCreatedDistance;

    //////////////////
    Position nearestEnemyBasePosition;
    Position nearestEdgePosition;
    BWTA::BaseLocation* baseLocation;
    Position nearestEdgeBasePosition;
    //////////////////

    std::map<Unit*, Unit*> capitalMyBaseDefenseProbes;

    vector<CarrierGroup> carrierGroups;
    vector<CorsairGroup> corsairGroups;
    vector<Position> carrierPath;

    Army(Ximp *x): ximp(x), 
                   carrierGroupSize(4), 
                   corsairGroupSize(14),
                   maxCreatedDistance(40*TILE_SIZE), 
                   nearestEnemyBasePosition(Position(-1,-1)), 
                   nearestEdgePosition(Position(-1,-1)),
                   baseLocation(NULL) {};

    void onStart();
    void onUnitDiscover(Unit* unit);
    void onFrame();
    void onNukeDetect(Position target);
    void onUnitCreate(Unit* unit);
    void onUnitComplete(Unit *unit);
    void onUnitDestroy(Unit* unit);
    void onUnitMorph(Unit* unit);
    void onUnitRenegade(Unit* unit);
    void onUnitEvade(Unit* unit);
    void onUnitShow(Unit* unit);
    void onUnitHide(Unit* unit);

    void processAnalysis();

    void trainInterceptors();
    void defendBasesWithCarrierGroups();
    void defendCapitalBase();
    void handleUnassignedUnits();
    void handleCapitalMyBaseZealots();
    void handleCapitalMyBaseDragoons();

    void followCapitalMyBaseEnemyProbes();

    void zerglingRushDefense();
    void canonRushDefense();

    CarrierGroup* getNearestCarrierGroupForCarrier(Unit* unit);
    CarrierGroup* getNearestCarrierGroup(Position pos, bool canDefendingMyBase = true, bool mustHaveEnoughInterceptors = false);
    void calculateCarrierPath();

    Unit* getUnassignedObserverToAnyGroup();
    Unit* getUnassignedArbiterToAnyGroup();
    int getNearestNextPosition(Position position, vector<Position> positions);

    vector<Position> getBasePositionsList(Position pos);

};