#include "Dll.h"


void Army::onDestroy(Unit* unit, bool onlyChangedOwnership) {
  if ((!Broodwar->self()->isEnemy(unit->getPlayer()) && !unit->getPlayer()->isNeutral()) || (Broodwar->self()->isEnemy(unit->getPlayer()) && onlyChangedOwnership)) {
    if (unit->getType() == UnitTypes::Protoss_Carrier) {
      for (vector<CarrierGroup>::iterator it = carrierGroups.begin(); it != carrierGroups.end(); it++) {
        if (it->units.find(unit) != it->units.end()) {
          for (set<Unit*>::iterator jt = it->units.begin(); jt != it->units.end(); jt++) {
            if (*jt == unit) {
              it->units.erase(jt);
              break;
            }
          }

          if (it->units.empty()) {
            if (it->defendedMyBase != NULL) {
              it->groupStopDefendBase();
            }
            carrierGroups.erase(it);
            break;
          }
        }
      }
    }
    else if (unit->getType() == UnitTypes::Protoss_Corsair) {
      for (vector<CorsairGroup>::iterator it = corsairGroups.begin(); it != corsairGroups.end(); it++) {
        if (it->units.find(unit) != it->units.end()) {
          for (set<Unit*>::iterator jt = it->units.begin(); jt != it->units.end(); jt++) {
            if (*jt == unit) {
              it->units.erase(jt);
              break;
            }
          }

          if (it->units.empty()) {
            corsairGroups.erase(it);
            break;
          }
        }
      }
    }
    else if (unit->getType() == UnitTypes::Protoss_Probe) {
      for (std::map<Unit*, Unit*>::iterator it = capitalMyBaseDefenseProbes.begin(); it != capitalMyBaseDefenseProbes.end(); it++) {
        if (it->first == unit) {
          capitalMyBaseDefenseProbes.erase(it);
          break;
        }
      }
    }
    else if (unit->getType() == UnitTypes::Protoss_Observer) {
      bool deleted = false;

      for (vector<CarrierGroup>::iterator it = carrierGroups.begin(); it != carrierGroups.end(); it++) {
        if (it->observer == unit) {
          it->observer = getUnassignedObserverToAnyGroup();
          deleted = true;
          break;
        }
      }

      if (!deleted) {
        for (vector<CorsairGroup>::iterator it = corsairGroups.begin(); it != corsairGroups.end(); it++) {
          if (it->observer == unit) {
            it->observer = getUnassignedObserverToAnyGroup();
            break;
          }
        }
      }
    }
    else if (unit->getType() == UnitTypes::Protoss_Arbiter) {
      for (vector<CarrierGroup>::iterator it = carrierGroups.begin(); it != carrierGroups.end(); it++) {
        if (it->arbiter == unit) {
          it->arbiter = getUnassignedArbiterToAnyGroup();
          break;
        }
      }
    }
  }

  for (vector<CarrierGroup>::iterator groupIt = carrierGroups.begin(); groupIt != carrierGroups.end(); groupIt++) {
    groupIt->onUnitDestroy(unit);
  }
}

void Army::onStart() {
  carrierGroups.clear();
  corsairGroups.clear();
}

void Army::onUnitDiscover(Unit* unit) {

}

void Army::onFrame() {
  #if WRITE_LOG 
    ostringstream ss;
    ss << "Army::onFrame - start";
    ximp->log.writeToLog(ss.str());
  #endif

  if ((Broodwar->getFrameCount() % 5 == 0) && (Broodwar->getFrameCount() > 0)) {
    for (vector<CarrierGroup>::iterator groupIt = carrierGroups.begin(); groupIt != carrierGroups.end(); groupIt++) {
      groupIt->computeCentroid();
      groupIt->doInstruction();

      if (groupIt->instruction == DONE && !groupIt->units.empty()) {
        vector<Position> positions = getBasePositionsList(groupIt->centroid);
        
        groupIt->attackPositionsCurrent = getNearestNextPosition(groupIt->centroid, positions);

        if (groupIt->attackPositionsCurrent > -1) {
          groupIt->hasAtLeastDone = true;
          groupIt->attackPositions = positions;
          groupIt->groupAttackPosition(positions[groupIt->attackPositionsCurrent]);
          groupIt->instruction = ATTACK_POSITIONS;
        }
        else {
          groupIt->instruction = ATTACK_ALL;
        }
      } 
    }

    trainInterceptors();
  }

  if ((Broodwar->getFrameCount() % 5 == 0) && (Broodwar->getFrameCount() > 0)) {
    for (vector<CorsairGroup>::iterator groupIt = corsairGroups.begin(); groupIt != corsairGroups.end(); groupIt++) {
      groupIt->computeCentroid();
    }
  }
  defendBasesWithCarrierGroups();
  defendCapitalBase();

  for (map<BWTA::BaseLocation*, EnemyBase>::iterator it = ximp->enemyBases.begin(); it != ximp->enemyBases.begin(); it++) {
    if (it->second.isEnemyBase()) {
      map<BWTA::BaseLocation*, MyBase>::iterator jt = ximp->colony.myBases.find(it->first);

      if (jt != ximp->colony.myBases.end()) {
        if (jt->second.defendingGroup != NULL) {
          jt->second.defendingGroup->groupStopDefendBase();
        }
      }
    }
  }

  for (vector<CarrierGroup>::iterator groupIt = carrierGroups.begin(); groupIt != carrierGroups.end(); groupIt++) {
    groupIt->doStopIfNeeded();
    groupIt->doRetreat();
  }

  if ((Broodwar->getFrameCount() % 5 == 0) && (Broodwar->getFrameCount() > 0)) {
    for (vector<CorsairGroup>::iterator groupIt = corsairGroups.begin(); groupIt != corsairGroups.end(); groupIt++) {
      groupIt->computeCentroid();
      groupIt->doInstruction();
    }
  }

  for (vector<CorsairGroup>::iterator groupIt = corsairGroups.begin(); groupIt != corsairGroups.end(); groupIt++) {
    groupIt->doRetreat();
  }

  handleUnassignedUnits();
  handleCapitalMyBaseZealots();
  handleCapitalMyBaseDragoons();

  if (ximp->isZerglingRush) {
    zerglingRushDefense();
  }

  if ((Broodwar->getFrameCount() % 5 == 0) && (Broodwar->getFrameCount() > 0) && ximp->isCanonRush) {
    canonRushDefense();
  }

  if (Broodwar->getFrameCount() < 8000) {
    followCapitalMyBaseEnemyProbes();  
  }
  else if (!capitalMyBaseDefenseProbes.empty()) {
    capitalMyBaseDefenseProbes.clear();
  }

  #if WRITE_LOG 
    ss.str("");
    ss << "Army::onFrame - end";
    ximp->log.writeToLog(ss.str());
  #endif
}

void Army::onNukeDetect(Position target) {

}

void Army::onUnitCreate(Unit* unit) {

}

void Army::onUnitComplete(Unit *unit) {
  if (!Broodwar->self()->isEnemy(unit->getPlayer()) && !unit->getPlayer()->isNeutral()) {
    if (unit->getType() == UnitTypes::Protoss_Carrier) {
      bool notAddedYet = true;

      for (vector<CarrierGroup>::iterator it = carrierGroups.begin(); it != carrierGroups.end(); it++) {
        if (it->units.find(unit) != it->units.end()) {
          notAddedYet = false;
          break;
        }
      }

      if (notAddedYet) {
        bool added = false;

        CarrierGroup* nearestGroup = getNearestCarrierGroupForCarrier(unit);

        if (nearestGroup != NULL) {
          nearestGroup->units.insert(unit);
          added = true;
            
          if (nearestGroup->units.size() == carrierGroupSize) {
            vector<Position> positions;

            if (ximp->getCapitalEnemyBase() != NULL && ximp->getCapitalEnemyBase()->isEnemyBase()) {
              positions = carrierPath;
              int i = getNearestNextPosition(nearestGroup->centroid, positions);

              nearestGroup->attackPositionsCurrent = i;

              if (i > -1) {
                MyBase* capitalMyBase = ximp->colony.getCapitalMyBase();

                Position basePosition = nearestGroup->centroid;
                if (capitalMyBase != NULL) {
                  basePosition = capitalMyBase->baseLocation->getPosition();
                }

                if (i + 1 < positions.size()) {
                  Position nearest = positions[i];
                  Position next = positions[i + 1];

                  Position current;
                  if (nearest.x() == next.x()) {
                    current = Position(nearest.x(), basePosition.y());
                  }
                  else if (nearest.y() == next.y()) {
                    current = Position(basePosition.x(), nearest.y());
                  }
                  else {
                    current = nearest;
                  }

                  for (vector<Position>::iterator it = positions.begin(); it != positions.end(); it++) {
                    if (*it == next) {
                      positions.insert(it, current);
                      break;
                    }
                  }

                  nearestGroup->attackPositionsCurrent = i + 1;
                }
                else {
                  nearestGroup->attackPositionsCurrent = i;
                }
              }
            }
            else {
              positions = getBasePositionsList(nearestGroup->centroid);
              nearestGroup->hasAtLeastDone = true;
              nearestGroup->attackPositionsCurrent = getNearestNextPosition(nearestGroup->centroid, positions);
            }

            MyBase* defendedBase = nearestGroup->defendedMyBase;

            if (nearestGroup->attackPositionsCurrent > -1) {
              nearestGroup->attackPositions = positions;
              nearestGroup->groupAttackPosition(positions[nearestGroup->attackPositionsCurrent]);
              nearestGroup->instruction = ATTACK_POSITIONS;
            }
            else {
              nearestGroup->instruction = ATTACK_ALL;
            }

            if (defendedBase != NULL) {
              nearestGroup->defendedMyBase = NULL;
              nearestGroup->groupDefendBase(defendedBase, defendedBase->baseLocation->getPosition());
            }
          }
        }
        

        if (!added) {
          if ((int)(ximp->colony.maxCountCarriers / carrierGroupSize) > carrierGroups.size()) {
            set<Unit*> newSet;
            newSet.insert(unit);

            CarrierGroup carrierGroup(ximp, newSet);
            carrierGroups.push_back(carrierGroup);
          }
          else {
            CarrierGroup* nearestGroup = getNearestCarrierGroupForCarrier(unit);

            if (nearestGroup != NULL) {
              nearestGroup->units.insert(unit);
            }
          }
        }
      }
    }
    else if (unit->getType() == UnitTypes::Protoss_Corsair) {
      MyBase* capitalMyBase = ximp->colony.getCapitalMyBase();

      if (capitalMyBase != NULL) {
        set<Unit*> minerals = capitalMyBase->baseLocation->getStaticMinerals();
        Position centroid = ximp->computeCentroid(minerals, true);
        
        if (centroid != Position(0,0)) {
          Position pos(centroid.x() + (rand() % 10*TILE_SIZE) - 5*TILE_SIZE, centroid.y() + (rand() % 10*TILE_SIZE) - 5*TILE_SIZE);
          unit->move(pos);
        }
      }

      bool notAddedYet = true;

      for (vector<CorsairGroup>::iterator it = corsairGroups.begin(); it != corsairGroups.end(); it++) {
        if (it->units.find(unit) != it->units.end()) {
          notAddedYet = false;
          break;
        }
      }

      if (notAddedYet) {
        bool added = false;

        for (vector<CorsairGroup>::iterator groupIt = corsairGroups.begin(); groupIt != corsairGroups.end(); groupIt++) {
          if (groupIt->units.size() < corsairGroupSize) {
            groupIt->units.insert(unit);
            added = true;
          }
        }

        if (!added) {
          set<Unit*> newSet;
          newSet.insert(unit);

          CorsairGroup corsairGroup(ximp, newSet);
          corsairGroups.push_back(corsairGroup);
        }
      }
    }
  }
}

void Army::onUnitDestroy(Unit* unit) {
  onDestroy(unit);
}

void Army::onUnitMorph(Unit* unit) {

}

void Army::onUnitRenegade(Unit* unit) {
  onDestroy(unit, true);
}

void Army::onUnitEvade(Unit* unit) {

}

void Army::onUnitShow(Unit* unit) {

}

void Army::onUnitHide(Unit* unit) {
  for (vector<CarrierGroup>::iterator groupIt = carrierGroups.begin(); groupIt != carrierGroups.end(); groupIt++) {
    groupIt->onUnitHide(unit);
  }
}

void Army::processAnalysis() {

}

void Army::trainInterceptors() {
  int maxInterceptors = Broodwar->self()->getUpgradeLevel(UpgradeTypes::Carrier_Capacity) == 0 ? 4 : 8;
  set<Unit*> carriers = ximp->getMyUnits(UnitTypes::Protoss_Carrier, true);

  for (set<Unit*>::iterator it = carriers.begin(); it != carriers.end(); it++) {
    if ((*it)->getTrainingQueue().empty() && (*it)->getInterceptorCount() < maxInterceptors) {
      (*it)->train(UnitTypes::Protoss_Interceptor);
    }
  }
}

void Army::defendBasesWithCarrierGroups() {
  map<BWTA::BaseLocation*, MyBase*> occupiedMyBases = ximp->colony.getOccupiedMyBases();

  for (map<BWTA::BaseLocation*, MyBase*>::iterator it = occupiedMyBases.begin(); it != occupiedMyBases.end(); it++) {
    if (it->second->isUnderAttack && it->second->defendingGroup == NULL) {
      Position pos(it->first->getPosition());

      Unit *underAttack = it->second->getFirstBuildingUnderAttack();
      if (underAttack != NULL) {
        pos = underAttack->getPosition();
      }

      CarrierGroup* carrierGroup = getNearestCarrierGroup(pos, false, false);
      if (carrierGroup != NULL) {
        carrierGroup->groupDefendBase(it->second, pos);
      }
    }
  }
}

void Army::defendCapitalBase() {
  MyBase* capitalMyBase = ximp->colony.getCapitalMyBase();

  if (capitalMyBase != NULL) {
    set<Unit*> dragoons = ximp->getMyUnits(UnitTypes::Protoss_Dragoon);
    set<Unit*> zealots = ximp->getMyUnits(UnitTypes::Protoss_Zealot);
          
    set<Unit*> units = Broodwar->getAllUnits();
    set<Unit*> enemyUnits = ximp->getEnemyUnits(units);

    for (set<Unit*>::iterator it = enemyUnits.begin(); it != enemyUnits.end(); ) { 
      if (capitalMyBase->isInBaseRegions((*it)->getPosition()) && (*it)->isDetected()) {
        it++;
      }
      else {
        it = enemyUnits.erase(it);
      }
    }

    set<Unit*> enemyGroundUnits = ximp->getGroundUnits(enemyUnits);

    set<Unit*> enemyUnitsThatCanAttack = ximp->getUnitsThatCanAttack(enemyUnits);
    set<Unit*> enemyGroundUnitsThatCanAttack = ximp->getUnitsThatCanAttack(enemyGroundUnits);

    for (set<Unit*>::iterator it = dragoons.begin(); it != dragoons.end(); it++) {
      if ((*it)->getOrder() == Orders::PlayerGuard || ((*it)->getOrderTarget() != NULL && !(*it)->getOrderTarget()->getType().canAttack())) {
        Unit* nearestEnemyUnit = ximp->getNearestUnit((*it)->getPosition(), enemyUnitsThatCanAttack);
        if (nearestEnemyUnit == NULL) {
          nearestEnemyUnit = ximp->getNearestUnit((*it)->getPosition(), enemyUnits);
        }
        if (nearestEnemyUnit != (*it)->getOrderTarget()) {
          (*it)->attack(nearestEnemyUnit);
        }
      }
    }
    
    for (set<Unit*>::iterator it = zealots.begin(); it != zealots.end(); it++) {
      if ((*it)->getOrder() == Orders::PlayerGuard || ((*it)->getOrderTarget() != NULL && !(*it)->getOrderTarget()->getType().canAttack())) {
        Unit* nearestEnemyUnit = ximp->getNearestUnit((*it)->getPosition(), enemyGroundUnitsThatCanAttack);
        if (nearestEnemyUnit == NULL) {
          nearestEnemyUnit = ximp->getNearestUnit((*it)->getPosition(), enemyGroundUnits);
        }
        if (nearestEnemyUnit != (*it)->getOrderTarget()) {
          (*it)->attack(nearestEnemyUnit);
        }
      }
    }
  }
}

void Army::handleUnassignedUnits() {
  Unit* unassignedObserver = getUnassignedObserverToAnyGroup();

  if (unassignedObserver != NULL) {
    CarrierGroup* nearest = NULL;

    for (vector<CarrierGroup>::iterator groupIt = carrierGroups.begin(); groupIt != carrierGroups.end(); groupIt++) {
      if (groupIt->observer == NULL && (nearest == NULL || unassignedObserver->getPosition().getDistance(groupIt->centroid) <= unassignedObserver->getPosition().getDistance(nearest->centroid))) {
        nearest = &(*groupIt);
      }
    }

    if (nearest != NULL) {
      nearest->observer = unassignedObserver;
    }
    else {
      CorsairGroup* nearest = NULL;

      for (vector<CorsairGroup>::iterator groupIt = corsairGroups.begin(); groupIt != corsairGroups.end(); groupIt++) {
        if (groupIt->observer == NULL && (nearest == NULL || unassignedObserver->getPosition().getDistance(groupIt->centroid) <= unassignedObserver->getPosition().getDistance(nearest->centroid))) {
          nearest = &(*groupIt);
        }
      }

      if (nearest != NULL) {
        nearest->observer = unassignedObserver;
      }
    }
  }

  Unit* unassignedArbiter = getUnassignedArbiterToAnyGroup();

  if (unassignedArbiter != NULL) {
    CarrierGroup* nearest = NULL;

    for (vector<CarrierGroup>::iterator groupIt = carrierGroups.begin(); groupIt != carrierGroups.end(); groupIt++) {
      if (groupIt->arbiter == NULL && (nearest == NULL || unassignedArbiter->getPosition().getDistance(groupIt->centroid) <= unassignedArbiter->getPosition().getDistance(nearest->centroid))) {
        nearest = &(*groupIt);
      }
    }

    if (nearest != NULL) {
      nearest->arbiter = unassignedArbiter;
    }
  }
}

void Army::handleCapitalMyBaseZealots() {
  MyBase* capitalMyBase = ximp->colony.getCapitalMyBase();
        
  if (capitalMyBase != NULL) {
    set<Unit*> zealots = ximp->getMyUnits(UnitTypes::Protoss_Zealot);
    
    for (set<Unit*>::iterator it = zealots.begin(); it != zealots.end(); it++) {
      set<Unit*> unitsInRadius = Broodwar->getUnitsInRadius((*it)->getPosition(), 2 * TILE_SIZE);
      set<Unit*> enemyUnits = ximp->getEnemyUnits(unitsInRadius);
      set<Unit*> enemyGroundUnits = ximp->getGroundUnits(enemyUnits);

      if ((*it)->getOrder() == Orders::PlayerGuard && enemyGroundUnits.empty()) {
        if ((*it)->getPosition().getDistance(capitalMyBase->baseLocation->getPosition()) > 5 * TILE_SIZE) {
          (*it)->move(capitalMyBase->baseLocation->getPosition());
        }
      }
    }
  }
}

void Army::handleCapitalMyBaseDragoons() {
  MyBase* capitalMyBase = ximp->colony.getCapitalMyBase();

  if (capitalMyBase != NULL) {
    set<Unit*> dragoons = ximp->getMyUnits(UnitTypes::Protoss_Dragoon);
          
    for (set<Unit*>::iterator it = dragoons.begin(); it != dragoons.end(); it++) {
      if ((*it)->getOrder() == Orders::PlayerGuard || !capitalMyBase->isInBaseRegions((*it)->getPosition())) {
        if ((*it)->getPosition().getDistance(capitalMyBase->baseLocation->getPosition()) > 5 * TILE_SIZE) {
          (*it)->move(capitalMyBase->baseLocation->getPosition());
        }
      }
    }
  }
}

void Army::followCapitalMyBaseEnemyProbes() {
  set<Unit*> units = Broodwar->getAllUnits();
  set<Unit*> enemyUnits = ximp->getEnemyUnits(units);

  set<Unit*> enemyProbes = ximp->getUnitsOfType(UnitTypes::Protoss_Probe, enemyUnits);

  MyBase* capitalMyBase = ximp->colony.getCapitalMyBase();

  for (set<Unit*>::iterator it = enemyProbes.begin(); it != enemyProbes.end(); ) { 
    bool isHunted = false;

    for (map<Unit*, Unit*>::iterator jt = capitalMyBaseDefenseProbes.begin(); jt != capitalMyBaseDefenseProbes.end(); jt++) {
      if (jt->second == *it) {
        isHunted = true;
        break;
      }
    }

    if (capitalMyBase != NULL && capitalMyBase->isInBaseRegions((*it)->getPosition()) && !isHunted) {
      it++;
    }
    else {
      it = enemyProbes.erase(it);
    }
  }
  
  if (!enemyProbes.empty()) {
    set<Unit*> probes = ximp->getMyUnits(UnitTypes::Protoss_Probe);
  
    for (set<Unit*>::iterator it = enemyProbes.begin(); it != enemyProbes.end(); it++) {
      Unit* nearest = NULL;

      for (set<Unit*>::iterator jt = probes.begin(); jt != probes.end(); jt++) {
        bool isInMyBaseDefenseProbes = false;

        for (map<Unit*, Unit*>::iterator kt = capitalMyBaseDefenseProbes.begin(); kt != capitalMyBaseDefenseProbes.end(); kt++) {
          if (kt->first == *jt) {
            isInMyBaseDefenseProbes = true;
            break;
          }
        }

        if (nearest == NULL || (*jt)->getPosition().getDistance((*enemyProbes.begin())->getPosition()) < nearest->getPosition().getDistance((*enemyProbes.begin())->getPosition())) {
          if (*jt != ximp->observation.earlyScoutWorker && *jt != ximp->observation.myBaseScoutWorker && (*jt)->isCompleted() && (*jt)->getOrder() != Orders::PlaceBuilding && !ximp->colony.isInBuildingWorkers(*jt) && !isInMyBaseDefenseProbes) {
            nearest = *jt;
          }
        }
      }

      if (nearest != NULL) {
        nearest->attack(*it);
        capitalMyBaseDefenseProbes.insert(capitalMyBaseDefenseProbes.begin(), pair<Unit*, Unit*>(nearest, *it));
      }
    }
  }

  for (map<Unit*, Unit*>::iterator it = capitalMyBaseDefenseProbes.begin(); it != capitalMyBaseDefenseProbes.end(); ) {
    if (capitalMyBase != NULL && capitalMyBase->isInBaseRegions(it->second->getPosition())) {
      it->first->attack(it->second);
      it++;
    }
    else {
      it = capitalMyBaseDefenseProbes.erase(it);
    }
  }
}

void Army::zerglingRushDefense() {
  TilePosition startLocation = Broodwar->self()->getStartLocation();

  MyBase* capitalMyBase = ximp->colony.getCapitalMyBase();
  MyBase* naturalMyBase = ximp->colony.getNaturalMyBase();

  set<Unit*> units = Broodwar->getAllUnits();
  set<Unit*> enemyUnits = ximp->getEnemyUnits(units);

  set<Unit*> enemyZerglings = ximp->getUnitsOfType(UnitTypes::Zerg_Zergling, enemyUnits);

  // Change build order and train zealots
  if (ximp->getMyUnits(UnitTypes::Protoss_Photon_Cannon, false).size() < 2) {
    ximp->colony.changeStartBuildOrderZerglingRush();
  }

  // Zealots defense against Zergling rush
  set<Unit*> gateways = ximp->getMyUnits(UnitTypes::Protoss_Gateway);

  if (!gateways.empty()) {
    if ((*gateways.begin())->getTrainingQueue().empty() && ximp->getMyUnits(UnitTypes::Protoss_Zealot, false).size() < 3) {
      (*gateways.begin())->train(UnitTypes::Protoss_Zealot);
    }
  }

  for (set<Unit*>::iterator it = enemyZerglings.begin(); it != enemyZerglings.end(); ) { 
    if ((capitalMyBase != NULL && capitalMyBase->isInBaseRegions((*it)->getPosition())) || (naturalMyBase != NULL && naturalMyBase->isInBaseRegions((*it)->getPosition()))) {
      it++;
    }
    else {
      it = enemyZerglings.erase(it);
    }
  }

  if (!enemyZerglings.empty()) {
    set<Unit*> zealots = ximp->getMyUnits(UnitTypes::Protoss_Zealot);

    for (set<Unit*>::iterator it = zealots.begin(); it != zealots.end(); it++) {
      Unit* nearestZergling = ximp->getNearestUnit((*it)->getPosition(), enemyZerglings);

      if (nearestZergling != NULL) {
        if ((*it)->getOrder() != Orders::AttackUnit) {
          (*it)->attack(nearestZergling);
        }
      }
    }
  }
  else {
    set<Unit*> zealots = ximp->getMyUnits(UnitTypes::Protoss_Zealot);

    for (set<Unit*>::iterator it = zealots.begin(); it != zealots.end(); it++) {
      if ((*it)->getPosition().getDistance(Position(startLocation)) > 5*TILE_SIZE) {
        (*it)->attack(Position(startLocation));
      }
    }
  }


  // Workers defense against Zergling rush
  for (set<Unit*>::iterator it = enemyZerglings.begin(); it != enemyZerglings.end(); ) { 
    if (capitalMyBase != NULL && 
      (((ximp->getMyUnits(UnitTypes::Protoss_Photon_Cannon).size() < 2 && ximp->getMyUnits(UnitTypes::Protoss_Zealot).size() < 3) && naturalMyBase != NULL && naturalMyBase->isInBaseRegions((*it)->getPosition())) ||
         capitalMyBase->isInBaseRegions((*it)->getPosition()))) {
      it++;
    }
    else {
      it = enemyZerglings.erase(it);
    }
  }

  if (!enemyZerglings.empty()) {
    set<Unit*> probes = ximp->getMyUnits(UnitTypes::Protoss_Probe);

    for (set<Unit*>::iterator it = probes.begin(); it != probes.end(); it++) {
      if (*it != ximp->observation.earlyScoutWorker) {
        Unit* nearestZergling = ximp->getNearestUnit((*it)->getPosition(), enemyZerglings);

        if (nearestZergling != NULL) {
          (*it)->attack(nearestZergling);
        }
      }
    }
  }
}

void Army::canonRushDefense() {
  set<Unit*> units = Broodwar->getAllUnits();
  set<Unit*> enemyUnits = ximp->getEnemyUnits(units);

  set<Unit*> enemyCannons = ximp->getUnitsOfType(UnitTypes::Protoss_Photon_Cannon, enemyUnits);
  set<Unit*> enemyProbes = ximp->getUnitsOfType(UnitTypes::Protoss_Probe, enemyUnits);
  set<Unit*> enemyPylons = ximp->getUnitsOfType(UnitTypes::Protoss_Pylon, enemyUnits);
  
  MyBase* capitalMyBase = ximp->colony.getCapitalMyBase();

  for (set<Unit*>::iterator it = enemyCannons.begin(); it != enemyCannons.end(); ) { 
    if (capitalMyBase != NULL && capitalMyBase->isInBaseRegions((*it)->getPosition())) {
      it++;
    }
    else {
      it = enemyCannons.erase(it);
    }
  }

  for (set<Unit*>::iterator it = enemyProbes.begin(); it != enemyProbes.end(); ) { 
    if (capitalMyBase != NULL && capitalMyBase->isInBaseRegions((*it)->getPosition())) {
      it++;
    }
    else {
      it = enemyProbes.erase(it);
    }
  }

  for (set<Unit*>::iterator it = enemyPylons.begin(); it != enemyPylons.end(); ) { 
    if (capitalMyBase != NULL && capitalMyBase->isInBaseRegions((*it)->getPosition())) {
      it++;
    }
    else {
      it = enemyPylons.erase(it);
    }
  }  

  set<Unit*> probes = ximp->getMyUnits(UnitTypes::Protoss_Probe);

  if (!enemyCannons.empty()) {
    for (set<Unit*>::iterator it = probes.begin(); it != probes.end(); it++) {
      if (*it != ximp->observation.earlyScoutWorker) {
        Unit* nearestCannon = ximp->getNearestUnit((*it)->getPosition(), enemyCannons);

        if (nearestCannon != NULL) {
          (*it)->attack(nearestCannon);
        }
      }
    }
  }

  if (!enemyProbes.empty()) {
    for (set<Unit*>::iterator it = probes.begin(); it != probes.end(); it++) {
      if (*it != ximp->observation.earlyScoutWorker) {
        Unit* nearestProbe = ximp->getNearestUnit((*it)->getPosition(), enemyProbes);

        if (nearestProbe != NULL) {
          (*it)->attack(nearestProbe);
        }
      }
    }
  }

  if (!enemyPylons.empty()) {
    for (set<Unit*>::iterator it = probes.begin(); it != probes.end(); it++) {
      if (*it != ximp->observation.earlyScoutWorker) {
        Unit* nearestPylon = ximp->getNearestUnit((*it)->getPosition(), enemyPylons);

        if (nearestPylon != NULL) {
          (*it)->attack(nearestPylon);
        }
      }
    }
  }
}

CarrierGroup* Army::getNearestCarrierGroupForCarrier(Unit* unit) {
  CarrierGroup* nearest = NULL;

  for (vector<CarrierGroup>::iterator groupIt = carrierGroups.begin(); groupIt != carrierGroups.end(); groupIt++) {
    if (groupIt->units.size() < carrierGroupSize && (nearest == NULL || unit->getPosition().getDistance(groupIt->centroid) <= unit->getPosition().getDistance(nearest->centroid))) {
      groupIt->units.insert(unit);
      nearest = &(*groupIt);
    }
  }

  return nearest;
}

CarrierGroup* Army::getNearestCarrierGroup(Position pos, bool canDefendingMyBase, bool mustHaveEnoughInterceptors) {
  CarrierGroup* nearest = NULL;

  for (vector<CarrierGroup>::iterator groupIt = carrierGroups.begin(); groupIt != carrierGroups.end(); groupIt++) {
    if (!mustHaveEnoughInterceptors || groupIt->countInterceptors() >= groupIt->minCountInterceptors) {
      if (canDefendingMyBase || groupIt->defendedMyBase == NULL) {
        if (nearest == NULL || pos.getDistance(groupIt->centroid) < pos.getDistance(nearest->centroid)) {
          nearest = &(*groupIt);
        }
      }
    }
  }

  return nearest;
}

Unit* Army::getUnassignedObserverToAnyGroup() {
  Unit* unit = NULL;

  set<Unit*> units = ximp->getMyUnits(UnitTypes::Protoss_Observer);

  for (set<Unit*>::iterator it = units.begin(); it != units.end(); it++) {
    bool assigned = false;

    for (vector<CarrierGroup>::iterator groupIt = carrierGroups.begin(); groupIt != carrierGroups.end(); groupIt++) {
      if (groupIt->observer == *it) {
        assigned = true;
        break;
      }
    }

    if (!assigned) {
      for (vector<CorsairGroup>::iterator groupIt = corsairGroups.begin(); groupIt != corsairGroups.end(); groupIt++) {
        if (groupIt->observer == *it) {
          assigned = true;
          break;
        }
      }
    }

    if (!assigned) {
      unit = *it;
      break;
    }
  }

  return unit;
}

Unit* Army::getUnassignedArbiterToAnyGroup() {
  Unit* unit = NULL;

  set<Unit*> units = ximp->getMyUnits(UnitTypes::Protoss_Arbiter);

  for (set<Unit*>::iterator it = units.begin(); it != units.end(); it++) {
    bool assigned = false;

    for (vector<CarrierGroup>::iterator groupIt = carrierGroups.begin(); groupIt != carrierGroups.end(); groupIt++) {
      if (groupIt->arbiter == *it) {
        assigned = true;
        break;
      }
    }

    if (!assigned) {
      unit = *it;
      break;
    }
  }

  return unit;
}

void Army::calculateCarrierPath() {
  if (!ximp->analyzed) {
    return;
  }

  vector<Position> path;

  EnemyBase* enemyBase = ximp->getCapitalEnemyBase();

  if (enemyBase != NULL) {
    /*BWTA::BaseLocation* */baseLocation = enemyBase->baseLocation;
    BWTA::BaseLocation* nearestEnemyBaseLocation = ximp->colony.getNearestBaseLocation(baseLocation->getPosition(), baseLocation, false, true);

    if (nearestEnemyBaseLocation != NULL) {
      /*Position */nearestEnemyBasePosition = nearestEnemyBaseLocation->getPosition();

      //Position nearestEdgePosition;
      vector<Position> positions;
      positions.push_back(Position(0, nearestEnemyBasePosition.y()));
      positions.push_back(Position(Broodwar->mapWidth()*TILE_SIZE, nearestEnemyBasePosition.y()));
      positions.push_back(Position(nearestEnemyBasePosition.x(), 0));
      positions.push_back(Position(nearestEnemyBasePosition.x(), Broodwar->mapHeight()*TILE_SIZE));

      for (vector<Position>::iterator it = positions.begin(); it != positions.end(); it++) {
        if (nearestEdgePosition == Position(-1,-1) || nearestEnemyBasePosition.getDistance(*it) < nearestEnemyBasePosition.getDistance(nearestEdgePosition)) {
          nearestEdgePosition = *it;
        }
      }

      bool xx = false;
      if (nearestEdgePosition.x() == nearestEnemyBasePosition.x()) {
        xx = true;
      }

      /*Position*/ nearestEdgeBasePosition = Position(!xx ? nearestEdgePosition.x() : baseLocation->getPosition().x(), xx ? nearestEdgePosition.y() : baseLocation->getPosition().y());

      // Tau Cross
      if (Broodwar->mapHash() == "9bfc271360fa5bab3707a29e1326b84d0ff58911") {
        if (baseLocation->getPosition() == Position(288, 1456)) {
          nearestEdgeBasePosition = Position(0, baseLocation->getPosition().y());
        }
      }

      Position vec(nearestEdgeBasePosition.x() - nearestEnemyBasePosition.x(), nearestEdgeBasePosition.y() - nearestEnemyBasePosition.y());
      Position nearestEnemyCorner = Position(vec.x() <= 0 ? 3*TILE_SIZE : (Broodwar->mapWidth()-3)*TILE_SIZE, vec.y() <= 0 ? 3*TILE_SIZE : (Broodwar->mapHeight()-3)*TILE_SIZE);

      Position vecRot1(-vec.x(), vec.y());
      Position vecRot2(vec.x(), -vec.y());

      Position farCorner1;
      if (vecRot1.x() * vec.x() + vecRot1.y() * vec.y() >= 0) {
        farCorner1 = Position(vecRot1.x() <= 0 ? 3*TILE_SIZE : (Broodwar->mapWidth()-3)*TILE_SIZE, vecRot1.y() <= 0 ? 3*TILE_SIZE : (Broodwar->mapHeight()-3)*TILE_SIZE);
      }
      else {
        farCorner1 = Position(vecRot2.x() <= 0 ? 3*TILE_SIZE : (Broodwar->mapWidth()-3)*TILE_SIZE, vecRot2.y() <= 0 ? 3*TILE_SIZE : (Broodwar->mapHeight()-3)*TILE_SIZE);
      }

      Position farCorner2(Broodwar->mapWidth()*TILE_SIZE - nearestEnemyCorner.x(), Broodwar->mapHeight()*TILE_SIZE - nearestEnemyCorner.y());
      Position farCorner3(Broodwar->mapWidth()*TILE_SIZE - farCorner1.x(), Broodwar->mapHeight()*TILE_SIZE - farCorner1.y());

      path.push_back(farCorner3);
      path.push_back(farCorner2);
      path.push_back(farCorner1);
      path.push_back(nearestEnemyCorner);
      Unit* nearestMineral = ximp->getNearestMineralField(baseLocation->getPosition(), false, true);
      if (nearestMineral != NULL) {
        path.push_back(nearestMineral->getInitialPosition());
      }
      else {
        path.push_back(baseLocation->getPosition());
      }
      
      map<BWTA::BaseLocation*, MyBase>::iterator myBasesIt = ximp->colony.myBases.find(baseLocation);
      if (myBasesIt != ximp->colony.myBases.end()) {
        for (set<BWTA::Region*>::iterator it = myBasesIt->second.regions.begin(); it != myBasesIt->second.regions.end(); it++) {
          path.push_back((*it)->getCenter());
        }
      }

    }
  }

  carrierPath = path;
}

int Army::getNearestNextPosition(Position position, vector<Position> positions) {
  int nearest = -1;

  int i = 0;
  for (vector<Position>::iterator it = positions.begin(); it != positions.end(); it++) {
    if (nearest == -1 || it->getDistance(position) < positions.at(nearest).getDistance(position)) {
      nearest = i;
    }
    i++;
  }

  return nearest;
}

vector<Position> Army::getBasePositionsList(Position pos) {
  set<BWTA::BaseLocation*> baseLocations = BWTA::getBaseLocations();

  for (set<BWTA::BaseLocation*>::iterator it = baseLocations.begin(); it != baseLocations.end(); ) {
    if (ximp->colony.checkMyOccupied(*it)) {
      it = baseLocations.erase(it);
    }
    else {
      it++;
    }
  }
        
  vector<Position> positions;
  BWTA::Region* region = BWTA::getRegion(pos);
  Position first(0,0);
     
  if (region != NULL) {
    first = region->getCenter();
    positions.push_back(first);
  }

  Position last = first;
  while (!baseLocations.empty()) {
    BWTA::BaseLocation* nearest = ximp->getNearestBaseLocationFromSet(last, baseLocations);

    if (nearest != NULL) {
      last = nearest->getPosition();
      positions.push_back(last);

      map<BWTA::BaseLocation*, MyBase>::iterator myBasesIt = ximp->colony.myBases.find(nearest);
      if (myBasesIt != ximp->colony.myBases.end()) {
        for (set<BWTA::Region*>::iterator it = myBasesIt->second.regions.begin(); it != myBasesIt->second.regions.end(); it++) {
          Position center = (*it)->getCenter();
          positions.push_back(center.makeValid());

          Position topLeft((*it)->getCenter().x()-10*TILE_SIZE, (*it)->getCenter().y()-10*TILE_SIZE);
          Position topRight((*it)->getCenter().x()+10*TILE_SIZE, (*it)->getCenter().y()-10*TILE_SIZE);
          Position bottomLeft((*it)->getCenter().x()-10*TILE_SIZE, (*it)->getCenter().y()+10*TILE_SIZE);
          Position bottomRight((*it)->getCenter().x()+10*TILE_SIZE, (*it)->getCenter().y()+10*TILE_SIZE);

          positions.push_back(topLeft.makeValid());
          positions.push_back(topRight.makeValid());
          positions.push_back(bottomLeft.makeValid());
          positions.push_back(bottomRight.makeValid());
        }
      }      

      for (set<BWTA::BaseLocation*>::iterator it = baseLocations.begin(); it != baseLocations.end(); it++) {
        if (*it == nearest) {
          baseLocations.erase(it);
          break;
        }
      }
    }
    else {
      break;
    }
  }

  return positions;
}