# Building MetaBot (tournament edition)

You can find these instructions formatted online in: https://github.com/andertavares/MetaBot/wiki/Build-for-tournament

# Requirements
Pre-requisites:
- Windows 7 (these instructions were tested on Windows 7 64 bits, but might work on posterior versions. Won't work on Windows XP because Visual Studio 2017 cannot be installed there)
- StarCraft patched to 1.16.1

For the items below, install and configuration instructions are given on this page:
- BWAPI 3.7.4 
- Visual Studio 2017
- Microsoft Visual C++ 2008 with SP1
- Microsoft Visual C++ 2010
- Boost 1.60.0 

# Instructions

## BWAPI 
- Get `BWAPI.3.7.4.7z` file [here](https://github.com/bwapi/bwapi/releases/tag/v3.7.4)
- (If you don't have 7zip to unpack .7z files, grab it [here](http://www.7-zip.org/))
- Extract the contents of `BWAPI.3.7.4.7z` to `c:\software` and rename the folder to `BWAPI3.7.4`(without space)
- Copy the contents of `c :\software\BWAPI3.7.4\starcraft` to your Starcraft folder.
- Copy the contents of `c:\software\BWAPI3.7.4\WINDOWS` to `c:\Windows`

## Visual Studios
- Download and install Visual C++ 2008 with Service Pack 1 - link [here](https://download.microsoft.com/download/E/8/E/E8EEB394-7F42-4963-A2D8-29559B738298/VS2008ExpressWithSP1ENUX1504728.iso)
- Download and install Visual C++ 2010 - link [here](https://download.microsoft.com/download/1/D/9/1D9A6C0E-FC89-43EE-9658-B9F0E3A76983/vc_web.exe)

- Download and install Visual Studio 2017 - link [here](https://visualstudio.microsoft.com/pt-br/downloads/?rr=https%3A%2F%2Fwww.google.com%2F) (Select only `Desktop development with C++` as a workload and hit `Install`)

All three versions are required for building it because the code can only be compiled through VC++ 2008's toolset due to portability issues and VC++2010 is what allow us to use this toolset on Visual Studio 2017.

## Boost
- Download `boost_1_60_0-msvc-9.0-32.exe` from [here](https://sourceforge.net/projects/boost/files/boost-binaries/1.60.0/boost_1_60_0-msvc-9.0-32.exe/download) (This link goes directly to the 32 bit version compatible with VC++2008 and should work. If, for some reason, you need another version, look [here](https://sourceforge.net/projects/boost/files/boost-binaries/))
- Install Boost 1.60.0 to `c:\software\boost`
- Rename directory `c:\software\boost\lib32-msvc-9.0` to `C:\software\boost\lib`

## Environment Variables
You must configure 2 environment variables:
- `BWAPI_DIR` pointing to where you unpacked BWAPI (if you followed these instructions it will be: `c:\software\BWAPI3.7.4`
- `BOOST_DIR` pointing to where you installed Boost (if you followed these instructions it will be: `c:\software\boost`

On Windows 7, the procedure is as follows:
- Open Start menu, right click "Computer" then "Properties"
- Click "Advanced system settings"
- In "Advanced" tab, click "Environment variables"
- In "System variables" click "New"
- Set the name and value as indicated (e.g.: name: `BWAPI_DIR` / value: `c:\software\BWAPI3.7.4`)

## Compiling sub-bots and MetaBot
- You will need `MetaBot_all-in-one.zip` from [here](https://www.dropbox.com/s/m9lts99fzuo251h/MetaBot_all-in-one.zip?dl=0)
- Download and extract the file. We'll name the destination directory `METABOT_DIR`

### Skynet
- Go to `METABOT_DIR/src/Skynet` and open Skynet.sln in Visual C++ 2008 with SP1. If you use a newer version of Visual Studio, make sure to use the `v90` Platform toolset (right click the project -> Properties. Under 'Configuration', select `All Configurations`. Under `General` set the Platform Toolset to `Visual Studio 2008 (v90))`.
- Build the solution using `Competition` configuration.
- The resulting binary will be located in `METABOT_DIR/src/Skynet/Competition/Skynet.dll`.

### AIUR
- Go to `METABOT_DIR/src/AIUR` and open `AiurProject.sln`  in Visual C++ 2008 with SP1. If you use a newer version of Visual Studio, make sure to use the `v90` Platform toolset (Accept the 'One-way Upgrade'. Then right click the project -> Properties. Under 'Configuration', select `All Configurations`. Under `General` set the Platform Toolset to `Visual Studio 2008 (v90))`.
- Build the solution using `Release` configuration.
- The resulting binary will be located in `METABOT_DIR/src/AIUR/Release/AIUR.dll`

### Ximp
- Go to `METABOT_DIR/src/Ximp` and open`Ximp.sln`inside the folder with Visual C++ 2008 with SP1. If you open with Visual Studio 2017, on the pop-up message that will appear, change the `Platform toolset` option to `No upgrade` and hit `OK`.
- Make sure the project will be built with VC++2008 (v90) toolset (right click the project -> Properties. Under 'Configuration', select `All Configurations`. Under `General` set the Platform Toolset to `Visual Studio 2008 (v90))`)
- Build the solution using `Release` configuration.
- The resulting binary will be located in `METABOT_DIR/src/Ximp/Release/Ximp.dll`

### Compiling MetaBot
- Go to `METABOT_DIR/src/MetaBot` and open `MetaBot.sln` in Visual Studio 2017. 
- On the pop-up message that will appear, change the `Platform toolset` option to `No upgrade` and hit `OK`
- Make sure the project will be built with VC++2008 (v90) toolset (right click the project -> Properties. Under 'Configuration', select `All Configurations`. Under `General` set the Platform Toolset to `Visual Studio 2008 (v90))`)
- Build the solution using `Release` configuration.
- The resulting binary will be located in `METABOT_DIR/src/MetaBot/Release/MetaBot.dll`

### Gathering all DLLs and required resources

- Copy all the DLLs compiled above to your `bwapi-data/AI` directory.
- Copy `METABOT_DIR/src/MetaBot/config/metabot_config.xml` to your `bwapi-data/AI` directory.
- Copy `METABOT_DIR/dll/AIUR/learning` to your `bwapi-data/AI` directory.
- Copy `METABOT_DIR/src/AIUR/directories.txt` to your `bwapi-data` directory (not `bwapi-data/AI`, this time).

You're good to go. Good luck, have fun!

## Common Problems
### "LNK2001: unresolved external symbol[...]"
The project is probably not being built as a `Release` with `Visual Studio 2008(v90)`. Go on `Project->Properties` and change Configuration to `Release` and `Plataform Toolset` on the `General` tab to `Visual Studio 2008(v90)`.

### "Visual Studio can't find the library BWAPI.h [...]"
Check the BWAPI_DIR variable, one common mistake is mispell the folder's name as "BWAPI 3.7.4" (with space)

### "Project file contains ToolsVersion="15.0" [...]"
The project file has been updated to the latest version of Visual Studio (2017). One easy way to solve it is by extracting the project files again.

### Game crashing on match start?
Remember to copy the contents of `METABOT_DIR/src/MetaBot/config` to `STARCRAFT_DIR/bwapi-data/AI` so the bot can access those informations.

### Visual Studio 2017 cannot find standard headers
Try these two choices (#2 seems to be the one that actually worked):
1) You must install `Windows Universal CRT SDK` (from https://stackoverflow.com/a/42778079). Follow the steps:
- On the menu, select: Tools -> Get tools and features
- Choose the "Individual components" tab
- Install `Windows Universal CRT SDK` (in portuguese it is `SDK do CRT Universal do Windows`)

2) Reopen the project and select a proper Windows SDK (under Visual Studio 2017)
- Delete the hidden `.vs` dir inside `METABOT_DIR`
- Reopen the solution
- When the "Review solution actions" window appear, select the Windows SDK version as `10.0.[lots-of-numbers]` and the Platform toolset as `No Upgrade`

