////////////////////////////////////////////////////////////////////////////////
//
//    Copyright (C) 2017-2018 OpenBW Team
//
//    This file is part of BWAPI4J.
//
//    BWAPI4J is free software: you can redistribute it and/or modify
//    it under the terms of the Lesser GNU General Public License as published
//    by the Free Software Foundation, version 3 only.
//
//    BWAPI4J is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with BWAPI4J.  If not, see <http://www.gnu.org/licenses/>.
//
////////////////////////////////////////////////////////////////////////////////

package org.openbw.bwapi4j.unit;

import static org.openbw.bwapi4j.type.TechType.Lockdown;
import static org.openbw.bwapi4j.type.TechType.Nuclear_Strike;
import static org.openbw.bwapi4j.type.TechType.Personnel_Cloaking;
import static org.openbw.bwapi4j.type.UnitCommandType.Use_Tech;
import static org.openbw.bwapi4j.type.UnitCommandType.Use_Tech_Position;
import static org.openbw.bwapi4j.type.UnitCommandType.Use_Tech_Unit;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openbw.bwapi4j.Position;

public class Ghost extends MobileUnitImpl
    implements SpellCaster, Organic, GroundAttacker, AirAttacker {
  private static final Logger logger = LogManager.getLogger();

  @Override
  public int getEnergy() {
    return this.energy;
  }

  @Override
  public int getMaxEnergy() {
    return super.getMaxEnergy();
  }

  public boolean personnelCloaking() {
    return issueCommand(this.iD, Use_Tech, -1, -1, -1, Personnel_Cloaking.getId());
  }

  /**
   * Use the Lockdown ability on a mechanical unit.
   *
   * @param unit target unit
   * @return true if command succeeded, false else.
   */
  public boolean lockdown(Mechanical unit) {
    if (unit instanceof Unit) {
      return issueCommand(this.iD, Use_Tech_Unit, ((Unit) unit).getId(), -1, -1, Lockdown.getId());
    } else {
      logger.error("unit {} is not a valid target for lockDown.", unit);
      return false;
    }
  }

  public boolean nuclearStrike(Position p) {
    return issueCommand(this.iD, Use_Tech_Position, -1, p.getX(), p.getY(), Nuclear_Strike.getId());
  }

  @Override
  public Weapon getGroundWeapon() {
    return groundWeapon;
  }

  @Override
  public Weapon getAirWeapon() {
    return airWeapon;
  }

  @Override
  public int getGroundWeaponMaxRange() {
    return super.getGroundWeaponMaxRange();
  }

  @Override
  public int getGroundWeaponMaxCooldown() {
    return super.getGroundWeaponMaxCooldown();
  }

  @Override
  public int getGroundWeaponCooldown() {
    return super.getGroundWeaponCooldown(this);
  }

  @Override
  public int getGroundWeaponDamage() {
    return super.getGroundWeaponDamage();
  }

  @Override
  public int getMaxGroundHits() {
    return super.getMaxGroundHits();
  }

  @Override
  public int getAirWeaponMaxRange() {
    return super.getAirWeaponMaxRange();
  }

  @Override
  public int getAirWeaponMaxCooldown() {
    return super.getAirWeaponMaxCooldown();
  }

  @Override
  public int getAirWeaponCooldown() {
    return super.getAirWeaponCooldown(this);
  }

  @Override
  public int getAirWeaponDamage() {
    return super.getAirWeaponDamage();
  }

  @Override
  public int getMaxAirHits() {
    return super.getMaxAirHits();
  }
}
