////////////////////////////////////////////////////////////////////////////////
//
//    Copyright (C) 2017-2018 OpenBW Team
//
//    This file is part of BWAPI4J.
//
//    BWAPI4J is free software: you can redistribute it and/or modify
//    it under the terms of the Lesser GNU General Public License as published
//    by the Free Software Foundation, version 3 only.
//
//    BWAPI4J is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with BWAPI4J.  If not, see <http://www.gnu.org/licenses/>.
//
////////////////////////////////////////////////////////////////////////////////

package org.openbw.bwapi4j.type;

public enum UnitCommandType {
  Attack_Move,
  Attack_Unit,
  Build,
  Build_Addon,
  Train,
  Morph,
  Research,
  Upgrade,
  Set_Rally_Position,
  Set_Rally_Unit,
  Move,
  Patrol,
  Hold_Position,
  Stop,
  Follow,
  Gather,
  Return_Cargo,
  Repair,
  Burrow,
  Unburrow,
  Cloak,
  Decloak,
  Siege,
  Unsiege,
  Lift,
  Land,
  Load,
  Unload,
  Unload_All,
  Unload_All_Position,
  Right_Click_Position,
  Right_Click_Unit,
  Halt_Construction,
  Cancel_Construction,
  Cancel_Addon,
  Cancel_Train,
  Cancel_Train_Slot,
  Cancel_Morph,
  Cancel_Research,
  Cancel_Upgrade,
  Use_Tech,
  Use_Tech_Position,
  Use_Tech_Unit,
  Place_COP,
  None,
  Unknown;

  public static UnitCommandType withId(int id) {
    return values()[id];
  }
}
