////////////////////////////////////////////////////////////////////////////////
//
//    Copyright (C) 2017-2018 OpenBW Team
//
//    This file is part of BWAPI4J.
//
//    BWAPI4J is free software: you can redistribute it and/or modify
//    it under the terms of the Lesser GNU General Public License as published
//    by the Free Software Foundation, version 3 only.
//
//    BWAPI4J is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with BWAPI4J.  If not, see <http://www.gnu.org/licenses/>.
//
////////////////////////////////////////////////////////////////////////////////

package org.openbw.bwapi4j.type;

public enum Order {
  Die,
  Stop,
  Guard,
  PlayerGuard,
  TurretGuard,
  BunkerGuard,
  Move,
  ReaverStop,
  Attack1,
  Attack2,
  AttackUnit,
  AttackFixedRange,
  AttackTile,
  Hover,
  AttackMove,
  InfestedCommandCenter,
  UnusedNothing,
  UnusedPowerup,
  TowerGuard,
  TowerAttack,
  VultureMine,
  StayInRange,
  TurretAttack,
  Nothing,
  Unused_24,
  DroneStartBuild,
  DroneBuild,
  CastInfestation,
  MoveToInfest,
  InfestingCommandCenter,
  PlaceBuilding,
  PlaceProtossBuilding,
  CreateProtossBuilding,
  ConstructingBuilding,
  Repair,
  MoveToRepair,
  PlaceAddon,
  BuildAddon,
  Train,
  RallyPointUnit,
  RallyPointTile,
  ZergBirth,
  ZergUnitMorph,
  ZergBuildingMorph,
  IncompleteBuilding,
  IncompleteMorphing,
  BuildNydusExit,
  EnterNydusCanal,
  IncompleteWarping,
  Follow,
  Carrier,
  ReaverCarrierMove,
  CarrierStop,
  CarrierAttack,
  CarrierMoveToAttack,
  CarrierIgnore2,
  CarrierFight,
  CarrierHoldPosition,
  Reaver,
  ReaverAttack,
  ReaverMoveToAttack,
  ReaverFight,
  ReaverHoldPosition,
  TrainFighter,
  InterceptorAttack,
  ScarabAttack,
  RechargeShieldsUnit,
  RechargeShieldsBattery,
  ShieldBattery,
  InterceptorReturn,
  DroneLand,
  BuildingLand,
  BuildingLiftOff,
  DroneLiftOff,
  LiftingOff,
  ResearchTech,
  Upgrade,
  Larva,
  SpawningLarva,
  Harvest1,
  Harvest2,
  MoveToGas,
  WaitForGas,
  HarvestGas,
  ReturnGas,
  MoveToMinerals,
  WaitForMinerals,
  MiningMinerals,
  Harvest3,
  Harvest4,
  ReturnMinerals,
  Interrupted,
  EnterTransport,
  PickupIdle,
  PickupTransport,
  PickupBunker,
  Pickup4,
  PowerupIdle,
  Sieging,
  Unsieging,
  WatchTarget,
  InitCreepGrowth,
  SpreadCreep,
  StoppingCreepGrowth,
  GuardianAspect,
  ArchonWarp,
  CompletingArchonSummon,
  HoldPosition,
  QueenHoldPosition,
  Cloak,
  Decloak,
  Unload,
  MoveUnload,
  FireYamatoGun,
  MoveToFireYamatoGun,
  CastLockdown,
  Burrowing,
  Burrowed,
  Unburrowing,
  CastDarkSwarm,
  CastParasite,
  CastSpawnBroodlings,
  CastEMPShockwave,
  NukeWait,
  NukeTrain,
  NukeLaunch,
  NukePaint,
  NukeUnit,
  CastNuclearStrike,
  NukeTrack,
  InitializeArbiter,
  CloakNearbyUnits,
  PlaceMine,
  RightClickAction,
  SuicideUnit,
  SuicideLocation,
  SuicideHoldPosition,
  CastRecall,
  Teleport,
  CastScannerSweep,
  Scanner,
  CastDefensiveMatrix,
  CastPsionicStorm,
  CastIrradiate,
  CastPlague,
  CastConsume,
  CastEnsnare,
  CastStasisField,
  CastHallucination,
  Hallucination2,
  ResetCollision,
  ResetHarvestCollision,
  Patrol,
  CTFCOPInit,
  CTFCOPStarted,
  CTFCOP2,
  ComputerAI,
  AtkMoveEP,
  HarassMove,
  AIPatrol,
  GuardPost,
  RescuePassive,
  Neutral,
  ComputerReturn,
  InitializePsiProvider,
  SelfDestructing,
  Critter,
  HiddenGun,
  OpenDoor,
  CloseDoor,
  HideTrap,
  RevealTrap,
  EnableDoodad,
  DisableDoodad,
  WarpIn,
  Medic,
  MedicHeal,
  HealMove,
  MedicHoldPosition,
  MedicHealToIdle,
  CastRestoration,
  CastDisruptionWeb,
  CastMindControl,
  DarkArchonMeld,
  CastFeedback,
  CastOpticalFlare,
  CastMaelstrom,
  JunkYardDog,
  Fatal,
  None,
  Unknown,
  MAX;

  public static Order withId(int id) {
    if (id < 0) {
      return null;
    }
    return values()[id];
  }
}
