/*
 * Decompiled with CFR 0.152.
 */
package org.openbw.bwapi4j.unit;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openbw.bwapi4j.Position;
import org.openbw.bwapi4j.type.TechType;
import org.openbw.bwapi4j.type.UnitCommandType;
import org.openbw.bwapi4j.unit.Archon;
import org.openbw.bwapi4j.unit.CommandCenter;
import org.openbw.bwapi4j.unit.DarkArchon;
import org.openbw.bwapi4j.unit.MobileUnit;
import org.openbw.bwapi4j.unit.MobileUnitImpl;
import org.openbw.bwapi4j.unit.Organic;
import org.openbw.bwapi4j.unit.Robotic;
import org.openbw.bwapi4j.unit.SpellCaster;

public class Queen
extends MobileUnitImpl
implements Organic,
SpellCaster {
    private static final Logger logger = LogManager.getLogger();

    @Override
    public int getEnergy() {
        return this.energy;
    }

    @Override
    public int getMaxEnergy() {
        return super.getMaxEnergy();
    }

    public boolean infestation(CommandCenter commandCenter) {
        if (this.energy < TechType.Infestation.energyCost()) {
            return false;
        }
        return this.issueCommand(this.iD, UnitCommandType.Use_Tech_Unit, commandCenter.getId(), -1, -1, TechType.Infestation.getId());
    }

    public boolean parasite(MobileUnit target) {
        if (this.energy < TechType.Parasite.energyCost()) {
            return false;
        }
        return this.issueCommand(this.iD, UnitCommandType.Use_Tech_Unit, target.getId(), -1, -1, TechType.Parasite.getId());
    }

    public boolean spawnBroodling(MobileUnit target) {
        if (this.energy < TechType.Spawn_Broodlings.energyCost()) {
            return false;
        }
        if (target instanceof Robotic || target instanceof Archon || target instanceof DarkArchon) {
            logger.info("Spawn Broodling spell cannot target a {}", (Object)target);
            return false;
        }
        return this.issueCommand(this.iD, UnitCommandType.Use_Tech_Unit, target.getId(), -1, -1, TechType.Spawn_Broodlings.getId());
    }

    public boolean ensnare(Position position) {
        if (this.energy < TechType.Ensnare.energyCost()) {
            return false;
        }
        return this.issueCommand(this.iD, UnitCommandType.Use_Tech_Position, -1, position.getX(), position.getY(), TechType.Ensnare.getId());
    }
}

