/*
 * Decompiled with CFR 0.152.
 */
package org.openbw.bwapi4j.unit;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openbw.bwapi4j.type.UnitCommandType;
import org.openbw.bwapi4j.type.UnitType;
import org.openbw.bwapi4j.unit.BuildingImpl;
import org.openbw.bwapi4j.unit.Loadable;
import org.openbw.bwapi4j.unit.Mechanical;
import org.openbw.bwapi4j.unit.MobileUnit;

public class Bunker
extends BuildingImpl
implements Mechanical,
Loadable {
    private static final Logger logger = LogManager.getLogger();

    protected Bunker(UnitType unitType, int timeSpotted) {
        super(unitType, timeSpotted);
    }

    @Override
    public boolean isLoaded() {
        return this.loaded;
    }

    @Override
    public boolean load(MobileUnit target) {
        return this.load(target, false);
    }

    @Override
    public boolean load(MobileUnit target, boolean queued) {
        if (target.isFlyer()) {
            logger.error("Can't load a {} into a garrison. Only non-flying units allowed.", (Object)target);
            return false;
        }
        return this.issueCommand(this.iD, UnitCommandType.Load, target.getId(), -1, -1, queued ? 1 : 0);
    }

    @Override
    public boolean unload(MobileUnit target) {
        return this.issueCommand(this.iD, UnitCommandType.Unload, target.getId(), -1, -1, -1);
    }

    @Override
    public boolean unloadAll() {
        return this.unloadAll(false);
    }

    @Override
    public boolean unloadAll(boolean queued) {
        return this.issueCommand(this.iD, UnitCommandType.Unload_All, -1, -1, -1, queued ? 1 : 0);
    }

    @Override
    public int getSpaceRemaining() {
        return this.spaceRemaining;
    }

    @Override
    public List<MobileUnit> getLoadedUnits() {
        return this.loadedUnits;
    }
}

