/*
 * Decompiled with CFR 0.152.
 */
package org.openbw.bwapi4j.type;

import java.util.ArrayList;
import java.util.List;
import org.openbw.bwapi4j.type.IdMapperHelper;
import org.openbw.bwapi4j.type.Race;
import org.openbw.bwapi4j.type.UnitType;
import org.openbw.bwapi4j.type.WithId;

public enum UpgradeType implements WithId
{
    Terran_Infantry_Armor(0),
    Terran_Vehicle_Plating(1),
    Terran_Ship_Plating(2),
    Zerg_Carapace(3),
    Zerg_Flyer_Carapace(4),
    Protoss_Ground_Armor(5),
    Protoss_Air_Armor(6),
    Terran_Infantry_Weapons(7),
    Terran_Vehicle_Weapons(8),
    Terran_Ship_Weapons(9),
    Zerg_Melee_Attacks(10),
    Zerg_Missile_Attacks(11),
    Zerg_Flyer_Attacks(12),
    Protoss_Ground_Weapons(13),
    Protoss_Air_Weapons(14),
    Protoss_Plasma_Shields(15),
    U_238_Shells(16),
    Ion_Thrusters(17),
    Titan_Reactor(19),
    Ocular_Implants(20),
    Moebius_Reactor(21),
    Apollo_Reactor(22),
    Colossus_Reactor(23),
    Ventral_Sacs(24),
    Antennae(25),
    Pneumatized_Carapace(26),
    Metabolic_Boost(27),
    Adrenal_Glands(28),
    Muscular_Augments(29),
    Grooved_Spines(30),
    Gamete_Meiosis(31),
    Metasynaptic_Node(32),
    Singularity_Charge(33),
    Leg_Enhancements(34),
    Scarab_Damage(35),
    Reaver_Capacity(36),
    Gravitic_Drive(37),
    Sensor_Array(38),
    Gravitic_Boosters(39),
    Khaydarin_Amulet(40),
    Apial_Sensors(41),
    Gravitic_Thrusters(42),
    Carrier_Capacity(43),
    Khaydarin_Core(44),
    Argus_Jewel(47),
    Argus_Talisman(49),
    Caduceus_Reactor(51),
    Chitinous_Plating(52),
    Anabolic_Synthesis(53),
    Charon_Boosters(54),
    Upgrade_60(60),
    None(61),
    Unknown(62),
    MAX(63);

    int iD;
    Race race;
    int[] mineralPrices;
    int mineralPriceFactor;
    int[] gasPrices;
    int gasPriceFactor;
    int[] upgradeTimes;
    int upgradeTimeFactor;
    int maxRepeats;
    UnitType whatUpgrades;
    UnitType[] whatsRequired;
    List<UnitType> whatUses = new ArrayList<UnitType>();

    private UpgradeType(int id) {
        this.iD = id;
    }

    public static UpgradeType withId(int id) {
        return IdMapper.upgradeTypeForId[id];
    }

    @Override
    public int getId() {
        return this.iD;
    }

    public Race getRace() {
        return this.race;
    }

    public int mineralPrice(int level) {
        return this.mineralPrices[level];
    }

    public int mineralPriceFactor() {
        return this.mineralPriceFactor;
    }

    public int gasPrice(int level) {
        return this.gasPrices[level];
    }

    public int gasPriceFactor() {
        return this.gasPriceFactor;
    }

    public int upgradeTime(int level) {
        return this.upgradeTimes[level];
    }

    public int upgradeTimeFactor() {
        return this.upgradeTimeFactor;
    }

    public int maxRepeats() {
        return this.maxRepeats;
    }

    public UnitType whatUpgrades() {
        return this.whatUpgrades;
    }

    public UnitType whatsRequired(int level) {
        return this.whatsRequired[level];
    }

    public List<UnitType> whatUses() {
        return this.whatUses;
    }

    private void addUsingUnit(int typeId) {
        this.whatUses.add(UnitType.values()[typeId]);
    }

    private static class IdMapper {
        static final UpgradeType[] upgradeTypeForId = (UpgradeType[])IdMapperHelper.toIdTypeArray(UpgradeType.class);

        private IdMapper() {
        }
    }
}

