/*
 * Decompiled with CFR 0.152.
 */
package org.openbw.bwapi4j.org.xguzm.pathfinding.finders;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.openbw.bwapi4j.org.xguzm.pathfinding.BHeap;
import org.openbw.bwapi4j.org.xguzm.pathfinding.NavigationGraph;
import org.openbw.bwapi4j.org.xguzm.pathfinding.NavigationNode;
import org.openbw.bwapi4j.org.xguzm.pathfinding.PathFinder;
import org.openbw.bwapi4j.org.xguzm.pathfinding.PathFinderOptions;
import org.openbw.bwapi4j.org.xguzm.pathfinding.Util;

public abstract class ThetaStarFinder<T extends NavigationNode>
implements PathFinder<T> {
    private PathFinderOptions defaultOptions;
    BHeap<T> openList;
    public int jobId;

    public ThetaStarFinder(Class<T> clazz, PathFinderOptions opt) {
        this.defaultOptions = opt;
        this.openList = new BHeap(new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                if (o1 == null || o2 == null) {
                    if (o1 == o2) {
                        return 0;
                    }
                    if (o1 == null) {
                        return -1;
                    }
                    return 1;
                }
                return (int)(o1.getF() - o2.getF());
            }
        });
    }

    @Override
    public List<T> findPath(T startNode, T endNode, NavigationGraph<T> graph) {
        Util.validateNotNull(startNode, "Start node cannot be null");
        Util.validateNotNull(endNode, "End node cannot be null");
        if (this.jobId == Integer.MAX_VALUE) {
            this.jobId = 0;
        }
        int job = ++this.jobId;
        ArrayList<NavigationNode> neighbors = new ArrayList<NavigationNode>();
        Util.validateNotNull(startNode, "Start node cannot be null");
        Util.validateNotNull(endNode, "End node cannot be null");
        startNode.setG(0.0f);
        startNode.setF(0.0f);
        this.openList.clear();
        this.openList.add(startNode);
        startNode.setParent(null);
        startNode.setOpenedOnJob(job, this.getClass());
        while (this.openList.size > 0) {
            NavigationNode node = (NavigationNode)this.openList.pop();
            node.setClosedOnJob(job, this.getClass());
            if (node == endNode) {
                return Util.backtrace(endNode);
            }
            neighbors.clear();
            neighbors.addAll(graph.getNeighbors(node, this.defaultOptions));
            int l = neighbors.size();
            for (int i = 0; i < l; ++i) {
                float ng;
                NavigationNode neighbor = (NavigationNode)neighbors.get(i);
                if (neighbor.getClosedOnJob(this.getClass()) == job || !graph.isWalkable(neighbor)) continue;
                NavigationNode parent = null;
                if (graph.lineOfSight(node.getParent(), neighbor)) {
                    ng = node.getParent().getG() + graph.getMovementCost(node.getParent(), neighbor, this.defaultOptions);
                    parent = node.getParent();
                } else {
                    ng = node.getG() + graph.getMovementCost(node, neighbor, this.defaultOptions);
                    parent = node;
                }
                if (neighbor.getOpenedOnJob(this.getClass()) == job && !(ng < neighbor.getG())) continue;
                float prevf = neighbor.getF();
                neighbor.setG(ng);
                neighbor.setH(this.defaultOptions.heuristic.calculate(neighbor, (NavigationNode)endNode));
                neighbor.setF(neighbor.getG() + neighbor.getH());
                neighbor.setParent(parent);
                if (neighbor.getOpenedOnJob(this.getClass()) != job) {
                    this.openList.add(neighbor);
                    neighbor.setOpenedOnJob(job, this.getClass());
                    continue;
                }
                this.openList.updateNode(neighbor, neighbor.getF() - prevf);
            }
        }
        return null;
    }
}

