/*
 * Decompiled with CFR 0.152.
 */
package org.openbw.bwapi4j;

import org.openbw.bwapi4j.Position;
import org.openbw.bwapi4j.TilePosition;

public class WalkPosition {
    public static final int SIZE_IN_PIXELS = 8;
    private final int x;
    private final int y;

    public WalkPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public WalkPosition(TilePosition tilePosition) {
        this.x = tilePosition.getX() * 32 / 8;
        this.y = tilePosition.getY() * 32 / 8;
    }

    public WalkPosition(Position position) {
        this.x = position.getX() / 8;
        this.y = position.getY() / 8;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public TilePosition toTilePosition() {
        int x = this.getX() * 8 / 32;
        int y = this.getY() * 8 / 32;
        return new TilePosition(x, y);
    }

    public Position toPosition() {
        int x = this.getX() * 8;
        int y = this.getY() * 8;
        return new Position(x, y);
    }

    public WalkPosition add(WalkPosition walkPosition) {
        int x = this.getX() + walkPosition.getX();
        int y = this.getY() + walkPosition.getY();
        return new WalkPosition(x, y);
    }

    public WalkPosition subtract(WalkPosition walkPosition) {
        int x = this.getX() - walkPosition.getX();
        int y = this.getY() - walkPosition.getY();
        return new WalkPosition(x, y);
    }

    public WalkPosition multiply(WalkPosition walkPosition) {
        int x = this.getX() * walkPosition.getX();
        int y = this.getY() * walkPosition.getY();
        return new WalkPosition(x, y);
    }

    public WalkPosition divide(WalkPosition walkPosition) {
        int x = this.getX() / walkPosition.getX();
        int y = this.getY() / walkPosition.getY();
        return new WalkPosition(x, y);
    }

    public String toString() {
        return "[" + this.getX() + ", " + this.getY() + "]";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof WalkPosition)) {
            return false;
        }
        WalkPosition walkPosition = (WalkPosition)object;
        if (this.getX() != walkPosition.getX()) {
            return false;
        }
        return this.getY() == walkPosition.getY();
    }

    public int hashCode() {
        return this.getX() * 2048 * 8 + this.getY();
    }
}

