/*
 * Decompiled with CFR 0.152.
 */
package org.openbw.bwapi4j;

import org.openbw.bwapi4j.Position;
import org.openbw.bwapi4j.type.Color;

public final class MapDrawer {
    private boolean drawingEnabled = true;

    MapDrawer() {
    }

    public void setEnabled(boolean enabled) {
        this.drawingEnabled = enabled;
    }

    public boolean isEnabled() {
        return this.drawingEnabled;
    }

    private native void drawCircleMap_native(int var1, int var2, int var3, int var4);

    private native void drawCircleMap_native(int var1, int var2, int var3, int var4, boolean var5);

    private native void drawBoxMap_native(int var1, int var2, int var3, int var4, int var5);

    private native void drawBoxMap_native(int var1, int var2, int var3, int var4, int var5, boolean var6);

    private native void drawBoxScreen_native(int var1, int var2, int var3, int var4, int var5, boolean var6);

    private native void drawLineMap_native(int var1, int var2, int var3, int var4, int var5);

    private native void drawTextMap_native(int var1, int var2, String var3);

    private native void drawTextScreen_native(int var1, int var2, String var3);

    public void drawCircleMap(Position p, int radius, Color color) {
        this.drawCircleMap(p.getX(), p.getY(), radius, color, false);
    }

    public void drawCircleMap(Position p, int radius, Color color, boolean isSolid) {
        this.drawCircleMap(p.getX(), p.getY(), radius, color, isSolid);
    }

    public void drawCircleMap(int x, int y, int radius, Color color) {
        this.drawCircleMap(x, y, radius, color, false);
    }

    public void drawCircleMap(int x, int y, int radius, Color color, boolean isSolid) {
        if (this.drawingEnabled) {
            this.drawCircleMap_native(x, y, radius, color.getValue(), isSolid);
        }
    }

    public void drawBoxMap(Position topLeft, Position bottomRight, Color color) {
        this.drawBoxMap(topLeft, bottomRight, color, false);
    }

    public void drawBoxMap(Position topLeft, Position bottomRight, Color color, boolean isSolid) {
        this.drawBoxMap(topLeft.getX(), topLeft.getY(), bottomRight.getX(), bottomRight.getY(), color, isSolid);
    }

    public void drawBoxMap(int left, int top, int right, int bottom, Color color) {
        this.drawBoxMap(left, top, right, bottom, color, false);
    }

    public void drawBoxMap(int left, int top, int right, int bottom, Color color, boolean isSolid) {
        if (this.drawingEnabled) {
            this.drawBoxMap_native(left, top, right, bottom, color.getValue(), isSolid);
        }
    }

    public void drawBoxScreen(Position topLeft, Position bottomRight, Color color) {
        this.drawBoxScreen(topLeft.getX(), topLeft.getY(), bottomRight.getX(), bottomRight.getY(), color, false);
    }

    public void drawBoxScreen(Position topLeft, Position bottomRight, Color color, boolean isSolid) {
        this.drawBoxScreen(topLeft.getX(), topLeft.getY(), bottomRight.getX(), bottomRight.getY(), color, isSolid);
    }

    public void drawBoxScreen(int left, int top, int right, int bottom, Color color) {
        this.drawBoxScreen(left, top, right, bottom, color, false);
    }

    public void drawBoxScreen(int left, int top, int right, int bottom, Color color, boolean isSolid) {
        if (this.drawingEnabled) {
            this.drawBoxScreen_native(left, top, right, bottom, color.getValue(), isSolid);
        }
    }

    public void drawLineMap(Position a, Position b, Color color) {
        this.drawLineMap(a.getX(), a.getY(), b.getX(), b.getY(), color);
    }

    public void drawLineMap(int x1, int y1, int x2, int y2, Color color) {
        if (this.drawingEnabled) {
            this.drawLineMap_native(x1, y1, x2, y2, color.getValue());
        }
    }

    public void drawTextMap(Position position, String text) {
        this.drawTextMap(position.getX(), position.getY(), text);
    }

    public void drawTextMap(int x, int y, String text) {
        if (this.drawingEnabled) {
            this.drawTextMap_native(x, y, text);
        }
    }

    public void drawTextScreen(Position position, String text) {
        this.drawTextScreen(position.getX(), position.getY(), text);
    }

    public void drawTextScreen(int x, int y, String text) {
        if (this.drawingEnabled) {
            this.drawTextScreen_native(x, y, text);
        }
    }

    public void setTextSize(TextSize textSize) {
        this.setTextSize(textSize.ordinal());
    }

    private native void setTextSize(int var1);

    private native void drawLineScreen_native(int var1, int var2, int var3, int var4, int var5);

    public void drawLineScreen(int x1, int y1, int x2, int y2, Color color) {
        this.drawLineScreen_native(x1, y1, x2, y2, color.getValue());
    }

    public void drawLineScreen(Position a, Position b, Color color) {
        this.drawLineScreen(a.getX(), a.getY(), b.getX(), b.getY(), color);
    }

    public static enum TextSize {
        Small,
        Default,
        Large,
        Huge;

    }
}

