/*
 * Decompiled with CFR 0.152.
 */
package org.openbw.bwapi4j;

import java.util.ArrayList;
import java.util.List;
import org.openbw.bwapi4j.BWMap;
import org.openbw.bwapi4j.InteractionHandler;
import org.openbw.bwapi4j.Position;
import org.openbw.bwapi4j.TilePosition;
import org.openbw.bwapi4j.WalkPosition;
import org.openbw.bwapi4j.type.UnitType;
import org.openbw.bwapi4j.unit.PlayerUnit;
import org.openbw.bwapi4j.util.Cache;

class BWMapImpl
implements BWMap {
    private String mapHash;
    private String mapFileName;
    private String mapName;
    private final InteractionHandler interactionHandler;
    int tileWidth;
    int tileHeight;
    private int[][] groundHeightData;
    private int[][] isBuildableData;
    private Cache<boolean[][]> getCreepDataCache;
    private ArrayList<TilePosition> startLocations;
    private int[][] isWalkableData;
    int walkWidth;
    int walkHeight;
    int pixelWidth;
    int pixelHeight;

    BWMapImpl(InteractionHandler interactionHandler) {
        this.interactionHandler = interactionHandler;
        this.startLocations = new ArrayList();
        this.getCreepDataCache = new Cache<boolean[][]>(this::getCreepData, this.interactionHandler);
    }

    @Override
    public String mapHash() {
        return this.mapHash;
    }

    @Override
    public String mapFileName() {
        return this.mapFileName;
    }

    @Override
    public String mapName() {
        return this.mapName;
    }

    @Override
    public int getGroundHeight(TilePosition position) {
        return this.groundHeightData[position.getX()][position.getY()];
    }

    @Override
    public int getGroundHeight(int tileX, int tileY) {
        return this.groundHeightData[tileX][tileY];
    }

    @Override
    public List<TilePosition> getStartPositions() {
        return this.startLocations;
    }

    @Override
    public boolean isWalkable(int walkX, int walkY) {
        return this.isWalkableData[walkX][walkY] == 1;
    }

    @Override
    public boolean isWalkable(WalkPosition walkPosition) {
        return this.isWalkable(walkPosition.getX(), walkPosition.getY());
    }

    @Override
    public boolean isValidPosition(TilePosition tilePosition) {
        return tilePosition.getX() >= 0 && tilePosition.getX() < this.mapWidth() && tilePosition.getY() >= 0 && tilePosition.getY() < this.mapHeight();
    }

    @Override
    public boolean isValidPosition(WalkPosition walkPosition) {
        return walkPosition.getX() >= 0 && walkPosition.getX() < this.mapWalkWidth() && walkPosition.getY() >= 0 && walkPosition.getY() < this.mapWalkHeight();
    }

    @Override
    public boolean isValidPosition(Position position) {
        return position.getX() >= 0 && position.getX() < this.mapPixelWidth() && position.getY() >= 0 && position.getY() < this.mapPixelHeight();
    }

    @Override
    public int mapWidth() {
        return this.tileWidth;
    }

    @Override
    public int mapHeight() {
        return this.tileHeight;
    }

    private int mapWalkWidth() {
        return this.walkWidth;
    }

    private int mapWalkHeight() {
        return this.walkHeight;
    }

    private int mapPixelWidth() {
        return this.pixelWidth;
    }

    private int mapPixelHeight() {
        return this.pixelHeight;
    }

    private native int _isBuildable(int var1, int var2, boolean var3);

    @Override
    public boolean isBuildable(int tileX, int tileY, boolean considerBuildings) {
        return considerBuildings ? this._isBuildable(tileX, tileY, considerBuildings) == 1 : this.isBuildable(tileX, tileY);
    }

    @Override
    public boolean isBuildable(TilePosition tilePosition, boolean considerBuildings) {
        return this.isBuildable(tilePosition.getX(), tilePosition.getY(), considerBuildings);
    }

    @Override
    public boolean isBuildable(int tileX, int tileY) {
        return tileX >= 0 && tileX < this.mapWidth() && tileY >= 0 && tileY < this.mapHeight() && this.isBuildableData[tileX][tileY] == 1;
    }

    @Override
    public boolean isBuildable(TilePosition tilePosition) {
        return this.isBuildable(tilePosition.getX(), tilePosition.getY());
    }

    private native int _isExplored(int var1, int var2);

    @Override
    public boolean isExplored(int tileX, int tileY) {
        return this._isExplored(tileX, tileY) == 1;
    }

    @Override
    public boolean isExplored(TilePosition position) {
        return this._isExplored(position.getX(), position.getY()) == 1;
    }

    private native int _isVisible(int var1, int var2);

    @Override
    public boolean isVisible(int tileX, int tileY) {
        return this._isVisible(tileX, tileY) == 1;
    }

    @Override
    public boolean isVisible(TilePosition position) {
        return this._isVisible(position.getX(), position.getY()) == 1;
    }

    private native int _hasPath(int var1, int var2, int var3, int var4);

    @Override
    public boolean hasPath(Position source, Position destination) {
        return this._hasPath(source.getX(), source.getY(), destination.getX(), destination.getY()) == 1;
    }

    private native int _canBuildHere(int var1, int var2, int var3);

    private native int _canBuildHere(int var1, int var2, int var3, int var4);

    @Override
    public boolean canBuildHere(TilePosition position, UnitType type) {
        return this._canBuildHere(position.getX(), position.getY(), type.getId()) == 1;
    }

    public boolean canBuildHere(TilePosition position, UnitType type, PlayerUnit builder) {
        return this._canBuildHere(position.getX(), position.getY(), type.getId(), builder.getId()) == 1;
    }

    private native int[] getCreepData_native();

    private boolean[][] getCreepData() {
        int[] data = this.getCreepData_native();
        int mapTileWidth = this.mapWidth();
        int mapTileHeight = this.mapHeight();
        boolean[][] creepData = new boolean[mapTileWidth][mapTileHeight];
        int index = 0;
        for (int tileX = 0; tileX < mapTileWidth; ++tileX) {
            for (int tileY = 0; tileY < mapTileHeight; ++tileY) {
                creepData[tileX][tileY] = data[index++] == 1;
            }
        }
        return creepData;
    }

    public boolean hasCreep(int tileX, int tileY) {
        return this.getCreepDataCache.get()[tileX][tileY];
    }

    @Override
    public boolean hasCreep(TilePosition tilePosition) {
        return this.hasCreep(tilePosition.getX(), tilePosition.getY());
    }
}

