/*
 * Decompiled with CFR 0.152.
 */
package org.openbw.bwapi4j;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openbw.bwapi4j.BWAPI4J;
import org.openbw.bwapi4j.BWEventListener;
import org.openbw.bwapi4j.BWMap;
import org.openbw.bwapi4j.BWMapImpl;
import org.openbw.bwapi4j.Bullet;
import org.openbw.bwapi4j.BulletBridge;
import org.openbw.bwapi4j.DamageEvaluator;
import org.openbw.bwapi4j.InteractionHandler;
import org.openbw.bwapi4j.MapDrawer;
import org.openbw.bwapi4j.Player;
import org.openbw.bwapi4j.PlayerBridge;
import org.openbw.bwapi4j.Position;
import org.openbw.bwapi4j.TilePosition;
import org.openbw.bwapi4j.type.TechType;
import org.openbw.bwapi4j.type.TechTypeBridge;
import org.openbw.bwapi4j.type.UnitType;
import org.openbw.bwapi4j.type.UnitTypeBridge;
import org.openbw.bwapi4j.type.UpgradeType;
import org.openbw.bwapi4j.type.UpgradeTypeBridge;
import org.openbw.bwapi4j.type.WeaponType;
import org.openbw.bwapi4j.type.WeaponTypeBridge;
import org.openbw.bwapi4j.unit.MineralPatch;
import org.openbw.bwapi4j.unit.PlayerUnit;
import org.openbw.bwapi4j.unit.Unit;
import org.openbw.bwapi4j.unit.UnitFactory;
import org.openbw.bwapi4j.unit.UnitImpl;
import org.openbw.bwapi4j.unit.UnitImplBridge;
import org.openbw.bwapi4j.unit.VespeneGeyser;
import org.openbw.bwapi4j.unit.WeaponBridge;
import org.openbw.bwapi4j.unit.Worker;
import org.openbw.bwapi4j.util.Cache;
import org.openbw.bwapi4j.util.DependencyManager;
import org.openbw.bwapi4j.util.system.SystemUtils;

public class BW {
    private static final Logger logger = LogManager.getLogger();
    private final DependencyManager dependencyManager = new DependencyManager();
    private BWEventListener listener;
    private InteractionHandler interactionHandler;
    private MapDrawer mapDrawer;
    private DamageEvaluator damageEvaluator;
    private BWMapImpl bwMap;
    private UnitImplBridge unitDataBridge;
    private PlayerBridge playerBridge;
    private BulletBridge bulletBridge;
    private UpgradeTypeBridge upgradeTypeBridge;
    private WeaponTypeBridge weaponTypeBridge;
    private TechTypeBridge techTypeBridge;
    private UnitTypeBridge unitTypeBridge;
    private Map<Integer, Player> players;
    private Map<Integer, UnitImpl> units;
    private Map<Integer, Bullet> bullets;
    private UnitFactory unitFactory;
    private Charset charset;
    private Cache<Map<Player, List<PlayerUnit>>> getUnitsFromPlayerCache;
    private Cache<List<MineralPatch>> getMineralPatchesCache;
    private Cache<List<VespeneGeyser>> getVespeneGeysersCache;

    public BW(BWEventListener listener) {
        this(listener, SystemUtils.isWindowsPlatform() ? BWAPI4J.BridgeType.VANILLA : BWAPI4J.BridgeType.OPENBW, true);
    }

    public BW(BWEventListener listener, BWAPI4J.BridgeType bridgeType, boolean extractBridgeDependencies) {
        try {
            bridgeType = BWAPI4J.BridgeType.parseBridgeType(System.getProperty(BWAPI4J.Property.BRIDGE_TYPE.toString()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        String extractBridgeDependenciesSystemProperty = System.getProperty(BWAPI4J.Property.EXTRACT_DEPENDENCIES.toString());
        if (extractBridgeDependenciesSystemProperty != null && !extractBridgeDependenciesSystemProperty.trim().isEmpty()) {
            extractBridgeDependencies = SystemUtils.systemPropertyEquals(BWAPI4J.Property.EXTRACT_DEPENDENCIES.toString(), true) || !SystemUtils.systemPropertyEquals(BWAPI4J.Property.EXTRACT_DEPENDENCIES.toString(), false);
        }
        this.dependencyManager.loadSharedLibraries(bridgeType, extractBridgeDependencies);
        this.players = new HashMap<Integer, Player>();
        this.units = new HashMap<Integer, UnitImpl>();
        this.bullets = new HashMap<Integer, Bullet>();
        this.listener = listener;
        this.interactionHandler = new InteractionHandler(this);
        this.mapDrawer = new MapDrawer();
        this.damageEvaluator = new DamageEvaluator();
        this.bwMap = new BWMapImpl(this.interactionHandler);
        this.unitDataBridge = new UnitImplBridge(this, new WeaponBridge(this));
        this.playerBridge = new PlayerBridge(this);
        this.bulletBridge = new BulletBridge(this);
        this.upgradeTypeBridge = new UpgradeTypeBridge(this);
        this.weaponTypeBridge = new WeaponTypeBridge(this);
        this.techTypeBridge = new TechTypeBridge(this);
        this.unitTypeBridge = new UnitTypeBridge(this);
        this.setUnitFactory(new UnitFactory());
        try {
            this.charset = Charset.forName("Cp949");
        }
        catch (UnsupportedCharsetException e) {
            logger.warn("Korean character set not available. Some characters may not be read properly.");
            this.charset = StandardCharsets.ISO_8859_1;
        }
        this.getUnitsFromPlayerCache = new Cache<Map>(() -> {
            HashMap<Player, List> playerListMap = new HashMap<Player, List>();
            for (Unit unit : this.units.values()) {
                PlayerUnit playerUnit;
                Player player;
                if (!(unit instanceof PlayerUnit) || (player = (playerUnit = (PlayerUnit)unit).getPlayer()) == null) continue;
                List units = playerListMap.computeIfAbsent(player, list -> new ArrayList());
                units.add(playerUnit);
            }
            return playerListMap;
        }, this.interactionHandler);
        this.getMineralPatchesCache = new Cache<List>(() -> this.units.values().stream().filter(u -> u instanceof MineralPatch).map(u -> (MineralPatch)u).collect(Collectors.toList()), this.interactionHandler);
        this.getVespeneGeysersCache = new Cache<List>(() -> this.units.values().stream().filter(u -> u instanceof VespeneGeyser).map(u -> (VespeneGeyser)u).collect(Collectors.toList()), this.interactionHandler);
    }

    public void startGame() {
        this.startGame(this);
    }

    public void createUnit(Player owner, UnitType type, int posX, int posY) {
        this.createUnit(owner.getId(), type.getId(), posX, posY);
    }

    private native void createUnit(int var1, int var2, int var3, int var4);

    public void killUnit(Unit unit) {
        this.killUnit(unit.getId());
    }

    private native void killUnit(int var1);

    public native void exit();

    private native void startGame(BW var1);

    private native int[] getUpgradeTypesData();

    private native int[] getWeaponTypesData();

    private native int[] getTechTypesData();

    private native int[] getUnitTypesData();

    private native int[] getAllUnitsData();

    private native int[] getAllBulletsData();

    private native int[] getAllPlayersData();

    private native int[] getGameData();

    private native int getClientVersion();

    private native String getPlayerName(int var1);

    private native int[] getPlayerExtra(int var1);

    public void setUnitFactory(UnitFactory unitFactory) {
        this.unitFactory = unitFactory;
        this.unitFactory.setBW(this);
    }

    public BWMap getBWMap() {
        return this.bwMap;
    }

    public MapDrawer getMapDrawer() {
        return this.mapDrawer;
    }

    public DamageEvaluator getDamageEvaluator() {
        return this.damageEvaluator;
    }

    public InteractionHandler getInteractionHandler() {
        return this.interactionHandler;
    }

    private void updateGame() {
        int[] data = this.getGameData();
        this.interactionHandler.update(data);
    }

    private void updateAllBullets() {
        int[] bulletData = this.getAllBulletsData();
        int index = 0;
        while (index < bulletData.length) {
            int bulletId = bulletData[index + 0];
            Bullet bullet = this.bullets.get(bulletId);
            if (bullet == null) {
                bullet = new Bullet();
                this.bullets.put(bulletId, bullet);
                this.bulletBridge.initialize(bullet, bulletData, index);
            }
            index = this.bulletBridge.update(bullet, bulletData, index);
        }
    }

    private boolean typeChanged(UnitType oldType, UnitType newType) {
        return !oldType.equals(newType) && !oldType.equals(UnitType.Terran_Siege_Tank_Siege_Mode) && !newType.equals(UnitType.Terran_Siege_Tank_Siege_Mode);
    }

    private void updateAllUnits(int frame) {
        for (UnitImpl unit : this.units.values()) {
            this.unitDataBridge.reset(unit);
        }
        int[] unitData = this.getAllUnitsData();
        int index = 0;
        while (index < unitData.length) {
            int unitId = unitData[index + 0];
            int typeId = unitData[index + 7];
            UnitImpl unit = this.units.get(unitId);
            if (unit == null || this.typeChanged(unit.getType(), UnitType.values()[typeId])) {
                if (unit != null) {
                    logger.debug("unit {} changed type from {} to {}.", (Object)unit.getId(), (Object)unit.getType(), (Object)UnitType.values()[typeId]);
                }
                logger.trace("creating unit for id {} and type {} ({}) ...", (Object)unitId, (Object)typeId, (Object)UnitType.values()[typeId]);
                unit = this.unitFactory.createUnit(unitId, UnitType.values()[typeId], frame);
                if (unit == null) {
                    logger.error("could not create unit for id {} and type {}.", (Object)unitId, (Object)UnitType.values()[typeId]);
                    continue;
                }
                logger.trace("state: {}", (Object)(unit.exists() ? "completed" : "created"));
                this.units.put(unitId, unit);
                this.unitDataBridge.initialize(unit, unitData, index);
                index = this.unitDataBridge.update(unit, unitData, index);
                logger.trace("initial pos: {}", (Object)unit.getInitialTilePosition());
                logger.trace("current pos: {}", (Object)unit.getTilePosition());
                logger.trace(" done.");
                continue;
            }
            index = this.unitDataBridge.update(unit, unitData, index);
        }
    }

    private void updateAllPlayers() {
        int[] playerData = this.getAllPlayersData();
        int index = 0;
        while (index < playerData.length) {
            int playerId = playerData[index + 1];
            Player player = this.players.get(playerId);
            if (player == null) {
                logger.debug("creating player for id {} ...", (Object)playerId);
                player = new Player(playerId, this.getPlayerName(playerId), this);
                logger.trace("player name: {}", (Object)player.getName());
                this.players.put(playerId, player);
                logger.trace("initializing...");
                this.playerBridge.initialize(player, playerData, index);
                player.initialize();
                logger.trace(" done.");
            }
            index = this.playerBridge.update(player, playerData, index);
            player.update(this.getPlayerExtra(playerId));
        }
    }

    public Player getPlayer(int playerId) {
        return this.players.get(playerId);
    }

    public Collection<Player> getAllPlayers() {
        return this.players.values();
    }

    public Unit getUnit(int unitId) {
        return unitId > 0 ? (Unit)this.units.get(unitId) : null;
    }

    public Collection<Bullet> getBullets() {
        return this.bullets.values();
    }

    public Bullet getBullet(int bulletId) {
        return this.bullets.get(bulletId);
    }

    public List<PlayerUnit> getUnits(Player player) {
        return this.getUnitsFromPlayerCache.get().getOrDefault(player, Collections.emptyList());
    }

    public List<MineralPatch> getMineralPatches() {
        return this.getMineralPatchesCache.get();
    }

    public List<VespeneGeyser> getVespeneGeysers() {
        return this.getVespeneGeysersCache.get();
    }

    public Collection<UnitImpl> getAllUnits() {
        return this.units.values();
    }

    public boolean canBuildHere(TilePosition position, UnitType type) {
        return this.bwMap.canBuildHere(position, type);
    }

    public boolean canBuildHere(TilePosition position, UnitType type, Worker builder) {
        return this.bwMap.canBuildHere(position, type, builder);
    }

    private void preFrame() {
        this.updateGame();
        logger.trace("updated game.");
        this.updateAllPlayers();
        logger.trace("updated players.");
        this.updateAllUnits(this.getInteractionHandler().getFrameCount());
        logger.trace("updated all units.");
        this.updateAllBullets();
        logger.trace("updated all bullets.");
    }

    private void onStart() {
        try {
            logger.trace(" --- onStart called.");
            this.players.clear();
            this.units.clear();
            this.bullets.clear();
            this.initializeTypes();
            logger.trace(" --- calling initial preFrame...");
            this.preFrame();
            logger.trace("done.");
            this.listener.onStart();
        }
        catch (Throwable e) {
            logger.error("exception during onStart.", e);
            throw e;
        }
    }

    private void initializeTypes() {
        this.initializeUpgradeTypes();
        this.initializeWeaponTypes();
        this.initializeTechTypes();
        this.initializeUnitTypes();
    }

    private void initializeUpgradeTypes() {
        int[] data = this.getUpgradeTypesData();
        int index = 0;
        while (index < data.length) {
            int id = data[index + 0];
            index = this.upgradeTypeBridge.update(UpgradeType.withId(id), data, index);
        }
    }

    private void initializeWeaponTypes() {
        int[] data = this.getWeaponTypesData();
        int index = 0;
        while (index < data.length) {
            int id = data[index + 0];
            index = this.weaponTypeBridge.update(WeaponType.withId(id), data, index);
        }
    }

    private void initializeTechTypes() {
        int[] data = this.getTechTypesData();
        int index = 0;
        while (index < data.length) {
            int id = data[index + 0];
            index = this.techTypeBridge.update(TechType.withId(id), data, index);
        }
    }

    private void initializeUnitTypes() {
        int[] data = this.getUnitTypesData();
        int index = 0;
        while (index < data.length) {
            int id = data[index + 0];
            index = this.unitTypeBridge.update(UnitType.withId(id), data, index);
        }
    }

    private void onEnd(boolean isWinner) {
        BW.catchAllCalling(this.listener::onEnd, isWinner);
    }

    private void onFrame() {
        try {
            this.preFrame();
            this.listener.onFrame();
        }
        catch (Throwable e) {
            logger.error("exception during onFrame", e);
            throw e;
        }
    }

    private void onSendText(String text) {
        BW.catchAllCalling(this.listener::onSendText, text);
    }

    private void onReceiveText(int playerId, String text) {
        Player player = this.players.get(playerId);
        BW.catchAllCalling(this.listener::onReceiveText, player, text);
    }

    private void onPlayerLeft(int playerId) {
        Player player = this.players.get(playerId);
        BW.catchAllCalling(this.listener::onPlayerLeft, player);
    }

    private void onNukeDetect(int x, int y) {
        BW.catchAllCalling(this.listener::onNukeDetect, new Position(x, y));
    }

    private void onUnitDiscover(int unitId) {
        Unit unit = this.units.get(unitId);
        if (unit == null) {
            logger.error("onUnitDiscover: no unit found for ID {}.", (Object)unitId);
        }
        BW.catchAllCalling(this.listener::onUnitDiscover, unit);
    }

    private void onUnitEvade(int unitId) {
        Unit unit = this.units.get(unitId);
        if (unit == null) {
            logger.error("onUnitEvade: no unit found for ID {}.", (Object)unitId);
        }
        BW.catchAllCalling(this.listener::onUnitEvade, unit);
    }

    private void onUnitShow(int unitId) {
        Unit unit = this.units.get(unitId);
        if (unit == null) {
            logger.error("onUnitShow: no unit found for ID {}.", (Object)unitId);
        }
        BW.catchAllCalling(this.listener::onUnitShow, unit);
    }

    private void onUnitHide(int unitId) {
        Unit unit = this.units.get(unitId);
        if (unit == null) {
            logger.error("onUnitHide: no unit found for ID {}.", (Object)unitId);
        }
        BW.catchAllCalling(this.listener::onUnitHide, unit);
    }

    private void onUnitCreate(int unitId) {
        Unit unit = this.units.get(unitId);
        if (unit == null) {
            logger.error("onUnitCreate: no unit found for ID {}.", (Object)unitId);
        }
        BW.catchAllCalling(this.listener::onUnitCreate, unit);
    }

    private void onUnitDestroy(int unitId) {
        Unit unit = this.units.get(unitId);
        if (unit == null) {
            logger.error("onUnitDestroy: no unit found for ID {}.", (Object)unitId);
        }
        BW.catchAllCalling(this.listener::onUnitDestroy, unit);
        this.units.remove(unitId);
    }

    private void onUnitMorph(int unitId) {
        Unit unit = this.units.get(unitId);
        if (unit == null) {
            logger.error("onUnitMorph: no unit found for ID {}.", (Object)unitId);
        }
        BW.catchAllCalling(this.listener::onUnitMorph, unit);
    }

    private void onUnitRenegade(int unitId) {
        Unit unit = this.units.get(unitId);
        if (unit == null) {
            logger.error("onUnitRenegade: no unit found for ID {}.", (Object)unitId);
        }
        BW.catchAllCalling(this.listener::onUnitRenegade, unit);
    }

    private void onSaveGame(String gameName) {
        BW.catchAllCalling(this.listener::onSaveGame, gameName);
    }

    private void onUnitComplete(int unitId) {
        Unit unit = this.units.get(unitId);
        if (unit == null) {
            logger.error("onUnitComplete: no unit found for ID {}.", (Object)unitId);
        }
        BW.catchAllCalling(this.listener::onUnitComplete, unit);
    }

    private static <T> void catchAllCalling(Consumer<T> consumer, T param) {
        try {
            consumer.accept(param);
        }
        catch (Throwable t) {
            logger.error(t);
        }
    }

    private static <T, U> void catchAllCalling(BiConsumer<T, U> consumer, T param1, U param2) {
        try {
            consumer.accept(param1, param2);
        }
        catch (Throwable t) {
            logger.error(t);
        }
    }
}

