/*
 * Decompiled with CFR 0.152.
 */
package bwem.util;

import bwem.CheckMode;
import bwem.map.MapImpl;
import bwem.util.Utils;
import java.util.ArrayList;
import java.util.List;
import org.openbw.bwapi4j.MapDrawer;
import org.openbw.bwapi4j.Position;
import org.openbw.bwapi4j.TilePosition;
import org.openbw.bwapi4j.WalkPosition;
import org.openbw.bwapi4j.type.Color;
import org.openbw.bwapi4j.util.Pair;

public final class BwemExt {
    private static final int TILE_POSITION_CENTER_OFFSET_IN_PIXELS = 16;
    public static final Position TILE_POSITION_CENTER_IN_PIXELS = new Position(16, 16);
    private static final int WALK_POSITION_CENTER_OFFSET_IN_PIXELS = 4;
    public static final Position WALK_POSITION_CENTER_IN_PIXELS = new Position(4, 4);
    public static final int lake_max_miniTiles = 300;
    public static final int lake_max_width_in_miniTiles = 32;
    public static final int area_min_miniTiles = 64;
    public static final int MAX_TILES_BETWEEN_COMMAND_CENTER_AND_RESOURCES = 10;
    public static final int min_tiles_between_Bases = 10;
    public static final int MAX_TILES_BETWEEN_STARTING_LOCATION_AND_ITS_ASSIGNED_BASE = 3;

    private BwemExt() {
    }

    public static Position center(TilePosition tilePosition) {
        return tilePosition.toPosition().add(TILE_POSITION_CENTER_IN_PIXELS);
    }

    public static Position center(WalkPosition walkPosition) {
        Position ret = walkPosition.toPosition().add(WALK_POSITION_CENTER_IN_PIXELS);
        return ret;
    }

    public static Position centerOfBuilding(TilePosition tilePosition, TilePosition buildingSize) {
        Position pixelSize = buildingSize.toPosition();
        Position pixelOffset = pixelSize.divide(new Position(2, 2));
        return tilePosition.toPosition().add(pixelOffset);
    }

    public static Pair<TilePosition, TilePosition> makeBoundingBoxIncludePoint(TilePosition topLeft, TilePosition bottomRight, TilePosition point) {
        int topLeftX = topLeft.getX();
        int topLeftY = topLeft.getY();
        int bottomRightX = bottomRight.getX();
        int bottomRightY = bottomRight.getY();
        if (point.getX() < topLeftX) {
            topLeftX = point.getX();
        }
        if (point.getX() > bottomRightX) {
            bottomRightX = point.getX();
        }
        if (point.getY() < topLeftY) {
            topLeftY = point.getY();
        }
        if (point.getY() > bottomRightY) {
            bottomRightY = point.getY();
        }
        return new Pair<TilePosition, TilePosition>(new TilePosition(topLeftX, topLeftY), new TilePosition(bottomRightX, bottomRightY));
    }

    public static TilePosition makePointFitToBoundingBox(TilePosition point, TilePosition topLeft, TilePosition bottomRight) {
        int pointX = point.getX();
        int pointY = point.getY();
        if (pointX < topLeft.getX()) {
            pointX = topLeft.getX();
        } else if (pointX > bottomRight.getX()) {
            pointX = bottomRight.getX();
        }
        if (pointY < topLeft.getY()) {
            pointY = topLeft.getY();
        } else if (pointY > bottomRight.getY()) {
            pointY = bottomRight.getY();
        }
        return new TilePosition(pointX, pointY);
    }

    public static boolean isPointInBoundingBox(TilePosition point, TilePosition topLeft, TilePosition bottomRight) {
        return point.getX() >= topLeft.getX() && point.getX() <= bottomRight.getX() && point.getY() >= topLeft.getY() && point.getY() <= bottomRight.getY();
    }

    public static int queenWiseDist(TilePosition a, TilePosition b) {
        TilePosition ret = a.subtract(b);
        return Utils.queenWiseNorm(ret.getX(), ret.getY());
    }

    public static int queenWiseDist(WalkPosition a, WalkPosition b) {
        WalkPosition ret = a.subtract(b);
        return Utils.queenWiseNorm(ret.getX(), ret.getY());
    }

    public static int queenWiseDist(Position a, Position b) {
        Position ret = a.subtract(b);
        return Utils.queenWiseNorm(ret.getX(), ret.getY());
    }

    public static int squaredDist(TilePosition a, TilePosition b) {
        TilePosition ret = a.subtract(b);
        return Utils.squaredNorm(ret.getX(), ret.getY());
    }

    public static int squaredDist(WalkPosition a, WalkPosition b) {
        WalkPosition ret = a.subtract(b);
        return Utils.squaredNorm(ret.getX(), ret.getY());
    }

    public static int squaredDist(Position a, Position b) {
        Position ret = a.subtract(b);
        return Utils.squaredNorm(ret.getX(), ret.getY());
    }

    public static double dist(TilePosition a, TilePosition b) {
        TilePosition ret = a.subtract(b);
        return Utils.norm(ret.getX(), ret.getY());
    }

    public static double dist(WalkPosition a, WalkPosition b) {
        WalkPosition ret = a.subtract(b);
        return Utils.norm(ret.getX(), ret.getY());
    }

    public static double dist(Position a, Position b) {
        Position ret = a.subtract(b);
        return Utils.norm(ret.getX(), ret.getY());
    }

    public static int roundedDist(TilePosition a, TilePosition b) {
        return (int)Math.round(BwemExt.dist(a, b));
    }

    public static int roundedDist(WalkPosition a, WalkPosition b) {
        return (int)Math.round(BwemExt.dist(a, b));
    }

    public static int roundedDist(Position a, Position b) {
        return (int)Math.round(BwemExt.dist(a, b));
    }

    public static int distToRectangle(Position a, Position topLeft, Position size) {
        Position bottomRight = topLeft.add(size).subtract(new Position(1, 1));
        if (a.getX() >= topLeft.getX()) {
            if (a.getX() <= bottomRight.getX()) {
                if (a.getY() > bottomRight.getY()) {
                    return a.getY() - bottomRight.getY();
                }
                if (a.getY() < topLeft.getY()) {
                    return topLeft.getY() - a.getY();
                }
                return 0;
            }
            if (a.getY() > bottomRight.getY()) {
                return BwemExt.roundedDist(a, bottomRight);
            }
            if (a.getY() < topLeft.getY()) {
                return BwemExt.roundedDist(a, new Position(bottomRight.getX(), topLeft.getY()));
            }
            return a.getX() - bottomRight.getX();
        }
        if (a.getY() > bottomRight.getY()) {
            return BwemExt.roundedDist(a, new Position(topLeft.getX(), bottomRight.getY()));
        }
        if (a.getY() < topLeft.getY()) {
            return BwemExt.roundedDist(a, topLeft);
        }
        return topLeft.getX() - a.getX();
    }

    private static List<Pair<Integer, Integer>> innerBorderDeltas(int sizeX, int sizeY, boolean noCorner) {
        ArrayList<Pair<Integer, Integer>> border = new ArrayList<Pair<Integer, Integer>>();
        for (int dy = 0; dy < sizeY; ++dy) {
            for (int dx = 0; dx < sizeX; ++dx) {
                if (dy != 0 && dy != sizeY - 1 && dx != 0 && dx != sizeX - 1 || noCorner && (dx == 0 && dy == 0 || dx == sizeX - 1 && dy == sizeY - 1 || dx == 0 && dy == sizeY - 1 || dx == sizeX - 1 && dy == 0)) continue;
                border.add(new Pair<Integer, Integer>(dx, dy));
            }
        }
        return border;
    }

    public static List<TilePosition> innerBorder(TilePosition topLeft, TilePosition size, boolean noCorner) {
        ArrayList<TilePosition> border = new ArrayList<TilePosition>();
        List<Pair<Integer, Integer>> deltas = BwemExt.innerBorderDeltas(size.getX(), size.getY(), noCorner);
        for (Pair<Integer, Integer> delta : deltas) {
            border.add(topLeft.add(new TilePosition(delta.getFirst(), delta.getSecond())));
        }
        return border;
    }

    public static List<TilePosition> innerBorder(TilePosition topLeft, TilePosition size) {
        return BwemExt.innerBorder(topLeft, size, false);
    }

    public static List<WalkPosition> innerBorder(WalkPosition topLeft, WalkPosition size, boolean noCorner) {
        ArrayList<WalkPosition> border = new ArrayList<WalkPosition>();
        List<Pair<Integer, Integer>> deltas = BwemExt.innerBorderDeltas(size.getX(), size.getY(), noCorner);
        for (Pair<Integer, Integer> delta : deltas) {
            border.add(topLeft.add(new WalkPosition(delta.getFirst(), delta.getSecond())));
        }
        return border;
    }

    public static List<WalkPosition> innerBorder(WalkPosition topLeft, WalkPosition size) {
        return BwemExt.innerBorder(topLeft, size, false);
    }

    public static List<TilePosition> outerBorder(TilePosition topLeft, TilePosition size, boolean noCorner) {
        return BwemExt.innerBorder(topLeft.subtract(new TilePosition(1, 1)), size.add(new TilePosition(2, 2)), noCorner);
    }

    public static List<TilePosition> outerBorder(TilePosition topLeft, TilePosition size) {
        return BwemExt.outerBorder(topLeft, size, false);
    }

    public static List<WalkPosition> outerBorder(WalkPosition topLeft, WalkPosition size, boolean noCorner) {
        return BwemExt.innerBorder(topLeft.subtract(new WalkPosition(1, 1)), size.add(new WalkPosition(2, 2)), noCorner);
    }

    public static List<WalkPosition> outerBorder(WalkPosition topLeft, WalkPosition size) {
        return BwemExt.outerBorder(topLeft, size, false);
    }

    public static List<WalkPosition> outerMiniTileBorder(TilePosition topLeft, TilePosition size, boolean noCorner) {
        return BwemExt.outerBorder(topLeft.toWalkPosition(), size.toWalkPosition(), noCorner);
    }

    public static List<WalkPosition> outerMiniTileBorder(TilePosition topLeft, TilePosition size) {
        return BwemExt.outerMiniTileBorder(topLeft, size, false);
    }

    public static List<WalkPosition> innerMiniTileBorder(TilePosition topLeft, TilePosition size, boolean noCorner) {
        return BwemExt.innerBorder(topLeft.toWalkPosition(), size.toWalkPosition(), noCorner);
    }

    public static List<WalkPosition> innerMiniTileBorder(TilePosition topLeft, TilePosition size) {
        return BwemExt.innerMiniTileBorder(topLeft, size, false);
    }

    public static boolean adjoins8SomeLakeOrNeutral(WalkPosition p, MapImpl pMap) {
        WalkPosition[] deltas;
        for (WalkPosition delta : deltas = new WalkPosition[]{new WalkPosition(-1, -1), new WalkPosition(0, -1), new WalkPosition(1, -1), new WalkPosition(-1, 0), new WalkPosition(1, 0), new WalkPosition(-1, 1), new WalkPosition(0, 1), new WalkPosition(1, 1)}) {
            WalkPosition next = p.add(delta);
            if (!pMap.getData().getMapData().isValid(next)) continue;
            if (pMap.getData().getTile(next.toTilePosition(), CheckMode.NO_CHECK).getNeutral() != null) {
                return true;
            }
            if (!pMap.getData().getMiniTile(next, CheckMode.NO_CHECK).isLake()) continue;
            return true;
        }
        return false;
    }

    public static void drawDiagonalCrossMap(MapDrawer mapDrawer, Position topLeft, Position bottomRight, Color col) {
        mapDrawer.drawLineMap(topLeft, bottomRight, col);
        mapDrawer.drawLineMap(new Position(bottomRight.getX(), topLeft.getY()), new Position(topLeft.getX(), bottomRight.getY()), col);
    }

    private static boolean overlap(int topLeft1X, int topLeft1Y, int size1X, int size1Y, int topLeft2X, int topLeft2Y, int size2X, int size2Y) {
        if (topLeft2X >= topLeft1X + size1X) {
            return false;
        }
        if (topLeft2Y >= topLeft1Y + size1Y) {
            return false;
        }
        if (topLeft1X >= topLeft2X + size2X) {
            return false;
        }
        return topLeft1Y < topLeft2Y + size2Y;
    }

    public static boolean overlap(TilePosition topLeft1, TilePosition size1, TilePosition topLeft2, TilePosition size2) {
        return BwemExt.overlap(topLeft1.getX(), topLeft1.getY(), size1.getX(), size1.getY(), topLeft2.getX(), topLeft2.getY(), size2.getX(), size2.getY());
    }

    public static boolean overlap(WalkPosition topLeft1, WalkPosition size1, WalkPosition topLeft2, WalkPosition size2) {
        return BwemExt.overlap(topLeft1.getX(), topLeft1.getY(), size1.getX(), size1.getY(), topLeft2.getX(), topLeft2.getY(), size2.getX(), size2.getY());
    }

    public static boolean overlap(Position topLeft1, Position size1, Position topLeft2, Position size2) {
        return BwemExt.overlap(topLeft1.getX(), topLeft1.getY(), size1.getX(), size1.getY(), topLeft2.getX(), topLeft2.getY(), size2.getX(), size2.getY());
    }

    private static boolean disjoint(int topLeft1X, int topLeft1Y, int size1X, int size1Y, int topLeft2X, int topLeft2Y, int size2X, int size2Y) {
        if (topLeft2X > topLeft1X + size1X) {
            return true;
        }
        if (topLeft2Y > topLeft1Y + size1Y) {
            return true;
        }
        if (topLeft1X > topLeft2X + size2X) {
            return true;
        }
        return topLeft1Y > topLeft2Y + size2Y;
    }

    public static boolean disjoint(TilePosition topLeft1, TilePosition size1, TilePosition topLeft2, TilePosition size2) {
        return BwemExt.disjoint(topLeft1.getX(), topLeft1.getY(), size1.getX(), size1.getY(), topLeft2.getX(), topLeft2.getY(), size2.getX(), size2.getY());
    }

    public static boolean disjoint(WalkPosition topLeft1, WalkPosition size1, WalkPosition topLeft2, WalkPosition size2) {
        return BwemExt.disjoint(topLeft1.getX(), topLeft1.getY(), size1.getX(), size1.getY(), topLeft2.getX(), topLeft2.getY(), size2.getX(), size2.getY());
    }

    public static boolean disjoint(Position topLeft1, Position size1, Position topLeft2, Position size2) {
        return BwemExt.disjoint(topLeft1.getX(), topLeft1.getY(), size1.getX(), size1.getY(), topLeft2.getX(), topLeft2.getY(), size2.getX(), size2.getY());
    }

    private static int getApproxDistance(int x0, int y0, int x1, int y1) {
        int min = Math.abs(x0 - x1);
        int max = Math.abs(y0 - y1);
        if (max < min) {
            int minTmp = min;
            min = max;
            max = minTmp;
        }
        if (min < max >> 2) {
            return max;
        }
        int minCalc = 3 * min >> 3;
        return (minCalc >> 5) + minCalc + max - (max >> 4) - (max >> 6);
    }

    public static int getApproxDistance(TilePosition source, TilePosition target) {
        return BwemExt.getApproxDistance(source.getX(), source.getY(), target.getX(), target.getY());
    }

    public static int getApproxDistance(WalkPosition source, WalkPosition target) {
        return BwemExt.getApproxDistance(source.getX(), source.getY(), target.getX(), target.getY());
    }

    public static int getApproxDistance(Position source, Position target) {
        return BwemExt.getApproxDistance(source.getX(), source.getY(), target.getX(), target.getY());
    }
}

