/*
 * Decompiled with CFR 0.152.
 */
package bwem.unit;

import bwem.area.Area;
import bwem.map.Map;
import bwem.map.MapImpl;
import bwem.map.TerrainDataInitializer;
import bwem.tile.Tile;
import bwem.tile.TileImpl;
import bwem.unit.Geyser;
import bwem.unit.Neutral;
import java.util.ArrayList;
import java.util.List;
import org.openbw.bwapi4j.Position;
import org.openbw.bwapi4j.TilePosition;
import org.openbw.bwapi4j.WalkPosition;
import org.openbw.bwapi4j.unit.Unit;

public abstract class NeutralImpl
implements Neutral {
    private final Unit bwapiUnit;
    private final Position pos;
    private final TilePosition topLeft;
    private final TilePosition tileSize;
    private final Map map;
    private Neutral nextStacked = null;
    private List<WalkPosition> blockedAreas = new ArrayList<WalkPosition>();

    protected NeutralImpl(Unit unit, Map map) {
        this.bwapiUnit = unit;
        this.map = map;
        this.pos = unit.getInitialPosition();
        this.topLeft = unit.getInitialTilePosition();
        this.tileSize = unit.getType().tileSize();
        this.putOnTiles();
    }

    public void simulateCPPObjectDestructor() {
        this.removeFromTiles();
        if (this.isBlocking()) {
            Map map = this.getMap();
            if (map instanceof MapImpl) {
                ((MapImpl)map).onBlockingNeutralDestroyed(this);
            } else {
                throw new IllegalStateException("expected class: " + MapImpl.class.getName() + ", actual class: " + map.getClass().getName());
            }
        }
    }

    @Override
    public Unit getUnit() {
        return this.bwapiUnit;
    }

    @Override
    public Position getCenter() {
        return this.pos;
    }

    @Override
    public TilePosition getTopLeft() {
        return this.topLeft;
    }

    @Override
    public TilePosition getBottomRight() {
        return this.topLeft.add(this.tileSize).subtract(new TilePosition(1, 1));
    }

    @Override
    public TilePosition getSize() {
        return this.tileSize;
    }

    @Override
    public boolean isBlocking() {
        return !this.blockedAreas.isEmpty();
    }

    @Override
    public List<Area> getBlockedAreas() {
        ArrayList<Area> blockedAreas = new ArrayList<Area>();
        for (WalkPosition w : this.blockedAreas) {
            blockedAreas.add(this.getMap().getArea(w));
        }
        return blockedAreas;
    }

    @Override
    public Neutral getNextStacked() {
        return this.nextStacked;
    }

    @Override
    public Neutral getLastStacked() {
        Neutral topNeutral = this;
        while (topNeutral.getNextStacked() != null) {
            topNeutral = topNeutral.getNextStacked();
        }
        return topNeutral;
    }

    public void setBlocking(List<WalkPosition> blockedAreas) {
        if (!this.blockedAreas.isEmpty() || blockedAreas.isEmpty()) {
            throw new IllegalStateException();
        }
        this.blockedAreas = blockedAreas;
    }

    public boolean isSameUnitTypeAs(Neutral neutral) {
        return this.getUnit().getClass().getName().equals(neutral.getUnit().getClass().getName());
    }

    private void putOnTiles() {
        if (this.getNextStacked() != null) {
            throw new IllegalStateException();
        }
        for (int dy = 0; dy < this.getSize().getY(); ++dy) {
            for (int dx = 0; dx < this.getSize().getX(); ++dx) {
                Tile deltaTile = ((TerrainDataInitializer)((Object)this.getMap().getData())).getTile_(this.getTopLeft().add(new TilePosition(dx, dy)));
                if (deltaTile.getNeutral() != null) {
                    Neutral topNeutral = deltaTile.getNeutral().getLastStacked();
                    if (this.equals(deltaTile.getNeutral())) {
                        throw new IllegalStateException();
                    }
                    if (this.equals(topNeutral)) {
                        throw new IllegalStateException();
                    }
                    if (topNeutral.getClass().getName().equals(Geyser.class.getName())) {
                        throw new IllegalStateException();
                    }
                    if (!((NeutralImpl)topNeutral).isSameUnitTypeAs(this)) {
                        throw new IllegalStateException("Stacked Neutral objects have different types: top=" + topNeutral.getClass().getName() + ", this=" + this.getClass().getName());
                    }
                    if (!topNeutral.getTopLeft().equals(this.getTopLeft())) {
                        throw new IllegalStateException("Stacked Neutral objects not aligned: top=" + topNeutral.toString() + ", this=" + this.getTopLeft().toString());
                    }
                    if (dx != 0 || dy != 0) {
                        throw new IllegalStateException();
                    }
                    ((NeutralImpl)topNeutral).nextStacked = this;
                    return;
                }
                ((TileImpl)deltaTile).addNeutral(this);
            }
        }
    }

    private void removeFromTiles() {
        for (int dy = 0; dy < this.getSize().getY(); ++dy) {
            for (int dx = 0; dx < this.getSize().getX(); ++dx) {
                Tile tile = ((TerrainDataInitializer)((Object)this.getMap().getData())).getTile_(this.getTopLeft().add(new TilePosition(dx, dy)));
                if (tile.getNeutral() == null) {
                    throw new IllegalStateException();
                }
                if (tile.getNeutral().equals(this)) {
                    ((TileImpl)tile).removeNeutral(this);
                    if (this.nextStacked == null) continue;
                    ((TileImpl)tile).addNeutral(this.nextStacked);
                    continue;
                }
                Neutral prevStacked = tile.getNeutral();
                while (!prevStacked.getNextStacked().equals(this)) {
                    prevStacked = prevStacked.getNextStacked();
                }
                if (!((NeutralImpl)prevStacked).isSameUnitTypeAs(this)) {
                    throw new IllegalStateException();
                }
                if (!prevStacked.getTopLeft().equals(this.getTopLeft())) {
                    throw new IllegalStateException();
                }
                if (dx != 0 || dy != 0) {
                    throw new IllegalStateException();
                }
                ((NeutralImpl)prevStacked).nextStacked = this.nextStacked;
                this.nextStacked = null;
                return;
            }
        }
        this.nextStacked = null;
    }

    protected Map getMap() {
        return this.map;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Neutral)) {
            return false;
        }
        Neutral that = (Neutral)object;
        return this.getUnit().getId() == that.getUnit().getId();
    }

    public int hashCode() {
        return this.getUnit().hashCode();
    }
}

