/*
 * Decompiled with CFR 0.152.
 */
package bwem.unit;

import bwem.map.Map;
import bwem.unit.Geyser;
import bwem.unit.Mineral;
import bwem.unit.NeutralData;
import bwem.unit.StaticBuilding;
import java.util.ArrayList;
import java.util.List;
import org.openbw.bwapi4j.unit.Building;
import org.openbw.bwapi4j.unit.MineralPatch;
import org.openbw.bwapi4j.unit.PlayerUnit;
import org.openbw.bwapi4j.unit.Unit;
import org.openbw.bwapi4j.unit.VespeneGeyser;

public class NeutralDataImpl
implements NeutralData {
    private final List<Mineral> minerals = new ArrayList<Mineral>();
    private final List<Geyser> geysers;
    private final List<StaticBuilding> staticBuildings;

    public NeutralDataImpl(Map map, List<MineralPatch> mineralPatches, List<VespeneGeyser> vespeneGeysers, List<PlayerUnit> neutralUnits) {
        for (MineralPatch mineralPatch : mineralPatches) {
            this.minerals.add(new Mineral(mineralPatch, map));
        }
        this.geysers = new ArrayList<Geyser>();
        for (VespeneGeyser vespeneGeyser : vespeneGeysers) {
            this.geysers.add(new Geyser(vespeneGeyser, map));
        }
        this.staticBuildings = new ArrayList<StaticBuilding>();
        for (Unit unit : neutralUnits) {
            if (!(unit instanceof Building)) continue;
            this.staticBuildings.add(new StaticBuilding(unit, map));
        }
    }

    @Override
    public List<Mineral> getMinerals() {
        return this.minerals;
    }

    @Override
    public Mineral getMineral(Unit unit) {
        for (Mineral mineral : this.getMinerals()) {
            if (!mineral.getUnit().equals(unit)) continue;
            return mineral;
        }
        return null;
    }

    @Override
    public List<Geyser> getGeysers() {
        return this.geysers;
    }

    @Override
    public Geyser getGeyser(Unit unit) {
        for (Geyser geyser : this.getGeysers()) {
            if (!geyser.getUnit().equals(unit)) continue;
            return geyser;
        }
        return null;
    }

    @Override
    public List<StaticBuilding> getStaticBuildings() {
        return this.staticBuildings;
    }
}

