/*
 * Decompiled with CFR 0.152.
 */
package bwem.tile;

import bwem.Markable;
import bwem.StaticMarkable;
import bwem.area.typedef.AreaId;
import bwem.tile.Tile;
import bwem.typedef.Altitude;
import bwem.unit.Neutral;

public class TileImpl
implements Tile {
    private static final StaticMarkable staticMarkable = new StaticMarkable();
    private final Markable markable = new Markable(staticMarkable);
    private Neutral neutral = null;
    private Altitude lowestAltitude = Altitude.ZERO;
    private AreaId areaId = AreaId.ZERO;
    private int internalData = 0;
    private Tile.GroundHeight groundHeight = Tile.GroundHeight.LOW_GROUND;
    private boolean isBuildable = false;
    private boolean isDoodad = false;

    public static StaticMarkable getStaticMarkable() {
        return staticMarkable;
    }

    public Markable getMarkable() {
        return this.markable;
    }

    @Override
    public boolean isBuildable() {
        return this.isBuildable;
    }

    @Override
    public AreaId getAreaId() {
        return this.areaId;
    }

    @Override
    public Altitude getLowestAltitude() {
        return this.lowestAltitude;
    }

    @Override
    public boolean isWalkable() {
        return this.getAreaId().intValue() != 0;
    }

    @Override
    public boolean isTerrain() {
        return this.isWalkable();
    }

    @Override
    public Tile.GroundHeight getGroundHeight() {
        return this.groundHeight;
    }

    @Override
    public boolean isDoodad() {
        return this.isDoodad;
    }

    @Override
    public Neutral getNeutral() {
        return this.neutral;
    }

    @Override
    public int getStackedNeutralCount() {
        int stackSize = 0;
        for (Neutral stackedNeutral = this.getNeutral(); stackedNeutral != null; stackedNeutral = stackedNeutral.getNextStacked()) {
            ++stackSize;
        }
        return stackSize;
    }

    public void setBuildable() {
        this.isBuildable = true;
    }

    public void setGroundHeight(int groundHeight) {
        this.groundHeight = Tile.GroundHeight.parseGroundHeight(groundHeight);
    }

    public void setDoodad() {
        this.isDoodad = true;
    }

    public void addNeutral(Neutral neutral) {
        if (this.getNeutral() != null || neutral == null) {
            throw new IllegalStateException();
        }
        this.neutral = neutral;
    }

    public void setAreaId(AreaId areaId) {
        if (areaId.intValue() != -1 && (this.getAreaId().intValue() != 0 || areaId.intValue() == 0)) {
            throw new IllegalStateException();
        }
        this.areaId = areaId;
    }

    public void resetAreaId() {
        this.areaId = AreaId.ZERO;
    }

    public void setLowestAltitude(Altitude lowestAltitude) {
        if (lowestAltitude.intValue() < 0) {
            throw new IllegalArgumentException();
        }
        this.lowestAltitude = lowestAltitude;
    }

    public void removeNeutral(Neutral neutral) {
        if (neutral == null || !this.getNeutral().equals(neutral)) {
            throw new IllegalStateException();
        }
        this.neutral = null;
    }

    public int getInternalData() {
        return this.internalData;
    }

    public void setInternalData(int internalData) {
        this.internalData = internalData;
    }
}

