/*
 * Decompiled with CFR 0.152.
 */
package bwem.tile;

import bwem.area.typedef.AreaId;
import bwem.typedef.Altitude;
import bwem.unit.Neutral;

public interface Tile {
    public boolean isBuildable();

    public AreaId getAreaId();

    public Altitude getLowestAltitude();

    public boolean isWalkable();

    public boolean isTerrain();

    public GroundHeight getGroundHeight();

    public boolean isDoodad();

    public Neutral getNeutral();

    public int getStackedNeutralCount();

    public static enum GroundHeight {
        LOW_GROUND(0),
        HIGH_GROUND(1),
        VERY_HIGH_GROUND(2);

        private final int val;

        private GroundHeight(int val) {
            this.val = val;
        }

        public int intValue() {
            return this.val;
        }

        public static GroundHeight parseGroundHeight(int height) {
            for (GroundHeight val : GroundHeight.values()) {
                if (val.intValue() != height) continue;
                return val;
            }
            throw new IllegalArgumentException("Unrecognized height: " + height);
        }
    }
}

