/*
 * Decompiled with CFR 0.152.
 */
package bwem.tile;

import bwem.area.typedef.AreaId;
import bwem.tile.MiniTile;
import bwem.typedef.Altitude;

public class MiniTileImpl
implements MiniTile {
    private static final AreaId blockingCP = new AreaId(Integer.MIN_VALUE);
    private Altitude altitude = Altitude.UNINITIALIZED;
    private AreaId areaId = AreaId.UNINITIALIZED;

    @Override
    public boolean isWalkable() {
        return this.areaId.intValue() != 0;
    }

    @Override
    public Altitude getAltitude() {
        return this.altitude;
    }

    @Override
    public boolean isSea() {
        return this.altitude.intValue() == 0;
    }

    @Override
    public boolean isLake() {
        return this.altitude.intValue() != 0 && !this.isWalkable();
    }

    @Override
    public boolean isTerrain() {
        return this.isWalkable();
    }

    @Override
    public AreaId getAreaId() {
        return this.areaId;
    }

    public void setWalkable(boolean walkable) {
        this.areaId = new AreaId(walkable ? -1 : 0);
        this.altitude = new Altitude(walkable ? -1 : 1);
    }

    public boolean isSeaOrLake() {
        return this.altitude.intValue() == 1;
    }

    public void setSea() {
        if (this.isWalkable() || !this.isSeaOrLake()) {
            throw new IllegalStateException();
        }
        this.altitude = Altitude.ZERO;
    }

    public void setLake() {
        if (this.isWalkable() || !this.isSea()) {
            throw new IllegalStateException();
        }
        this.altitude = Altitude.UNINITIALIZED;
    }

    public boolean isAltitudeMissing() {
        return this.altitude.intValue() == -1;
    }

    public void setAltitude(Altitude altitude) {
        if (!this.isAltitudeMissing() || altitude.intValue() <= 0) {
            throw new IllegalStateException();
        }
        this.altitude = altitude;
    }

    public boolean isAreaIdMissing() {
        return this.areaId.intValue() == -1;
    }

    public void setAreaId(AreaId areaId) {
        if (!this.isAreaIdMissing() || areaId.intValue() < 1) {
            throw new IllegalStateException();
        }
        this.areaId = areaId;
    }

    public void replaceAreaId(AreaId areaId) {
        if (this.areaId.intValue() <= 0) {
            throw new IllegalStateException("Failed assert: this.areaId.intValue() > 0: " + this.areaId.intValue());
        }
        if (areaId.intValue() < 1 && areaId.intValue() > -2) {
            throw new IllegalArgumentException("Failed assert: (id.intValue() >= 1) || (id.intValue() <= -2): " + areaId.intValue());
        }
        if (areaId.equals(this.areaId)) {
            throw new IllegalArgumentException("Failed assert: !id.equals (areaId): not expected: " + this.areaId.intValue() + ", actual: " + areaId.intValue());
        }
        this.areaId = areaId;
    }

    public void setBlocked() {
        if (!this.isAreaIdMissing()) {
            throw new IllegalStateException();
        }
        this.areaId = blockingCP;
    }

    public boolean isBlocked() {
        return this.areaId.equals(blockingCP);
    }

    public void replaceBlockedAreaId(AreaId areaId) {
        if (!this.areaId.equals(blockingCP) || areaId.intValue() < 1) {
            throw new IllegalStateException();
        }
        this.areaId = areaId;
    }
}

