/*
 * Decompiled with CFR 0.152.
 */
package bwem.map;

import bwem.CheckMode;
import bwem.map.MapData;
import bwem.map.TerrainDataImpl;
import bwem.map.TerrainDataInitializer;
import bwem.tile.MiniTile;
import bwem.tile.MiniTileImpl;
import bwem.tile.Tile;
import bwem.tile.TileData;
import bwem.tile.TileImpl;
import java.util.ArrayList;
import org.openbw.bwapi4j.BWMap;
import org.openbw.bwapi4j.TilePosition;
import org.openbw.bwapi4j.WalkPosition;

public class TerrainDataInitializerImpl
extends TerrainDataImpl
implements TerrainDataInitializer {
    public TerrainDataInitializerImpl(MapData mapData, TileData tileData) {
        super(mapData, tileData);
    }

    @Override
    public Tile getTile_(TilePosition tilePosition, CheckMode checkMode) {
        return this.getTile(tilePosition, checkMode);
    }

    @Override
    public Tile getTile_(TilePosition tilePosition) {
        return this.getTile_(tilePosition, CheckMode.CHECK);
    }

    @Override
    public MiniTile getMiniTile_(WalkPosition walkPosition, CheckMode checkMode) {
        return this.getMiniTile(walkPosition, checkMode);
    }

    @Override
    public MiniTile getMiniTile_(WalkPosition walkPosition) {
        return this.getMiniTile_(walkPosition, CheckMode.CHECK);
    }

    @Override
    public void markUnwalkableMiniTiles(BWMap bwMap) {
        for (int y = 0; y < this.getMapData().getWalkSize().getY(); ++y) {
            for (int x = 0; x < this.getMapData().getWalkSize().getX(); ++x) {
                if (bwMap.isWalkable(x, y)) continue;
                for (int dy = -1; dy <= 1; ++dy) {
                    for (int dx = -1; dx <= 1; ++dx) {
                        WalkPosition walkPosition = new WalkPosition(x + dx, y + dy);
                        if (!this.getMapData().isValid(walkPosition)) continue;
                        ((MiniTileImpl)this.getMiniTile_(walkPosition, CheckMode.NO_CHECK)).setWalkable(false);
                    }
                }
            }
        }
    }

    @Override
    public void markBuildableTilesAndGroundHeight(BWMap bwMap) {
        for (int y = 0; y < this.getMapData().getTileSize().getY(); ++y) {
            for (int x = 0; x < this.getMapData().getTileSize().getX(); ++x) {
                TilePosition tilePosition = new TilePosition(x, y);
                WalkPosition walkPosition = tilePosition.toWalkPosition();
                TileImpl tile = (TileImpl)this.getTile_(tilePosition);
                if (bwMap.isBuildable(tilePosition, false)) {
                    tile.setBuildable();
                    for (int dy = 0; dy < 4; ++dy) {
                        for (int dx = 0; dx < 4; ++dx) {
                            ((MiniTileImpl)this.getMiniTile_(walkPosition.add(new WalkPosition(dx, dy)), CheckMode.NO_CHECK)).setWalkable(true);
                        }
                    }
                }
                int bwapiGroundHeight = bwMap.getGroundHeight(tilePosition);
                tile.setGroundHeight(bwapiGroundHeight / 2);
                if (bwapiGroundHeight % 2 == 0) continue;
                tile.setDoodad();
            }
        }
    }

    @Override
    public void decideSeasOrLakes(int lakeMaxMiniTiles, int lakeMaxWidthInMiniTiles) {
        for (int y = 0; y < this.getMapData().getWalkSize().getY(); ++y) {
            for (int x = 0; x < this.getMapData().getWalkSize().getX(); ++x) {
                WalkPosition originWalkPosition = new WalkPosition(x, y);
                MiniTile originMiniTile = this.getMiniTile_(originWalkPosition, CheckMode.NO_CHECK);
                if (!((MiniTileImpl)originMiniTile).isSeaOrLake()) continue;
                ArrayList<WalkPosition> toSearch = new ArrayList<WalkPosition>();
                toSearch.add(originWalkPosition);
                ArrayList<MiniTile> seaExtent = new ArrayList<MiniTile>();
                ((MiniTileImpl)originMiniTile).setSea();
                seaExtent.add(originMiniTile);
                int topLeftX = originWalkPosition.getX();
                int topLeftY = originWalkPosition.getY();
                int bottomRightX = originWalkPosition.getX();
                int bottomRightY = originWalkPosition.getY();
                while (!toSearch.isEmpty()) {
                    WalkPosition[] deltas;
                    WalkPosition current = (WalkPosition)toSearch.remove(toSearch.size() - 1);
                    if (current.getX() < topLeftX) {
                        topLeftX = current.getX();
                    }
                    if (current.getY() < topLeftY) {
                        topLeftY = current.getY();
                    }
                    if (current.getX() > bottomRightX) {
                        bottomRightX = current.getX();
                    }
                    if (current.getY() > bottomRightY) {
                        bottomRightY = current.getY();
                    }
                    for (WalkPosition delta : deltas = new WalkPosition[]{new WalkPosition(0, -1), new WalkPosition(-1, 0), new WalkPosition(1, 0), new WalkPosition(0, 1)}) {
                        MiniTile nextMiniTile;
                        WalkPosition nextWalkPosition = current.add(delta);
                        if (!this.getMapData().isValid(nextWalkPosition) || !((MiniTileImpl)(nextMiniTile = this.getMiniTile_(nextWalkPosition, CheckMode.NO_CHECK))).isSeaOrLake()) continue;
                        toSearch.add(nextWalkPosition);
                        if (seaExtent.size() <= lakeMaxMiniTiles) {
                            seaExtent.add(nextMiniTile);
                        }
                        ((MiniTileImpl)nextMiniTile).setSea();
                    }
                }
                if (seaExtent.size() > lakeMaxMiniTiles || bottomRightX - topLeftX > lakeMaxWidthInMiniTiles || bottomRightY - topLeftY > lakeMaxWidthInMiniTiles || topLeftX < 2 || topLeftY < 2 || bottomRightX >= this.getMapData().getWalkSize().getX() - 2 || bottomRightY >= this.getMapData().getWalkSize().getY() - 2) continue;
                for (MiniTile miniTile : seaExtent) {
                    ((MiniTileImpl)miniTile).setLake();
                }
            }
        }
    }
}

