/*
 * Decompiled with CFR 0.152.
 */
package bwem.map;

import bwem.CheckMode;
import bwem.map.MapData;
import bwem.map.TerrainData;
import bwem.tile.MiniTile;
import bwem.tile.Tile;
import bwem.tile.TileData;
import org.openbw.bwapi4j.TilePosition;
import org.openbw.bwapi4j.WalkPosition;

public abstract class TerrainDataImpl
implements TerrainData {
    private final MapData mapData;
    private final TileData tileData;

    protected TerrainDataImpl(MapData mapData, TileData tileData) {
        this.mapData = mapData;
        this.tileData = tileData;
    }

    @Override
    public MapData getMapData() {
        return this.mapData;
    }

    @Override
    public TileData getTileData() {
        return this.tileData;
    }

    @Override
    public Tile getTile(TilePosition tilePosition, CheckMode checkMode) {
        if (checkMode != CheckMode.NO_CHECK && !this.getMapData().isValid(tilePosition)) {
            throw new IllegalArgumentException();
        }
        return this.getTileData().getTiles().get(this.getMapData().getTileSize().getX() * tilePosition.getY() + tilePosition.getX());
    }

    @Override
    public Tile getTile(TilePosition tilePosition) {
        return this.getTile(tilePosition, CheckMode.CHECK);
    }

    @Override
    public MiniTile getMiniTile(WalkPosition walkPosition, CheckMode checkMode) {
        if (checkMode != CheckMode.NO_CHECK && !this.getMapData().isValid(walkPosition)) {
            throw new IllegalArgumentException();
        }
        return this.getTileData().getMiniTiles().get(this.getMapData().getWalkSize().getX() * walkPosition.getY() + walkPosition.getX());
    }

    @Override
    public MiniTile getMiniTile(WalkPosition walkPosition) {
        return this.getMiniTile(walkPosition, CheckMode.CHECK);
    }

    @Override
    public boolean isSeaWithNonSeaNeighbors(WalkPosition walkPosition) {
        WalkPosition[] deltas;
        if (!this.getMiniTile(walkPosition).isSea()) {
            return false;
        }
        for (WalkPosition delta : deltas = new WalkPosition[]{new WalkPosition(0, -1), new WalkPosition(-1, 0), new WalkPosition(1, 0), new WalkPosition(0, 1)}) {
            WalkPosition walkPositionDelta = walkPosition.add(delta);
            if (!this.getMapData().isValid(walkPositionDelta) || this.getMiniTile(walkPositionDelta, CheckMode.NO_CHECK).isSea()) continue;
            return true;
        }
        return false;
    }
}

