/*
 * Decompiled with CFR 0.152.
 */
package bwem.map;

import bwem.CheckMode;
import bwem.area.TempAreaInfo;
import bwem.area.typedef.AreaId;
import bwem.map.MapDataImpl;
import bwem.map.MapImpl;
import bwem.map.MapInitializer;
import bwem.map.TerrainData;
import bwem.map.TerrainDataInitializer;
import bwem.map.TerrainDataInitializerImpl;
import bwem.tile.MiniTile;
import bwem.tile.MiniTileImpl;
import bwem.tile.TileDataImpl;
import bwem.tile.TileImpl;
import bwem.typedef.Altitude;
import bwem.unit.Mineral;
import bwem.unit.Neutral;
import bwem.unit.NeutralDataImpl;
import bwem.unit.NeutralImpl;
import bwem.unit.StaticBuilding;
import bwem.util.BwemExt;
import bwem.util.PairGenericAltitudeComparator;
import bwem.util.PairGenericMiniTileAltitudeComparator;
import bwem.util.Timer;
import bwem.util.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openbw.bwapi4j.BWMap;
import org.openbw.bwapi4j.MapDrawer;
import org.openbw.bwapi4j.Player;
import org.openbw.bwapi4j.TilePosition;
import org.openbw.bwapi4j.WalkPosition;
import org.openbw.bwapi4j.org.apache.commons.lang3.tuple.MutablePair;
import org.openbw.bwapi4j.unit.MineralPatch;
import org.openbw.bwapi4j.unit.PlayerUnit;
import org.openbw.bwapi4j.unit.UnitImpl;
import org.openbw.bwapi4j.unit.VespeneGeyser;

public class MapInitializerImpl
extends MapImpl
implements MapInitializer {
    private static final Logger logger = LogManager.getLogger();

    public MapInitializerImpl(BWMap bwMap, MapDrawer mapDrawer, Collection<Player> players, List<MineralPatch> mineralPatches, List<VespeneGeyser> vespeneGeysers, Collection<UnitImpl> units) {
        super(bwMap, mapDrawer, players, mineralPatches, vespeneGeysers, units);
    }

    private native void initialize_native();

    @Override
    public void initialize(boolean enableTimer) {
        Timer overallTimer = new Timer();
        Timer timer = new Timer();
        this.initializeTerrainData(this.getBWMap().mapWidth(), this.getBWMap().mapHeight(), this.getBWMap().getStartPositions());
        if (enableTimer) {
            logger.info("Map::initialize-resize: " + timer.elapsedMilliseconds() + " ms");
            timer.reset();
        }
        ((TerrainDataInitializer)((Object)this.getData())).markUnwalkableMiniTiles(this.getBWMap());
        ((TerrainDataInitializer)((Object)this.getData())).markBuildableTilesAndGroundHeight(this.getBWMap());
        if (enableTimer) {
            logger.info("Map::LoadData: " + timer.elapsedMilliseconds() + " ms");
            timer.reset();
        }
        ((TerrainDataInitializer)((Object)this.getData())).decideSeasOrLakes(300, 32);
        if (enableTimer) {
            logger.info("Map::DecideSeasOrLakes: " + timer.elapsedMilliseconds() + " ms");
            timer.reset();
        }
        this.initializeNeutralData(this.mineralPatches, this.vespeneGeysers, this.filterNeutralPlayerUnits(this.units, this.players));
        if (enableTimer) {
            logger.info("Map::InitializeNeutrals: " + timer.elapsedMilliseconds() + " ms");
            timer.reset();
        }
        this.computeAltitude(this.getData());
        if (enableTimer) {
            logger.info("Map::ComputeAltitude: " + timer.elapsedMilliseconds() + " ms");
            timer.reset();
        }
        this.processBlockingNeutrals(this.getCandidates(this.getNeutralData().getStaticBuildings(), this.getNeutralData().getMinerals()));
        if (enableTimer) {
            logger.info("Map::processBlockingNeutrals: " + timer.elapsedMilliseconds() + " ms");
            timer.reset();
        }
        this.computeAreas(this.computeTempAreas(this.getSortedMiniTilesByDescendingAltitude()), 64);
        if (enableTimer) {
            logger.info("Map::computeAreas: " + timer.elapsedMilliseconds() + " ms");
            timer.reset();
        }
        this.getGraph().createChokePoints(this.getNeutralData().getStaticBuildings(), this.getNeutralData().getMinerals(), this.getRawFrontier());
        if (enableTimer) {
            logger.info("Map::createChokePoints: " + timer.elapsedMilliseconds() + " ms");
            timer.reset();
        }
        this.getGraph().computeChokePointDistanceMatrix();
        if (enableTimer) {
            logger.info("Map::computeChokePointDistanceMatrix: " + timer.elapsedMilliseconds() + " ms");
            timer.reset();
        }
        this.getGraph().collectInformation();
        if (enableTimer) {
            logger.info("Map::collectInformation: " + timer.elapsedMilliseconds() + " ms");
            timer.reset();
        }
        this.getGraph().createBases(this.getData());
        if (enableTimer) {
            logger.info("Map::createBases: " + timer.elapsedMilliseconds() + " ms");
            timer.reset();
        }
        if (enableTimer) {
            logger.info("Map::initialize Total: " + overallTimer.elapsedMilliseconds() + " ms");
            timer.reset();
        }
    }

    @Override
    public void initializeTerrainData(int mapTileWidth, int mapTileHeight, List<TilePosition> startingLocations) {
        MapDataImpl mapData = new MapDataImpl(mapTileWidth, mapTileHeight, startingLocations);
        TileDataImpl tileData = new TileDataImpl(mapData.getTileSize().getX() * mapData.getTileSize().getY(), mapData.getWalkSize().getX() * mapData.getWalkSize().getY());
        this.terrainData = new TerrainDataInitializerImpl(mapData, tileData);
    }

    @Override
    public void initializeNeutralData(List<MineralPatch> mineralPatches, List<VespeneGeyser> vespeneGeysers, List<PlayerUnit> neutralUnits) {
        this.neutralData = new NeutralDataImpl(this, mineralPatches, vespeneGeysers, neutralUnits);
    }

    @Override
    public void computeAltitude(TerrainData terrainData) {
        int altitudeScale = 8;
        List<MutablePair<WalkPosition, Altitude>> deltasByAscendingAltitude = this.getSortedDeltasByAscendingAltitude(terrainData.getMapData().getWalkSize().getX(), terrainData.getMapData().getWalkSize().getY(), 8);
        List<MutablePair<WalkPosition, Altitude>> activeSeaSides = this.getActiveSeaSideList(terrainData);
        this.setHighestAltitude(this.setAltitudesAndGetUpdatedHighestAltitude(this.getHighestAltitude(), terrainData, deltasByAscendingAltitude, activeSeaSides, 8));
    }

    @Override
    public List<MutablePair<WalkPosition, Altitude>> getSortedDeltasByAscendingAltitude(int mapWalkTileWidth, int mapWalkTileHeight, int altitudeScale) {
        int range = Math.max(mapWalkTileWidth, mapWalkTileHeight) / 2 + 3;
        ArrayList<MutablePair<WalkPosition, Altitude>> deltasByAscendingAltitude = new ArrayList<MutablePair<WalkPosition, Altitude>>();
        for (int dy = 0; dy <= range; ++dy) {
            for (int dx = dy; dx <= range; ++dx) {
                if (dx == 0 && dy == 0) continue;
                deltasByAscendingAltitude.add(new MutablePair<WalkPosition, Altitude>(new WalkPosition(dx, dy), new Altitude((int)Math.round(Utils.norm(dx, dy) * (double)altitudeScale))));
            }
        }
        deltasByAscendingAltitude.sort(new PairGenericAltitudeComparator());
        return deltasByAscendingAltitude;
    }

    @Override
    public List<MutablePair<WalkPosition, Altitude>> getActiveSeaSideList(TerrainData terrainData) {
        ArrayList<MutablePair<WalkPosition, Altitude>> activeSeaSideList = new ArrayList<MutablePair<WalkPosition, Altitude>>();
        for (int y = -1; y <= terrainData.getMapData().getWalkSize().getY(); ++y) {
            for (int x = -1; x <= terrainData.getMapData().getWalkSize().getX(); ++x) {
                WalkPosition walkPosition = new WalkPosition(x, y);
                if (terrainData.getMapData().isValid(walkPosition) && !terrainData.isSeaWithNonSeaNeighbors(walkPosition)) continue;
                activeSeaSideList.add(new MutablePair<WalkPosition, Altitude>(walkPosition, Altitude.ZERO));
            }
        }
        return activeSeaSideList;
    }

    @Override
    public Altitude setAltitudesAndGetUpdatedHighestAltitude(Altitude currentHighestAltitude, TerrainData terrainData, List<MutablePair<WalkPosition, Altitude>> deltasByAscendingAltitude, List<MutablePair<WalkPosition, Altitude>> activeSeaSideList, int altitudeScale) {
        Altitude updatedHighestAltitude = currentHighestAltitude;
        for (MutablePair<WalkPosition, Altitude> deltaAltitude : deltasByAscendingAltitude) {
            WalkPosition d = deltaAltitude.getLeft();
            Altitude altitude = deltaAltitude.getRight();
            for (int i = 0; i < activeSeaSideList.size(); ++i) {
                WalkPosition[] deltas;
                MutablePair<WalkPosition, Altitude> current = activeSeaSideList.get(i);
                if (altitude.intValue() - current.getRight().intValue() >= 2 * altitudeScale) {
                    Utils.fastErase(activeSeaSideList, i--);
                    continue;
                }
                for (WalkPosition delta : deltas = new WalkPosition[]{new WalkPosition(d.getX(), d.getY()), new WalkPosition(-d.getX(), d.getY()), new WalkPosition(d.getX(), -d.getY()), new WalkPosition(-d.getX(), -d.getY()), new WalkPosition(d.getY(), d.getX()), new WalkPosition(-d.getY(), d.getX()), new WalkPosition(d.getY(), -d.getX()), new WalkPosition(-d.getY(), -d.getX())}) {
                    MiniTile miniTile;
                    WalkPosition w = current.getLeft().add(delta);
                    if (!terrainData.getMapData().isValid(w) || !((MiniTileImpl)(miniTile = ((TerrainDataInitializer)((Object)terrainData)).getMiniTile_(w, CheckMode.NO_CHECK))).isAltitudeMissing()) continue;
                    if (updatedHighestAltitude != null && updatedHighestAltitude.intValue() > altitude.intValue()) {
                        throw new IllegalStateException();
                    }
                    updatedHighestAltitude = altitude;
                    current.setRight(altitude);
                    ((MiniTileImpl)miniTile).setAltitude(altitude);
                }
            }
        }
        return updatedHighestAltitude;
    }

    @Override
    public void setHighestAltitude(Altitude altitude) {
        this.highestAltitude = altitude;
    }

    @Override
    public void processBlockingNeutrals(List<Neutral> candidates) {
        for (Neutral pCandidate : candidates) {
            if (pCandidate.getNextStacked() != null) continue;
            List<WalkPosition> border = this.trimOuterMiniTileBorder(this.getOuterMiniTileBorderOfNeutral(pCandidate));
            List<WalkPosition> doors = this.getDoors(border);
            List<WalkPosition> trueDoors = this.getTrueDoors(doors, pCandidate);
            this.markBlockingStackedNeutrals(pCandidate, trueDoors);
        }
    }

    @Override
    public List<Neutral> getCandidates(List<StaticBuilding> staticBuildings, List<Mineral> minerals) {
        ArrayList<Neutral> candidates = new ArrayList<Neutral>();
        candidates.addAll(staticBuildings);
        candidates.addAll(minerals);
        return candidates;
    }

    @Override
    public List<WalkPosition> getOuterMiniTileBorderOfNeutral(Neutral pCandidate) {
        return BwemExt.outerMiniTileBorder(pCandidate.getTopLeft(), pCandidate.getSize());
    }

    @Override
    public List<WalkPosition> trimOuterMiniTileBorder(List<WalkPosition> border) {
        border.removeIf(w -> !this.getData().getMapData().isValid((WalkPosition)w) || !this.getData().getMiniTile((WalkPosition)w, CheckMode.NO_CHECK).isWalkable() || this.getData().getTile(w.toTilePosition(), CheckMode.NO_CHECK).getNeutral() != null);
        return border;
    }

    @Override
    public List<WalkPosition> getDoors(List<WalkPosition> border) {
        ArrayList<WalkPosition> doors = new ArrayList<WalkPosition>();
        while (!border.isEmpty()) {
            WalkPosition door = border.remove(border.size() - 1);
            doors.add(door);
            ArrayList<WalkPosition> toVisit = new ArrayList<WalkPosition>();
            toVisit.add(door);
            ArrayList<WalkPosition> visited = new ArrayList<WalkPosition>();
            visited.add(door);
            while (!toVisit.isEmpty()) {
                WalkPosition[] deltas;
                WalkPosition current = (WalkPosition)toVisit.remove(toVisit.size() - 1);
                for (WalkPosition delta : deltas = new WalkPosition[]{new WalkPosition(0, -1), new WalkPosition(-1, 0), new WalkPosition(1, 0), new WalkPosition(0, 1)}) {
                    WalkPosition next = current.add(delta);
                    if (!this.getData().getMapData().isValid(next) || visited.contains(next) || !this.getData().getMiniTile(next, CheckMode.NO_CHECK).isWalkable() || this.getData().getTile(next.toPosition().toTilePosition(), CheckMode.NO_CHECK).getNeutral() != null || !BwemExt.adjoins8SomeLakeOrNeutral(next, this)) continue;
                    toVisit.add(next);
                    visited.add(next);
                }
            }
            border.removeIf(visited::contains);
        }
        return doors;
    }

    @Override
    public List<WalkPosition> getTrueDoors(List<WalkPosition> doors, Neutral pCandidate) {
        ArrayList<WalkPosition> trueDoors = new ArrayList<WalkPosition>();
        if (doors.size() >= 2) {
            for (WalkPosition door : doors) {
                int limit;
                ArrayList<WalkPosition> toVisit = new ArrayList<WalkPosition>();
                toVisit.add(door);
                ArrayList<WalkPosition> visited = new ArrayList<WalkPosition>();
                visited.add(door);
                int n = limit = pCandidate instanceof StaticBuilding ? 10 : 400;
                while (!toVisit.isEmpty() && visited.size() < limit) {
                    WalkPosition[] deltas;
                    WalkPosition current = (WalkPosition)toVisit.remove(toVisit.size() - 1);
                    for (WalkPosition delta : deltas = new WalkPosition[]{new WalkPosition(0, -1), new WalkPosition(-1, 0), new WalkPosition(1, 0), new WalkPosition(0, 1)}) {
                        WalkPosition next = current.add(delta);
                        if (!this.getData().getMapData().isValid(next) || visited.contains(next) || !this.getData().getMiniTile(next, CheckMode.NO_CHECK).isWalkable() || this.getData().getTile(next.toTilePosition(), CheckMode.NO_CHECK).getNeutral() != null) continue;
                        toVisit.add(next);
                        visited.add(next);
                    }
                }
                if (visited.size() < limit) continue;
                trueDoors.add(door);
            }
        }
        return trueDoors;
    }

    @Override
    public void markBlockingStackedNeutrals(Neutral pCandidate, List<WalkPosition> trueDoors) {
        if (trueDoors.size() >= 2) {
            for (Neutral pNeutral = this.getData().getTile(pCandidate.getTopLeft()).getNeutral(); pNeutral != null; pNeutral = pNeutral.getNextStacked()) {
                ((NeutralImpl)pNeutral).setBlocking(trueDoors);
            }
            WalkPosition pCandidateW = pCandidate.getSize().toWalkPosition();
            for (int dy = 0; dy < pCandidateW.getY(); ++dy) {
                for (int dx = 0; dx < pCandidateW.getX(); ++dx) {
                    MiniTile miniTile = ((TerrainDataInitializer)((Object)this.getData())).getMiniTile_(pCandidate.getTopLeft().toPosition().toWalkPosition().add(new WalkPosition(dx, dy)));
                    if (!miniTile.isWalkable()) continue;
                    ((MiniTileImpl)miniTile).setBlocked();
                }
            }
        }
    }

    @Override
    public void computeAreas(List<TempAreaInfo> tempAreaList, int areaMinMiniTiles) {
        this.createAreas(tempAreaList, areaMinMiniTiles);
        this.setAreaIdAndLowestAltitudeInTiles();
    }

    @Override
    public List<MutablePair<WalkPosition, MiniTile>> getSortedMiniTilesByDescendingAltitude() {
        ArrayList<MutablePair<WalkPosition, MiniTile>> miniTilesByDescendingAltitude = new ArrayList<MutablePair<WalkPosition, MiniTile>>();
        for (int y = 0; y < this.getData().getMapData().getWalkSize().getY(); ++y) {
            for (int x = 0; x < this.getData().getMapData().getWalkSize().getX(); ++x) {
                WalkPosition w = new WalkPosition(x, y);
                MiniTile miniTile = ((TerrainDataInitializer)((Object)this.getData())).getMiniTile_(w, CheckMode.NO_CHECK);
                if (!((MiniTileImpl)miniTile).isAreaIdMissing()) continue;
                miniTilesByDescendingAltitude.add(new MutablePair<WalkPosition, MiniTile>(w, miniTile));
            }
        }
        miniTilesByDescendingAltitude.sort(new PairGenericMiniTileAltitudeComparator());
        Collections.reverse(miniTilesByDescendingAltitude);
        return miniTilesByDescendingAltitude;
    }

    @Override
    public List<TempAreaInfo> computeTempAreas(List<MutablePair<WalkPosition, MiniTile>> miniTilesByDescendingAltitude) {
        ArrayList<TempAreaInfo> tempAreaList = new ArrayList<TempAreaInfo>();
        tempAreaList.add(new TempAreaInfo());
        for (MutablePair<WalkPosition, MiniTile> current : miniTilesByDescendingAltitude) {
            WalkPosition pos = new WalkPosition(current.getLeft().getX(), current.getLeft().getY());
            MiniTile cur = current.getRight();
            MutablePair<AreaId, AreaId> neighboringAreas = this.findNeighboringAreas(pos);
            if (neighboringAreas.getLeft() == null) {
                tempAreaList.add(new TempAreaInfo(new AreaId(tempAreaList.size()), cur, pos));
                continue;
            }
            if (neighboringAreas.getRight() == null) {
                ((TempAreaInfo)tempAreaList.get(neighboringAreas.getLeft().intValue())).add(cur);
                continue;
            }
            AreaId smaller = neighboringAreas.getLeft();
            AreaId bigger = neighboringAreas.getRight();
            if (((TempAreaInfo)tempAreaList.get(smaller.intValue())).getSize() > ((TempAreaInfo)tempAreaList.get(bigger.intValue())).getSize()) {
                AreaId smallerTmp = smaller;
                smaller = bigger;
                bigger = smallerTmp;
            }
            boolean cppAlgorithmStdAnyOf = this.getData().getMapData().getStartingLocations().stream().anyMatch(startingLoc -> BwemExt.dist(pos.toTilePosition(), startingLoc.add(new TilePosition(2, 1))) <= 3.0);
            int curAltitude = cur.getAltitude().intValue();
            int biggerHighestAltitude = ((TempAreaInfo)tempAreaList.get(bigger.intValue())).getHighestAltitude().intValue();
            int smallerHighestAltitude = ((TempAreaInfo)tempAreaList.get(smaller.intValue())).getHighestAltitude().intValue();
            if (((TempAreaInfo)tempAreaList.get(smaller.intValue())).getSize() < 80 || smallerHighestAltitude < 80 || (double)curAltitude / (double)biggerHighestAltitude >= 0.9 || (double)curAltitude / (double)smallerHighestAltitude >= 0.9 || cppAlgorithmStdAnyOf) {
                ((TempAreaInfo)tempAreaList.get(bigger.intValue())).add(cur);
                this.replaceAreaIds(((TempAreaInfo)tempAreaList.get(smaller.intValue())).getWalkPositionWithHighestAltitude(), bigger);
                ((TempAreaInfo)tempAreaList.get(bigger.intValue())).merge((TempAreaInfo)tempAreaList.get(smaller.intValue()));
                continue;
            }
            ((TempAreaInfo)tempAreaList.get(this.chooseNeighboringArea(smaller, bigger).intValue())).add(cur);
            this.rawFrontier.add(new MutablePair<MutablePair<AreaId, AreaId>, WalkPosition>(neighboringAreas, pos));
        }
        this.rawFrontier.removeIf(f -> ((AreaId)((MutablePair)f.getLeft()).getLeft()).equals(((MutablePair)f.getLeft()).getRight()));
        return tempAreaList;
    }

    @Override
    public void replaceAreaIds(WalkPosition p, AreaId newAreaId) {
        MiniTile origin = ((TerrainDataInitializer)((Object)this.getData())).getMiniTile_(p, CheckMode.NO_CHECK);
        AreaId oldAreaId = origin.getAreaId();
        ((MiniTileImpl)origin).replaceAreaId(newAreaId);
        ArrayList<WalkPosition> toSearch = new ArrayList<WalkPosition>();
        toSearch.add(p);
        while (!toSearch.isEmpty()) {
            WalkPosition[] deltas;
            WalkPosition current = (WalkPosition)toSearch.remove(toSearch.size() - 1);
            for (WalkPosition delta : deltas = new WalkPosition[]{new WalkPosition(0, -1), new WalkPosition(-1, 0), new WalkPosition(1, 0), new WalkPosition(0, 1)}) {
                MiniTile miniTile;
                WalkPosition next = current.add(delta);
                if (!this.getData().getMapData().isValid(next) || !(miniTile = ((TerrainDataInitializer)((Object)this.getData())).getMiniTile_(next, CheckMode.NO_CHECK)).getAreaId().equals(oldAreaId)) continue;
                toSearch.add(next);
                ((MiniTileImpl)miniTile).replaceAreaId(newAreaId);
            }
        }
        if (newAreaId.intValue() > 0) {
            for (MutablePair<MutablePair<AreaId, AreaId>, WalkPosition> f : this.rawFrontier) {
                if (f.getLeft().getLeft().equals(oldAreaId)) {
                    f.getLeft().setLeft(newAreaId);
                }
                if (!f.getLeft().getRight().equals(oldAreaId)) continue;
                f.getLeft().setRight(newAreaId);
            }
        }
    }

    @Override
    public void createAreas(List<TempAreaInfo> tempAreaList, int areaMinMiniTiles) {
        ArrayList<MutablePair<WalkPosition, Integer>> areasList = new ArrayList<MutablePair<WalkPosition, Integer>>();
        int newAreaId = 1;
        int newTinyAreaId = -2;
        for (TempAreaInfo tempArea : tempAreaList) {
            if (!tempArea.isValid()) continue;
            if (tempArea.getSize() >= areaMinMiniTiles) {
                if (newAreaId > tempArea.getId().intValue()) {
                    throw new IllegalStateException();
                }
                if (newAreaId != tempArea.getId().intValue()) {
                    this.replaceAreaIds(tempArea.getWalkPositionWithHighestAltitude(), new AreaId(newAreaId));
                }
                areasList.add(new MutablePair<WalkPosition, Integer>(tempArea.getWalkPositionWithHighestAltitude(), tempArea.getSize()));
                ++newAreaId;
                continue;
            }
            this.replaceAreaIds(tempArea.getWalkPositionWithHighestAltitude(), new AreaId(newTinyAreaId));
            --newTinyAreaId;
        }
        this.getGraph().createAreas(areasList);
    }

    @Override
    public void setLowestAltitudeInTile(TilePosition t) {
        Altitude lowestAltitude = new Altitude(Integer.MAX_VALUE);
        for (int dy = 0; dy < 4; ++dy) {
            for (int dx = 0; dx < 4; ++dx) {
                Altitude altitude = this.getData().getMiniTile(t.toPosition().toWalkPosition().add(new WalkPosition(dx, dy)), CheckMode.NO_CHECK).getAltitude();
                if (altitude.intValue() >= lowestAltitude.intValue()) continue;
                lowestAltitude = altitude;
            }
        }
        ((TileImpl)((TerrainDataInitializer)((Object)this.getData())).getTile_(t)).setLowestAltitude(lowestAltitude);
    }

    private void setAreaIdAndLowestAltitudeInTiles() {
        for (int y = 0; y < this.getData().getMapData().getTileSize().getY(); ++y) {
            for (int x = 0; x < this.getData().getMapData().getTileSize().getX(); ++x) {
                TilePosition t = new TilePosition(x, y);
                this.setAreaIdInTile(t);
                this.setLowestAltitudeInTile(t);
            }
        }
    }

    @Override
    public List<PlayerUnit> filterPlayerUnits(Collection<UnitImpl> units, Player player) {
        return super.filterPlayerUnits(units, player);
    }

    @Override
    public List<PlayerUnit> filterNeutralPlayerUnits(Collection<UnitImpl> units, Collection<Player> players) {
        return super.filterNeutralPlayerUnits(units, players);
    }
}

