/*
 * Decompiled with CFR 0.152.
 */
package bwem.map;

import bwem.area.TempAreaInfo;
import bwem.area.typedef.AreaId;
import bwem.map.TerrainData;
import bwem.tile.MiniTile;
import bwem.typedef.Altitude;
import bwem.unit.Mineral;
import bwem.unit.Neutral;
import bwem.unit.StaticBuilding;
import java.util.Collection;
import java.util.List;
import org.openbw.bwapi4j.Player;
import org.openbw.bwapi4j.TilePosition;
import org.openbw.bwapi4j.WalkPosition;
import org.openbw.bwapi4j.org.apache.commons.lang3.tuple.MutablePair;
import org.openbw.bwapi4j.unit.MineralPatch;
import org.openbw.bwapi4j.unit.PlayerUnit;
import org.openbw.bwapi4j.unit.UnitImpl;
import org.openbw.bwapi4j.unit.VespeneGeyser;

public interface MapInitializer {
    public void initialize(boolean var1);

    public void initializeTerrainData(int var1, int var2, List<TilePosition> var3);

    public void initializeNeutralData(List<MineralPatch> var1, List<VespeneGeyser> var2, List<PlayerUnit> var3);

    public void computeAltitude(TerrainData var1);

    public List<MutablePair<WalkPosition, Altitude>> getSortedDeltasByAscendingAltitude(int var1, int var2, int var3);

    public List<MutablePair<WalkPosition, Altitude>> getActiveSeaSideList(TerrainData var1);

    public Altitude setAltitudesAndGetUpdatedHighestAltitude(Altitude var1, TerrainData var2, List<MutablePair<WalkPosition, Altitude>> var3, List<MutablePair<WalkPosition, Altitude>> var4, int var5);

    public void setHighestAltitude(Altitude var1);

    public void processBlockingNeutrals(List<Neutral> var1);

    public List<Neutral> getCandidates(List<StaticBuilding> var1, List<Mineral> var2);

    public List<WalkPosition> getOuterMiniTileBorderOfNeutral(Neutral var1);

    public List<WalkPosition> trimOuterMiniTileBorder(List<WalkPosition> var1);

    public List<WalkPosition> getDoors(List<WalkPosition> var1);

    public List<WalkPosition> getTrueDoors(List<WalkPosition> var1, Neutral var2);

    public void markBlockingStackedNeutrals(Neutral var1, List<WalkPosition> var2);

    public void computeAreas(List<TempAreaInfo> var1, int var2);

    public List<MutablePair<WalkPosition, MiniTile>> getSortedMiniTilesByDescendingAltitude();

    public List<TempAreaInfo> computeTempAreas(List<MutablePair<WalkPosition, MiniTile>> var1);

    public void replaceAreaIds(WalkPosition var1, AreaId var2);

    public void createAreas(List<TempAreaInfo> var1, int var2);

    public void setLowestAltitudeInTile(TilePosition var1);

    public List<PlayerUnit> filterPlayerUnits(Collection<UnitImpl> var1, Player var2);

    public List<PlayerUnit> filterNeutralPlayerUnits(Collection<UnitImpl> var1, Collection<Player> var2);
}

