/*
 * Decompiled with CFR 0.152.
 */
package bwem.map;

import bwem.Base;
import bwem.BaseImpl;
import bwem.CheckMode;
import bwem.ChokePoint;
import bwem.ChokePointImpl;
import bwem.Graph;
import bwem.MapPrinter;
import bwem.area.Area;
import bwem.area.AreaImpl;
import bwem.area.typedef.AreaId;
import bwem.map.Map;
import bwem.map.TerrainData;
import bwem.map.TerrainDataInitializer;
import bwem.tile.MiniTile;
import bwem.tile.MiniTileImpl;
import bwem.tile.Tile;
import bwem.tile.TileImpl;
import bwem.typedef.Altitude;
import bwem.typedef.CPPath;
import bwem.typedef.Pred;
import bwem.unit.Mineral;
import bwem.unit.Neutral;
import bwem.unit.NeutralData;
import bwem.unit.StaticBuilding;
import bwem.util.BwemExt;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.openbw.bwapi4j.BWMap;
import org.openbw.bwapi4j.MapDrawer;
import org.openbw.bwapi4j.Player;
import org.openbw.bwapi4j.Position;
import org.openbw.bwapi4j.TilePosition;
import org.openbw.bwapi4j.WalkPosition;
import org.openbw.bwapi4j.org.apache.commons.lang3.mutable.MutableBoolean;
import org.openbw.bwapi4j.org.apache.commons.lang3.mutable.MutableInt;
import org.openbw.bwapi4j.org.apache.commons.lang3.tuple.MutablePair;
import org.openbw.bwapi4j.type.Color;
import org.openbw.bwapi4j.unit.MineralPatch;
import org.openbw.bwapi4j.unit.PlayerUnit;
import org.openbw.bwapi4j.unit.Unit;
import org.openbw.bwapi4j.unit.UnitImpl;
import org.openbw.bwapi4j.unit.VespeneGeyser;

public abstract class MapImpl
implements Map {
    private final MapPrinter mapPrinter;
    protected TerrainData terrainData = null;
    protected NeutralData neutralData = null;
    protected Altitude highestAltitude;
    private final MutableBoolean automaticPathUpdate = new MutableBoolean(false);
    private final Graph graph;
    protected final List<MutablePair<MutablePair<AreaId, AreaId>, WalkPosition>> rawFrontier = new ArrayList<MutablePair<MutablePair<AreaId, AreaId>, WalkPosition>>();
    private final BWMap bwMap;
    private final MapDrawer mapDrawer;
    protected final List<MineralPatch> mineralPatches;
    protected final Collection<Player> players;
    protected final List<VespeneGeyser> vespeneGeysers;
    protected final Collection<UnitImpl> units;
    private final NeighboringAreaChooser neighboringAreaChooser;

    public MapImpl(BWMap bwMap, MapDrawer mapDrawer, Collection<Player> players, List<MineralPatch> mineralPatches, List<VespeneGeyser> vespeneGeysers, Collection<UnitImpl> units) {
        this.mapPrinter = new MapPrinter();
        this.mapDrawer = mapDrawer;
        this.bwMap = bwMap;
        this.players = players;
        this.mineralPatches = mineralPatches;
        this.vespeneGeysers = vespeneGeysers;
        this.units = units;
        this.graph = new Graph(this);
        this.neighboringAreaChooser = new NeighboringAreaChooser();
    }

    protected BWMap getBWMap() {
        return this.bwMap;
    }

    @Override
    public TerrainData getData() {
        return this.terrainData;
    }

    @Override
    public MapPrinter getMapPrinter() {
        return this.mapPrinter;
    }

    @Override
    public boolean isInitialized() {
        return this.terrainData != null;
    }

    public Graph getGraph() {
        return this.graph;
    }

    @Override
    public List<MutablePair<MutablePair<AreaId, AreaId>, WalkPosition>> getRawFrontier() {
        return this.rawFrontier;
    }

    @Override
    public boolean automaticPathUpdate() {
        return this.automaticPathUpdate.booleanValue();
    }

    @Override
    public void enableAutomaticPathAnalysis() {
        this.automaticPathUpdate.setTrue();
    }

    @Override
    public void assignStartingLocationsToSuitableBases() {
        boolean atLeastOneFailed = false;
        for (TilePosition startingLocation : this.getData().getMapData().getStartingLocations()) {
            boolean isAssigned = false;
            for (Base base : this.getBases()) {
                if (BwemExt.queenWiseDist(base.getLocation(), startingLocation) > 3) continue;
                ((BaseImpl)base).assignStartingLocation(startingLocation);
                isAssigned = true;
            }
            if (atLeastOneFailed || isAssigned) continue;
            atLeastOneFailed = true;
        }
        if (atLeastOneFailed) {
            throw new IllegalStateException("At least one starting location was not assigned to a base.");
        }
    }

    @Override
    public List<TilePosition> getUnassignedStartingLocations() {
        ArrayList<TilePosition> remainingStartingLocations = new ArrayList<TilePosition>(this.getData().getMapData().getStartingLocations());
        for (Base base : this.getBases()) {
            if (remainingStartingLocations.isEmpty()) break;
            if (!base.isStartingLocation() || !base.getLocation().equals(remainingStartingLocations.get(0))) continue;
            remainingStartingLocations.remove(0);
        }
        return remainingStartingLocations;
    }

    @Override
    public Altitude getHighestAltitude() {
        return this.highestAltitude;
    }

    @Override
    public List<Base> getBases() {
        return this.getGraph().getBases();
    }

    @Override
    public List<ChokePoint> getChokePoints() {
        return this.getGraph().getChokePoints();
    }

    @Override
    public NeutralData getNeutralData() {
        return this.neutralData;
    }

    @Override
    public void onUnitDestroyed(Unit u) {
        if (u instanceof MineralPatch) {
            this.onMineralDestroyed(u);
        } else {
            try {
                this.onStaticBuildingDestroyed(u);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void onMineralDestroyed(Unit u) {
        for (int i = 0; i < this.getNeutralData().getMinerals().size(); ++i) {
            Mineral mineral = this.getNeutralData().getMinerals().get(i);
            if (!mineral.getUnit().equals(u)) continue;
            this.onMineralDestroyed(mineral);
            mineral.simulateCPPObjectDestructor();
            this.getNeutralData().getMinerals().remove(i);
            return;
        }
        throw new IllegalArgumentException("unit is not a Mineral");
    }

    private void onMineralDestroyed(Mineral pMineral) {
        for (Area area : this.getGraph().getAreas()) {
            ((AreaImpl)area).onMineralDestroyed(pMineral);
        }
    }

    @Override
    public void onStaticBuildingDestroyed(Unit u) {
        for (int i = 0; i < this.getNeutralData().getStaticBuildings().size(); ++i) {
            StaticBuilding building = this.getNeutralData().getStaticBuildings().get(i);
            if (!building.getUnit().equals(u)) continue;
            building.simulateCPPObjectDestructor();
            this.getNeutralData().getStaticBuildings().remove(i);
            return;
        }
        throw new IllegalArgumentException("unit is not a StaticBuilding");
    }

    public void onBlockingNeutralDestroyed(Neutral pBlocking) {
        int dy;
        if (pBlocking == null || !pBlocking.isBlocking()) {
            throw new IllegalArgumentException();
        }
        for (Area pArea : pBlocking.getBlockedAreas()) {
            for (ChokePoint cp : pArea.getChokePoints()) {
                ((ChokePointImpl)cp).onBlockingNeutralDestroyed(pBlocking);
            }
        }
        if (this.getData().getTile(pBlocking.getTopLeft()).getNeutral() != null) {
            return;
        }
        AreaId newId = pBlocking.getBlockedAreas().iterator().next().getId();
        WalkPosition pBlockingW = pBlocking.getSize().toWalkPosition();
        for (dy = 0; dy < pBlockingW.getY(); ++dy) {
            for (int dx = 0; dx < pBlockingW.getX(); ++dx) {
                MiniTile miniTile = ((TerrainDataInitializer)((Object)this.getData())).getMiniTile_(pBlocking.getTopLeft().toWalkPosition().add(new WalkPosition(dx, dy)));
                if (!miniTile.isWalkable()) continue;
                ((MiniTileImpl)miniTile).replaceBlockedAreaId(newId);
            }
        }
        for (dy = 0; dy < pBlocking.getSize().getY(); ++dy) {
            for (int dx = 0; dx < pBlocking.getSize().getX(); ++dx) {
                ((TileImpl)((TerrainDataInitializer)((Object)this.getData())).getTile_(pBlocking.getTopLeft().add(new TilePosition(dx, dy)))).resetAreaId();
                this.setAreaIdInTile(pBlocking.getTopLeft().add(new TilePosition(dx, dy)));
            }
        }
        if (this.automaticPathUpdate()) {
            this.getGraph().computeChokePointDistanceMatrix();
        }
    }

    @Override
    public List<Area> getAreas() {
        return this.getGraph().getAreas();
    }

    @Override
    public Area getArea(AreaId id) {
        return this.graph.getArea(id);
    }

    @Override
    public Area getArea(WalkPosition w) {
        return this.graph.getArea(w);
    }

    @Override
    public Area getArea(TilePosition t) {
        return this.graph.getArea(t);
    }

    @Override
    public Area getNearestArea(WalkPosition w) {
        return this.graph.getNearestArea(w);
    }

    @Override
    public Area getNearestArea(TilePosition t) {
        return this.graph.getNearestArea(t);
    }

    @Override
    public Area getMainArea(TilePosition topLeft, TilePosition size) {
        ArrayList<Area> areas = new ArrayList<Area>();
        for (int dy = 0; dy < size.getY(); ++dy) {
            for (int dx = 0; dx < size.getX(); ++dx) {
                Area area = this.getArea(topLeft.add(new TilePosition(dx, dy)));
                if (area == null || areas.contains(area)) continue;
                areas.add(area);
            }
        }
        return areas.isEmpty() ? null : (Area)areas.get(areas.size() - 1);
    }

    @Override
    public CPPath getPath(Position a, Position b, MutableInt pLength) {
        return this.graph.getPath(a, b, pLength);
    }

    @Override
    public CPPath getPath(Position a, Position b) {
        return this.getPath(a, b, null);
    }

    @Override
    public TilePosition breadthFirstSearch(TilePosition start, Pred findCond, Pred visitCond, boolean connect8) {
        TilePosition[] directions;
        if (findCond.isTrue(this.getData().getTile(start), start, this)) {
            return start;
        }
        TreeSet<TilePosition> visited = new TreeSet<TilePosition>((a, b) -> {
            int result = Integer.compare(a.getX(), b.getX());
            if (result != 0) {
                return result;
            }
            return Integer.compare(a.getY(), b.getY());
        });
        ArrayDeque<TilePosition> toVisit = new ArrayDeque<TilePosition>();
        toVisit.add(start);
        visited.add(start);
        TilePosition[] dir8 = new TilePosition[]{new TilePosition(-1, -1), new TilePosition(0, -1), new TilePosition(1, -1), new TilePosition(-1, 0), new TilePosition(1, 0), new TilePosition(-1, 1), new TilePosition(0, 1), new TilePosition(1, 1)};
        TilePosition[] dir4 = new TilePosition[]{new TilePosition(0, -1), new TilePosition(-1, 0), new TilePosition(1, 0), new TilePosition(0, 1)};
        TilePosition[] tilePositionArray = directions = connect8 ? dir8 : dir4;
        while (!toVisit.isEmpty()) {
            TilePosition current = (TilePosition)toVisit.remove();
            for (TilePosition delta : directions) {
                TilePosition next = current.add(delta);
                if (!this.getData().getMapData().isValid(next)) continue;
                Tile nextTile = this.getData().getTile(next, CheckMode.NO_CHECK);
                if (findCond.isTrue(nextTile, next, this)) {
                    return next;
                }
                if (!visitCond.isTrue(nextTile, next, this) || visited.contains(next)) continue;
                toVisit.add(next);
                visited.add(next);
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public TilePosition breadthFirstSearch(TilePosition start, Pred findCond, Pred visitCond) {
        return this.breadthFirstSearch(start, findCond, visitCond, true);
    }

    @Override
    public WalkPosition breadthFirstSearch(WalkPosition start, Pred findCond, Pred visitCond, boolean connect8) {
        WalkPosition[] directions;
        if (findCond.isTrue(this.getData().getMiniTile(start), start, this)) {
            return start;
        }
        TreeSet<WalkPosition> visited = new TreeSet<WalkPosition>((a, b) -> {
            int result = Integer.compare(a.getX(), b.getX());
            if (result != 0) {
                return result;
            }
            return Integer.compare(a.getY(), b.getY());
        });
        ArrayDeque<WalkPosition> toVisit = new ArrayDeque<WalkPosition>();
        toVisit.add(start);
        visited.add(start);
        WalkPosition[] dir8 = new WalkPosition[]{new WalkPosition(-1, -1), new WalkPosition(0, -1), new WalkPosition(1, -1), new WalkPosition(-1, 0), new WalkPosition(1, 0), new WalkPosition(-1, 1), new WalkPosition(0, 1), new WalkPosition(1, 1)};
        WalkPosition[] dir4 = new WalkPosition[]{new WalkPosition(0, -1), new WalkPosition(-1, 0), new WalkPosition(1, 0), new WalkPosition(0, 1)};
        WalkPosition[] walkPositionArray = directions = connect8 ? dir8 : dir4;
        while (!toVisit.isEmpty()) {
            WalkPosition current = (WalkPosition)toVisit.remove();
            for (WalkPosition delta : directions) {
                WalkPosition next = current.add(delta);
                if (!this.getData().getMapData().isValid(next)) continue;
                MiniTile miniTile = this.getData().getMiniTile(next, CheckMode.NO_CHECK);
                if (findCond.isTrue(miniTile, next, this)) {
                    return next;
                }
                if (!visitCond.isTrue(miniTile, next, this) || visited.contains(next)) continue;
                toVisit.add(next);
                visited.add(next);
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public WalkPosition breadthFirstSearch(WalkPosition start, Pred findCond, Pred visitCond) {
        return this.breadthFirstSearch(start, findCond, visitCond, true);
    }

    @Override
    public void drawDiagonalCrossMap(Position topLeft, Position bottomRight, Color col) {
        this.mapDrawer.drawLineMap(topLeft, bottomRight, col);
        this.mapDrawer.drawLineMap(new Position(bottomRight.getX(), topLeft.getY()), new Position(topLeft.getX(), bottomRight.getY()), col);
    }

    protected List<PlayerUnit> filterPlayerUnits(Collection<UnitImpl> units, Player player) {
        ArrayList<PlayerUnit> ret = new ArrayList<PlayerUnit>();
        for (Unit unit : units) {
            PlayerUnit playerUnit;
            if (!(unit instanceof PlayerUnit) || !(playerUnit = (PlayerUnit)unit).getPlayer().equals(player)) continue;
            ret.add(playerUnit);
        }
        return ret;
    }

    protected List<PlayerUnit> filterNeutralPlayerUnits(Collection<UnitImpl> units, Collection<Player> players) {
        ArrayList<PlayerUnit> ret = new ArrayList<PlayerUnit>();
        for (Player player : players) {
            if (!player.isNeutral()) continue;
            ret.addAll(this.filterPlayerUnits(units, player));
        }
        return ret;
    }

    public void setAreaIdInTile(TilePosition t) {
        Tile tile = ((TerrainDataInitializer)((Object)this.getData())).getTile_(t);
        if (tile.getAreaId().intValue() != 0) {
            throw new IllegalStateException();
        }
        for (int dy = 0; dy < 4; ++dy) {
            for (int dx = 0; dx < 4; ++dx) {
                AreaId id = this.getData().getMiniTile(t.toWalkPosition().add(new WalkPosition(dx, dy)), CheckMode.NO_CHECK).getAreaId();
                if (id.intValue() == 0) continue;
                if (tile.getAreaId().intValue() == 0) {
                    ((TileImpl)tile).setAreaId(id);
                    continue;
                }
                if (tile.getAreaId().equals(id)) continue;
                ((TileImpl)tile).setAreaId(AreaId.UNINITIALIZED);
                return;
            }
        }
    }

    public MutablePair<AreaId, AreaId> findNeighboringAreas(WalkPosition p) {
        WalkPosition[] deltas;
        MutablePair<Object, Object> result = new MutablePair<Object, Object>(null, null);
        for (WalkPosition delta : deltas = new WalkPosition[]{new WalkPosition(0, -1), new WalkPosition(-1, 0), new WalkPosition(1, 0), new WalkPosition(0, 1)}) {
            AreaId areaId;
            if (!this.getData().getMapData().isValid(p.add(delta)) || (areaId = this.getData().getMiniTile(p.add(delta), CheckMode.NO_CHECK).getAreaId()).intValue() <= 0) continue;
            if (result.getLeft() == null) {
                result.setLeft(areaId);
                continue;
            }
            if (((AreaId)result.getLeft()).equals(areaId) || result.getRight() != null && areaId.intValue() >= ((AreaId)result.getRight()).intValue()) continue;
            result.setRight(areaId);
        }
        return result;
    }

    public AreaId chooseNeighboringArea(AreaId a, AreaId b) {
        return this.neighboringAreaChooser.chooseNeighboringArea(a, b);
    }

    private static class NeighboringAreaChooser {
        private final BitSet areaPairFlag = new BitSet(800000);

        private NeighboringAreaChooser() {
        }

        AreaId chooseNeighboringArea(AreaId a, AreaId b) {
            int aId = a.intValue();
            int bId = b.intValue();
            int cantor = (aId + bId) * (aId + bId + 1);
            cantor = aId > bId ? (cantor += bId) : (cantor += aId);
            this.areaPairFlag.flip(cantor);
            return this.areaPairFlag.get(cantor) ? a : b;
        }
    }
}

