/*
 * Decompiled with CFR 0.152.
 */
package bwem.map;

import bwem.map.MapData;
import bwem.util.XYCropper;
import java.util.ArrayList;
import java.util.List;
import java.util.SplittableRandom;
import org.openbw.bwapi4j.Position;
import org.openbw.bwapi4j.TilePosition;
import org.openbw.bwapi4j.WalkPosition;

public class MapDataImpl
implements MapData {
    private final SplittableRandom randomGenerator = new SplittableRandom();
    private final TilePosition tileSize;
    private final WalkPosition walkSize;
    private final Position pixelSize;
    private final Position center;
    private final List<TilePosition> startingLocations;
    private final XYCropper tileSizeCropper;
    private final XYCropper walkSizeCropper;
    private final XYCropper pixelSizeCropper;

    public MapDataImpl(int tileWidth, int tileHeight, List<TilePosition> startingLocations) {
        this.tileSize = new TilePosition(tileWidth, tileHeight);
        this.walkSize = this.tileSize.toWalkPosition();
        this.pixelSize = this.tileSize.toPosition();
        this.center = new Position(this.pixelSize.getX() / 2, this.pixelSize.getY() / 2);
        this.startingLocations = new ArrayList<TilePosition>(startingLocations);
        this.tileSizeCropper = new XYCropper(0, 0, this.getTileSize().getX() - 1, this.getTileSize().getY() - 1);
        this.walkSizeCropper = new XYCropper(0, 0, this.getWalkSize().getX() - 1, this.getWalkSize().getY() - 1);
        this.pixelSizeCropper = new XYCropper(0, 0, this.getPixelSize().getX() - 1, this.getPixelSize().getY() - 1);
    }

    @Override
    public TilePosition getTileSize() {
        return this.tileSize;
    }

    @Override
    public WalkPosition getWalkSize() {
        return this.walkSize;
    }

    @Override
    public Position getPixelSize() {
        return this.pixelSize;
    }

    @Override
    public Position getCenter() {
        return this.center;
    }

    @Override
    public List<TilePosition> getStartingLocations() {
        return this.startingLocations;
    }

    @Override
    public boolean isValid(TilePosition tilePosition) {
        return this.isValid(tilePosition.getX(), tilePosition.getY(), this.getTileSize().getX(), this.getTileSize().getY());
    }

    @Override
    public boolean isValid(WalkPosition walkPosition) {
        return this.isValid(walkPosition.getX(), walkPosition.getY(), this.getWalkSize().getX(), this.getWalkSize().getY());
    }

    @Override
    public boolean isValid(Position position) {
        return this.isValid(position.getX(), position.getY(), this.getPixelSize().getX(), this.getPixelSize().getY());
    }

    private boolean isValid(int x, int y, int maxX, int maxY) {
        return x >= 0 && x < maxX && y >= 0 && y < maxY;
    }

    @Override
    public TilePosition crop(TilePosition tilePosition) {
        int[] xy = this.tileSizeCropper.crop(tilePosition.getX(), tilePosition.getY());
        return new TilePosition(xy[0], xy[1]);
    }

    @Override
    public WalkPosition crop(WalkPosition walkPosition) {
        int[] xy = this.walkSizeCropper.crop(walkPosition.getX(), walkPosition.getY());
        return new WalkPosition(xy[0], xy[1]);
    }

    @Override
    public Position crop(Position position) {
        int[] xy = this.pixelSizeCropper.crop(position.getX(), position.getY());
        return new Position(xy[0], xy[1]);
    }

    @Override
    public Position getRandomPosition() {
        int x = this.randomGenerator.nextInt(this.getPixelSize().getX());
        int y = this.randomGenerator.nextInt(this.getPixelSize().getY());
        return new Position(x, y);
    }
}

