/*
 * Decompiled with CFR 0.152.
 */
package bwem.map;

import bwem.Base;
import bwem.ChokePoint;
import bwem.MapPrinter;
import bwem.area.Area;
import bwem.area.typedef.AreaId;
import bwem.map.TerrainData;
import bwem.typedef.Altitude;
import bwem.typedef.CPPath;
import bwem.typedef.Pred;
import bwem.unit.NeutralData;
import java.util.List;
import org.openbw.bwapi4j.Position;
import org.openbw.bwapi4j.TilePosition;
import org.openbw.bwapi4j.WalkPosition;
import org.openbw.bwapi4j.org.apache.commons.lang3.mutable.MutableInt;
import org.openbw.bwapi4j.org.apache.commons.lang3.tuple.MutablePair;
import org.openbw.bwapi4j.type.Color;
import org.openbw.bwapi4j.unit.Unit;

public interface Map {
    public TerrainData getData();

    public MapPrinter getMapPrinter();

    public boolean isInitialized();

    public boolean automaticPathUpdate();

    public void enableAutomaticPathAnalysis();

    public void assignStartingLocationsToSuitableBases();

    public List<TilePosition> getUnassignedStartingLocations();

    public Altitude getHighestAltitude();

    public List<Base> getBases();

    public List<ChokePoint> getChokePoints();

    public NeutralData getNeutralData();

    public void onUnitDestroyed(Unit var1);

    public void onMineralDestroyed(Unit var1);

    public void onStaticBuildingDestroyed(Unit var1);

    public List<Area> getAreas();

    public Area getArea(AreaId var1);

    public Area getArea(WalkPosition var1);

    public Area getArea(TilePosition var1);

    public Area getNearestArea(WalkPosition var1);

    public Area getNearestArea(TilePosition var1);

    public Area getMainArea(TilePosition var1, TilePosition var2);

    public CPPath getPath(Position var1, Position var2, MutableInt var3);

    public CPPath getPath(Position var1, Position var2);

    public TilePosition breadthFirstSearch(TilePosition var1, Pred var2, Pred var3, boolean var4);

    public TilePosition breadthFirstSearch(TilePosition var1, Pred var2, Pred var3);

    public WalkPosition breadthFirstSearch(WalkPosition var1, Pred var2, Pred var3, boolean var4);

    public WalkPosition breadthFirstSearch(WalkPosition var1, Pred var2, Pred var3);

    public List<MutablePair<MutablePair<AreaId, AreaId>, WalkPosition>> getRawFrontier();

    public void drawDiagonalCrossMap(Position var1, Position var2, Color var3);
}

