/*
 * Decompiled with CFR 0.152.
 */
package bwem.example;

import bwem.Base;
import bwem.CheckMode;
import bwem.ChokePoint;
import bwem.MapPrinter;
import bwem.area.Area;
import bwem.map.Map;
import bwem.tile.MiniTile;
import bwem.tile.Tile;
import bwem.typedef.CPPath;
import bwem.unit.Geyser;
import bwem.unit.Mineral;
import bwem.unit.Neutral;
import bwem.unit.StaticBuilding;
import java.awt.Color;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.SplittableRandom;
import org.openbw.bwapi4j.TilePosition;
import org.openbw.bwapi4j.WalkPosition;
import org.openbw.bwapi4j.org.apache.commons.lang3.mutable.MutableInt;
import org.openbw.bwapi4j.org.apache.commons.lang3.tuple.MutablePair;
import org.openbw.bwapi4j.type.UnitType;

public class MapPrinterExample {
    private final MapPrinter mapPrinter;
    private final SplittableRandom randomGenerator;

    public MapPrinterExample(MapPrinter mapPrinter) {
        this.mapPrinter = mapPrinter;
        this.randomGenerator = new SplittableRandom();
    }

    private boolean getZoneColorCppAlgorithmAnyOf(java.util.Map<Area, List<ChokePoint>> chokePointsByArea, java.util.Map<Integer, Color> mapZoneColor, Color color) {
        for (Area neighbor : chokePointsByArea.keySet()) {
            int neighborId = neighbor.getId().intValue();
            Color neighboringColor = mapZoneColor.get(neighborId);
            if (neighboringColor == null || Math.abs(color.getRed() - neighboringColor.getRed()) + Math.abs(color.getGreen() - neighboringColor.getGreen()) >= 150) continue;
            return true;
        }
        return false;
    }

    private Color getZoneColor(Area area, java.util.Map<Integer, Color> mapZoneColor) {
        this.mapPrinter.getClass();
        int zoneId = area.getId().intValue();
        Color color = mapZoneColor.get(zoneId);
        if (color == null) {
            int tries = 0;
            while (true) {
                color = new Color(this.randomGenerator.nextInt(256), this.randomGenerator.nextInt(256), 0);
                if (++tries > 100) break;
                if (color.getRed() + color.getGreen() < 150) continue;
                this.mapPrinter.getClass();
                if (!this.getZoneColorCppAlgorithmAnyOf(area.getChokePointsByArea(), mapZoneColor, color)) break;
            }
            mapZoneColor.put(zoneId, color);
        }
        return color;
    }

    private void printNeutral(Map theMap, Neutral n, Color col) {
        WalkPosition delta = new WalkPosition(n.getCenter().getX() < theMap.getData().getMapData().getCenter().getX() ? 1 : -1, n.getCenter().getY() < theMap.getData().getMapData().getCenter().getY() ? 1 : -1);
        this.mapPrinter.getClass();
        int stackSize = theMap.getData().getTile(n.getTopLeft()).getStackedNeutralCount();
        for (int i = 0; i < stackSize; ++i) {
            WalkPosition origin = n.getTopLeft().toWalkPosition().add(delta.multiply(new WalkPosition(i, i)));
            WalkPosition size = n.getSize().toWalkPosition();
            if (!theMap.getData().getMapData().isValid(origin) || !theMap.getData().getMapData().isValid(origin.add(size).subtract(new WalkPosition(1, 1)))) break;
            this.mapPrinter.rectangle(origin, origin.add(size).subtract(new WalkPosition(1, 1)), col, MapPrinter.fill_t.fill);
            this.mapPrinter.getClass();
            if (!n.isBlocking()) continue;
            if (i < stackSize - 1) {
                this.mapPrinter.point(origin, MapPrinter.CustomColor.BLOCKING_NEUTRALS.color());
                this.mapPrinter.point(origin.add(size).subtract(new WalkPosition(1, 1)), MapPrinter.CustomColor.BLOCKING_NEUTRALS.color());
                this.mapPrinter.point(new WalkPosition(origin.getX(), origin.add(size).subtract(new WalkPosition(1, 1)).getY()), MapPrinter.CustomColor.BLOCKING_NEUTRALS.color());
                this.mapPrinter.point(new WalkPosition(origin.add(size).subtract(new WalkPosition(1, 1)).getX(), origin.getY()), MapPrinter.CustomColor.BLOCKING_NEUTRALS.color());
                continue;
            }
            this.mapPrinter.rectangle(origin, origin.add(size).subtract(new WalkPosition(1, 1)), MapPrinter.CustomColor.BLOCKING_NEUTRALS.color());
        }
    }

    public void printMap(Map theMap, String filename) {
        int y;
        HashMap<Integer, Color> mapZoneColor = new HashMap<Integer, Color>();
        for (y = 0; y < theMap.getData().getMapData().getWalkSize().getY(); ++y) {
            for (int i = 0; i < theMap.getData().getMapData().getWalkSize().getX(); ++i) {
                Color col;
                WalkPosition p = new WalkPosition(i, y);
                MiniTile miniTile = theMap.getData().getMiniTile(p, CheckMode.NO_CHECK);
                if (miniTile.isSea()) {
                    this.mapPrinter.getClass();
                    col = theMap.getData().isSeaWithNonSeaNeighbors(p) ? MapPrinter.CustomColor.SEA_SIDE.color() : MapPrinter.CustomColor.SEA.color();
                } else {
                    this.mapPrinter.getClass();
                    if (miniTile.isLake()) {
                        col = MapPrinter.CustomColor.LAKE.color();
                    } else {
                        this.mapPrinter.getClass();
                        int c = 255 - miniTile.getAltitude().intValue() * 255 / theMap.getHighestAltitude().intValue();
                        col = new Color(c, c, c);
                        this.mapPrinter.getClass();
                        if (miniTile.getAreaId().intValue() > 0) {
                            Area area = theMap.getArea(miniTile.getAreaId());
                            Color zoneColor = this.getZoneColor(area, mapZoneColor);
                            int red = zoneColor.getRed() * col.getRed() / 255;
                            int green = zoneColor.getGreen() * col.getGreen() / 255;
                            col = new Color(red, green, 0);
                        } else {
                            col = MapPrinter.CustomColor.TINY_AREA.color();
                        }
                    }
                }
                this.mapPrinter.point(p, col);
            }
        }
        this.mapPrinter.getClass();
        this.mapPrinter.getClass();
        this.mapPrinter.getClass();
        for (y = 0; y < theMap.getData().getMapData().getTileSize().getY(); ++y) {
            for (int i = 0; i < theMap.getData().getMapData().getTileSize().getX(); ++i) {
                Object groundHeight = theMap.getData().getTile(new TilePosition(i, y)).getGroundHeight();
                if (groundHeight.intValue() < Tile.GroundHeight.HIGH_GROUND.intValue()) continue;
                for (int dy = 0; dy < 4; ++dy) {
                    for (int dx = 0; dx < 4; ++dx) {
                        WalkPosition p = new TilePosition(i, y).toWalkPosition().add(new WalkPosition(dx, dy));
                        if (!theMap.getData().getMiniTile(p, CheckMode.NO_CHECK).isWalkable() || (dx + dy & (groundHeight == Tile.GroundHeight.HIGH_GROUND ? 1 : 3)) == 0) continue;
                        this.mapPrinter.point(p, MapPrinter.CustomColor.HIGHER_GROUND.color());
                    }
                }
            }
        }
        this.mapPrinter.getClass();
        for (Area area : theMap.getAreas()) {
            for (Base base : area.getBases()) {
                for (Mineral m : base.getMinerals()) {
                    this.mapPrinter.line(base.getCenter().toWalkPosition(), m.getCenter().toWalkPosition(), MapPrinter.CustomColor.BASES.color());
                }
                for (Geyser g : base.getGeysers()) {
                    this.mapPrinter.line(base.getCenter().toWalkPosition(), g.getCenter().toWalkPosition(), MapPrinter.CustomColor.BASES.color());
                }
            }
        }
        this.mapPrinter.getClass();
        for (Geyser geyser : theMap.getNeutralData().getGeysers()) {
            this.printNeutral(theMap, geyser, MapPrinter.CustomColor.GEYSERS.color());
        }
        this.mapPrinter.getClass();
        for (Mineral mineral : theMap.getNeutralData().getMinerals()) {
            this.printNeutral(theMap, mineral, MapPrinter.CustomColor.MINERALS.color());
        }
        this.mapPrinter.getClass();
        for (StaticBuilding staticBuilding : theMap.getNeutralData().getStaticBuildings()) {
            this.printNeutral(theMap, staticBuilding, MapPrinter.CustomColor.STATIC_BUILDINGS.color());
        }
        this.mapPrinter.getClass();
        for (TilePosition tilePosition : theMap.getData().getMapData().getStartingLocations()) {
            WalkPosition origin = tilePosition.toWalkPosition();
            WalkPosition size = UnitType.Terran_Command_Center.tileSize().toWalkPosition();
            this.mapPrinter.rectangle(origin, origin.add(size).subtract(new WalkPosition(1, 1)), MapPrinter.CustomColor.STARTING_LOCATIONS.color(), MapPrinter.fill_t.fill);
        }
        this.mapPrinter.getClass();
        for (Area area : theMap.getAreas()) {
            for (Base base : area.getBases()) {
                WalkPosition origin = base.getLocation().toWalkPosition();
                WalkPosition size = UnitType.Terran_Command_Center.tileSize().toWalkPosition();
                MapPrinter.dashed_t dashMode = base.getBlockingMinerals().isEmpty() ? MapPrinter.dashed_t.not_dashed : MapPrinter.dashed_t.dashed;
                this.mapPrinter.rectangle(origin, origin.add(size).subtract(new WalkPosition(1, 1)), MapPrinter.CustomColor.BASES.color(), MapPrinter.fill_t.do_not_fill, dashMode);
            }
        }
        this.mapPrinter.getClass();
        for (MutablePair mutablePair : theMap.getRawFrontier()) {
            WalkPosition walkPosition = (WalkPosition)mutablePair.getRight();
            this.mapPrinter.getClass();
            this.mapPrinter.point(walkPosition, MapPrinter.CustomColor.CHOKE_POINTS_SHOW_AREAS.color());
        }
        for (Area area : theMap.getAreas()) {
            for (ChokePoint cp : area.getChokePoints()) {
                ChokePoint.Node[] nodes;
                for (ChokePoint.Node n : nodes = new ChokePoint.Node[]{ChokePoint.Node.END1, ChokePoint.Node.END2}) {
                    this.mapPrinter.square(cp.getNodePosition(n), 1, new Color(255, 0, 255), MapPrinter.fill_t.fill);
                }
                this.mapPrinter.square(cp.getCenter(), 1, new Color(0, 0, 255), MapPrinter.fill_t.fill);
            }
        }
        try {
            this.mapPrinter.writeImageToFile(Paths.get(filename + ".png", new String[0]), "png");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void pathExample(Map theMap, String filename) {
        WalkPosition a;
        if (theMap.getData().getMapData().getStartingLocations().size() < 2) {
            return;
        }
        Color col = new Color(255, 255, 255);
        WalkPosition b = a = theMap.getData().getMapData().getStartingLocations().get(this.randomGenerator.nextInt(theMap.getData().getMapData().getStartingLocations().size())).toWalkPosition();
        while (b.equals(a)) {
            b = theMap.getData().getMapData().getStartingLocations().get(this.randomGenerator.nextInt(theMap.getData().getMapData().getStartingLocations().size())).toWalkPosition();
        }
        this.mapPrinter.circle(a, 6, col, MapPrinter.fill_t.fill);
        this.mapPrinter.circle(b, 6, col, MapPrinter.fill_t.fill);
        MutableInt length = new MutableInt(0);
        CPPath path = theMap.getPath(a.toPosition(), b.toPosition(), length);
        if (length.intValue() < 0) {
            return;
        }
        if (path.isEmpty()) {
            if (!theMap.getNearestArea(a).equals(theMap.getNearestArea(b))) {
                throw new IllegalStateException();
            }
            this.mapPrinter.line(a, b, col, MapPrinter.dashed_t.dashed);
        } else {
            if (theMap.getNearestArea(a).equals(theMap.getNearestArea(b))) {
                throw new IllegalStateException();
            }
            ChokePoint cpPrevious = null;
            for (ChokePoint cp : path) {
                if (cpPrevious != null) {
                    this.mapPrinter.line(cpPrevious.getCenter(), cp.getCenter(), col, MapPrinter.dashed_t.dashed);
                }
                this.mapPrinter.circle(cp.getCenter(), 6, col);
                cpPrevious = cp;
            }
            this.mapPrinter.line(a, path.get(0).getCenter(), col, MapPrinter.dashed_t.dashed);
            this.mapPrinter.line(b, path.get(path.size() - 1).getCenter(), col, MapPrinter.dashed_t.dashed);
        }
        try {
            this.mapPrinter.writeImageToFile(Paths.get(filename + ".png", new String[0]), "png");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

