/*
 * Decompiled with CFR 0.152.
 */
package bwem.area;

import bwem.area.typedef.AreaId;
import bwem.tile.MiniTile;
import bwem.tile.MiniTileImpl;
import bwem.typedef.Altitude;
import org.openbw.bwapi4j.WalkPosition;

public class TempAreaInfo {
    private boolean isValid;
    private final AreaId id;
    private final WalkPosition walkPositionWithHighestAltitude;
    private final Altitude highestAltitude;
    private int size;

    public TempAreaInfo() {
        this.isValid = false;
        this.id = AreaId.ZERO;
        this.walkPositionWithHighestAltitude = new WalkPosition(0, 0);
        this.highestAltitude = Altitude.ZERO;
        if (this.isValid()) {
            throw new IllegalStateException();
        }
    }

    public TempAreaInfo(AreaId id, MiniTile miniTile, WalkPosition walkPositionWithHighestAltitude) {
        this.isValid = true;
        this.id = id;
        this.walkPositionWithHighestAltitude = walkPositionWithHighestAltitude;
        this.size = 0;
        this.highestAltitude = miniTile.getAltitude();
        this.add(miniTile);
        if (!this.isValid()) {
            throw new IllegalStateException();
        }
    }

    public boolean isValid() {
        return this.isValid;
    }

    public AreaId getId() {
        if (!this.isValid()) {
            throw new IllegalStateException();
        }
        return this.id;
    }

    public WalkPosition getWalkPositionWithHighestAltitude() {
        if (!this.isValid()) {
            throw new IllegalStateException();
        }
        return this.walkPositionWithHighestAltitude;
    }

    public int getSize() {
        if (!this.isValid()) {
            throw new IllegalStateException();
        }
        return this.size;
    }

    public Altitude getHighestAltitude() {
        if (!this.isValid()) {
            throw new IllegalStateException();
        }
        return this.highestAltitude;
    }

    public void add(MiniTile miniTile) {
        if (!this.isValid()) {
            throw new IllegalStateException();
        }
        ++this.size;
        ((MiniTileImpl)miniTile).setAreaId(this.id);
    }

    public void merge(TempAreaInfo absorbed) {
        if (!this.isValid() || !absorbed.isValid()) {
            throw new IllegalStateException();
        }
        if (this.size < absorbed.size) {
            throw new IllegalStateException();
        }
        this.size += absorbed.size;
        absorbed.isValid = false;
    }
}

