/*
 * Decompiled with CFR 0.152.
 */
package bwem.area;

import bwem.Base;
import bwem.BaseImpl;
import bwem.CheckMode;
import bwem.ChokePoint;
import bwem.Markable;
import bwem.StaticMarkable;
import bwem.area.Area;
import bwem.area.AreaImpl;
import bwem.area.AreaInitializer;
import bwem.area.typedef.AreaId;
import bwem.area.typedef.GroupId;
import bwem.map.Map;
import bwem.map.TerrainData;
import bwem.tile.MiniTile;
import bwem.tile.Tile;
import bwem.tile.TileImpl;
import bwem.unit.Geyser;
import bwem.unit.Mineral;
import bwem.unit.Neutral;
import bwem.unit.Resource;
import bwem.unit.StaticBuilding;
import bwem.util.BwemExt;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import org.openbw.bwapi4j.TilePosition;
import org.openbw.bwapi4j.WalkPosition;
import org.openbw.bwapi4j.type.UnitType;
import org.openbw.bwapi4j.util.Pair;

public class AreaInitializerImpl
extends AreaImpl
implements AreaInitializer {
    private static final StaticMarkable staticMarkable = new StaticMarkable();
    private final Markable markable;
    private final Map map;

    public AreaInitializerImpl(Map map, AreaId areaId, WalkPosition top, int miniTileCount) {
        super(areaId, top, miniTileCount);
        this.map = map;
        this.markable = new Markable(staticMarkable);
        if (areaId.intValue() <= 0) {
            throw new IllegalArgumentException();
        }
        MiniTile topMiniTile = this.getMap().getData().getMiniTile(top);
        if (!topMiniTile.getAreaId().equals(areaId)) {
            throw new IllegalStateException("assert failed: topMiniTile.AreaId().equals(areaId): expected: " + topMiniTile.getAreaId().intValue() + ", actual: " + areaId.intValue());
        }
        this.highestAltitude = topMiniTile.getAltitude();
    }

    public static StaticMarkable getStaticMarkable() {
        return staticMarkable;
    }

    @Override
    public Markable getMarkable() {
        return this.markable;
    }

    @Override
    public void addChokePoints(Area area, List<ChokePoint> chokePoints) {
        if (this.chokePointsByArea.get(area) != null || chokePoints == null) {
            throw new IllegalArgumentException();
        }
        this.chokePointsByArea.put(area, chokePoints);
        this.chokePoints.addAll(chokePoints);
    }

    @Override
    public void addMineral(Mineral mineral) {
        if (mineral == null || this.minerals.contains(mineral)) {
            throw new IllegalStateException();
        }
        this.minerals.add(mineral);
    }

    @Override
    public void addGeyser(Geyser geyser) {
        if (geyser == null || this.geysers.contains(geyser)) {
            throw new IllegalStateException();
        }
        this.geysers.add(geyser);
    }

    @Override
    public void addTileInformation(TilePosition tilePosition, Tile tile) {
        ++this.tileCount;
        if (tile.isBuildable()) {
            ++this.buildableTileCount;
        }
        if (tile.getGroundHeight() == Tile.GroundHeight.HIGH_GROUND) {
            ++this.highGroundTileCount;
        } else if (tile.getGroundHeight() == Tile.GroundHeight.VERY_HIGH_GROUND) {
            ++this.veryHighGroundTileCount;
        }
        if (tilePosition.getX() < this.topLeft.getX()) {
            this.topLeft = new TilePosition(tilePosition.getX(), this.topLeft.getY());
        }
        if (tilePosition.getY() < this.topLeft.getY()) {
            this.topLeft = new TilePosition(this.topLeft.getX(), tilePosition.getY());
        }
        if (tilePosition.getX() > this.bottomRight.getX()) {
            this.bottomRight = new TilePosition(tilePosition.getX(), this.bottomRight.getY());
        }
        if (tilePosition.getY() > this.bottomRight.getY()) {
            this.bottomRight = new TilePosition(this.bottomRight.getX(), tilePosition.getY());
        }
    }

    @Override
    public void setGroupId(GroupId gid) {
        if (gid.intValue() < 1) {
            throw new IllegalArgumentException();
        }
        this.groupId = gid;
    }

    @Override
    public Map getMap() {
        return this.map;
    }

    @Override
    public void postCollectInformation() {
    }

    @Override
    public int[] computeDistances(ChokePoint startCP, List<ChokePoint> targetCPs) {
        if (targetCPs.contains(startCP)) {
            throw new IllegalStateException();
        }
        TilePosition start = this.getMap().breadthFirstSearch(startCP.getNodePositionInArea(ChokePoint.Node.MIDDLE, this).toTilePosition(), args -> {
            Object ttile = args[0];
            if (ttile instanceof Tile) {
                Tile tile = (Tile)ttile;
                return tile.getAreaId().equals(this.getId());
            }
            throw new IllegalArgumentException();
        }, args -> true);
        ArrayList<TilePosition> targets = new ArrayList<TilePosition>();
        for (ChokePoint cp : targetCPs) {
            TilePosition t = this.getMap().breadthFirstSearch(cp.getNodePositionInArea(ChokePoint.Node.MIDDLE, this).toTilePosition(), args -> {
                Object ttile = args[0];
                if (ttile instanceof Tile) {
                    Tile tile = (Tile)ttile;
                    return tile.getAreaId().equals(this.getId());
                }
                throw new IllegalArgumentException();
            }, args -> true);
            targets.add(t);
        }
        return this.computeDistances(start, targets);
    }

    @Override
    public int[] computeDistances(TilePosition start, List<TilePosition> targets) {
        int[] distances = new int[targets.size()];
        TileImpl.getStaticMarkable().unmarkAll();
        PriorityQueue<Pair> toVisit = new PriorityQueue<Pair>(Comparator.comparingInt(Pair::getFirst));
        toVisit.offer(new Pair<Integer, TilePosition>(0, start));
        int remainingTargets = targets.size();
        while (!toVisit.isEmpty()) {
            TilePosition[] deltas;
            Pair distanceAndTilePosition = (Pair)toVisit.poll();
            int currentDist = (Integer)distanceAndTilePosition.getFirst();
            TilePosition current = (TilePosition)distanceAndTilePosition.getSecond();
            Tile currentTile = this.getMap().getData().getTile(current, CheckMode.NO_CHECK);
            if (((TileImpl)currentTile).getInternalData() != currentDist) {
                throw new IllegalStateException("currentTile.InternalData().intValue()=" + ((TileImpl)currentTile).getInternalData() + ", currentDist=" + currentDist);
            }
            ((TileImpl)currentTile).setInternalData(0);
            ((TileImpl)currentTile).getMarkable().setMarked();
            for (int i = 0; i < targets.size(); ++i) {
                if (!current.equals(targets.get(i))) continue;
                distances[i] = (int)Math.round((double)currentDist * 32.0 / 10000.0);
                --remainingTargets;
            }
            if (remainingTargets == 0) break;
            for (TilePosition delta : deltas = new TilePosition[]{new TilePosition(-1, -1), new TilePosition(0, -1), new TilePosition(1, -1), new TilePosition(-1, 0), new TilePosition(1, 0), new TilePosition(-1, 1), new TilePosition(0, 1), new TilePosition(1, 1)}) {
                Tile nextTile;
                boolean diagonalMove = delta.getX() != 0 && delta.getY() != 0;
                int newNextDist = currentDist + (diagonalMove ? 14142 : 10000);
                TilePosition next = current.add(delta);
                if (!this.getMap().getData().getMapData().isValid(next) || ((TileImpl)(nextTile = this.getMap().getData().getTile(next, CheckMode.NO_CHECK))).getMarkable().isMarked()) continue;
                if (((TileImpl)nextTile).getInternalData() != 0) {
                    if (newNextDist >= ((TileImpl)nextTile).getInternalData()) continue;
                    boolean removed = toVisit.remove(new Pair<Integer, TilePosition>(((TileImpl)nextTile).getInternalData(), next));
                    if (!removed) {
                        throw new IllegalStateException();
                    }
                    ((TileImpl)nextTile).setInternalData(newNextDist);
                    toVisit.offer(new Pair<Integer, TilePosition>(newNextDist, next));
                    continue;
                }
                if (!nextTile.getAreaId().equals(this.getId()) && !nextTile.getAreaId().equals(AreaId.UNINITIALIZED)) continue;
                ((TileImpl)nextTile).setInternalData(newNextDist);
                toVisit.offer(new Pair<Integer, TilePosition>(newNextDist, next));
            }
        }
        if (remainingTargets != 0) {
            throw new IllegalStateException();
        }
        for (Pair distanceAndTilePosition : toVisit) {
            TileImpl tileToUpdate = (TileImpl)this.getMap().getData().getTile((TilePosition)distanceAndTilePosition.getSecond(), CheckMode.NO_CHECK);
            tileToUpdate.setInternalData(0);
        }
        return distances;
    }

    @Override
    public void updateAccessibleNeighbors() {
        this.accessibleNeighbors.clear();
        block0: for (Area area : this.getChokePointsByArea().keySet()) {
            for (ChokePoint cp : this.getChokePointsByArea().get(area)) {
                if (cp.isBlocked()) continue;
                this.accessibleNeighbors.add(area);
                continue block0;
            }
        }
    }

    @Override
    public void createBases(TerrainData terrainData) {
        TilePosition resourceDepotDimensions = UnitType.Terran_Command_Center.tileSize();
        ArrayList<Resource> remainingResources = new ArrayList<Resource>();
        for (Mineral mineral : this.getMinerals()) {
            if (mineral.getInitialAmount() < 40 || mineral.isBlocking()) continue;
            remainingResources.add(mineral);
        }
        for (Geyser geyser : this.getGeysers()) {
            if (geyser.getInitialAmount() < 300 || geyser.isBlocking()) continue;
            remainingResources.add(geyser);
        }
        while (!remainingResources.isEmpty()) {
            TilePosition deltaTilePosition;
            int dx;
            int dy;
            TilePosition topLeftResources = new TilePosition(Integer.MAX_VALUE, Integer.MAX_VALUE);
            TilePosition bottomRightResources = new TilePosition(Integer.MIN_VALUE, Integer.MIN_VALUE);
            for (Resource r : remainingResources) {
                Pair<TilePosition, TilePosition> pair1 = BwemExt.makeBoundingBoxIncludePoint(topLeftResources, bottomRightResources, r.getTopLeft());
                topLeftResources = pair1.getFirst();
                bottomRightResources = pair1.getSecond();
                Iterator pair2 = BwemExt.makeBoundingBoxIncludePoint(topLeftResources, bottomRightResources, r.getBottomRight());
                topLeftResources = ((Pair)((Object)pair2)).getFirst();
                bottomRightResources = ((Pair)((Object)pair2)).getSecond();
            }
            TilePosition dimensionsBetweenResourceDepotAndResources = new TilePosition(10, 10);
            TilePosition topLeftSearchBoundingBox = topLeftResources.subtract(resourceDepotDimensions).subtract(dimensionsBetweenResourceDepotAndResources);
            TilePosition bottomRightSearchBoundingBox = bottomRightResources.add(new TilePosition(1, 1)).add(dimensionsBetweenResourceDepotAndResources);
            topLeftSearchBoundingBox = BwemExt.makePointFitToBoundingBox(topLeftSearchBoundingBox, this.getTopLeft(), this.getBottomRight().subtract(resourceDepotDimensions).add(new TilePosition(1, 1)));
            bottomRightSearchBoundingBox = BwemExt.makePointFitToBoundingBox(bottomRightSearchBoundingBox, this.getTopLeft(), this.getBottomRight().subtract(resourceDepotDimensions).add(new TilePosition(1, 1)));
            for (Resource r : remainingResources) {
                for (dy = -resourceDepotDimensions.getY() - 10; dy < r.getSize().getY() + resourceDepotDimensions.getY() + 10; ++dy) {
                    for (dx = -resourceDepotDimensions.getX() - 10; dx < r.getSize().getX() + resourceDepotDimensions.getX() + 10; ++dx) {
                        deltaTilePosition = r.getTopLeft().add(new TilePosition(dx, dy));
                        if (!terrainData.getMapData().isValid(deltaTilePosition)) continue;
                        Tile tile = terrainData.getTile(deltaTilePosition, CheckMode.NO_CHECK);
                        int dist = (BwemExt.distToRectangle(BwemExt.center(deltaTilePosition), r.getTopLeft().toPosition(), r.getSize().toPosition()) + 16) / 32;
                        int score = Math.max(13 - dist, 0);
                        if (r instanceof Geyser) {
                            score *= 3;
                        }
                        if (!tile.getAreaId().equals(this.getId())) continue;
                        ((TileImpl)tile).setInternalData(((TileImpl)tile).getInternalData() + score);
                    }
                }
            }
            for (Resource r : remainingResources) {
                for (dy = -3; dy < r.getSize().getY() + 3; ++dy) {
                    for (dx = -3; dx < r.getSize().getX() + 3; ++dx) {
                        deltaTilePosition = r.getTopLeft().add(new TilePosition(dx, dy));
                        if (!terrainData.getMapData().isValid(deltaTilePosition)) continue;
                        Tile tileToUpdate = terrainData.getTile(deltaTilePosition, CheckMode.NO_CHECK);
                        ((TileImpl)tileToUpdate).setInternalData(-1);
                    }
                }
            }
            TilePosition bestLocation = null;
            int bestScore = 0;
            ArrayList<Mineral> blockingMinerals = new ArrayList<Mineral>();
            for (int y = topLeftSearchBoundingBox.getY(); y <= bottomRightSearchBoundingBox.getY(); ++y) {
                for (int x = topLeftSearchBoundingBox.getX(); x <= bottomRightSearchBoundingBox.getX(); ++x) {
                    int score = this.computeBaseLocationScore(terrainData, new TilePosition(x, y));
                    if (score <= bestScore || !this.validateBaseLocation(terrainData, new TilePosition(x, y), blockingMinerals)) continue;
                    bestScore = score;
                    bestLocation = new TilePosition(x, y);
                }
            }
            for (Resource r : remainingResources) {
                for (int dy2 = -resourceDepotDimensions.getY() - 10; dy2 < r.getSize().getY() + resourceDepotDimensions.getY() + 10; ++dy2) {
                    for (int dx2 = -resourceDepotDimensions.getX() - 10; dx2 < r.getSize().getX() + resourceDepotDimensions.getX() + 10; ++dx2) {
                        TilePosition deltaTilePosition2 = r.getTopLeft().add(new TilePosition(dx2, dy2));
                        if (!terrainData.getMapData().isValid(deltaTilePosition2)) continue;
                        Tile tileToUpdate = terrainData.getTile(deltaTilePosition2, CheckMode.NO_CHECK);
                        ((TileImpl)tileToUpdate).setInternalData(0);
                    }
                }
            }
            if (bestScore == 0) break;
            ArrayList<Resource> assignedResources = new ArrayList<Resource>();
            for (Resource r : remainingResources) {
                if (BwemExt.distToRectangle(r.getCenter(), bestLocation.toPosition(), resourceDepotDimensions.toPosition()) + 2 > 320) continue;
                assignedResources.add(r);
            }
            remainingResources.removeIf(assignedResources::contains);
            if (assignedResources.isEmpty()) break;
            this.bases.add(new BaseImpl(this, bestLocation, assignedResources, blockingMinerals));
        }
    }

    @Override
    public int computeBaseLocationScore(TerrainData terrainData, TilePosition location) {
        TilePosition dimCC = UnitType.Terran_Command_Center.tileSize();
        int sumScore = 0;
        for (int dy = 0; dy < dimCC.getY(); ++dy) {
            for (int dx = 0; dx < dimCC.getX(); ++dx) {
                Tile tile = terrainData.getTile(location.add(new TilePosition(dx, dy)), CheckMode.NO_CHECK);
                if (!tile.isBuildable()) {
                    return -1;
                }
                if (((TileImpl)tile).getInternalData() == -1) {
                    return -1;
                }
                if (!tile.getAreaId().equals(this.getId())) {
                    return -1;
                }
                if (tile.getNeutral() != null && tile.getNeutral() instanceof StaticBuilding) {
                    return -1;
                }
                sumScore += ((TileImpl)tile).getInternalData();
            }
        }
        return sumScore;
    }

    @Override
    public boolean validateBaseLocation(TerrainData terrainData, TilePosition location, List<Mineral> blockingMinerals) {
        TilePosition dimCC = UnitType.Terran_Command_Center.tileSize();
        blockingMinerals.clear();
        for (int dy = -3; dy < dimCC.getY() + 3; ++dy) {
            for (int dx = -3; dx < dimCC.getX() + 3; ++dx) {
                Tile deltaTile;
                Neutral deltaTileNeutral;
                TilePosition deltaLocation = location.add(new TilePosition(dx, dy));
                if (!terrainData.getMapData().isValid(deltaLocation) || (deltaTileNeutral = (deltaTile = terrainData.getTile(deltaLocation, CheckMode.NO_CHECK)).getNeutral()) == null) continue;
                if (deltaTileNeutral instanceof Geyser) {
                    return false;
                }
                if (!(deltaTileNeutral instanceof Mineral)) continue;
                Mineral deltaTileMineral = (Mineral)deltaTileNeutral;
                if (deltaTileMineral.getInitialAmount() <= 8) {
                    blockingMinerals.add(deltaTileMineral);
                    continue;
                }
                return false;
            }
        }
        for (Base base : this.getBases()) {
            if (BwemExt.roundedDist(base.getLocation(), location) >= 10) continue;
            return false;
        }
        return true;
    }
}

