/*
 * Decompiled with CFR 0.152.
 */
package bwem.area;

import bwem.Base;
import bwem.BaseImpl;
import bwem.ChokePoint;
import bwem.area.Area;
import bwem.area.typedef.AreaId;
import bwem.area.typedef.GroupId;
import bwem.typedef.Altitude;
import bwem.unit.Geyser;
import bwem.unit.Mineral;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openbw.bwapi4j.TilePosition;
import org.openbw.bwapi4j.WalkPosition;

public abstract class AreaImpl
implements Area {
    private final AreaId id;
    protected GroupId groupId = GroupId.ZERO;
    private final WalkPosition walkPositionWithHighestAltitude;
    protected Altitude highestAltitude;
    protected TilePosition topLeft = new TilePosition(Integer.MAX_VALUE, Integer.MAX_VALUE);
    protected TilePosition bottomRight = new TilePosition(Integer.MIN_VALUE, Integer.MIN_VALUE);
    private final int miniTileCount;
    protected int tileCount = 0;
    protected int buildableTileCount = 0;
    protected int highGroundTileCount = 0;
    protected int veryHighGroundTileCount = 0;
    protected final Map<Area, List<ChokePoint>> chokePointsByArea = new HashMap<Area, List<ChokePoint>>();
    protected final List<Area> accessibleNeighbors = new ArrayList<Area>();
    protected final List<ChokePoint> chokePoints = new ArrayList<ChokePoint>();
    protected final List<Mineral> minerals = new ArrayList<Mineral>();
    protected final List<Geyser> geysers = new ArrayList<Geyser>();
    protected final List<Base> bases = new ArrayList<Base>();

    protected AreaImpl(AreaId areaId, WalkPosition top, int miniTileCount) {
        this.id = areaId;
        this.walkPositionWithHighestAltitude = top;
        this.miniTileCount = miniTileCount;
    }

    @Override
    public AreaId getId() {
        return this.id;
    }

    @Override
    public GroupId getGroupId() {
        return this.groupId;
    }

    @Override
    public TilePosition getTopLeft() {
        return this.topLeft;
    }

    @Override
    public TilePosition getBottomRight() {
        return this.bottomRight;
    }

    @Override
    public TilePosition getBoundingBoxSize() {
        return this.bottomRight.subtract(this.topLeft).add(new TilePosition(1, 1));
    }

    @Override
    public WalkPosition getWalkPositionWithHighestAltitude() {
        return this.walkPositionWithHighestAltitude;
    }

    @Override
    public WalkPosition getTop() {
        return this.getWalkPositionWithHighestAltitude();
    }

    @Override
    public Altitude getHighestAltitude() {
        return this.highestAltitude;
    }

    @Override
    public int getSize() {
        return this.miniTileCount;
    }

    @Override
    public int getLowGroundPercentage() {
        int lowGroundTileCount = this.tileCount - this.highGroundTileCount - this.veryHighGroundTileCount;
        return lowGroundTileCount * 100 / this.tileCount;
    }

    @Override
    public int getHighGroundPercentage() {
        return this.highGroundTileCount * 100 / this.tileCount;
    }

    @Override
    public int getVeryHighGroundPercentage() {
        return this.veryHighGroundTileCount * 100 / this.tileCount;
    }

    @Override
    public List<ChokePoint> getChokePoints() {
        return this.chokePoints;
    }

    @Override
    public List<ChokePoint> getChokePoints(Area area) {
        List<ChokePoint> ret = this.chokePointsByArea.get(area);
        if (ret == null) {
            throw new IllegalArgumentException();
        }
        return ret;
    }

    @Override
    public Map<Area, List<ChokePoint>> getChokePointsByArea() {
        return this.chokePointsByArea;
    }

    @Override
    public List<Area> getAccessibleNeighbors() {
        return this.accessibleNeighbors;
    }

    @Override
    public boolean isAccessibleFrom(Area area) {
        return this.getGroupId().equals(area.getGroupId());
    }

    @Override
    public List<Mineral> getMinerals() {
        return this.minerals;
    }

    @Override
    public List<Geyser> getGeysers() {
        return this.geysers;
    }

    @Override
    public List<Base> getBases() {
        return this.bases;
    }

    public void onMineralDestroyed(Mineral mineral) {
        if (mineral == null) {
            throw new IllegalArgumentException();
        }
        this.minerals.remove(mineral);
        for (Base base : this.getBases()) {
            ((BaseImpl)base).onMineralDestroyed(mineral);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Area)) {
            return false;
        }
        Area that = (Area)object;
        return this.getId().equals(that.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

