/*
 * Decompiled with CFR 0.152.
 */
package bwem;

import bwem.map.Map;
import bwem.util.BwemExt;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.nio.file.Path;
import javax.imageio.ImageIO;
import org.openbw.bwapi4j.BW;
import org.openbw.bwapi4j.WalkPosition;

public class MapPrinter {
    private Map map;
    private BufferedImage image;
    private Graphics2D BMP;
    public final boolean showAltitude = true;
    public final boolean showAreas = true;
    public final boolean showContinents = false;
    public final boolean showLakes = true;
    public final boolean showSeaSide = true;
    public final boolean showUnbuildable = false;
    public final boolean showGroundHeight = true;
    public final boolean showChokePoints = true;
    public final boolean showResources = true;
    public final boolean showMinerals = true;
    public final boolean showGeysers = true;
    public final boolean showStaticBuildings = true;
    public final boolean showBlockingBuildings = true;
    public final boolean showStackedNeutrals = true;
    public final boolean showStartingLocations = true;
    public final boolean showBases = true;
    public final boolean showAssignedResources = true;
    public final boolean showData = false;

    public static Color color() {
        return new Color(0, 0, 0);
    }

    public void initialize(BW pBW, Map pMap) {
        if (!pMap.isInitialized()) {
            throw new IllegalStateException();
        }
        this.map = pMap;
        this.image = new BufferedImage(pBW.getBWMap().mapWidth() * 4, pBW.getBWMap().mapHeight() * 4, 1);
        this.BMP = this.image.createGraphics();
    }

    public void point(int x, int y, Color col) {
        if (0 > x || x >= this.image.getWidth()) {
            throw new IllegalArgumentException();
        }
        if (0 > y || y >= this.image.getHeight()) {
            throw new IllegalArgumentException();
        }
        this.BMP.setColor(col);
        this.BMP.drawLine(x, y, x, y);
    }

    public void point(WalkPosition p, Color col) {
        this.point(p.getX(), p.getY(), col);
    }

    public void line(WalkPosition a, WalkPosition b, Color col, dashed_t dashedMode) {
        int n = Math.max(1, BwemExt.roundedDist(a, b));
        if (dashedMode == dashed_t.dashed && n >= 4) {
            n /= 2;
        }
        for (int i = 0; i <= n; ++i) {
            int x = (a.getX() * i + b.getX() * (n - i)) / n;
            int y = (a.getY() * i + b.getY() * (n - i)) / n;
            this.point(new WalkPosition(x, y), col);
        }
    }

    public void line(WalkPosition a, WalkPosition b, Color col) {
        this.line(a, b, col, dashed_t.not_dashed);
    }

    public void rectangle(WalkPosition topLeft, WalkPosition bottomRight, Color col, fill_t fillMode, dashed_t dashedMode) {
        for (int y = topLeft.getY(); y <= bottomRight.getY(); ++y) {
            for (int x = topLeft.getX(); x <= bottomRight.getX(); ++x) {
                if (fillMode != fill_t.fill && y != topLeft.getY() && y != bottomRight.getY() && x != topLeft.getX() && x != bottomRight.getX() || dashedMode != dashed_t.not_dashed && (x + y & 1) == 0) continue;
                this.point(x, y, col);
            }
        }
    }

    public void rectangle(WalkPosition topLeft, WalkPosition bottomRight, Color col, fill_t fillMode) {
        this.rectangle(topLeft, bottomRight, col, fillMode, dashed_t.not_dashed);
    }

    public void rectangle(WalkPosition topLeft, WalkPosition bottomRight, Color col) {
        this.rectangle(topLeft, bottomRight, col, fill_t.do_not_fill);
    }

    public void square(WalkPosition center, int radius, Color col, fill_t fillMode) {
        for (int y = center.getY() - radius; y <= center.getY() + radius; ++y) {
            for (int x = center.getX() - radius; x <= center.getX() + radius; ++x) {
                if (fillMode != fill_t.fill && y != center.getY() - radius && y != center.getY() + radius && x != center.getX() - radius && x != center.getX() + radius || !this.map.getData().getMapData().isValid(new WalkPosition(x, y))) continue;
                this.point(x, y, col);
            }
        }
    }

    public void square(WalkPosition center, int radius, Color col) {
        this.square(center, radius, col, fill_t.do_not_fill);
    }

    public void circle(WalkPosition center, int radius, Color col, fill_t fillMode) {
        for (int y = center.getY() - radius; y <= center.getY() + radius; ++y) {
            for (int x = center.getX() - radius; x <= center.getX() + radius; ++x) {
                WalkPosition w = new WalkPosition(x, y);
                if (!(BwemExt.dist(w, center) <= (double)radius) || fillMode != fill_t.fill && !(BwemExt.dist(w, center) >= (double)(radius - 1)) || !this.map.getData().getMapData().isValid(w)) continue;
                this.point(x, y, col);
            }
        }
    }

    public void circle(WalkPosition center, int radius, Color col) {
        this.circle(center, radius, col, fill_t.do_not_fill);
    }

    public void writeImageToFile(Path file, String imageFormat) throws IOException {
        ImageIO.write((RenderedImage)this.image, imageFormat, file.toFile());
    }

    public static enum fill_t {
        do_not_fill,
        fill;

    }

    public static enum dashed_t {
        not_dashed,
        dashed;

    }

    public static enum CustomColor {
        HIGHER_GROUND(new Color(0, 0, 0)),
        UNBUILDABLE(new Color(0, 0, 0)),
        TERRAIN(new Color(164, 164, 164)),
        SEA(new Color(0, 0, 192)),
        SEA_SIDE(new Color(0, 0, 100)),
        LAKE(new Color(0, 100, 200)),
        TINY_AREA(new Color(50, 50, 255)),
        CHOKE_POINTS_SHOW_AREAS(new Color(255, 255, 255)),
        CHOKE_POINTS_SHOW_CONTINENTS(new Color(0, 0, 0)),
        MINERALS(new Color(0, 255, 255)),
        GEYSERS(new Color(0, 255, 0)),
        STATIC_BUILDINGS(new Color(255, 0, 255)),
        BLOCKING_NEUTRALS(new Color(0, 0, 0)),
        STARTING_LOCATIONS(new Color(255, 255, 0)),
        BASES(new Color(0, 0, 255));

        private final Color color;

        private CustomColor(Color color) {
            this.color = color;
        }

        public Color color() {
            return this.color;
        }
    }
}

