/*
 * Decompiled with CFR 0.152.
 */
package bwem;

import bwem.Base;
import bwem.CheckMode;
import bwem.ChokePoint;
import bwem.ChokePointImpl;
import bwem.area.Area;
import bwem.area.AreaInitializer;
import bwem.area.AreaInitializerImpl;
import bwem.area.typedef.AreaId;
import bwem.area.typedef.GroupId;
import bwem.map.Map;
import bwem.map.TerrainData;
import bwem.tile.MiniTile;
import bwem.tile.Tile;
import bwem.tile.TileImpl;
import bwem.typedef.Altitude;
import bwem.typedef.CPPath;
import bwem.typedef.Index;
import bwem.unit.Geyser;
import bwem.unit.Mineral;
import bwem.unit.Neutral;
import bwem.unit.NeutralImpl;
import bwem.unit.StaticBuilding;
import bwem.util.BwemExt;
import bwem.util.Utils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import org.openbw.bwapi4j.Position;
import org.openbw.bwapi4j.TilePosition;
import org.openbw.bwapi4j.WalkPosition;
import org.openbw.bwapi4j.org.apache.commons.lang3.mutable.MutableInt;
import org.openbw.bwapi4j.org.apache.commons.lang3.tuple.MutablePair;
import org.openbw.bwapi4j.util.Pair;

public final class Graph {
    private final Map map;
    private final List<Area> areas = new ArrayList<Area>();
    private final List<ChokePoint> chokePoints = new ArrayList<ChokePoint>();
    private final List<List<List<ChokePoint>>> chokePointsMatrix = new ArrayList<List<List<ChokePoint>>>();
    private final List<List<Integer>> chokePointDistanceMatrix = new ArrayList<List<Integer>>();
    private final List<List<CPPath>> pathsBetweenChokePoints = new ArrayList<List<CPPath>>();
    private final List<Base> bases = new ArrayList<Base>();

    public Graph(Map map) {
        this.map = map;
    }

    public Map getMap() {
        return this.map;
    }

    public List<Area> getAreas() {
        return this.areas;
    }

    public int getAreaCount() {
        return this.areas.size();
    }

    public Area getArea(AreaId id) {
        if (!this.isValid(id)) {
            throw new IllegalArgumentException();
        }
        return this.areas.get(id.intValue() - 1);
    }

    public Area getArea(WalkPosition walkPosition) {
        AreaId areaId = this.getMap().getData().getMiniTile(walkPosition).getAreaId();
        return areaId.intValue() > 0 ? this.getArea(areaId) : null;
    }

    public Area getArea(TilePosition tilePosition) {
        AreaId areaId = this.getMap().getData().getTile(tilePosition).getAreaId();
        return areaId.intValue() > 0 ? this.getArea(areaId) : null;
    }

    public Area getNearestArea(WalkPosition walkPosition) {
        Area area = this.getArea(walkPosition);
        if (area != null) {
            return area;
        }
        WalkPosition w = this.getMap().breadthFirstSearch(walkPosition, args -> {
            Object ttile = args[0];
            if (ttile instanceof MiniTile) {
                MiniTile miniTile = (MiniTile)ttile;
                return miniTile.getAreaId().intValue() > 0;
            }
            throw new IllegalArgumentException();
        }, args -> true);
        return this.getArea(w);
    }

    public Area getNearestArea(TilePosition tilePosition) {
        Area area = this.getArea(tilePosition);
        if (area != null) {
            return area;
        }
        TilePosition t = this.getMap().breadthFirstSearch(tilePosition, args -> {
            Object ttile = args[0];
            if (ttile instanceof Tile) {
                Tile tile = (Tile)ttile;
                return tile.getAreaId().intValue() > 0;
            }
            throw new IllegalArgumentException();
        }, args -> true);
        return this.getArea(t);
    }

    public List<ChokePoint> getChokePoints() {
        return this.chokePoints;
    }

    public List<ChokePoint> getChokePoints(AreaId a, AreaId b) {
        int bVal;
        if (!this.isValid(a)) {
            throw new IllegalArgumentException();
        }
        if (!this.isValid(b)) {
            throw new IllegalArgumentException();
        }
        if (a.intValue() == b.intValue()) {
            throw new IllegalArgumentException();
        }
        int aVal = a.intValue();
        if (aVal > (bVal = b.intValue())) {
            int aValTmp = aVal;
            aVal = bVal;
            bVal = aValTmp;
        }
        return this.chokePointsMatrix.get(bVal).get(aVal);
    }

    public List<ChokePoint> getChokePoints(Area a, Area b) {
        return this.getChokePoints(a.getId(), b.getId());
    }

    public int distance(ChokePoint cpA, ChokePoint cpB) {
        return this.chokePointDistanceMatrix.get(((ChokePointImpl)cpA).getIndex().intValue()).get(((ChokePointImpl)cpB).getIndex().intValue());
    }

    public CPPath getPath(ChokePoint cpA, ChokePoint cpB) {
        return this.pathsBetweenChokePoints.get(((ChokePointImpl)cpA).getIndex().intValue()).get(((ChokePointImpl)cpB).getIndex().intValue());
    }

    public CPPath getPath(Position a, Position b, MutableInt pLength) {
        Area areaB;
        Area areaA = this.getNearestArea(a.toWalkPosition());
        if (areaA.equals(areaB = this.getNearestArea(b.toWalkPosition()))) {
            if (pLength != null) {
                pLength.setValue(BwemExt.getApproxDistance(a, b));
            }
            return new CPPath();
        }
        if (!areaA.isAccessibleFrom(areaB)) {
            if (pLength != null) {
                pLength.setValue(-1);
            }
            return new CPPath();
        }
        int minDistAB = Integer.MAX_VALUE;
        Object pBestCpA = null;
        ChokePoint pBestCpB = null;
        for (ChokePoint cpA : areaA.getChokePoints()) {
            if (cpA.isBlocked()) continue;
            int distACpA = BwemExt.getApproxDistance(a, cpA.getCenter().toPosition());
            for (ChokePoint cpB : areaB.getChokePoints()) {
                int distBToCPB;
                int distAToB;
                if (cpB.isBlocked() || (distAToB = distACpA + (distBToCPB = BwemExt.getApproxDistance(b, cpB.getCenter().toPosition())) + this.distance(cpA, cpB)) >= minDistAB) continue;
                minDistAB = distAToB;
                pBestCpA = cpA;
                pBestCpB = cpB;
            }
        }
        if (minDistAB == Integer.MAX_VALUE) {
            throw new IllegalStateException();
        }
        CPPath path = this.getPath((ChokePoint)pBestCpA, pBestCpB);
        if (pLength != null) {
            if (path.size() < 1) {
                throw new IllegalStateException();
            }
            pLength.setValue(minDistAB);
            if (path.size() == 1) {
                if (!pBestCpA.equals(pBestCpB)) {
                    throw new IllegalStateException();
                }
                Position cpEnd1 = BwemExt.center(pBestCpA.getNodePosition(ChokePoint.Node.END1));
                Position cpEnd2 = BwemExt.center(pBestCpA.getNodePosition(ChokePoint.Node.END2));
                if (Utils.intersect(a.getX(), a.getY(), b.getX(), b.getY(), cpEnd1.getX(), cpEnd1.getY(), cpEnd2.getX(), cpEnd2.getY())) {
                    pLength.setValue(BwemExt.getApproxDistance(a, b));
                } else {
                    for (ChokePoint.Node node : new ChokePoint.Node[]{ChokePoint.Node.END1, ChokePoint.Node.END2}) {
                        Position c = BwemExt.center(pBestCpA.getNodePosition(node));
                        int distAToB = BwemExt.getApproxDistance(a, c) + BwemExt.getApproxDistance(b, c);
                        if (distAToB >= pLength.intValue()) continue;
                        pLength.setValue(distAToB);
                    }
                }
            }
        }
        return this.getPath((ChokePoint)pBestCpA, pBestCpB);
    }

    public CPPath getPath(Position a, Position b) {
        return this.getPath(a, b, null);
    }

    public List<Base> getBases() {
        return this.bases;
    }

    public void createAreas(List<MutablePair<WalkPosition, Integer>> areasList) {
        for (int id = 1; id <= areasList.size(); ++id) {
            WalkPosition top = areasList.get(id - 1).getLeft();
            int miniTileCount = areasList.get(id - 1).getRight();
            this.areas.add(new AreaInitializerImpl(this.getMap(), new AreaId(id), top, miniTileCount));
        }
    }

    private void initializeChokePointsMatrix(List<List<List<ChokePoint>>> chokePointsMatrix, int areasCount) {
        chokePointsMatrix.clear();
        for (int i = 0; i < areasCount + 1; ++i) {
            chokePointsMatrix.add(new ArrayList());
        }
        for (int id = 1; id <= areasCount; ++id) {
            for (int n = 0; n < id; ++n) {
                chokePointsMatrix.get(id).add(new ArrayList());
            }
        }
    }

    private java.util.Map<MutablePair<AreaId, AreaId>, List<WalkPosition>> createRawFrontierByAreaPairMap(List<MutablePair<MutablePair<AreaId, AreaId>, WalkPosition>> rawFrontier) {
        HashMap<MutablePair<AreaId, AreaId>, List<WalkPosition>> rawFrontierByAreaPair = new HashMap<MutablePair<AreaId, AreaId>, List<WalkPosition>>();
        for (MutablePair<MutablePair<AreaId, AreaId>, WalkPosition> raw : rawFrontier) {
            int b;
            int a = raw.getLeft().getLeft().intValue();
            if (a > (b = raw.getLeft().getRight().intValue())) {
                int a_tmp = a;
                a = b;
                b = a_tmp;
            }
            if (a > b) {
                throw new IllegalStateException();
            }
            if (a < 1 || b > this.getAreaCount()) {
                throw new IllegalStateException();
            }
            MutablePair<AreaId, AreaId> key = new MutablePair<AreaId, AreaId>(new AreaId(a), new AreaId(b));
            rawFrontierByAreaPair.computeIfAbsent(key, mp -> new ArrayList()).add(raw.getRight());
        }
        return rawFrontierByAreaPair;
    }

    /*
     * WARNING - void declaration
     */
    public void createChokePoints(List<StaticBuilding> staticBuildings, List<Mineral> minerals, List<MutablePair<MutablePair<AreaId, AreaId>, WalkPosition>> rawFrontier) {
        void var7_13;
        Iterator<Object> iterator;
        Index newIndex = new Index(0);
        ArrayList<NeutralImpl> blockingNeutrals = new ArrayList<NeutralImpl>();
        for (StaticBuilding staticBuilding : staticBuildings) {
            if (!staticBuilding.isBlocking()) continue;
            blockingNeutrals.add(staticBuilding);
        }
        for (Mineral mineral : minerals) {
            if (!mineral.isBlocking()) continue;
            blockingNeutrals.add(mineral);
        }
        this.initializeChokePointsMatrix(this.chokePointsMatrix, this.getAreaCount());
        java.util.Map<MutablePair<AreaId, AreaId>, List<WalkPosition>> rawFrontierByAreaPair = this.createRawFrontierByAreaPairMap(rawFrontier);
        for (Map.Entry<MutablePair<AreaId, AreaId>, List<WalkPosition>> entry : rawFrontierByAreaPair.entrySet()) {
            MutablePair<AreaId, AreaId> rawleft = entry.getKey();
            List<WalkPosition> rawFrontierAB = entry.getValue();
            ArrayList<Altitude> altitudes = new ArrayList<Altitude>();
            iterator = rawFrontierAB.iterator();
            while (iterator.hasNext()) {
                WalkPosition w = iterator.next();
                altitudes.add(this.getMap().getData().getMiniTile(w).getAltitude());
            }
            for (int i = 1; i < altitudes.size(); ++i) {
                int curr;
                int prev = ((Altitude)altitudes.get(i - 1)).intValue();
                if (prev >= (curr = ((Altitude)altitudes.get(i)).intValue())) continue;
                throw new IllegalStateException();
            }
            int clusterMinDist = (int)Math.sqrt(300.0);
            ArrayList clusters = new ArrayList();
            Iterator prev = rawFrontierAB.iterator();
            while (prev.hasNext()) {
                WalkPosition w = (WalkPosition)prev.next();
                boolean added = false;
                for (List list : clusters) {
                    int distToBack;
                    int distToFront = BwemExt.queenWiseDist((WalkPosition)list.get(0), w);
                    if (Math.min(distToFront, distToBack = BwemExt.queenWiseDist((WalkPosition)list.get(list.size() - 1), w)) > clusterMinDist) continue;
                    if (distToFront < distToBack) {
                        list.add(0, w);
                    } else {
                        list.add(w);
                    }
                    added = true;
                    break;
                }
                if (added) continue;
                ArrayList<WalkPosition> arrayList = new ArrayList<WalkPosition>();
                arrayList.add(w);
                clusters.add(arrayList);
            }
            AreaId a = rawleft.getLeft();
            AreaId b = rawleft.getRight();
            for (List list : clusters) {
                this.getChokePoints(a, b).add(new ChokePointImpl(this, newIndex, this.getArea(a), this.getArea(b), list));
                newIndex = newIndex.add(1);
            }
        }
        for (Neutral neutral : blockingNeutrals) {
            if (neutral.getNextStacked() != null) continue;
            List<Area> blockedAreas = neutral.getBlockedAreas();
            for (Area blockedAreaA : blockedAreas) {
                Area blockedAreaB;
                iterator = blockedAreas.iterator();
                while (iterator.hasNext() && !(blockedAreaB = (Area)iterator.next()).equals(blockedAreaA)) {
                    WalkPosition center = this.getMap().breadthFirstSearch(neutral.getCenter().toWalkPosition(), args -> {
                        Object ttile = args[0];
                        if (!(ttile instanceof MiniTile)) {
                            throw new IllegalArgumentException();
                        }
                        MiniTile miniTile = (MiniTile)ttile;
                        return miniTile.isWalkable();
                    }, args -> true);
                    ArrayList<WalkPosition> list = new ArrayList<WalkPosition>();
                    list.add(center);
                    this.getChokePoints(blockedAreaA, blockedAreaB).add(new ChokePointImpl(this, newIndex, blockedAreaA, blockedAreaB, list, neutral));
                    newIndex = newIndex.add(1);
                }
            }
        }
        boolean bl = true;
        while (var7_13 <= this.getAreaCount()) {
            void var8_18;
            boolean bl2 = true;
            while (var8_18 < var7_13) {
                AreaId a = new AreaId((int)var7_13);
                AreaId b = new AreaId((int)var8_18);
                if (!this.getChokePoints(a, b).isEmpty()) {
                    ((AreaInitializer)((Object)this.getArea(a))).addChokePoints(this.getArea(b), this.getChokePoints(a, b));
                    ((AreaInitializer)((Object)this.getArea(b))).addChokePoints(this.getArea(a), this.getChokePoints(a, b));
                    this.chokePoints.addAll(this.getChokePoints(a, b));
                }
                ++var8_18;
            }
            ++var7_13;
        }
    }

    public void computeChokePointDistanceMatrix() {
        int n;
        int i;
        this.chokePointDistanceMatrix.clear();
        for (i = 0; i < this.chokePoints.size(); ++i) {
            this.chokePointDistanceMatrix.add(new ArrayList());
        }
        for (i = 0; i < this.chokePointDistanceMatrix.size(); ++i) {
            for (n = 0; n < this.chokePoints.size(); ++n) {
                this.chokePointDistanceMatrix.get(i).add(-1);
            }
        }
        this.pathsBetweenChokePoints.clear();
        for (i = 0; i < this.chokePoints.size(); ++i) {
            this.pathsBetweenChokePoints.add(new ArrayList());
        }
        for (i = 0; i < this.pathsBetweenChokePoints.size(); ++i) {
            for (n = 0; n < this.chokePoints.size(); ++n) {
                this.pathsBetweenChokePoints.get(i).add(new CPPath());
            }
        }
        for (Area area : this.getAreas()) {
            this.computeChokePointDistances(area);
        }
        this.computeChokePointDistances(this);
        for (ChokePoint cp : this.getChokePoints()) {
            this.setDistance(cp, cp, 0);
            CPPath cppath = new CPPath();
            cppath.add(cp);
            this.setPath(cp, cp, cppath);
        }
        for (Area area : this.getAreas()) {
            ((AreaInitializer)((Object)area)).updateAccessibleNeighbors();
        }
        this.updateGroupIds();
    }

    public void collectInformation() {
        Area area;
        for (Mineral mineral : this.getMap().getNeutralData().getMinerals()) {
            area = this.getMap().getMainArea(mineral.getTopLeft(), mineral.getSize());
            if (area == null) continue;
            ((AreaInitializer)((Object)area)).addMineral(mineral);
        }
        for (Geyser geyser : this.getMap().getNeutralData().getGeysers()) {
            area = this.getMap().getMainArea(geyser.getTopLeft(), geyser.getSize());
            if (area == null) continue;
            ((AreaInitializer)((Object)area)).addGeyser(geyser);
        }
        for (int y = 0; y < this.getMap().getData().getMapData().getTileSize().getY(); ++y) {
            for (int x = 0; x < this.getMap().getData().getMapData().getTileSize().getX(); ++x) {
                Tile tile = this.getMap().getData().getTile(new TilePosition(x, y));
                if (tile.getAreaId().intValue() <= 0) continue;
                ((AreaInitializer)((Object)this.getArea(tile.getAreaId()))).addTileInformation(new TilePosition(x, y), tile);
            }
        }
        for (Area area2 : this.areas) {
            ((AreaInitializer)((Object)area2)).postCollectInformation();
        }
    }

    public void createBases(TerrainData terrainData) {
        this.bases.clear();
        for (Area area : this.areas) {
            ((AreaInitializer)((Object)area)).createBases(terrainData);
            this.bases.addAll(area.getBases());
        }
    }

    private void computeChokePointDistances(Area pContext) {
        for (ChokePoint pStart : pContext.getChokePoints()) {
            ArrayList<ChokePoint> targets = new ArrayList<ChokePoint>();
            for (ChokePoint cp : pContext.getChokePoints()) {
                if (cp.equals(pStart)) break;
                targets.add(cp);
            }
            int[] distanceToTargets = ((AreaInitializer)((Object)pContext)).computeDistances(pStart, targets);
            this.setPathForComputeChokePointDistances(distanceToTargets, pStart, targets, false);
        }
    }

    private void computeChokePointDistances(Graph pContext) {
        for (ChokePoint pStart : pContext.getChokePoints()) {
            ArrayList<ChokePoint> targets = new ArrayList<ChokePoint>();
            for (ChokePoint cp : pContext.getChokePoints()) {
                if (cp.equals(pStart)) break;
                targets.add(cp);
            }
            int[] distanceToTargets = pContext.computeDistances(pStart, targets);
            this.setPathForComputeChokePointDistances(distanceToTargets, pStart, targets, true);
        }
    }

    private void setPathForComputeChokePointDistances(int[] distanceToTargets, ChokePoint pStart, List<ChokePoint> targets, boolean collectIntermediateChokePoints) {
        for (int i = 0; i < targets.size(); ++i) {
            int newDist = distanceToTargets[i];
            ChokePoint target = targets.get(i);
            int existingDist = this.distance(pStart, target);
            if (newDist == 0 || existingDist != -1 && newDist >= existingDist) continue;
            this.setDistance(pStart, target, newDist);
            CPPath path = new CPPath();
            path.add(pStart);
            path.add(target);
            if (collectIntermediateChokePoints) {
                ChokePoint pPrev = ((ChokePointImpl)target).getPathBackTrace();
                while (!pPrev.equals(pStart)) {
                    path.add(1, pPrev);
                    pPrev = ((ChokePointImpl)pPrev).getPathBackTrace();
                }
            }
            this.setPath(pStart, target, path);
        }
    }

    private int[] computeDistances(ChokePoint start, List<ChokePoint> targets) {
        int[] distances = new int[targets.size()];
        TileImpl.getStaticMarkable().unmarkAll();
        PriorityQueue<Pair> toVisit = new PriorityQueue<Pair>(Comparator.comparingInt(a -> (Integer)a.getFirst()));
        toVisit.offer(new Pair<Integer, ChokePoint>(0, start));
        int remainingTargets = targets.size();
        while (!toVisit.isEmpty()) {
            Pair distanceAndChokePoint = (Pair)toVisit.poll();
            int currentDist = (Integer)distanceAndChokePoint.getFirst();
            ChokePoint current = (ChokePoint)distanceAndChokePoint.getSecond();
            Tile currentTile = this.getMap().getData().getTile(current.getCenter().toTilePosition(), CheckMode.NO_CHECK);
            if (((TileImpl)currentTile).getInternalData() != currentDist) {
                throw new IllegalStateException();
            }
            ((TileImpl)currentTile).setInternalData(0);
            ((TileImpl)currentTile).getMarkable().setMarked();
            for (int i = 0; i < targets.size(); ++i) {
                if (current != targets.get(i)) continue;
                distances[i] = currentDist;
                --remainingTargets;
            }
            if (remainingTargets == 0) break;
            if (current.isBlocked() && !current.equals(start)) continue;
            for (Area pArea : new Area[]{current.getAreas().getFirst(), current.getAreas().getSecond()}) {
                for (ChokePoint next : pArea.getChokePoints()) {
                    if (next.equals(current)) continue;
                    int newNextDist = currentDist + this.distance(current, next);
                    Tile nextTile = this.getMap().getData().getTile(next.getCenter().toTilePosition(), CheckMode.NO_CHECK);
                    if (((TileImpl)nextTile).getMarkable().isMarked()) continue;
                    if (((TileImpl)nextTile).getInternalData() != 0) {
                        if (newNextDist >= ((TileImpl)nextTile).getInternalData()) continue;
                        boolean removed = toVisit.remove(new Pair<Integer, ChokePoint>(((TileImpl)nextTile).getInternalData(), next));
                        if (!removed) {
                            throw new IllegalStateException();
                        }
                        ((TileImpl)nextTile).setInternalData(newNextDist);
                        ((ChokePointImpl)next).setPathBackTrace(current);
                        toVisit.offer(new Pair<Integer, ChokePoint>(newNextDist, next));
                        continue;
                    }
                    ((TileImpl)nextTile).setInternalData(newNextDist);
                    ((ChokePointImpl)next).setPathBackTrace(current);
                    toVisit.offer(new Pair<Integer, ChokePoint>(newNextDist, next));
                }
            }
        }
        for (Pair distanceToChokePoint : toVisit) {
            ((TileImpl)this.getMap().getData().getTile(((ChokePoint)distanceToChokePoint.getSecond()).getCenter().toTilePosition(), CheckMode.NO_CHECK)).setInternalData(0);
        }
        return distances;
    }

    private void updateGroupIds() {
        int nextGroupId = 1;
        AreaInitializerImpl.getStaticMarkable().unmarkAll();
        for (Area start : this.getAreas()) {
            if (((AreaInitializer)((Object)start)).getMarkable().isMarked()) continue;
            ArrayList<Area> toVisit = new ArrayList<Area>();
            toVisit.add(start);
            while (!toVisit.isEmpty()) {
                Area current = (Area)toVisit.remove(toVisit.size() - 1);
                ((AreaInitializer)((Object)current)).setGroupId(new GroupId(nextGroupId));
                for (Area next : current.getAccessibleNeighbors()) {
                    if (((AreaInitializer)((Object)next)).getMarkable().isMarked()) continue;
                    ((AreaInitializer)((Object)next)).getMarkable().setMarked();
                    toVisit.add(next);
                }
            }
            ++nextGroupId;
        }
    }

    private void setDistance(ChokePoint cpA, ChokePoint cpB, int value) {
        int indexA = ((ChokePointImpl)cpA).getIndex().intValue();
        int indexB = ((ChokePointImpl)cpB).getIndex().intValue();
        this.chokePointDistanceMatrix.get(indexA).set(indexB, value);
        this.chokePointDistanceMatrix.get(indexB).set(indexA, value);
    }

    private void setPath(ChokePoint cpA, ChokePoint cpB, CPPath pathAB) {
        int indexA = ((ChokePointImpl)cpA).getIndex().intValue();
        int indexB = ((ChokePointImpl)cpB).getIndex().intValue();
        this.pathsBetweenChokePoints.get(indexA).set(indexB, pathAB);
        if (cpA != cpB) {
            CPPath reversePath = this.pathsBetweenChokePoints.get(indexB).get(indexA);
            reversePath.clear();
            for (int i = pathAB.size() - 1; i >= 0; --i) {
                ChokePoint cp = pathAB.get(i);
                reversePath.add(cp);
            }
        }
    }

    private boolean isValid(AreaId id) {
        return 1 <= id.intValue() && id.intValue() <= this.getAreaCount();
    }
}

