/*
 * Decompiled with CFR 0.152.
 */
package bwem;

import bwem.CheckMode;
import bwem.ChokePoint;
import bwem.Graph;
import bwem.area.Area;
import bwem.map.Map;
import bwem.tile.MiniTile;
import bwem.tile.MiniTileImpl;
import bwem.typedef.CPPath;
import bwem.typedef.Index;
import bwem.unit.Neutral;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.openbw.bwapi4j.WalkPosition;
import org.openbw.bwapi4j.org.apache.commons.lang3.tuple.MutablePair;
import org.openbw.bwapi4j.util.Pair;

public class ChokePointImpl
implements ChokePoint {
    private final Graph graph;
    private final boolean isPseudo;
    private final Index index;
    private final Pair<Area, Area> areas;
    private final WalkPosition[] nodes;
    private final List<MutablePair<WalkPosition, WalkPosition>> nodesInArea;
    private final List<WalkPosition> geometry;
    private boolean isBlocked;
    private Neutral blockingNeutral;
    private ChokePoint pathBackTrace = null;

    public ChokePointImpl(Graph graph, Index index, Area area1, Area area2, List<WalkPosition> geometry, Neutral blockingNeutral) {
        int i;
        if (geometry.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.graph = graph;
        this.index = index;
        this.areas = new Pair<Area, Area>(area1, area2);
        this.geometry = geometry;
        this.blockingNeutral = blockingNeutral != null ? this.getMap().getData().getTile(blockingNeutral.getTopLeft()).getNeutral() : blockingNeutral;
        this.isPseudo = this.isBlocked = blockingNeutral != null;
        this.nodes = new WalkPosition[ChokePoint.Node.NODE_COUNT.ordinal()];
        this.nodes[ChokePoint.Node.END1.ordinal()] = geometry.get(0);
        this.nodes[ChokePoint.Node.END2.ordinal()] = geometry.get(geometry.size() - 1);
        this.nodesInArea = new ArrayList<MutablePair<WalkPosition, WalkPosition>>(ChokePoint.Node.NODE_COUNT.ordinal());
        for (i = 0; i < ChokePoint.Node.NODE_COUNT.ordinal(); ++i) {
            this.nodesInArea.add(new MutablePair<WalkPosition, WalkPosition>(new WalkPosition(0, 0), new WalkPosition(0, 0)));
        }
        for (i = geometry.size() / 2; i > 0 && this.getMap().getData().getMiniTile(geometry.get(i - 1)).getAltitude().intValue() > this.getMap().getData().getMiniTile(geometry.get(i)).getAltitude().intValue(); --i) {
        }
        while (i < geometry.size() - 1 && this.getMap().getData().getMiniTile(geometry.get(i + 1)).getAltitude().intValue() > this.getMap().getData().getMiniTile(geometry.get(i)).getAltitude().intValue()) {
            ++i;
        }
        this.nodes[ChokePoint.Node.MIDDLE.ordinal()] = geometry.get(i);
        for (int n = 0; n < ChokePoint.Node.NODE_COUNT.ordinal(); ++n) {
            for (Area area : new Area[]{area1, area2}) {
                WalkPosition nodeInArea = this.getGraph().getMap().breadthFirstSearch(this.nodes[n], args -> {
                    Object ttile = args[0];
                    Object tpos = args[1];
                    Object tmap = args[args.length - 1];
                    if (ttile instanceof MiniTile && tpos instanceof WalkPosition && tmap instanceof Map) {
                        MiniTile miniTile = (MiniTile)ttile;
                        WalkPosition w = (WalkPosition)tpos;
                        Map map = (Map)tmap;
                        return miniTile.getAreaId().equals(area.getId()) && map.getData().getTile(w.toTilePosition(), CheckMode.NO_CHECK).getNeutral() == null;
                    }
                    throw new IllegalArgumentException();
                }, args -> {
                    Object ttile = args[0];
                    Object tpos = args[1];
                    Object tmap = args[args.length - 1];
                    if (ttile instanceof MiniTile && tpos instanceof WalkPosition) {
                        MiniTile miniTile = (MiniTile)ttile;
                        WalkPosition w = (WalkPosition)tpos;
                        Map map = (Map)tmap;
                        return miniTile.getAreaId().equals(area.getId()) || this.isBlocked() && (((MiniTileImpl)miniTile).isBlocked() || map.getData().getTile(w.toTilePosition(), CheckMode.NO_CHECK).getNeutral() != null);
                    }
                    throw new IllegalArgumentException("Invalid argument list.");
                });
                WalkPosition left = this.nodesInArea.get(n).getLeft();
                WalkPosition right = this.nodesInArea.get(n).getRight();
                MutablePair<WalkPosition, WalkPosition> replacementPair = new MutablePair<WalkPosition, WalkPosition>(left, right);
                if (area.equals(this.areas.getFirst())) {
                    replacementPair.setLeft(nodeInArea);
                } else {
                    replacementPair.setRight(nodeInArea);
                }
                this.nodesInArea.set(n, replacementPair);
            }
        }
    }

    public ChokePointImpl(Graph graph, Index index, Area area1, Area area2, List<WalkPosition> geometry) {
        this(graph, index, area1, area2, geometry, null);
    }

    private Map getMap() {
        return this.graph.getMap();
    }

    private Graph getGraph() {
        return this.graph;
    }

    @Override
    public boolean isPseudo() {
        return this.isPseudo;
    }

    @Override
    public Pair<Area, Area> getAreas() {
        return this.areas;
    }

    @Override
    public WalkPosition getCenter() {
        return this.getNodePosition(ChokePoint.Node.MIDDLE);
    }

    @Override
    public WalkPosition getNodePosition(ChokePoint.Node node) {
        if (node.ordinal() >= ChokePoint.Node.NODE_COUNT.ordinal()) {
            throw new IllegalArgumentException();
        }
        return this.nodes[node.ordinal()];
    }

    @Override
    public WalkPosition getNodePositionInArea(ChokePoint.Node node, Area area) {
        if (!area.equals(this.areas.getFirst()) && !area.equals(this.areas.getSecond())) {
            throw new IllegalArgumentException();
        }
        return area.equals(this.areas.getFirst()) ? this.nodesInArea.get(node.ordinal()).getLeft() : this.nodesInArea.get(node.ordinal()).getRight();
    }

    @Override
    public List<WalkPosition> getGeometry() {
        return this.geometry;
    }

    @Override
    public boolean isBlocked() {
        return this.isBlocked;
    }

    @Override
    public Neutral getBlockingNeutral() {
        return this.blockingNeutral;
    }

    @Override
    public int distanceFrom(ChokePoint chokePoint) {
        return this.getGraph().distance(this, chokePoint);
    }

    @Override
    public boolean accessibleFrom(ChokePoint chokePoint) {
        return this.distanceFrom(chokePoint) >= 0;
    }

    @Override
    public CPPath getPathTo(ChokePoint cp) {
        return this.getGraph().getPath(this, cp);
    }

    public void onBlockingNeutralDestroyed(Neutral pBlocking) {
        if (pBlocking == null || !pBlocking.isBlocking()) {
            throw new IllegalStateException();
        }
        if (this.blockingNeutral.equals(pBlocking)) {
            this.blockingNeutral = this.getMap().getData().getTile(this.blockingNeutral.getTopLeft()).getNeutral();
            if (this.blockingNeutral == null && this.getGraph().getMap().automaticPathUpdate()) {
                this.isBlocked = false;
            }
        }
    }

    public Index getIndex() {
        return this.index;
    }

    public ChokePoint getPathBackTrace() {
        return this.pathBackTrace;
    }

    public void setPathBackTrace(ChokePoint pathBackTrace) {
        this.pathBackTrace = pathBackTrace;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ChokePointImpl)) {
            return false;
        }
        ChokePointImpl that = (ChokePointImpl)object;
        boolean lel = this.areas.getFirst().equals(that.areas.getFirst());
        boolean ler = this.areas.getFirst().equals(that.areas.getSecond());
        boolean rer = this.areas.getSecond().equals(that.areas.getSecond());
        boolean rel = this.areas.getSecond().equals(that.areas.getFirst());
        return lel && rer || ler && rel;
    }

    public int hashCode() {
        int idRight;
        int idLeft = this.areas.getFirst().getId().intValue();
        if (idLeft > (idRight = this.areas.getSecond().getId().intValue())) {
            int idLeftTmp = idLeft;
            idLeft = idRight;
            idRight = idLeftTmp;
        }
        return Objects.hash(idLeft, idRight);
    }
}

