/*
 * Decompiled with CFR 0.152.
 */
package bwem;

import bwem.Base;
import bwem.area.Area;
import bwem.unit.Geyser;
import bwem.unit.Mineral;
import bwem.unit.Resource;
import bwem.util.BwemExt;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.openbw.bwapi4j.Position;
import org.openbw.bwapi4j.TilePosition;
import org.openbw.bwapi4j.type.UnitType;

public class BaseImpl
implements Base {
    private final Area area;
    private TilePosition location;
    private Position center;
    private final List<Mineral> minerals = new ArrayList<Mineral>();
    private final List<Geyser> geysers = new ArrayList<Geyser>();
    private final List<Mineral> blockingMinerals;
    private boolean isStartingLocation = false;

    public BaseImpl(Area area, TilePosition location, List<Resource> assignedResources, List<Mineral> blockingMinerals) {
        this.area = area;
        this.location = location;
        this.center = BwemExt.centerOfBuilding(location, UnitType.Terran_Command_Center.tileSize());
        this.blockingMinerals = blockingMinerals;
        if (assignedResources.isEmpty()) {
            throw new IllegalArgumentException();
        }
        for (Resource assignedResource : assignedResources) {
            if (assignedResource instanceof Mineral) {
                Mineral assignedMineral = (Mineral)assignedResource;
                this.minerals.add(assignedMineral);
                continue;
            }
            if (!(assignedResource instanceof Geyser)) continue;
            Geyser assignedGeyser = (Geyser)assignedResource;
            this.geysers.add(assignedGeyser);
        }
    }

    @Override
    public boolean isStartingLocation() {
        return this.isStartingLocation;
    }

    @Override
    public Area getArea() {
        return this.area;
    }

    @Override
    public TilePosition getLocation() {
        return this.location;
    }

    @Override
    public Position getCenter() {
        return this.center;
    }

    @Override
    public List<Mineral> getMinerals() {
        return this.minerals;
    }

    @Override
    public List<Geyser> getGeysers() {
        return this.geysers;
    }

    @Override
    public List<Mineral> getBlockingMinerals() {
        return this.blockingMinerals;
    }

    public void assignStartingLocation(TilePosition actualLocation) {
        this.isStartingLocation = true;
        this.location = actualLocation;
        this.center = BwemExt.centerOfBuilding(actualLocation, UnitType.Terran_Command_Center.tileSize());
    }

    public void onMineralDestroyed(Mineral mineral) {
        if (mineral == null) {
            throw new IllegalArgumentException();
        }
        this.minerals.remove(mineral);
        this.blockingMinerals.remove(mineral);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Base)) {
            return false;
        }
        Base that = (Base)object;
        return this.getArea().equals(that.getArea()) && this.getLocation().equals(that.getLocation()) && this.getCenter().equals(that.getCenter());
    }

    public int hashCode() {
        return Objects.hash(this.area, this.location, this.center);
    }
}

