#pragma once

#include <BWAPI.h>
#include "CUNYAIModule.h"
#include "Resource_Inventory.h"
#include "InventoryManager.h"
#include "Reservation_Manager.h"
#include "Research_Inventory.h"
#include "FAP\FAP\include\FAP.hpp"

using namespace std;
using namespace BWAPI;

// Two dependent structures for this inventory manager, a container of enemy_units and enemy units itself. Intend to add more funtionality to Enemy_Inventory, such as upgrades, etc.  May revisit when I learn about parentage, but ought to function for now.
struct Inventory;
struct Reservation;

struct Stored_Unit {

    //Creates a steryotyped ideal of the unit. For comparisons.
    Stored_Unit( const UnitType &unittype );
    // Creates an enemy unit object, an abbreviated version of the original.
    Stored_Unit( const Unit &unit );
    Stored_Unit();
    auto convertToFAP(const Research_Inventory &ri); // puts stored unit into the fap type.
    auto convertToFAPPosition(const Position &chosen_pos, const Research_Inventory &ri); // puts the stored unit into the fap type... at a specific position

    static void updateFAPvalue(FAP::FAPUnit<Stored_Unit*> &fap_unit); //updates a single unit's fap forecast when given the fap unit.
    void updateFAPvalueDead(); //Updates the unit in the case of it not surviving the FAP simulation.

    static bool unitAliveinFuture(const Stored_Unit &unit, const int & number_of_frames_in_future); // returns true if the unit has a MA forcast that implies it will be alive in X frames.

    void updateStoredUnit(const Unit &unit);

    // Critical information not otherwise stored.
    UnitType type_;
    UnitType build_type_;
    Position pos_; // in pixels
	Unit locked_mine_;

    // Unit Orders
    Order order_;
    UnitCommand command_;
    int time_since_last_command_; // note command != orders.
    int time_of_last_purge_; //test

    //Unit Movement Information;
    Position attract_;
    Position seperation_;
    Position retreat_;
    Position cohesion_;
    unsigned int health_;
    unsigned int shields_;
    bool is_flying_;
    unsigned int elevation_;
    unsigned int cd_remaining_;
    bool stimmed_;
    bool updated_fap_this_frame_;

    string phase_ = "None";

    //Needed commands for workers.
	void startMine(Stored_Resource &new_resource, Resource_Inventory &ri);
	void stopMine(Resource_Inventory &ri);
    Stored_Resource * getMine(Resource_Inventory & ri);
    bool isAssignedClearing( Resource_Inventory &ri);  // If the unit is clearing a spot.
    bool isAssignedLongDistanceMining(Resource_Inventory & ri);
    bool isAssignedMining(Resource_Inventory & ri); // If the unit is assigned to mine a spot.
    bool isAssignedGas(Resource_Inventory & ri); // If the unit is assigned to mine gas.
    bool isAssignedResource(Resource_Inventory  &ri);
    bool isAssignedBuilding(Resource_Inventory  &ri); // If the unit is assigned to build something.
    bool isBrokenLock(Resource_Inventory & ri); // If the unit has been distracted somehow.
    bool isLocallyLocked(Resource_Inventory & ri); // If the unit is properly attached.
    bool isNoLock(); // If the unit has no target. May be broken.
    bool isLongRangeLock(Resource_Inventory & ri); // if the unit cannot see its target.
    bool isMovingLock(Resource_Inventory & ri); // if the unit is moving towards its target not gathering.

    int current_hp_;
    bool valid_pos_; // good suggestion by Hannes Brandenburg. Know to alter unit data when we see that they are not present.
    int unit_ID_;

    // evaluates the value of a stock of specific unit, in terms of pythagorian distance of min & gas & supply. Doesn't consider the counterfactual larva. Is set to considers the unit's condition. BWAPI measures supply in half units. 
    int current_stock_value_; // Precalculated, precached.
    int stock_value_; // Precalculated, precached.
    int future_fap_value_; // only taken from fap.
    int ma_future_fap_value_; // A moving average of FAP values.
    bool hasTarget_;

    int velocity_x_;
    int velocity_y_;
    int circumference_;
    int circumference_remaining_;

    Unit bwapi_unit_;

};

struct Unit_Inventory {

    //Creates an instance of the Unit inventory class.
    Unit_Inventory();
    Unit_Inventory( const Unitset &unit_set );

    //what about their upgrades?
    //Other details?

    int stock_fliers_;
    int stock_ground_units_;
    int stock_both_up_and_down_;
    int stock_shoots_up_;
    int stock_shoots_down_;
    int stock_high_ground_;
    int stock_fighting_total_;
    int stock_ground_fodder_;
    int stock_air_fodder_;
    int stock_total_;
    int stock_full_health_;
    int max_range_;
    int max_cooldown_;
	int worker_count_;
	int volume_;
    int detector_count_;
    int cloaker_count_;
    int resource_depot_count_;
    int future_fap_stock_;
    int moving_average_fap_stock_;
    int is_shooting_;
    int is_attacking_;
    int is_retreating_;
	std::map <Unit, Stored_Unit> unit_inventory_;

    // Updates the count of units.
    void addStored_Unit( const Unit &unit );
    void addStored_Unit( const Stored_Unit &stored_unit );

    //Removes units
    void removeStored_Unit( Unit unit );

    //Updates summary of inventory, stored here.
    void updateUnitInventorySummary();
	void updateUnitInventory(const Unitset &unit_set);
    void updateUnitsControlledBy(const Player & Player);
    void purgeBrokenUnits();
    void purgeUnseenUnits(); //drops all unseen units. Useful to make sure you don't have dead units in your own inventory.
    void purgeWorkerRelations(const Unit &unit, Resource_Inventory &ri, Inventory &inv, Reservation &res);
    void purgeWorkerRelationsNoStop(const Unit & unit, Resource_Inventory & ri, Inventory & inv, Reservation & res);
    void drawAllVelocities(const Inventory &inv) const; // sometimes causes a lag-out or a crash. Unclear why.
    void drawAllHitPoints(const Inventory & inv) const;
    void drawAllMAFAPaverages(const Inventory & inv) const;
    void drawAllSpamGuards(const Inventory & inv) const;
    void drawAllWorkerTasks(const Inventory & inv, Resource_Inventory &ri) const;
    void drawAllLocations(const Inventory &inv) const;

    bool squadAliveinFuture(const int & number_of_frames_in_future) const;



    void addToFAPatPos(FAP::FastAPproximation<Stored_Unit*>& fap_object, const Position pos, const bool friendly, const Research_Inventory &ri); // adds to buildFAP
    void addToMCFAP(FAP::FastAPproximation<Stored_Unit*>& fap_object, const bool friendly, const Research_Inventory & ri); // adds to MC fap.
    void addToBuildFAP(FAP::FastAPproximation<Stored_Unit*>& fap_object, const bool friendly, const Research_Inventory & ri);// adds to the building combat simulator, friendly side.


    void pullFromFAP(vector<FAP::FAPUnit<Stored_Unit*>> &FAPunits); // updates UI with FAP forecasts. Throws exceptions if something is misaligned.

    // Pass pointers
    Stored_Unit* getStoredUnit(const Unit &unit);
    // Passing values for const-safety.
    Stored_Unit getStoredUnitValue(const Unit & unit) const;

    Position getMeanLocation() const;
    Position getMeanBuildingLocation() const;
    Position getMeanAirLocation() const;
    Position getStrongestLocation() const; //in progress
    Position getMeanCombatLocation() const;
    Position getMeanArmyLocation() const;
    //Position getClosestMeanArmyLocation() const;

    void stopMine(Unit u, Resource_Inventory & ri);
    friend Unit_Inventory operator + (const Unit_Inventory & lhs, const Unit_Inventory& rhs);
    friend Unit_Inventory operator - (const Unit_Inventory & lhs, const Unit_Inventory& rhs);
    Unit_Inventory(Unit_Inventory const &) = default;

};

Position positionMCFAP(const Stored_Unit & su);
Position positionBuildFap(bool friendly);


