#include "OverlordManager.h"
#include "OverlordData.h"
using namespace CDBot;
OverlordManager::OverlordManager()
{
	ScoutOverlord = nullptr;
	TheFirstOverorldAtBegin = true;
}
OverlordManager & OverlordManager::Instance()
{
	static OverlordManager instance;
	return instance;
}
void OverlordManager::update()
{
	CheckFirstOverlord();
	HandleEscapeOverLord();
	HandleMoveOverLord();
	HandleScoutOverLord();
	//HandleTransportOverLord();
}
void OverlordManager::CheckFirstOverlord()
{
	if (ScoutOverlord==nullptr && TheFirstOverorldAtBegin == true){
		for (const auto MyUnit : BWAPI::Broodwar->self()->getUnits())
		{
			if (MyUnit->getType() == BWAPI::UnitTypes::Zerg_Overlord)
			{
				overlordData.AddOverlord(MyUnit);
				SetScoutOverlord(MyUnit);
				TheFirstOverorldAtBegin = false;
				return;
			}
		}
	}
	return;
}
void OverlordManager::OnUnitDestroyed(BWAPI::Unit unit)
{
	overlordData.OverlordDestroyed(unit);
	if (overlordData.GetOverlordJob(unit) == OverlordData::Scout)
	{
		ScoutOverlord = nullptr;
	}
}
void  OverlordManager::OnUnitMorph(BWAPI::Unit unit)
{
	UAB_ASSERT(unit != nullptr, "Unit was null");
	overlordData.AddOverlord(unit);
	if (ScoutOverlord == nullptr)
	{
		SetScoutOverlord(unit);
	}
	else 
	{
		SetMoveOverlord(unit);
	}
}
void OverlordManager::SetMoveOverlord(BWAPI::Unit unit)
{
	overlordData.SetOverlordJob(unit, OverlordData::Move, nullptr);
}
void OverlordManager::SetEscapeOverlord(BWAPI::Unit unit)
{
	overlordData.SetOverlordJob(unit, OverlordData::Escape, nullptr);
}
void OverlordManager::SetScoutOverlord(BWAPI::Unit unit)
{
	ScoutOverlord = unit;
	overlordData.SetOverlordJob(unit, OverlordData::Scout, nullptr);
}
void OverlordManager::SetTransportOverlord(BWAPI::Unit unit)
{
	overlordData.SetOverlordJob(unit, OverlordData::Transport, nullptr);
}
void OverlordManager::StopScoutOverlord(BWAPI::Unit unit)
{
	overlordData.SetOverlordJob(unit, OverlordData::Default, nullptr);
}
void OverlordManager::StopTransportOverlord(BWAPI::Unit unit)
{
	overlordData.SetOverlordJob(unit, OverlordData::Default, nullptr);
}
void OverlordManager::HandleMoveOverLord()
{
	for (const auto overlord : overlordData.getOverlords())
	{
		UAB_ASSERT(overlord != nullptr, "MoveOverlord was null");
		if (overlordData.GetOverlordJob(overlord) == OverlordData::Move)
		{
			if (overlord->isUnderAttack() || CheckAirDefence(overlord))
			{
				SetEscapeOverlord(overlord);
				return;
			}
			//else if (overlord) not move set job default
			Move(overlord);
		}
	}
}
void OverlordManager::HandleEscapeOverLord()
{
	BWTA::BaseLocation * ourBaseLocation = InformationManager::Instance().getMyMainBaseLocation();
	for (const auto overlord : overlordData.getOverlords())
	{
		UAB_ASSERT(overlord != nullptr, "EscapeOverlord was null");
		//if (!overlord->isUnderAttack){
			//newjob
		//}
		EscapeMove(overlord);
	}
}
void OverlordManager::HandleScoutOverLord()
{
	for (const auto overlord : overlordData.getOverlords())
	{
		UAB_ASSERT(overlord != nullptr, "ScoutOverlord was null");
		if (overlordData.GetOverlordJob(overlord) == OverlordData::Scout)
		{
			if (overlord->isUnderAttack() || CheckAirDefence(overlord))
			{
				SetEscapeOverlord(overlord);
				if (overlord->isUnderAttack()) BWAPI::Broodwar->printf("ScoutOverLord Escape");
				ScoutOverlord = nullptr;
				return;
			}
			ScoutMove();
		}
	}
}
void OverlordManager::HandleTransportOverLord()
{
	for (const auto overlord : overlordData.getOverlords())
	{
		UAB_ASSERT(overlord != nullptr, "TransportOverlord was null");
		if (overlordData.GetOverlordJob(overlord) == OverlordData::Transport)
		{
			if (overlord->isUnderAttack())
			{
				SetEscapeOverlord(overlord);
			}

		}
	}
}
void OverlordManager::ScoutMove()
{
	BWTA::BaseLocation * enemyBaseLocation = InformationManager::Instance().getEnemyMainBaseLocation();
	Micro::SmartMove(ScoutOverlord, enemyBaseLocation->getPosition());
}
void OverlordManager::EscapeMove(BWAPI::Unit unit)
{
	BWTA::BaseLocation * ourBaseLocation = InformationManager::Instance().getMyMainBaseLocation();
	Micro::SmartMove(unit, ourBaseLocation->getPosition());
}
void OverlordManager::Move(BWAPI::Unit unit)
{
	BWTA::BaseLocation * enemyBaseLocation = InformationManager::Instance().getEnemyMainBaseLocation();
	Micro::SmartMove(ScoutOverlord, enemyBaseLocation->getPosition());
}
bool OverlordManager::CheckAirDefence(BWAPI::Unit unit)
{
	for (const auto EnemyUnit : BWAPI::Broodwar->enemy()->getUnits())
	{
		if (EnemyUnit->getType().airWeapon().targetsAir() && EnemyUnit->getDistance(unit) <=30)
		{
			BWAPI::Broodwar->printf("Air Defence Found!!");
			return true;
		}
	}
	return false;
}