#pragma once

#include "Common.h"
namespace CDBot
{
	class OverlordData
	{
	public:
		enum OverlordJob { Default , Move , Escape , Scout , Transport};

	private:
		BWAPI::Unitset Overlords;

		std::map<BWAPI::Unit, enum OverlordJob> OverlordJobMap;

		void clearPreviousJob(BWAPI::Unit unit);

	public:

		OverlordData();
		void OverlordDestroyed(BWAPI::Unit unit);
		void AddOverlord(BWAPI::Unit unit);
		void AddOverlord(BWAPI::Unit unit, OverlordJob Job, BWAPI::Unit jobUnit);
		void AddOverlord(BWAPI::Unit unit, OverlordJob Job, BWAPI::UnitType jobUnitType);
		void SetOverlordJob(BWAPI::Unit unit, OverlordJob Job, BWAPI::Unit jobUnit);
		void SetOverlordJob(BWAPI::Unit unit, OverlordJob Job, BWAPI::UnitType jobUnitType);

		enum OverlordJob GetOverlordJob(BWAPI::Unit unit);
		void MoveScoutOverLord(BWAPI::Unit unit);


		const BWAPI::Unitset & getOverlords() const { return Overlords; }
	};

}