#include "OverlordData.h"
#include "Micro.h"

using namespace CDBot;

OverlordData::OverlordData()
{

}

void OverlordData::OverlordDestroyed(BWAPI::Unit unit)
{
	if (!unit){ return; }
	clearPreviousJob(unit);
	Overlords.erase(unit);
}
void OverlordData::AddOverlord(BWAPI::Unit unit)
{
	if (!unit || !unit->exists()){ return; }
	Overlords.insert(unit);
	OverlordJobMap[unit] = Default;
}
void OverlordData::AddOverlord(BWAPI::Unit unit, OverlordJob Job, BWAPI::Unit jobUnit)
{
	if (!unit || !unit->exists() || !jobUnit || !jobUnit->exists()){ return; }
	assert(Overlords.find(unit) == Overlords.end());
	Overlords.insert(unit);
	SetOverlordJob(unit, Job, jobUnit);
}
void OverlordData::AddOverlord(BWAPI::Unit unit, OverlordJob Job, BWAPI::UnitType jobUnitType)
{
	if (!unit || !unit->exists()){ return; }
	assert(Overlords.find(unit) == Overlords.end());
	Overlords.insert(unit);
	SetOverlordJob(unit, Job, jobUnitType);
}
void OverlordData::SetOverlordJob(BWAPI::Unit unit, OverlordJob Job, BWAPI::Unit jobUnit)
{
	if (!unit || !unit->exists()){ return; }
	clearPreviousJob(unit);
	OverlordJobMap[unit] = Job;
	if (Job == Move)
	{
		BWAPI::Broodwar->printf("Overlord Move");

	}
	else if (Job = Scout)
	{
		BWAPI::Broodwar->printf("Overlord Scout");

	}
	else if (Job = Escape)
	{
		BWAPI::Broodwar->printf("Overlord Escape");
		
	}
	else if (Job = Transport)
	{

	}
}
void OverlordData::SetOverlordJob(BWAPI::Unit unit, OverlordJob Job, BWAPI::UnitType jobUnitType)
{}

void OverlordData::clearPreviousJob(BWAPI::Unit unit)
{
	if (!unit){ return; }
	OverlordJob previousJob = GetOverlordJob(unit);
	if (previousJob == Move)
	{

	}
	else if (previousJob = Scout)
	{

	}
	else if (previousJob = Escape)
	{

	}
	else if (previousJob = Transport)
	{

	}
	OverlordJobMap.erase(unit);
}
enum OverlordData::OverlordJob OverlordData::GetOverlordJob(BWAPI::Unit unit)
{
	if (!unit){ return Default; }
	std::map<BWAPI::Unit, enum OverlordJob>::iterator it = OverlordJobMap.find(unit);

	if (it != OverlordJobMap.end()){ return it->second; }

	return Default;
}
void OverlordData::MoveScoutOverLord(BWAPI::Unit unit)
{
}