/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.unitgroups;

import bwapi.Color;
import bwapi.Game;
import bwapi.Order;
import bwapi.Player;
import bwapi.Position;
import bwapi.TechType;
import bwapi.Unit;
import bwapi.UnitType;
import bwapi.WeaponType;
import bwta.Chokepoint;
import bwta.Region;
import com.tyr.DebugMessages;
import com.tyr.EnemyManager;
import com.tyr.EnemyPosition;
import com.tyr.PositionUtil;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.agents.Attack;
import com.tyr.agents.MedicAttack;
import com.tyr.agents.None;
import com.tyr.buildingplacement.SpaceManager;
import com.tyr.unitgroups.IAttackGroup;
import com.tyr.unitgroups.ZealotDropGroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class WallAttackGroup
extends IAttackGroup {
    private Unit killTarget;
    public static boolean hunting = false;
    public static boolean fearBarracks = false;
    private Unit prey;
    private Agent hunter;
    private List<Agent> highTemplar = new ArrayList<Agent>();
    private static Region enemyNatural = null;
    public static boolean killWall;
    private boolean attackWall = false;
    private List<Unit> enemyTanks = new ArrayList<Unit>();
    private List<ZealotDropGroup> drops = new ArrayList<ZealotDropGroup>();
    private Map<Integer, Unit> carrierTargets = new HashMap<Integer, Unit>();
    public static boolean fearTanks;
    private List<Agent> huntingDragoons = new ArrayList<Agent>();
    private Position naturalDefensePos;

    static {
        fearTanks = true;
    }

    public WallAttackGroup(Position target) {
        super(target);
    }

    public void setKillTarget(Unit killTarget) {
        this.killTarget = killTarget;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        void var9_29;
        Position wallPos;
        if (this.killTarget != null) {
            Tyr.drawCircle(this.killTarget.getPosition(), Color.Purple, 16);
        }
        for (ZealotDropGroup drop : this.drops) {
            drop.cleanup();
        }
        int i = this.units.size() - 1;
        while (i >= 0) {
            block63: {
                Object agent = (Agent)this.units.get(i);
                if (((Agent)agent).unit.getType() == UnitType.Protoss_Shuttle) {
                    for (ZealotDropGroup drop : this.drops) {
                        if (!drop.needsShuttle()) continue;
                        this.units.remove(i);
                        drop.add((Agent)agent);
                        break block63;
                    }
                    ZealotDropGroup drop2 = new ZealotDropGroup();
                    this.units.remove(i);
                    drop2.add((Agent)agent);
                    this.drops.add(drop2);
                }
            }
            --i;
        }
        for (ZealotDropGroup drop : this.drops) {
            if (!drop.needsShuttle()) {
                int i2 = this.units.size() - 1;
                while (i2 >= 0) {
                    if (drop.getZealots() >= 4) break;
                    Agent agent = (Agent)this.units.get(i2);
                    if (agent.unit.getType() == UnitType.Protoss_Zealot) {
                        this.units.remove(i2);
                        drop.add(agent);
                    }
                    --i2;
                }
            }
            drop.setTarget(this.getDropTarget());
            drop.onFrame(game, self, bot);
        }
        Position medicTarget = this.target;
        for (Object agent : this.units) {
            if (((Agent)agent).unit.getGroundWeaponCooldown() <= 0) continue;
            medicTarget = ((Agent)agent).unit.getPosition();
            break;
        }
        int i3 = this.enemyTanks.size() - 1;
        while (i3 >= 0) {
            Unit tank = this.enemyTanks.get(i3);
            Position pos = EnemyManager.getManager().getLastPosition(tank);
            for (Unit unit : self.getUnits()) {
                if (unit.getType().isBuilding() || unit.getType().isWorker() || pos != null && PositionUtil.distanceSq(pos, unit) > 40000) continue;
                this.enemyTanks.remove(i3);
                break;
            }
            --i3;
        }
        for (Unit unit : EnemyManager.getEnemyUnits()) {
            if (unit.getType() != UnitType.Terran_Siege_Tank_Siege_Mode && unit.getType() != UnitType.Terran_Siege_Tank_Tank_Mode || this.enemyTanks.contains(unit)) continue;
            this.enemyTanks.add(unit);
        }
        Position carrierTarget = this.getCarrierTarget();
        if (carrierTarget != null) {
            Tyr.drawCircle(carrierTarget, Color.White, 32);
        }
        for (Integer id : this.carrierTargets.keySet()) {
            Agent agent;
            Unit target = this.carrierTargets.get(id);
            if (target == null) continue;
            if (Agent.isDead(target)) {
                this.carrierTargets.put(id, null);
            }
            if (!target.isDetected()) {
                this.carrierTargets.put(id, null);
            }
            if ((agent = bot.agentMap.get(id)).distanceSquared(target) < 90000) continue;
            this.carrierTargets.put(id, null);
        }
        if (hunting) {
            if (this.prey == null || Agent.isDead(this.prey) || this.hunter == null || this.hunter.isDead()) {
                this.prey = null;
                this.hunter = null;
            }
            if (this.prey == null) {
                ArrayList<Unit> enemyTargets = new ArrayList<Unit>();
                for (Unit enemy : EnemyManager.getEnemyUnits()) {
                    if (enemy.getType() != UnitType.Protoss_Reaver && enemy.getType() != UnitType.Terran_Siege_Tank_Siege_Mode && enemy.getType() != UnitType.Terran_Siege_Tank_Tank_Mode) continue;
                    enemyTargets.add(enemy);
                }
                block11: for (Agent agent : this.units) {
                    if (agent.unit.getType() != UnitType.Protoss_Zealot) continue;
                    for (Unit unit : enemyTargets) {
                        if (agent.distanceSquared(unit) > 90000) continue;
                        this.prey = unit;
                        this.hunter = agent;
                        break block11;
                    }
                }
            }
        }
        if (!this.highTemplar.isEmpty()) {
            this.manageHighTemplar();
        }
        if (enemyNatural == null && bot.suspectedEnemy.size() == 1) {
            enemyNatural = SpaceManager.getEnemyNatural().getRegion();
        }
        Unit wall = null;
        if (enemyNatural != null) {
            for (Chokepoint choke : enemyNatural.getChokepoints()) {
                Tyr.drawCircle(choke.getCenter(), Color.Blue, 200);
            }
            for (Unit enemy : EnemyManager.getEnemyUnits()) {
                if (enemy.getType() != UnitType.Terran_Barracks || enemy.isLifted()) continue;
                for (Chokepoint chokepoint : enemyNatural.getChokepoints()) {
                    if (PositionUtil.distanceSq(enemy, chokepoint.getCenter()) > 40000) continue;
                    wall = enemy;
                }
            }
        }
        Position position = wallPos = wall == null ? null : wall.getPosition();
        if (wallPos == null && enemyNatural != null) {
            for (EnemyPosition pos : EnemyManager.getManager().enemyBuildingMemory) {
                if (pos.type != UnitType.Terran_Barracks) continue;
                for (Chokepoint choke : enemyNatural.getChokepoints()) {
                    if (PositionUtil.distanceSq(pos.pos, choke.getCenter()) > 40000) continue;
                    wallPos = pos.pos;
                }
            }
        }
        boolean dragoonAtWall = false;
        boolean bl = false;
        DebugMessages.addMessage("Wall: " + (wall != null));
        if (wallPos != null) {
            Tyr.drawCircle(wallPos, Color.Red, 300);
            for (Agent agent : this.units) {
                if (agent.unit.getType() == UnitType.Protoss_Dragoon && agent.distanceSquared(wallPos) <= 90000) {
                    dragoonAtWall = true;
                }
                if (agent.unit.getType() != UnitType.Protoss_Zealot || agent.distanceSquared(wallPos) > 160000) continue;
                ++var9_29;
            }
        }
        this.attackWall = var9_29 >= true && killWall;
        DebugMessages.addMessage("Zealots at wall: " + (int)var9_29);
        ArrayList<Unit> repairingSCVs = new ArrayList<Unit>();
        for (Unit unit : EnemyManager.getEnemyUnits()) {
            if (wall == null) break;
            if (!unit.getType().isWorker() || !unit.isRepairing() || PositionUtil.distanceSq(unit, wall) > 40000) continue;
            repairingSCVs.add(unit);
        }
        block20: for (Agent agent : this.units) {
            if (fearBarracks && !dragoonAtWall && !this.attackWall && agent.unit.getType() == UnitType.Protoss_Zealot && wallPos != null && agent.distanceSquared(wallPos) <= 90000) {
                agent.move(Tyr.getStartLocation());
                continue;
            }
            boolean closeTank = false;
            for (Unit tank : this.enemyTanks) {
                int dist;
                if (agent.unit.getType() == UnitType.Protoss_Carrier || !fearTanks) break;
                if (tank.getType() == UnitType.Terran_Siege_Tank_Tank_Mode) continue;
                Position pos = EnemyManager.getManager().getLastPosition(tank);
                int n = dist = pos == null ? 1000000 : agent.distanceSquared(pos);
                if (dist <= 360000) {
                    agent.move(Tyr.getStartLocation());
                    continue block20;
                }
                if (dist > 422500) continue;
                closeTank = true;
            }
            if (agent.unit.getType() == UnitType.Protoss_Dragoon && closeTank) {
                if (!(agent.unit.isHoldingPosition() || agent.unit.isAttackFrame() || agent.unit.isAttacking())) {
                    agent.drawCircle(Color.Blue, 6);
                    agent.unit.holdPosition();
                    continue;
                }
                agent.drawCircle(Color.Green, 6);
                continue;
            }
            if (wall != null && (agent.unit.getType() == UnitType.Protoss_Dragoon || agent.unit.getType() == UnitType.Protoss_Zealot) && this.attackWall && agent.distanceSquared(wall) <= 90000) {
                agent.attack(wall);
                agent.drawCircle(Color.Yellow, 6);
                continue;
            }
            if (agent == this.hunter) {
                agent.attack(this.prey);
                game.drawLineMap(agent.unit.getPosition(), this.prey.getPosition(), Color.Red);
                continue;
            }
            if (agent.unit.getType() == UnitType.Protoss_Reaver) {
                if (!agent.unit.isTraining() && agent.unit.getScarabCount() < 5) {
                    agent.unit.train(UnitType.Protoss_Scarab);
                }
            } else if (agent.unit.getType() == UnitType.Protoss_Carrier) {
                Unit killTarget;
                if (!agent.unit.isTraining() && agent.unit.getInterceptorCount() < 8) {
                    agent.unit.train(UnitType.Protoss_Interceptor);
                }
                if (agent.unit.isTraining() && agent.unit.getInterceptorCount() < 4) {
                    agent.unit.move(Tyr.getStartLocation());
                }
                if (agent.unit.isTraining() && agent.unit.getInterceptorCount() < 8) {
                    agent.attack(carrierTarget);
                }
                if (agent.unit.isUnderAttack()) {
                    agent.unit.move(Tyr.getStartLocation());
                    continue;
                }
                int id = agent.unit.getID();
                if (!this.carrierTargets.containsKey(id) || this.carrierTargets.get(id) == null) {
                    this.carrierTargets.put(id, this.getCarrierTarget(agent));
                }
                if ((killTarget = this.carrierTargets.get(id)) != null) {
                    game.drawLineMap(killTarget.getPosition(), agent.unit.getPosition(), Color.Red);
                    agent.attack(killTarget);
                    continue;
                }
            }
            if (agent.unit.getType() == UnitType.Terran_Vulture) {
                if (!self.hasResearched(TechType.Spider_Mines)) {
                    agent.drawCircle(Color.Green, 6);
                } else if (agent.unit.getSpiderMineCount() <= 0) {
                    agent.drawCircle(Color.Blue, 6);
                }
            }
            if (agent.unit.getType() == UnitType.Terran_Medic) {
                agent.order(new MedicAttack(agent, medicTarget));
            }
            if (agent.unit.getType() == UnitType.Protoss_Dark_Templar) {
                boolean retreat = false;
                for (Unit enemy : EnemyManager.getEnemyUnits()) {
                    if (!enemy.getType().isDetector() || agent.distanceSquared(enemy) > 160000) continue;
                    retreat = true;
                }
                if (!retreat) continue;
                agent.move(Tyr.getStartLocation());
                continue;
            }
            if (this.killTarget != null) {
                agent.order(new None(agent));
                if (agent.distanceSquared(this.killTarget) <= agent.unit.getType().groundWeapon().maxRange() * agent.unit.getType().groundWeapon().maxRange()) {
                    agent.attack(this.killTarget);
                    continue;
                }
                agent.unit.move(this.killTarget.getPosition());
                continue;
            }
            agent.order(new Attack(agent, this.target));
        }
    }

    private void manageHuntingDragoons() {
        Agent.clean(this.huntingDragoons);
        int hunterCount = Math.max(0, Math.min(3, this.units.size() - 12));
        while (this.huntingDragoons.size() > hunterCount) {
            this.units.add(this.huntingDragoons.get(this.huntingDragoons.size() - 1));
            this.huntingDragoons.remove(this.huntingDragoons.size() - 1);
        }
        int i = this.units.size() - 1;
        while (i >= 0) {
            Agent agent = (Agent)this.units.get(i);
            if (this.huntingDragoons.size() >= hunterCount) break;
            if (agent.unit.getType() == UnitType.Protoss_Dragoon) {
                this.units.remove(i);
                this.huntingDragoons.add(agent);
            }
            --i;
        }
        Unit target = null;
        int dist = 4000000;
        for (Unit unit : EnemyManager.getEnemyUnits()) {
            int newDist;
            if (unit.getType() != UnitType.Terran_Vulture && unit.getType() != UnitType.Terran_Wraith || (newDist = PositionUtil.distanceSq(Tyr.getStartLocation(), unit)) >= dist) continue;
            target = unit;
            dist = newDist;
        }
        if (target != null) {
            Tyr.drawCircle(target.getPosition(), Color.Red, 64);
        }
        if (this.naturalDefensePos == null && this.huntingDragoons.size() > 0) {
            this.naturalDefensePos = SpaceManager.getNaturalDefensePos();
        }
        for (Agent agent : this.huntingDragoons) {
            agent.drawCircle(Color.Red, 6);
            if (target != null) {
                agent.attack(target.getPosition());
                continue;
            }
            if (this.naturalDefensePos != null) {
                agent.attack(this.naturalDefensePos);
                continue;
            }
            agent.attack(Tyr.getStartLocation());
        }
    }

    private Unit getCarrierTarget(Agent agent) {
        Unit result = null;
        int dist = 90000;
        for (Unit enemy : EnemyManager.getEnemyUnits()) {
            int newDist;
            if (enemy.getType().airWeapon() == WeaponType.None && enemy.getType() != UnitType.Protoss_Carrier && enemy.getType() != UnitType.Terran_Bunker || !enemy.isDetected() || (newDist = agent.distanceSquared(enemy)) >= dist) continue;
            dist = newDist;
            result = enemy;
        }
        return result;
    }

    private void manageHighTemplar() {
        HashSet<Unit> stormTargets = new HashSet<Unit>();
        for (Unit enemy : EnemyManager.getEnemyUnits()) {
            if (enemy.getType().isBuilding() || enemy.getType() == UnitType.Zerg_Overlord) continue;
            int count = 1;
            for (Unit enemy2 : EnemyManager.getEnemyUnits()) {
                if (enemy.getType().isBuilding() || enemy.getType() == UnitType.Zerg_Overlord || Math.abs(enemy.getX() - enemy2.getX()) > 48 || Math.abs(enemy.getY() - enemy2.getY()) > 48) continue;
                ++count;
            }
            if (count < 6) continue;
            stormTargets.add(enemy);
        }
        block2: for (Agent agent : this.highTemplar) {
            if (agent.unit.getOrder() == Order.CastPsionicStorm) continue;
            boolean canStorm = Tyr.self.hasResearched(TechType.Psionic_Storm) && agent.unit.getEnergy() >= 75;
            for (Unit enemy : EnemyManager.getEnemyUnits()) {
                int dist = agent.distanceSquared(enemy);
                if (!enemy.getType().isBuilding() && enemy.getType() != UnitType.Zerg_Overlord && dist <= 90000 && canStorm && stormTargets.contains(enemy)) {
                    agent.unit.useTech(TechType.Psionic_Storm, enemy.getPosition());
                }
                if (dist <= 22500) {
                    int dx = agent.unit.getX() - enemy.getX();
                    int dy = agent.unit.getX() - enemy.getX();
                    double length = Math.sqrt(dx * dx + dy * dy);
                    Position fleePos = new Position((int)((double)agent.unit.getX() + (double)(dx * 64) / length), (int)((double)agent.unit.getY() + (double)(dy * 64) / length));
                    agent.move(fleePos);
                    continue;
                }
                if (dist > 62500) continue;
                agent.move(Tyr.getStartLocation());
                continue block2;
            }
            agent.unit.move(this.target);
        }
    }

    private Position getCarrierTarget() {
        Position result = this.target;
        int avgX = 0;
        int avgY = 0;
        int total = 0;
        for (Agent agent : this.units) {
            if (agent.unit.getType() == UnitType.Protoss_Carrier) continue;
            avgX += agent.unit.getX();
            avgY += agent.unit.getY();
            ++total;
        }
        if (total == 0) {
            return this.target;
        }
        Position center = new Position(avgX /= total, avgY /= total);
        int dist = 1000000000;
        for (Agent agent : this.units) {
            int newDist = agent.distanceSquared(center);
            if (newDist >= dist) continue;
            dist = newDist;
            result = agent.unit.getPosition();
        }
        return result;
    }

    private Position getDropTarget() {
        int dist = 1000000000;
        Position result = Tyr.getStartLocation();
        for (Agent agent : this.units) {
            int newDist = agent.distanceSquared(this.target);
            if (newDist >= dist) continue;
            result = agent.unit.getPosition();
            dist = newDist;
        }
        return result;
    }

    @Override
    public void add(Agent agent) {
        if (agent.unit.getType() == UnitType.Protoss_High_Templar) {
            this.highTemplar.add(agent);
            agent.order(new None(agent));
            agent.unit.stop();
        }
        super.add(agent);
    }

    @Override
    public void cleanup() {
        super.cleanup();
        Agent.clean(this.highTemplar);
    }
}

