/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.unitgroups;

import bwapi.Color;
import bwapi.Game;
import bwapi.Order;
import bwapi.Player;
import bwapi.Position;
import bwapi.Race;
import bwapi.Unit;
import bwapi.UnitType;
import bwapi.WeaponType;
import com.tyr.EnemyManager;
import com.tyr.EnemyPosition;
import com.tyr.Settings;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.agents.WorkerAgent;
import com.tyr.buildingplacement.DefensiveStructures;
import com.tyr.buildingplacement.SpaceManager;
import com.tyr.buildingplacement.TurretBuildSite;
import com.tyr.unitgroups.GasWorkers;
import com.tyr.unitgroups.LocalDefendingWorkers;
import com.tyr.unitgroups.OutOfJob;
import com.tyr.unitgroups.PatchWorkers;
import com.tyr.unitgroups.UnitGroup;
import java.util.ArrayList;

public class MineralWorkers
extends UnitGroup {
    public Unit resourceDepot;
    public ArrayList<Unit> minerals = new ArrayList();
    public ArrayList<PatchWorkers> patchWorkers = new ArrayList();
    public GasWorkers gasWorkers;
    public Position defensePos;
    public DefensiveStructures defenses = null;
    public TurretBuildSite turretSite;
    public boolean underAttack;
    public boolean abandon;
    public Unit invader = null;
    public int invaderCount;
    private LocalDefendingWorkers defendingWorkers;

    public MineralWorkers(OutOfJob rejects, Unit resourceDepot) {
        super(rejects);
        this.resourceDepot = resourceDepot;
        for (Unit neutralUnit : Tyr.game.neutral().getUnits()) {
            if (neutralUnit.getType().isMineralField() && neutralUnit.getDistance(resourceDepot) <= 270) {
                this.minerals.add(neutralUnit);
                this.patchWorkers.add(new PatchWorkers(rejects, resourceDepot, neutralUnit));
                continue;
            }
            if (neutralUnit.getType() != UnitType.Resource_Vespene_Geyser || neutralUnit.getDistance(resourceDepot) > 270) continue;
            this.gasWorkers = new GasWorkers(rejects, neutralUnit);
        }
        this.defensePos = resourceDepot == null || resourceDepot.getDistance(Tyr.tileToPosition(Tyr.game.self().getStartLocation())) < 64 ? null : SpaceManager.getDefensePos(resourceDepot.getPosition(), this.minerals);
        boolean exists = false;
        for (DefensiveStructures structures : Tyr.bot.defensiveStructures) {
            if (resourceDepot.getDistance(structures.defendedPosition) >= 64) continue;
            exists = true;
            this.defenses = structures;
            this.defenses.disabled = false;
            break;
        }
        if (!exists) {
            this.defenses = new DefensiveStructures(resourceDepot.getPosition(), this.defensePos);
            Tyr.bot.defensiveStructures.add(this.defenses);
        }
        this.defendingWorkers = new LocalDefendingWorkers(rejects, this);
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        Tyr.drawCircle(this.resourceDepot.getPosition(), Color.Orange, 16);
        Tyr.game.drawTextMap(this.resourceDepot.getX(), this.resourceDepot.getY(), "" + this.size());
        if (this.turretSite == null && self.getRace() == Race.Terran) {
            this.turretSite = new TurretBuildSite(this);
        }
        for (Unit neutralUnit : Tyr.game.neutral().getUnits()) {
            if (neutralUnit.getType().isMineralField() && neutralUnit.getDistance(this.resourceDepot) <= 270) {
                if (!this.minerals.contains(neutralUnit)) {
                    this.minerals.add(neutralUnit);
                }
                boolean alreadyAdded = false;
                for (PatchWorkers patch : this.patchWorkers) {
                    if (patch.mineral.getID() != neutralUnit.getID()) continue;
                    alreadyAdded = true;
                    break;
                }
                if (alreadyAdded) continue;
                this.patchWorkers.add(new PatchWorkers(this.rejects, this.resourceDepot, neutralUnit));
                continue;
            }
            if (this.gasWorkers != null || neutralUnit.getType() != UnitType.Resource_Vespene_Geyser || neutralUnit.getDistance(this.resourceDepot) > 270) continue;
            this.gasWorkers = new GasWorkers(this.rejects, neutralUnit);
        }
        if (this.defensePos != null) {
            Tyr.drawCircle(this.defensePos, Color.Green, 64);
        }
        int i = this.minerals.size() - 1;
        while (i >= 0) {
            if (!this.minerals.get(i).exists()) {
                this.minerals.remove(i);
            }
            --i;
        }
        if (this.minedOut() || this.resourceDepot == null || !this.resourceDepot.exists() || this.resourceDepot.getHitPoints() <= 0 || this.resourceDepot.getRemoveTimer() != 0) {
            if (this.defenses != null && this.defenses.defendedPosition.getDistance(Tyr.tileToPosition(self.getStartLocation())) >= 200.0) {
                this.defenses.disable();
                this.defenses = null;
            }
            return;
        }
        this.determineThreat();
        if (this.abandon) {
            for (Agent agent : this.units) {
                this.rejects.add(agent);
            }
            this.units = new ArrayList();
            for (PatchWorkers patch : this.patchWorkers) {
                for (Agent agent : patch.units) {
                    this.rejects.add(agent);
                }
                patch.units = new ArrayList();
            }
        } else {
            this.defendingWorkers.cleanup();
            this.defendingWorkers.onFrame(game, self, bot);
        }
        i = 0;
        while (this.units.size() > 0) {
            for (PatchWorkers patch : this.patchWorkers) {
                if (patch.units.size() <= i) {
                    patch.add((Agent)this.units.get(this.units.size() - 1));
                    this.units.remove(this.units.size() - 1);
                }
                if (this.units.size() == 0) break;
            }
            ++i;
        }
        for (PatchWorkers patch : this.patchWorkers) {
            patch.onFrame(game, self, bot);
        }
        if (this.gasWorkers != null && this.gasWorkers.geyser.getResources() == 0 && this.gasWorkers.geyser.getType().isRefinery()) {
            for (Agent unit : this.gasWorkers.units) {
                this.add(unit);
            }
            this.gasWorkers = null;
        } else if (this.gasWorkers != null) {
            while (this.gasWorkers.geyser.isCompleted() && this.gasWorkers.units.size() < Settings.getWorkersPerGas() && this.gasWorkers.geyser.getType().isRefinery() && this.gasWorkers.geyser.getPlayer() == self) {
                Agent gasWorker = this.pop(this.gasWorkers.geyser.getPosition());
                if (gasWorker == null) break;
                this.remove(gasWorker);
                this.gasWorkers.add(gasWorker);
            }
            this.gasWorkers.onFrame(game, self, bot);
        }
    }

    private void determineThreat() {
        this.underAttack = false;
        this.abandon = false;
        this.invaderCount = 0;
        boolean lurkers = false;
        for (Unit enemy : EnemyManager.getEnemyUnits()) {
            if (enemy.getType().groundWeapon() == WeaponType.None || enemy.getType().isFlyer() || enemy.getType() == UnitType.Protoss_Dark_Templar || this.resourceDepot == null || this.resourceDepot.getDistance(enemy) >= 300) continue;
            ++this.invaderCount;
            this.underAttack = true;
            this.invader = enemy;
            if (enemy.getType() == UnitType.Zerg_Lurker) {
                lurkers = true;
            }
            if (enemy.getType().isWorker()) continue;
            this.abandon = true;
        }
        if (this.abandon && !lurkers && this.resourceDepot != null && this.resourceDepot.getDistance(Tyr.tileToPosition(Tyr.self.getStartLocation())) <= Settings.getDefendExpandDist()) {
            this.abandon = false;
        }
        if (Tyr.bot.defensiveStructures.size() <= 1) {
            this.abandon = false;
        }
        if (this.underAttack && this.invaderCount == 1 && this.invader.getType().isWorker()) {
            this.underAttack = false;
        }
        if (this.abandon) {
            Tyr.drawCircle(this.resourceDepot.getPosition(), Color.Red, 16);
        } else if (this.underAttack) {
            Tyr.drawCircle(this.resourceDepot.getPosition(), Color.Orange, 16);
        }
    }

    @Override
    public Agent pop() {
        int i = this.units.size() - 1;
        while (i >= 0) {
            if (!((WorkerAgent)this.units.get((int)i)).isBlocked && !((Agent)this.units.get((int)i)).unit.isConstructing() && ((Agent)this.units.get((int)i)).unit.getOrder() != Order.ConstructingBuilding) {
                Agent result = (Agent)this.units.get(i);
                this.remove(i);
                return result;
            }
            --i;
        }
        for (PatchWorkers patch : this.patchWorkers) {
            Agent result = patch.pop();
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public Agent poll() {
        int i = this.units.size() - 1;
        while (i >= 0) {
            if (!((WorkerAgent)this.units.get((int)i)).isBlocked && !((Agent)this.units.get((int)i)).unit.isConstructing() && ((Agent)this.units.get((int)i)).unit.getOrder() != Order.ConstructingBuilding) {
                Agent result = (Agent)this.units.get(i);
                return result;
            }
            --i;
        }
        for (PatchWorkers patch : this.patchWorkers) {
            Agent result = patch.poll();
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public Agent pop(Position pos) {
        return this.pop(pos, false);
    }

    public Agent pop(Position pos, boolean healthyOnly) {
        Agent result = null;
        double distance = Double.MAX_VALUE;
        for (Agent worker : this.units) {
            int newDist;
            if (((WorkerAgent)worker).isBlocked || worker.unit.isConstructing() || worker.unit.getBuildUnit() != null || worker.unit.getOrder().equals(Order.ConstructingBuilding) || healthyOnly && worker.unit.getHitPoints() < 20 || !((double)(newDist = worker.distanceSquared(pos)) < distance)) continue;
            distance = newDist;
            result = worker;
        }
        if (result != null) {
            this.units.remove(result);
        }
        PatchWorkers last = null;
        for (PatchWorkers patch : this.patchWorkers) {
            for (Agent agent : patch.units) {
                int newDist;
                if (((WorkerAgent)agent).isBlocked || agent.unit.isConstructing() || agent.unit.getBuildUnit() != null || agent.unit.getOrder().equals(Order.ConstructingBuilding) || healthyOnly && agent.unit.getHitPoints() < 20 || !((double)(newDist = agent.distanceSquared(pos)) < distance)) continue;
                if (result != null && last == null) {
                    this.units.add(result);
                }
                last = patch;
                distance = newDist;
                result = agent;
            }
        }
        if (last != null && result != null) {
            last.units.remove(result);
        }
        return result;
    }

    public Agent poll(Position pos) {
        Agent result = null;
        double distance = Double.MAX_VALUE;
        for (Agent worker : this.units) {
            int newDist;
            if (((WorkerAgent)worker).isBlocked || worker.unit.isConstructing() || worker.unit.getBuildUnit() != null || worker.unit.getOrder().equals(Order.ConstructingBuilding) || !((double)(newDist = worker.distanceSquared(pos)) < distance)) continue;
            distance = newDist;
            result = worker;
        }
        for (PatchWorkers patch : this.patchWorkers) {
            for (Agent agent : patch.units) {
                int newDist;
                if (((WorkerAgent)agent).isBlocked || agent.unit.isConstructing() || agent.unit.getBuildUnit() != null || agent.unit.getOrder().equals(Order.ConstructingBuilding) || !((double)(newDist = agent.distanceSquared(pos)) < distance)) continue;
                distance = newDist;
                result = agent;
            }
        }
        return result;
    }

    @Override
    public void add(Agent agent) {
        if (agent == null) {
            return;
        }
        if (agent.unit == null) {
            return;
        }
        super.add(agent);
    }

    @Override
    public void cleanup() {
        super.cleanup();
        int i = this.patchWorkers.size() - 1;
        while (i >= 0) {
            this.patchWorkers.get(i).cleanup();
            if (this.patchWorkers.get((int)i).mineral == null) {
                this.patchWorkers.remove(i);
            }
            --i;
        }
        i = this.minerals.size() - 1;
        while (i >= 0) {
            if (!this.minerals.get(i).exists() || this.minerals.get(i).getResources() <= 0) {
                this.minerals.remove(i);
            }
            --i;
        }
        if (this.minedOut()) {
            for (Agent unit : this.units) {
                this.rejects.add(unit);
            }
            this.units = new ArrayList();
        }
        if (this.gasWorkers != null) {
            this.gasWorkers.cleanup();
        }
        this.defendingWorkers.cleanup();
    }

    public void clear(UnitGroup receivingGroup) {
        for (PatchWorkers patch : this.patchWorkers) {
            for (Agent worker : patch.units) {
                receivingGroup.add(worker);
            }
            patch.units = new ArrayList();
        }
    }

    public int size() {
        int result = 0;
        for (PatchWorkers patch : this.patchWorkers) {
            result += patch.units.size();
        }
        return result;
    }

    public boolean minedOut() {
        if (this.minerals.size() > 0) {
            return false;
        }
        for (EnemyPosition neutralUnit : EnemyManager.getManager().neutralBuildingMemory) {
            if (!neutralUnit.type.isMineralField() || neutralUnit.distanceSq(this.resourceDepot) > 72900) continue;
            return false;
        }
        return true;
    }
}

