/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.unitgroups;

import bwapi.Game;
import bwapi.Player;
import bwapi.Race;
import bwapi.Unit;
import bwapi.UnitType;
import com.tyr.DebugMessages;
import com.tyr.EnemyManager;
import com.tyr.EnemyPosition;
import com.tyr.Settings;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.unitgroups.OutOfJob;
import com.tyr.unitgroups.UnitGroup;
import java.util.ArrayList;

public class DefendingWorkers
extends UnitGroup {
    public static boolean stop = false;
    private boolean proxyCannon = false;
    private boolean workerRush = false;

    public DefendingWorkers(OutOfJob rejects) {
        super(rejects);
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        this.cleanup();
        Unit invader = EnemyManager.getManager().getInvader();
        if (EnemyManager.getManager().getInvadingWorkerCount() >= 3) {
            this.workerRush = true;
        }
        if (this.workerRush) {
            DebugMessages.addMessage("Worker rush! " + EnemyManager.getManager().getInvadingWorkerCount() + " invading workers.");
        }
        int invaderCount = EnemyManager.getManager().getInvaderCount();
        DebugMessages.addMessage("Invading enemies: " + invaderCount);
        boolean proxy = false;
        for (EnemyPosition building : EnemyManager.getManager().enemyBuildingMemory) {
            if (building.distanceSq(Tyr.tileToPosition(self.getStartLocation())) > Settings.getLargeInvasionDist() * Settings.getLargeInvasionDist()) continue;
            proxy = true;
            if (building.type != UnitType.Protoss_Photon_Cannon || !building.completed) continue;
            this.proxyCannon = true;
            break;
        }
        if (invader == null || invader.getDistance(self.getStartLocation().getX() * 32, self.getStartLocation().getY() * 32) >= 480.0 || this.proxyCannon || invader.getType() == UnitType.Zerg_Lurker) {
            for (Agent agent : this.units) {
                this.rejects.add(agent);
            }
            if (this.units.size() != 0) {
                this.units = new ArrayList();
            }
            DebugMessages.addMessage("No threat detected.");
            return;
        }
        if (invader.getDistance(self.getStartLocation().getX() * 32, self.getStartLocation().getY() * 32) >= 480.0) {
            DebugMessages.addMessage("Invader too far away.");
            return;
        }
        int desiredDefenders = 0;
        int halfWorkers = (this.units.size() + bot.workForce.units.size()) / 2;
        desiredDefenders = invaderCount == 1 && !invader.getType().isFlyer() && !proxy ? (invader.getType().isWorker() ? Math.min(1, halfWorkers) : Math.min(3, halfWorkers)) : (invaderCount == 2 && !proxy ? Math.min(5, halfWorkers) : halfWorkers);
        if (this.workerRush) {
            DebugMessages.addMessage("Worker count: " + (this.units.size() + bot.workForce.units.size()));
            if (self.getRace() == Race.Terran) {
                if (EnemyManager.getManager().getInvadingWorker() == null || EnemyManager.getManager().getInvadingWorker().getDistance(Tyr.tileToPosition(self.getStartLocation())) > 256) {
                    desiredDefenders = 0;
                } else {
                    int totalWorkers = this.units.size() + bot.workForce.units.size();
                    int keepWorkers = 3;
                    if (totalWorkers > 8) {
                        ++keepWorkers;
                    }
                    desiredDefenders = Math.min(totalWorkers - keepWorkers, invaderCount);
                }
            } else {
                desiredDefenders = EnemyManager.getManager().getInvadingWorker() == null || EnemyManager.getManager().getInvadingWorker().getDistance(Tyr.tileToPosition(self.getStartLocation())) > 256 ? 0 : this.units.size() + bot.workForce.units.size() - 2;
            }
            int i = this.units.size() - 1;
            while (i >= 0) {
                if (((Agent)this.units.get((int)i)).unit.getHitPoints() < 20) {
                    this.rejects.add((Agent)this.units.get(i));
                    this.units.remove(i);
                }
                --i;
            }
        }
        if (stop) {
            desiredDefenders = 0;
        }
        while (this.units.size() < desiredDefenders) {
            Agent newAgent = bot.workForce.pop(invader.getPosition(), this.workerRush);
            this.units.add(newAgent);
        }
        while (this.units.size() > desiredDefenders && this.units.size() > 0) {
            this.rejects.add((Agent)this.units.get(this.units.size() - 1));
            this.units.remove(this.units.size() - 1);
        }
        for (Agent worker : this.units) {
            if (worker == null || worker.isDead() || worker.unit.getOrder() == null) continue;
            game.drawTextMap(worker.unit.getPosition().getX(), worker.unit.getPosition().getY(), worker.unit.getOrder().toString());
        }
        DebugMessages.addMessage("Desired defenders: " + desiredDefenders + " Actual defenders: " + this.units.size());
        if (game.getFrameCount() % 100 == 0 && invader != null) {
            for (Agent worker : this.units) {
                if (worker == null) continue;
                if (invaderCount > 1) {
                    worker.unit.attack(invader.getPosition());
                    continue;
                }
                worker.unit.attack(invader);
            }
        }
    }
}

